/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxManager;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import java.util.Hashtable;
import java.util.logging.Logger;

public class QueryManager {
    private static final Logger LOGGER = Logger.getLogger(QueryManager.class.getName());
    private static final String KEY_QUERY = "query";
    private static final String KEY_PREPARETYPE = "preparetype";

    public static void initializePreparedQueries(DatastaxSession dsession, Hashtable querieslist) throws Exception {
        LOGGER.info("Initializing prepared queries for dsession: " + dsession + " querieslist: " + querieslist);
        for (Object key : querieslist.keySet()) {
            String[] keys = ("" + key).split(":");
            String table = keys[0];
            String identifier = keys[1];
            Hashtable value = (Hashtable)HttpDataWraper.getObject((String)("" + querieslist.get(key)));
            String query = (String)value.get(KEY_QUERY);
            int preparetype = value.containsKey(KEY_PREPARETYPE) ? Integer.valueOf("" + value.get(KEY_PREPARETYPE)) : 1;
            dsession.registerPreparedQuery(table, identifier, query, (Integer)preparetype);
        }
    }

    public static void initializePreparedQueries(Hashtable querieslist) throws Exception {
        QueryManager.initializePreparedQueries(DatastaxManager.getDefaultSession(), querieslist);
    }

    public static void registerPreparedQuery(String table, String identifier, String query, int preparetype) throws Exception {
        DatastaxManager.getDefaultSession().registerPreparedQuery(table, identifier, query, (Integer)preparetype);
    }

    public void registerPreparedQuery(String table, String identifier, RegularStatement regularstatement, int preparetype) throws Exception {
        DatastaxManager.getDefaultSession().registerPreparedQuery(table, identifier, regularstatement, (Integer)preparetype);
    }

    public PreparedStatement getPreparedStatement(String table, String queryidentifier) throws Exception {
        return DatastaxManager.getDefaultSession().getPreparedQueriesFor(table).get(queryidentifier).getPreparedStatement();
    }

    public void prepareTheseQueries(String table, String ... queryidentifiers) throws Exception {
        DatastaxManager.getDefaultSession().prepareTheseQueries(table, queryidentifiers);
    }
}

