/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.PreparedQuery;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import java.util.logging.Logger;

public class DefaultPreparedQueryImpl
implements PreparedQuery,
QueryId {
    private static final Logger LOGGER = Logger.getLogger(DefaultPreparedQueryImpl.class.getName());
    private final String identifier;
    private final int preparetype;
    private final String query;
    private final RegularStatement regularstatement;
    private final DatastaxSession dsession;
    private final String table;
    private volatile PreparedStatement preparedstatement;

    public DefaultPreparedQueryImpl(String identifier, DatastaxSession dsession, String table, String query, Integer preparetype) throws Exception {
        this.identifier = identifier;
        this.preparetype = preparetype != null ? preparetype : 1;
        this.dsession = dsession;
        this.table = table;
        this.query = query;
        this.regularstatement = null;
        this.init();
    }

    public DefaultPreparedQueryImpl(String identifier, DatastaxSession dsession, String table, RegularStatement regularstatement, Integer preparetype) throws Exception {
        this.identifier = identifier;
        this.preparetype = preparetype != null ? preparetype : 1;
        this.dsession = dsession;
        this.table = table;
        this.query = null;
        this.regularstatement = regularstatement;
        this.init();
    }

    private void init() throws Exception {
        if (this.preparetype == 0) {
            this.getPreparedStatement();
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getPrepareType() {
        return this.preparetype;
    }

    @Override
    public boolean isPrepared() {
        return this.preparedstatement != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement getPreparedStatement() throws Exception {
        PreparedStatement result = this.preparedstatement;
        if (result == null) {
            DefaultPreparedQueryImpl defaultPreparedQueryImpl = this;
            synchronized (defaultPreparedQueryImpl) {
                LOGGER.info("Inside getPreparedStatement Lock : " + this);
                result = this.preparedstatement;
                if (result == null) {
                    if (this.query != null) {
                        result = this.preparedstatement = QueryExecutor.prepare(this.dsession, this.table, this.query);
                    } else if (this.regularstatement != null) {
                        result = this.preparedstatement = QueryExecutor.prepare(this.dsession, this.table, this.regularstatement);
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isPreparable() {
        return true;
    }

    public String toString() {
        return "[ id: " + this.identifier + " preptype: " + this.preparetype + " table: " + this.table + " query: " + this.query + " regstmt: " + this.regularstatement + " dsession: " + this.dsession + " ]";
    }
}

