/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfManager {
    private static String adapterhome = null;
    private static Properties licenseConf;
    private static Logger logger;
    private static String serverConfFile;
    private static String ztiConfFile;
    private static String teleConfFile;
    private static String licenseConfFile;
    private static boolean ssl;
    private static String notifyserver;
    private static boolean useproxy;
    private static String proxyusername;
    private static String proxypasswd;
    private static String proxyhost;
    private static String proxyport;
    private static String zapikey;
    private static String scope;
    private static String prdcode;
    private static String zsportal;
    private static int retryexpiry;

    public static boolean initialize(String confpath) {
        ztiConfFile = confpath;
        try {
            Properties ztiConf;
            Properties serverConf = ConfManager.getProperties(serverConfFile);
            if (serverConf == null) {
                logger.log(Level.INFO, "Unable to load properties file. Check the file server.properties under conf folder");
            }
            if ((ztiConf = ConfManager.getProperties(ztiConfFile)) == null) {
                logger.log(Level.INFO, "Unable to load properties file. Check the file zti.properties under conf folder");
            }
            if ((licenseConf = ConfManager.getProperties(licenseConfFile)) != null) {
                logger.log(Level.INFO, "License configuration files loaded...");
            }
            ssl = !serverConf.getProperty("ssl", "true").equals("false");
            ConfManager.setNotifyServer((ssl ? "https://" : "http://") + serverConf.getProperty("notify").toString());
            prdcode = serverConf.getProperty("prdcode").toString();
            useproxy = ztiConf.getProperty("proxy", "false").equals("true");
            proxyusername = ztiConf.getProperty("proxy.user");
            proxypasswd = ztiConf.getProperty("proxy.passwd");
            proxyport = ztiConf.getProperty("proxy.port");
            proxyhost = ztiConf.getProperty("proxy.host");
            retryexpiry = Integer.parseInt(serverConf.getProperty("retryexpiry", "" + retryexpiry));
            ConfManager.setZAPIkey(ztiConf.getProperty("zapikey"));
            scope = serverConf.getProperty("scope", scope);
            zsportal = ztiConf.getProperty("zsportal", zsportal);
            logger.log(Level.INFO, "ConfManager zsportal : " + zsportal);
            logger.log(Level.INFO, "ConfManager server prop: " + serverConf.toString());
            if (ConfManager.getZAPIKey() == null || ConfManager.getZAPIKey().equals("")) {
                logger.log(Level.INFO, "ConfManager invalid empty zapikey");
            }
            return true;
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Error while ConfManager.initialize : ", exp);
            return false;
        }
    }

    public static Properties getProperties(String propsFile) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            return props;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static String getTeleAdapterConfFilePath() {
        return teleConfFile;
    }

    public static String getAdapterHome() {
        return adapterhome;
    }

    public static boolean isProxyEnabled() {
        return useproxy;
    }

    public static String getProxyUserName() {
        return proxyusername;
    }

    public static String getProxyPasswd() {
        return proxypasswd;
    }

    public static String getProxyHost() {
        return proxyhost;
    }

    public static String getProxyPort() {
        return proxyport;
    }

    public static boolean isSSLEnabled() {
        return ssl;
    }

    public static int getRetrythreshold() {
        return retryexpiry;
    }

    public static String getScope() {
        return scope;
    }

    public static String getZSPortal() {
        return zsportal;
    }

    public static String getPrd() {
        return prdcode;
    }

    public static Hashtable getLicenseConfigurations() {
        return licenseConf;
    }

    public static String getZAPIKey() {
        return zapikey;
    }

    public static void setZAPIkey(String zapikey) {
        ConfManager.zapikey = zapikey;
    }

    public static String getNotifyServer() {
        return notifyserver;
    }

    public static void setNotifyServer(String notifyserver) {
        ConfManager.notifyserver = notifyserver;
    }

    static {
        adapterhome = System.getProperty("adapter.home");
        if (adapterhome == null) {
            adapterhome = ".";
        }
        System.setProperty("server.home", adapterhome);
        licenseConf = null;
        logger = Logger.getLogger(ConfManager.class.getName());
        serverConfFile = adapterhome + File.separator + "conf" + File.separator + "server.properties";
        ztiConfFile = adapterhome + File.separator + "conf" + File.separator + "zti.properties";
        teleConfFile = adapterhome + File.separator + "conf" + File.separator + "teleadapter.properties";
        licenseConfFile = adapterhome + File.separator + "conf" + File.separator + "license.properties";
        ssl = true;
        notifyserver = null;
        useproxy = false;
        proxyusername = null;
        proxypasswd = null;
        proxyhost = null;
        proxyport = null;
        zapikey = null;
        scope = "desktelephony";
        prdcode = "ZS";
        zsportal = null;
        retryexpiry = 43200000;
    }
}

