/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.websocket;

import com.adventnet.wms.nioclient.http.HttpRequestEventListener;
import com.adventnet.wms.nioclient.http.HttpRequestWrapper;
import com.zoho.desk.websocket.DMSClient;
import com.zoho.desk.websocket.DMSDomainHandler;
import com.zoho.desk.websocket.DMSReconnect;
import com.zoho.desk.websocket.DMSStatusHandler;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMSEventHandler
extends DMSStatusHandler
implements HttpRequestEventListener {
    private static final Logger LOGGER = Logger.getLogger(DMSEventHandler.class.getName());

    public void onConnectError(HttpRequestWrapper req) {
        LOGGER.log(Level.INFO, "onConnectError {0}", req);
        try {
            DMSClient.setAgentState(DMSStatusHandler.AgentStatus.ON_CONNECT_ERROR.ordinal());
            DMSReconnect.interruptReconnectThread();
            DMSReconnect.setDmsReconnect(null);
            if (!DMSEventHandler.isDmsConnected()) {
                DMSDomainHandler.getInstance().changeDC();
            }
            LOGGER.log(Level.INFO, "onConnectError - RECONNECT THREAD INITIATED");
            this.retryOnIncrementalTime(15000, 60000);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "onConnectError - ERROR DURING ON CONNECT ERROR HANDLING", ex);
        }
    }

    public void onReadTimeout(HttpRequestWrapper req) {
        LOGGER.log(Level.INFO, "onReadTimeout - ON READ TIMEOUT {0}", req);
        DMSReconnect.interruptReconnectThread();
        DMSReconnect.setDmsReconnect(null);
        this.invokeRetry(true);
    }

    public void onConnect(HttpRequestWrapper req) {
        LOGGER.log(Level.INFO, "onConnect - ON CONNECT {0}", req);
    }

    public void onSubmit(HttpRequestWrapper req) {
        DMSEventHandler.setAgentState(DMSStatusHandler.AgentStatus.ACTIVE.ordinal());
        LOGGER.log(Level.INFO, "onSubmit - ON SUBMIT {0}", req);
    }

    public void onSubmitError(HttpRequestWrapper req) {
        LOGGER.log(Level.INFO, "onSubmitError - ON SUBMIT ERROR {0}", req);
        this.invokeRetry(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(HttpRequestWrapper req) {
        try {
            DMSEventHandler dMSEventHandler = this;
            synchronized (dMSEventHandler) {
                String response = req.getResponse().getResponseString();
                if (!response.isEmpty()) {
                    String repLog = response.replaceAll("(\\s*?[^~,]+dbpw[^~,]+\\s*?:\\s*?)[^~,]+,", "$1\"******\"");
                    LOGGER.log(Level.INFO, "onResponse - Time: {0}, RESPONSE: {1}, RESPONSE HEADERS: {2}", new Object[]{new Date(), repLog, req.getResponse().getResponseHeaders()});
                }
                DMSClient.getInstance().handleResponse(response);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "onResponse - Error", ex);
        }
    }

    public void onResponseError(HttpRequestWrapper req) {
        LOGGER.log(Level.INFO, "onResponseError - ON RESPONSE ERROR {0}", req);
        this.invokeRetry(true);
    }

    public void onWriteRefill(HttpRequestWrapper httpRequestWrapper) {
    }

    public void onDisconnect(HttpRequestWrapper req) {
        try {
            LOGGER.log(Level.INFO, "onDisconnect - ON DISCONNECT {0}", req);
            Thread.sleep(1000L);
            int agentStatus = DMSClient.getAgentState();
            DMSReconnect.interruptReconnectThread();
            DMSReconnect.setDmsReconnect(null);
            if (DMSStatusHandler.isCreateNewSession()) {
                DMSClient.getInstance().initializeConnectivity();
            } else if (agentStatus == DMSStatusHandler.AgentStatus.DOS_TEMP.ordinal()) {
                this.invokeRetryOnNewThread(60000L);
            } else if (agentStatus == DMSStatusHandler.AgentStatus.SERVICE_DOWN.ordinal()) {
                this.invokeRetryOnNewThread(300000L);
            } else if (agentStatus != DMSStatusHandler.AgentStatus.DOS_PERM.ordinal() && agentStatus != DMSStatusHandler.AgentStatus.ON_CONNECT_ERROR.ordinal() && agentStatus != DMSStatusHandler.AgentStatus.AUTH_FAILED.ordinal() && !DMSEventHandler.isAgentDisconnect()) {
                this.invokeRetry(false);
            }
            if (DMSEventHandler.isAgentDisconnect() && agentStatus != DMSStatusHandler.AgentStatus.DOS_PERM.ordinal() && agentStatus != DMSStatusHandler.AgentStatus.ON_CONNECT_ERROR.ordinal() && agentStatus != DMSStatusHandler.AgentStatus.AUTH_FAILED.ordinal()) {
                LOGGER.log(Level.INFO, "onDisconnect - CLOSING - OLDER SESSION");
                DMSEventHandler.setAgentDisconnect(false);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "onDisconnect - ERROR DURING ON DISCONNECT", ex);
        }
    }

    public void onPingSent(HttpRequestWrapper httpRequestWrapper) {
        DMSEventHandler.setPingTime(System.currentTimeMillis());
        DMSEventHandler.setDmsConnected(false);
    }

    public void onPongReceived(HttpRequestWrapper httpRequestWrapper, byte[] bytes) {
        try {
            DMSClient.getInstance().handlePongResponse();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "onPongReceived - PONG RESPONSE HANDLER", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRetry(boolean delay) {
        try {
            DMSEventHandler dMSEventHandler = this;
            synchronized (dMSEventHandler) {
                if (!this.isRetryInvoked()) {
                    LOGGER.log(Level.INFO, "INVOKING RETRY REQUEST");
                    if (delay) {
                        DMSClient.handleDisconnect();
                    } else {
                        DMSClient.handleDisconnectWithOutDelay();
                    }
                    this.setRetryInvoked(true);
                    LOGGER.log(Level.INFO, "INVOKING RETRY REQUEST FLAG SET TO TRUE");
                } else {
                    LOGGER.log(Level.INFO, "INVOKING RETRY REQUEST - ALREADY INITIALED");
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "INVOKING RETRY REQUEST ERROR", ex);
        }
    }

    public void invokeRetryOnTimeInterval(long milliSec) {
        try {
            Thread.sleep(milliSec);
            this.invokeRetry(false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "invokeRetryOnTimeInterval ERROR", ex);
        }
    }

    public void invokeRetryOnNewThread(long milliSec) {
        new Thread(() -> this.invokeRetryOnTimeInterval(milliSec)).start();
    }

    public void retryOnIncrementalTime(int incMilliSec, int incTill) {
        int retryTime = DMSEventHandler.getRetryTime();
        if (incTill > retryTime) {
            DMSEventHandler.setRetryTime(retryTime += incMilliSec);
        }
        this.invokeRetryOnNewThread(retryTime);
    }
}

