/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs.dfs;

import com.adventnet.dfs.DFSClient;
import com.adventnet.dfs.DFSClientPool;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.wfs.WFSConfManager;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import com.zoho.ear.fileencryptagent.FileEncryptAgent;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DFS {
    private static Logger logger = Logger.getLogger(DFS.class.getName());
    private static String serviceName = "wms";
    private static boolean useGZIP = true;

    public static boolean initialize() {
        try {
            DFSClientPool.initialize();
            logger.log(Level.INFO, "WFS--> DFS initialized");
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WFSERR--> Exception during initialization of DFS", ex);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_DFS_NOTINITIALIZE.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_DFS_NOTINITIALIZE");
            return false;
        }
    }

    public static String write(String scopeID, String entityID, String keyFilePath, InputStream fis) {
        return DFS.write(scopeID, entityID, keyFilePath, fis, null);
    }

    public static String write(String scopeID, String entityID, String keyFilePath, InputStream fis, String gridID) {
        String blockID = null;
        byte[] buffer = new byte[WFSConfManager.getWriteBufferSize()];
        int bytesRead = -1;
        DFSClient dfsClient = null;
        try {
            dfsClient = gridID != null ? DFSClientPool.getWriteDFSClientForGrid((String)scopeID, (String)serviceName, (String)gridID) : DFSClientPool.getDFSClient((String)scopeID, (String)serviceName);
            try (OutputStream out = dfsClient.write(keyFilePath, true, (short)3, false, true);){
                if (WFSConfManager.isFileEncryptionEnabled()) {
                    OutputStream earOutStream = FileEncryptAgent.getInstance().getEncryptOutputStream(entityID, out, false, WFSConfManager.getWMSEARRefreshToken());
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        earOutStream.write(buffer, 0, bytesRead);
                    }
                } else {
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                blockID = dfsClient.getBlockId();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WFS-->[DFSEXCEPTION] Error at write DFS :: keyFilePath:" + keyFilePath + "::scopeID:" + scopeID, ex);
                throw ex;
            }
            finally {
                if (dfsClient != null) {
                    try {
                        if (blockID == null) {
                            blockID = dfsClient.getBlockId();
                        }
                    }
                    catch (Exception ex) {
                        blockID = null;
                    }
                    DFSClientPool.returnDFSClient((DFSClient)dfsClient);
                    dfsClient = null;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at write DFS :: keyFilePath:" + keyFilePath + "::scopeID:" + scopeID, ex);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.DFS_WRITE_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("DFS_WRITE_FAILED");
        }
        return blockID;
    }

    /*
     * Exception decompiling
     */
    public static boolean load(String scopeID, String entityID, String blockID, String dfsFilePath, boolean isEncrypt, FileOutputStream fos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream read(String scopeID, String entityID, String blockID, String dfsFilePath, boolean isEncrypt) {
        try {
            DFSClient dfsClient = DFSClientPool.getDFSClient((String)scopeID, (String)serviceName);
            try {
                InputStream in = dfsClient.read(dfsFilePath, blockID, true, false);
                if (isEncrypt) {
                    InputStream earInStream;
                    InputStream inputStream2 = earInStream = FileEncryptAgent.getInstance().getDecryptInputStream(entityID, in, false, WFSConfManager.getWMSEARRefreshToken());
                    return inputStream2;
                }
                InputStream inputStream = in;
                return inputStream;
            }
            finally {
                if (dfsClient != null) {
                    DFSClientPool.returnDFSClient((DFSClient)dfsClient);
                    dfsClient = null;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at read DFS :: dfsFilePath:" + dfsFilePath + "::scopeID:" + scopeID + "::blockID:" + blockID, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.DFS_READ_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("DFS_READ_FAILED");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFile(String scopeID, String blockID, String dfsFilePath) {
        boolean result = false;
        DFSClient dfsClient = null;
        try {
            dfsClient = DFSClientPool.getDFSClient((String)scopeID, (String)serviceName);
            boolean isExist = false;
            try {
                isExist = dfsClient.exists(dfsFilePath, blockID);
            }
            catch (Exception ex) {
                isExist = false;
            }
            if (isExist) {
                ArrayList<String> al = new ArrayList<String>();
                al.add(dfsFilePath);
                dfsClient.delete(al, blockID, true);
            } else {
                logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at delete DFS, File not exist in DFS :: dfsFilePath:{0}::scopeID:{1}::blockID:{2}", new Object[]{dfsFilePath, scopeID, blockID});
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at delete DFS :: dfsFilePath:" + dfsFilePath + "::scopeID:" + scopeID + "::blockID:" + blockID, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.DFS_DELETE_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("DFS_DELETE_FAILED");
        }
        finally {
            if (dfsClient != null) {
                DFSClientPool.returnDFSClient((DFSClient)dfsClient);
                dfsClient = null;
            }
        }
        return result;
    }
}

