/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs.cassandra;

import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.wfs.WFD;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSCassandraManager;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WFSFileMappingCF {
    private static Logger logger = Logger.getLogger(WFSFileMappingCF.class.getName());
    private static String cfname = "wfsfilemapping";
    private static String keyspacename = "WFS";

    private static ArrayList getData(String storage, String entityID, int limit, UUID start, UUID end) {
        return WFSFileMappingCF.getData(storage, entityID, null, null, limit, start, end);
    }

    public static ArrayList getData(String storage, String entityID, String folderName, String filePath, int limit, UUID start, UUID end) {
        ArrayList returnList = new ArrayList();
        if (limit <= 0) {
            logger.info("WFS--> Count less than zero,  storage=" + storage + ",entityID=" + entityID);
            return returnList;
        }
        try {
            long startTime = System.currentTimeMillis();
            Statement getStatement = WFSFileMappingCF.getSelectStatement(storage, entityID, folderName, filePath, start, end, limit);
            ResultSet getResult = QueryExecutor.execute(WFSCassandraManager.getSession(), getStatement);
            List getResultList = getResult.all();
            if (getResultList.size() == 0) {
                return returnList;
            }
            for (Row row : getResultList) {
                Hashtable<String, String> data = new Hashtable<String, String>();
                if (row.getString("value") == null) continue;
                data.put("storage", "" + row.getString("storage"));
                data.put("entityID", "" + row.getString("entityID"));
                data.put("foldername", "" + row.getString("foldername"));
                data.put("filepath", "" + row.getString("filepath"));
                data.put("ctime", "" + row.getUUID("ctime"));
                data.put("data", row.getString("value"));
                returnList.add(data);
            }
            if (returnList.size() == 1) {
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA", "GET", System.currentTimeMillis() - startTime);
            } else {
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA", "GET_LIST", System.currentTimeMillis() - startTime);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at getdataFrom cassandra,storage:" + storage + "::entityID:" + entityID + "::filePath:" + filePath, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_GETLIST_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_GETLIST_FAILED");
        }
        return returnList;
    }

    public static ArrayList getData(String storage, String entityID, String folderName, int limit, WFD wfd) {
        ArrayList returnList = new ArrayList();
        if (limit <= 0) {
            logger.info("WFS--> Count less than zero,  storage=" + storage + ",entityID=" + entityID);
            return returnList;
        }
        try {
            long startTime = System.currentTimeMillis();
            Statement getStatement = WFSFileMappingCF.getSelectListStatement(storage, entityID, folderName, null, wfd, limit);
            ResultSet getResult = QueryExecutor.execute(WFSCassandraManager.getSession(), getStatement);
            List getResultList = getResult.all();
            if (getResultList.size() == 0) {
                return returnList;
            }
            for (Row row : getResultList) {
                Hashtable<String, String> data = new Hashtable<String, String>();
                if (row.getString("value") == null) continue;
                data.put("storage", "" + row.getString("storage"));
                data.put("entityID", "" + row.getString("entityID"));
                data.put("foldername", "" + row.getString("foldername"));
                data.put("filepath", "" + row.getString("filepath"));
                data.put("ctime", "" + row.getUUID("ctime"));
                data.put("data", row.getString("value"));
                returnList.add(data);
            }
            if (returnList.size() == 1) {
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA", "GET", System.currentTimeMillis() - startTime);
            } else {
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA", "GET_FILE_LIST", System.currentTimeMillis() - startTime);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at getdataFrom cassandra,storage:" + storage + "::entityID:" + entityID + "::wfd:" + wfd, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_GETFILELIST_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_GETFILELIST_FAILED");
        }
        return returnList;
    }

    public static Hashtable getLatest(String storage, String entityID, String folderName, String filePath) {
        return WFSFileMappingCF.getData(storage, entityID, folderName, filePath, null);
    }

    public static Hashtable getData(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        ArrayList returnList = WFSFileMappingCF.getData(storage, entityID, folderName, filePath, 1, tuuid, tuuid);
        if (returnList.size() == 1) {
            return (Hashtable)returnList.get(0);
        }
        return null;
    }

    public static boolean insertData(String storage, String entityID, String folderName, String filePath, UUID tuuid, String data) {
        try {
            long startTime = System.currentTimeMillis();
            Statement insertStatement = WFSFileMappingCF.getInsertStatement(storage, entityID, folderName, filePath, tuuid, data, System.currentTimeMillis());
            ResultSet insertResult = QueryExecutor.execute(WFSCassandraManager.getSession(), insertStatement);
            WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA", "INSERT", System.currentTimeMillis() - startTime);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at insertion of cassandra wfsfilemapping ,storage:" + storage + "::entityID:" + entityID + "::filePath:" + filePath, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_INSERT_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_INSERT_FAILED");
            return false;
        }
    }

    public static boolean deleteData(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        try {
            long startTime = System.currentTimeMillis();
            Statement deleteStatement = WFSFileMappingCF.getDeleteStatement(storage, entityID, folderName, filePath, tuuid);
            ResultSet deleteResult = QueryExecutor.execute(WFSCassandraManager.getSession(), deleteStatement);
            WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA", "DELETE", System.currentTimeMillis() - startTime);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at deletion of cassandra wfsfilemapping ,storage:" + storage + "::entityID:" + entityID + "::filePath:" + filePath, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_DELETE_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_DELETE_FAILED");
            return false;
        }
    }

    public static List getList(String storage, String entityID, int count, UUID start, UUID end) {
        return WFSFileMappingCF.getData(storage, entityID, count, start, end);
    }

    public static List getList(String storage, String entityID, String folderName, String filePath, int count, UUID start, UUID end) {
        return WFSFileMappingCF.getData(storage, entityID, folderName, filePath, count, start, end);
    }

    private static Statement getInsertStatement(String storage, String entityID, String folderName, String filePath, UUID ctime, String value, long clock) throws Exception {
        Insert statement = QueryBuilder.insertInto((String)QueryBuilder.quote((String)keyspacename), (String)QueryBuilder.quote((String)cfname)).using(QueryBuilder.timestamp((long)clock)).value("storage", (Object)storage).value("entityid", (Object)entityID).value("foldername", (Object)folderName).value("filepath", (Object)filePath).value("ctime", (Object)ctime).value("value", (Object)value);
        return statement;
    }

    private static Statement getSelectStatement(String storage, String entityID, String folderName, String filePath, UUID start, UUID end, int limit) throws Exception {
        Select.Selection selection = QueryBuilder.select();
        Select.Builder builder = selection.all();
        Select select = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfname));
        Select.Where where = select.where(QueryBuilder.eq((String)"storage", (Object)storage));
        where = where.and(QueryBuilder.eq((String)"entityid", (Object)entityID));
        if (folderName != null) {
            where = where.and(QueryBuilder.eq((String)"foldername", (Object)folderName));
            if (filePath != null) {
                where = where.and(QueryBuilder.eq((String)"filepath", (Object)filePath));
                if (start != null && limit == 1) {
                    where = where.and(QueryBuilder.eq((String)"ctime", (Object)start));
                    return select;
                }
                if (start != null) {
                    where = where.and(QueryBuilder.lte((String)"ctime", (Object)start));
                }
                if (end != null) {
                    where = where.and(QueryBuilder.gt((String)"ctime", (Object)end));
                }
            }
        }
        if (limit > 0) {
            select = where.limit(limit);
            return select;
        }
        return where;
    }

    private static Statement getSelectListStatement(String storage, String entityID, String folderName, String filePath, WFD wfd, int limit) throws Exception {
        Select.Selection selection = QueryBuilder.select();
        Select.Builder builder = selection.all();
        Select select = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfname));
        Select.Where where = select.where(QueryBuilder.eq((String)"storage", (Object)storage));
        where = where.and(QueryBuilder.eq((String)"entityid", (Object)entityID));
        if (wfd != null) {
            if (folderName != null) {
                where = where.and(QueryBuilder.eq((String)"foldername", (Object)folderName));
                if (filePath != null) {
                    where = where.and(QueryBuilder.eq((String)"filepath", (Object)wfd.getSourcePath()));
                    where = where.and(QueryBuilder.lt((String)"ctime", (Object)UUID.fromString(wfd.getTuuid())));
                } else {
                    where = where.and(QueryBuilder.lt((String)"filepath", (Object)wfd.getSourcePath()));
                }
            } else {
                where = where.and(QueryBuilder.lt((String)"foldername", (Object)wfd.getFolderName()));
            }
        } else if (folderName != null) {
            where = where.and(QueryBuilder.eq((String)"foldername", (Object)folderName));
            if (filePath != null) {
                where = where.and(QueryBuilder.eq((String)"filepath", (Object)wfd.getSourcePath()));
            }
        }
        if (limit > 0) {
            select = where.limit(limit);
            return select;
        }
        return where;
    }

    private static Statement getDeleteStatement(String storage, String entityID, String folderName, String filePath, UUID uuid) {
        Delete.Selection selection = QueryBuilder.delete();
        Delete.Builder builder = selection.all();
        Delete del = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfname));
        Delete.Where where = del.where(QueryBuilder.eq((String)"storage", (Object)storage));
        where = where.and(QueryBuilder.eq((String)"entityid", (Object)entityID));
        if (folderName != null && folderName != "") {
            where = where.and(QueryBuilder.eq((String)"foldername", (Object)folderName));
            if (filePath != null && filePath != "") {
                where = where.and(QueryBuilder.eq((String)"filepath", (Object)filePath));
                if (uuid != null) {
                    where = where.and(QueryBuilder.eq((String)"ctime", (Object)uuid));
                }
            }
        }
        return where;
    }
}

