/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.wfs.WFD;
import com.adventnet.wms.servercommon.wfs.WFSCleanupManager;
import com.adventnet.wms.servercommon.wfs.WFSConfManager;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSAtticCF;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSCassandraManager;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSFileMappingCF;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSUtil;
import com.adventnet.wms.servercommon.wfs.dfs.DFS;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WFS {
    private static Logger logger = Logger.getLogger(WFS.class.getName());
    private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
    private static Pattern pattern = Pattern.compile("[A-Za-z0-9_-]*$");

    public static boolean initialize() {
        try {
            WFS.initInfluxStatsConf();
            if (!WFSConfManager.initialize()) {
                logger.log(Level.SEVERE, "WFSERR--> WFS confManager not initialized");
                return false;
            }
            if (!WFSCassandraManager.initialize()) {
                logger.log(Level.SEVERE, "WFSERR--> WFS cassandra manager not initialized");
                return false;
            }
            if (!DFS.initialize()) {
                logger.log(Level.SEVERE, "WFSERR--> DFS not initialized");
                return false;
            }
            if (!WFSCleanupManager.initialize()) {
                logger.log(Level.SEVERE, "WFSERR--> WFSCleanup not initialized");
                return false;
            }
            logger.log(Level.INFO, "WFS--> WFS initialized Successfully");
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WFSERR--> WFS not initialized Ex:{0}", ex);
        }
        catch (Error er) {
            logger.log(Level.SEVERE, "WFSERR--> WFS not initialized Ex:{0}", er);
            throw er;
        }
        return false;
    }

    public static String getDateFormat(long ms) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ms);
        return new SimpleDateFormat("yyyy_MM_dd").format(c.getTime());
    }

    public static long getTimeFromUUID(UUID uuid) {
        return (uuid.timestamp() - 122192928000000000L) / 10000L;
    }

    private static void initInfluxStatsConf() {
        try {
            Hashtable<String, String> statsDefs = new Hashtable<String, String>();
            statsDefs.put("wfs_overall_data", "[[\"qos\",\"qos_wfs\",\"\",\"wfs_overall_data\",false],[\"servertype\",\"storage\",\"foldername\",\"opr\",\"type\"],[],[\"count\",\"timetaken\"]]");
            statsDefs.put("wfs_monitoring_error", "[[\"qos\",\"qos_wfs\",\"\",\"wfs_monitoring_error\",false],[\"error_type\",\"servertype\",\"cluster\"],[],[\"count\"]]");
            statsDefs.put("wfsfilesize", "[[\"qos\",\"qos_wfs\",\"\",\"qos_wfs_sizemetric\",false,true,\"1024\"],[\"storage\",\"foldername\",\"type\",\"opr\"],[],[\"objsize\"]]");
            if (StatsConf.loadStatsKeyDef(statsDefs)) {
                StatsDB.initialize();
                logger.log(Level.INFO, "WFS--> Influx Stats Initialized!!");
            }
            WFSStats.enableStats();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS--> Error initializing Influx ", e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_INFLUXSTATS_NOTINITIALIZE.getErrorCode(), 1L);
        }
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String localFilePath) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, null, localFilePath);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, String localFilePath) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, gridID, localFilePath, -1);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String localFilePath, int versionCount) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, null, localFilePath, versionCount);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, String localFilePath, int versionCount) throws Exception {
        if (localFilePath != null) {
            return WFS.save(storage, folderName, entityID, sourcePath, gridID, new File(localFilePath), versionCount);
        }
        return null;
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, File file) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, null, file);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, File file) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, gridID, file, -1);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, File file, int versionCount) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, null, file, versionCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, File file, int versionCount) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            WFD wFD = WFS.save(storage, folderName, entityID, sourcePath, gridID, in, file.length(), versionCount);
            return wFD;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, InputStream fis, long size) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, null, fis, size, -1);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, InputStream fis, long size, String dfsPath) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, null, fis, size, -1, null);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, InputStream fis, long size) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, gridID, fis, size, -1);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, InputStream fis, long size, int versionCount) throws Exception {
        return WFS.save(storage, folderName, entityID, sourcePath, gridID, fis, size, -1, null);
    }

    public static WFD save(String storage, String folderName, String entityID, String sourcePath, String gridID, InputStream fis, long size, int versionCount, String dfsFilePath) throws Exception {
        StringBuilder sb;
        String blockID = null;
        WFD fd = null;
        int versionLimit = 0;
        Random rand = new Random();
        String scopeID = "" + (rand.nextInt(WFSConfManager.getScopeIDRange()) + 1);
        UUID tuuid = WFSUtil.Cassandra.getTimeUUID();
        if (dfsFilePath == null) {
            dfsFilePath = storage + "_" + entityID + "_" + folderName + "_" + tuuid;
        }
        if (!pattern.matcher(dfsFilePath).matches()) {
            sb = new StringBuilder().append("WFSERR--> dfsFilePath contains splCharacters, EntityID=").append(entityID).append(" dfsFilePath=").append(dfsFilePath);
            logger.log(Level.SEVERE, sb.toString());
        }
        if (dfsFilePath.length() > 255) {
            sb = new StringBuilder().append("WFS--> dfsFilePath length greater than 255, EntityID=").append(entityID).append(" dfsFilePath=").append(dfsFilePath);
            logger.log(Level.SEVERE, sb.toString());
        }
        WFSStats.addWFSFileSizeStat(storage, folderName, "WFS", "SAVE", size);
        long startTime = System.currentTimeMillis();
        blockID = DFS.write(scopeID, entityID, dfsFilePath, fis, gridID);
        WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "DFS", "WRITE", System.currentTimeMillis() - startTime);
        if (blockID != null) {
            WFSStats.addWFSFileSizeStat(storage, folderName, "DFS", "SAVE", size);
            fd = new WFD(storage, entityID, sourcePath, folderName, dfsFilePath, blockID, size, "" + tuuid, scopeID, WFSConfManager.isFileEncryptionEnabled());
            WFSFileMappingCF.insertData(storage, entityID, folderName, sourcePath, tuuid, fd.toString());
            startTime = System.currentTimeMillis() - startTime;
            versionLimit = versionCount <= 0 ? WFSConfManager.getVersionCount() : versionCount;
            List result = WFSFileMappingCF.getList(storage, entityID, folderName, sourcePath, versionLimit + 1, tuuid, null);
            if (result.size() > 1) {
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "UPDATE", startTime);
            } else {
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "CREATE", startTime);
            }
            if (WFSConfManager.isCleanupEnabled() && result.size() > versionLimit) {
                Hashtable dbData = (Hashtable)result.get(result.size() - 1);
                WFS.cleanup(storage, entityID, folderName, sourcePath, UUID.fromString((String)dbData.get("ctime")));
            }
        } else {
            logger.log(Level.INFO, "WFS--> save failed!! null blockID storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, sourcePath});
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_BLOCKID_NULL.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_BLOCKID_NULL");
        }
        return fd;
    }

    public static WFD save(WFD wfd, int versionCount) {
        int versionLimit = 0;
        WFSStats.addWFSFileSizeStat(wfd.getStorage(), wfd.getFolderName(), "WFS", "SAVE", wfd.getSize());
        long startTime = System.currentTimeMillis();
        try {
            if (wfd.getBlockID() != null && WFSFileMappingCF.insertData(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()), wfd.toString())) {
                WFSStats.addWFSFileSizeStat(wfd.getStorage(), wfd.getFolderName(), "DFS", "SAVE", wfd.getSize());
                startTime = System.currentTimeMillis() - startTime;
                versionLimit = versionCount <= 0 ? WFSConfManager.getVersionCount() : versionCount;
                List result = WFSFileMappingCF.getList(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), versionLimit + 1, UUID.fromString(wfd.getTuuid()), null);
                if (result.size() > 1) {
                    WFSStats.addWFSOverallStat(DC.getServertype(), wfd.getStorage(), wfd.getFolderName(), "WFS", "UPDATE", startTime);
                } else {
                    WFSStats.addWFSOverallStat(DC.getServertype(), wfd.getStorage(), wfd.getFolderName(), "WFS", "CREATE", startTime);
                }
                if (WFSConfManager.isCleanupEnabled() && result.size() > versionLimit) {
                    Hashtable dbData = (Hashtable)result.get(result.size() - 1);
                    WFS.cleanup(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), UUID.fromString((String)dbData.get("ctime")));
                }
                return wfd;
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "WFS--> save failed!! null blockID storage:{0}::entityID:{1}::filePath:{2}", new Object[]{wfd.getStorage(), wfd.getEntityID(), wfd.getSourcePath()});
        }
        return null;
    }

    public static boolean load(WFD wfd, String destPath) throws FileNotFoundException {
        if (wfd != null && destPath != null) {
            return WFS.load(wfd.getStorage(), wfd.getFolderName(), wfd.getEntityID(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()), destPath);
        }
        return false;
    }

    public static boolean load(WFD wfd, File file) throws FileNotFoundException {
        if (wfd != null && file != null) {
            return WFS.load(wfd.getStorage(), wfd.getFolderName(), wfd.getEntityID(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()), file);
        }
        return false;
    }

    public static boolean load(WFD wfd, FileOutputStream fos) throws FileNotFoundException {
        if (wfd != null) {
            return WFS.load(wfd.getStorage(), wfd.getFolderName(), wfd.getEntityID(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()), fos);
        }
        return false;
    }

    public static boolean load(String storage, String folderName, String entityID, String filePath, String destPath) throws FileNotFoundException {
        return WFS.load(storage, folderName, entityID, filePath, null, destPath);
    }

    public static boolean load(String storage, String folderName, String entityID, String filePath, UUID tuuid, String destPath) throws FileNotFoundException {
        return WFS.load(storage, folderName, entityID, filePath, tuuid, new File(destPath));
    }

    public static boolean load(String storage, String folderName, String entityID, String filePath, File file) {
        return WFS.load(storage, folderName, entityID, filePath, null, file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load(String storage, String folderName, String entityID, String filePath, UUID tuuid, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            boolean bl = WFS.load(storage, folderName, entityID, filePath, tuuid, fos);
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean load(String storage, String folderName, String entityID, String filePath, FileOutputStream fos) {
        return WFS.load(storage, folderName, entityID, filePath, null, fos);
    }

    public static boolean load(String storage, String folderName, String entityID, String filePath, UUID tuuid, FileOutputStream fos) {
        long startTime = System.currentTimeMillis();
        Hashtable dbData = WFSFileMappingCF.getData(storage, entityID, folderName, filePath, tuuid);
        WFD wfd = null;
        if (dbData != null && dbData.get("data") != null) {
            wfd = new WFD((String)dbData.get("data"));
            long dfsTime = System.currentTimeMillis();
            boolean status = DFS.load(wfd.getScopeID(), wfd.getEntityID(), wfd.getBlockID(), wfd.getDfsFilePath(), wfd.isEncrypt(), fos);
            if (status) {
                WFSStats.addWFSFileSizeStat(storage, folderName, "DFS", "LOAD", wfd.getSize());
                WFSStats.addWFSFileSizeStat(storage, folderName, "WFS", "LOAD", wfd.getSize());
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "DFS", "LOAD", System.currentTimeMillis() - dfsTime);
                WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "LOAD", System.currentTimeMillis() - startTime);
                return status;
            }
            logger.log(Level.INFO, "WFS--> load failed!! status null storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, filePath});
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_LOAD_FAILURE.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_LOAD_FAILURE");
        }
        return false;
    }

    public static boolean delete(String storage, String entityID) {
        return WFS.delete(storage, entityID, null, null);
    }

    public static boolean delete(String storage, String entityID, String folderName) {
        return WFS.delete(storage, entityID, folderName, null, null);
    }

    public static boolean delete(String storage, String entityID, String folderName, String filePath) {
        return WFS.delete(storage, entityID, folderName, filePath, null);
    }

    public static boolean delete(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        if (storage == null || entityID == null) {
            return false;
        }
        int limit = 10;
        if (tuuid != null) {
            limit = 1;
        }
        ArrayList returnList = WFSFileMappingCF.getData(storage, entityID, folderName, filePath, limit, tuuid, tuuid);
        while (returnList.size() > 0) {
            for (Hashtable dbData : returnList) {
                if (dbData == null || dbData.get("data") == null) continue;
                WFD wfd = new WFD((String)dbData.get("data"));
                if (wfd.getScopeID() != null && wfd.getEntityID() != null && wfd.getStorage() != null && wfd.getFolderName() != null) {
                    long startTime = System.currentTimeMillis();
                    if (WFSConfManager.isForceDelete(wfd.getStorage(), wfd.getFolderName())) {
                        if (DFS.deleteFile(wfd.getScopeID(), wfd.getBlockID(), wfd.getDfsFilePath())) {
                            WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "DFS", "FORCE_DELETE", System.currentTimeMillis() - startTime);
                            tuuid = UUID.fromString(wfd.getTuuid());
                            WFSFileMappingCF.deleteData(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), tuuid);
                            WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "FORCE_DELETE", System.currentTimeMillis() - startTime);
                            return true;
                        }
                        logger.log(Level.INFO, "WFS-->force delete failed!! storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, filePath});
                        StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_DELETE_FAILURE.getErrorCode(), 1L);
                        WFSStats.addErrorStats("WFS_FORCE_DELETE_FAILURE");
                        continue;
                    }
                    if (WFSAtticCF.insert(wfd)) {
                        WFSFileMappingCF.deleteData(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()));
                        WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "DELETE", System.currentTimeMillis() - startTime);
                        return true;
                    }
                    logger.log(Level.INFO, "WFS-->delete failed!! storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, filePath});
                    StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_DELETE_FAILURE.getErrorCode(), 1L);
                    WFSStats.addErrorStats("WFS_DELETE_FAILURE");
                    continue;
                }
                logger.log(Level.INFO, "WFS-->delete failed!! scope id/entityID null. ScopeID:{0} storage:{1}::entityID:{2}::filePath:{3}", new Object[]{wfd.getScopeID(), storage, entityID, filePath});
                StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_DELETE_SCOPEID_NULL.getErrorCode(), 1L);
                WFSStats.addErrorStats("WFS_DELETE_FAILURE");
            }
            returnList = WFSFileMappingCF.getData(storage, entityID, folderName, filePath, limit, tuuid, tuuid);
        }
        return false;
    }

    private static boolean cleanup(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        List result = WFSFileMappingCF.getList(storage, entityID, folderName, filePath, 10, tuuid, null);
        while (result.size() > 0) {
            if (WFS.cleanup(storage, entityID, folderName, filePath, tuuid, result)) {
                result = WFSFileMappingCF.getList(storage, entityID, folderName, filePath, 10, tuuid, null);
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean cleanup(String storage, String entityID, String folderName, String filePath, UUID tuuid, List result) {
        try {
            for (Object object : result) {
                WFD wfd;
                Hashtable dbData = (Hashtable)object;
                if (dbData == null || dbData.get("data") == null || (wfd = new WFD((String)dbData.get("data"))).getScopeID() == null || wfd.getEntityID() == null || wfd.getStorage() == null || wfd.getFolderName() == null) continue;
                long startTime = System.currentTimeMillis();
                if (WFSConfManager.isForceDelete(wfd.getStorage(), wfd.getFolderName())) {
                    if (DFS.deleteFile(wfd.getScopeID(), wfd.getBlockID(), wfd.getDfsFilePath())) {
                        WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "DFS", "FORCE_DELETE", System.currentTimeMillis() - startTime);
                        tuuid = UUID.fromString(wfd.getTuuid());
                        WFSFileMappingCF.deleteData(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()));
                        WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "FORCE_DELETE", System.currentTimeMillis() - startTime);
                        continue;
                    }
                    logger.log(Level.INFO, "WFS-->force delete failed!! storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, filePath});
                    StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_DELETE_FAILURE.getErrorCode(), 1L);
                    WFSStats.addErrorStats("WFS_FORCE_DELETE_FAILURE");
                    continue;
                }
                if (WFSAtticCF.insert(wfd)) {
                    WFSFileMappingCF.deleteData(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()));
                    WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS", "DELETE", System.currentTimeMillis() - startTime);
                    continue;
                }
                logger.log(Level.INFO, "WFS-->delete failed!! storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, filePath});
                StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_DELETE_FAILURE.getErrorCode(), 1L);
                WFSStats.addErrorStats("WFS_DELETE_FAILURE");
            }
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Cleanup Exception!! storage:" + storage + "::entityID:" + entityID + "::filePath:" + filePath + "::tuuid:" + tuuid, ex);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CLEANUP_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CLEANUP_FAILED");
            return false;
        }
    }

    public static InputStream getInputStream(String storage, String entityID, String folderName, String filePath) {
        return WFS.getInputStream(storage, entityID, folderName, filePath, null);
    }

    public static InputStream getInputStream(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        WFD wfd = WFS.getWFD(storage, entityID, folderName, filePath, tuuid);
        return WFS.getInputStream(wfd);
    }

    public static InputStream getInputStream(WFD wfd) {
        if (wfd != null) {
            long dfsTime = System.currentTimeMillis();
            InputStream stream = DFS.read(wfd.getScopeID(), wfd.getEntityID(), wfd.getBlockID(), wfd.getDfsFilePath(), wfd.isEncrypt());
            if (stream != null) {
                WFSStats.addWFSFileSizeStat(wfd.getStorage(), wfd.getFolderName(), "DFS", "READ", wfd.getSize());
                WFSStats.addWFSFileSizeStat(wfd.getStorage(), wfd.getFolderName(), "WFS", "READ", wfd.getSize());
                WFSStats.addWFSOverallStat(DC.getServertype(), wfd.getStorage(), wfd.getFolderName(), "DFS", "READ", System.currentTimeMillis() - dfsTime);
                WFSStats.addWFSOverallStat(DC.getServertype(), wfd.getStorage(), wfd.getFolderName(), "WFS", "READ", System.currentTimeMillis() - dfsTime);
                return stream;
            }
            logger.log(Level.INFO, "WFS--> read failed!! status null storage:{0}::entityID:{1}::filePath:{2}", new Object[]{wfd.getStorage(), wfd.getEntityID(), wfd.getSourcePath()});
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_READ_FAILURE.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_READ_FAILURE");
        }
        return null;
    }

    public static boolean isFileExists(WFD wfd) {
        if (wfd != null) {
            return WFS.isFileExists(wfd.getStorage(), wfd.getEntityID(), wfd.getFolderName(), wfd.getSourcePath(), UUID.fromString(wfd.getTuuid()));
        }
        return false;
    }

    public static boolean isFileExists(String storage, String entityID, String folderName, String filePath) {
        return WFS.isFileExists(storage, entityID, folderName, filePath, null);
    }

    public static boolean isFileExists(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        Hashtable dbData = WFSFileMappingCF.getData(storage, entityID, folderName, filePath, tuuid);
        WFD wfd = null;
        if (dbData != null && dbData.get("data") != null) {
            wfd = new WFD((String)dbData.get("data"));
        }
        return wfd != null && wfd.getDfsFilePath() != null;
    }

    public static WFD getWFD(String storage, String entityID, String folderName, String filePath, UUID tuuid) {
        Hashtable dbData = WFSFileMappingCF.getData(storage, entityID, folderName, filePath, tuuid);
        WFD wfd = null;
        if (dbData != null && dbData.get("data") != null) {
            wfd = new WFD((String)dbData.get("data"));
        } else {
            logger.log(Level.INFO, "WFS--> getWFD failed!! wfdData null, storage:{0}::entityID:{1}::filePath:{2}", new Object[]{storage, entityID, filePath});
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_GETWFD_FAILURE.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_GETWFD_FAILURE");
        }
        return wfd;
    }

    public static long getFileSize(String storage, String entityID, String folderName, String filePath) {
        WFD wfd = WFS.getWFD(storage, entityID, folderName, filePath, null);
        if (wfd != null) {
            return wfd.getSize();
        }
        return 0L;
    }

    public static List<WFD> getFileList(String storage, String entityID, String folderName, int count, WFD wfd) {
        Set<WFD> data = Collections.synchronizedSet(WFS.getFileSet(storage, entityID, folderName, count, wfd));
        return new ArrayList<WFD>(data);
    }

    private static LinkedHashSet<WFD> getFileSet(String storage, String entityID, String folderName, int count, WFD wfd) {
        Map<String, WFD> resultMap = Collections.synchronizedMap(WFS.getFileMap(storage, entityID, folderName, count, wfd));
        return new LinkedHashSet<WFD>(resultMap.values());
    }

    private static LinkedHashMap<String, WFD> getFileMap(String storage, String entityID, String folderName, int count, WFD wfd) {
        ArrayList list = new ArrayList();
        LinkedHashMap<String, WFD> resultMap = new LinkedHashMap<String, WFD>();
        LinkedHashSet<WFD> resultSet = new LinkedHashSet<WFD>();
        list = WFSFileMappingCF.getData(storage, entityID, folderName, count, wfd);
        LinkedHashMap result = new LinkedHashMap();
        WFD latestwfd = null;
        for (Hashtable data : list) {
            if (data.get("filepath") == null || data.get("ctime") == null) continue;
            latestwfd = new WFD((String)data.get("data"));
            resultSet.add(latestwfd);
            if (resultMap.containsKey(latestwfd.getSourcePath())) continue;
            resultMap.put(latestwfd.getSourcePath(), latestwfd);
        }
        if (resultMap.size() < count && latestwfd != null) {
            LinkedHashMap<String, WFD> iterateMap = WFS.getFileMap(storage, entityID, folderName, count - resultMap.size(), latestwfd);
            for (String filepath : iterateMap.keySet()) {
                latestwfd = iterateMap.get(filepath);
                if (resultMap.containsKey(filepath)) continue;
                resultMap.put(filepath, latestwfd);
            }
        }
        return resultMap;
    }
}

