/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wdb.engine;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.wdb.engine.AbstractDB;
import com.adventnet.wms.servercommon.wdb.engine.MemoryDB;
import com.adventnet.wms.servercommon.wdb.engine.WDBIterator;
import com.adventnet.wms.servercommon.wdb.engine.WDBRecordBinding;
import com.adventnet.wms.servercommon.wdb.engine.WmsDB;
import com.zoho.instrument.common.CommonCall;
import com.zoho.instrument.common.TCBCall;
import java.io.File;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class WDBManager {
    private static Logger logger = Logger.getLogger(WDBManager.class.getName());
    private static final String WDBTYPE = "tc";
    private static ConcurrentHashMap<String, AbstractDB> dbmap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, WDBRecordBinding> binding = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> iterstatus = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> syncstatus = new ConcurrentHashMap();
    private static SortedSet<Integer> threadNameSet = new TreeSet<Integer>();
    private static String wmsDBConfFile = ServerUtil.serverHome + File.separator + "conf" + File.separator + "wmsdb.conf";
    private static ConcurrentHashMap<String, HashMap<String, AtomicLong>> wdbcounter = new ConcurrentHashMap(50, 0.75f, 50);
    private static ConcurrentHashMap<String, HashMap<String, AtomicLong>> wdbcounternew = new ConcurrentHashMap(50, 0.75f, 50);

    public static boolean initialize() {
        try {
            Properties dbconf = ServerUtil.getProperties(wmsDBConfFile);
            String bdbDir = ServerUtil.dataHome + "wdbfiles" + File.separator;
            File dir = new File(bdbDir);
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            if (!dir.exists()) {
                logger.severe("Unable to setup wmsdata home " + ServerUtil.dataHome);
                return false;
            }
            logger.info("Initializing Database");
            Enumeration<?> e = dbconf.propertyNames();
            while (e.hasMoreElements()) {
                String dbname = (String)e.nextElement();
                String bindClass = (String)dbconf.get(dbname);
                WDBRecordBinding bindObject = (WDBRecordBinding)Class.forName(bindClass).newInstance();
                binding.put(dbname, bindObject);
                AbstractDB db = null;
                try {
                    db = new WmsDB();
                }
                catch (Error er) {
                    er.printStackTrace();
                    logger.severe("Error : Unable to initialise WDB, Starting server with In-Memory DB");
                    db = new MemoryDB();
                }
                if (!((AbstractDB)db).open(bdbDir + dbname + ".bdb")) {
                    WDBManager.showError("create", db);
                    throw new WMSException("Unable create bd " + dbname);
                }
                dbmap.put(dbname, db);
                syncstatus.put(dbname, Boolean.TRUE);
                iterstatus.put(dbname, Boolean.FALSE);
                logger.info("DB " + dbname + " done");
            }
            new AutoSync().start();
            logger.info("DB Initialization completed");
        }
        catch (Exception exp) {
            exp.printStackTrace();
            logger.severe("Unable to setup db");
            return false;
        }
        return true;
    }

    public static TCBCall startInsrumentation(String db, String key, int type) {
        TCBCall call = null;
        if (!ServerUtil.isMiDisabled()) {
            try {
                call = WDBManager.getInstrumentation();
                call.start();
                call.setOperation(type);
                call.setKey(db + ":" + key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return call;
    }

    public static void stopInstrumentation(TCBCall call, Exception e) {
        if (!ServerUtil.isMiDisabled() && call != null) {
            if (e != null) {
                call.complete((Throwable)e);
            } else {
                call.complete();
            }
        }
    }

    public static void put(String db, String skey, Object value) throws WMSException {
        TCBCall call = null;
        try {
            call = WDBManager.startInsrumentation(db, skey, CommonCall.OperationType.WRITE.ordinal());
            WDBRecordBinding rbind = binding.get(db);
            long time = System.currentTimeMillis();
            long timeNano = System.nanoTime();
            if (!dbmap.get(db).put(rbind.getKey(skey), rbind.serialize(value))) {
                throw new WMSException("unable to put record for " + db);
            }
            WDBManager.stopInstrumentation(call, null);
            WDBManager.hit(db, "put", System.currentTimeMillis() - time);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "put", 1, System.nanoTime() - timeNano);
            }
            syncstatus.put(db, Boolean.FALSE);
        }
        catch (Exception e) {
            e.printStackTrace();
            WDBManager.stopInstrumentation(call, e);
            logger.warning("Unable to put record [" + db + "] [" + skey + "] => (" + value + ")");
            throw new WMSException("Unable to put record [" + db + "] [" + skey + "]");
        }
    }

    public static Object get(String db, String skey) throws WMSException {
        TCBCall call = null;
        try {
            call = WDBManager.startInsrumentation(db, skey, CommonCall.OperationType.READ.ordinal());
            long time = System.currentTimeMillis();
            long timeNano = System.nanoTime();
            WDBRecordBinding rbind = binding.get(db);
            Object obj = rbind.deserialize(dbmap.get(db).get(rbind.getKey(skey)));
            WDBManager.stopInstrumentation(call, null);
            WDBManager.hit(db, "get", System.currentTimeMillis() - time);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "get", 1, System.nanoTime() - timeNano);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            WDBManager.stopInstrumentation(call, e);
            logger.warning("Unable to get record [" + db + "] [" + skey + "]");
            throw new WMSException("Unable to get record [" + db + "] [" + skey + "]");
        }
    }

    public static boolean optimize(String db) throws WMSException {
        try {
            AbstractDB bdb = dbmap.get(db);
            return bdb.optimize();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warning("Unable to optimize db [" + db + "]");
            throw new WMSException("Unable to optimize db [" + db + "]");
        }
    }

    public static void delete(String db, String skey) throws WMSException {
        TCBCall call = null;
        try {
            call = WDBManager.startInsrumentation(db, skey, CommonCall.OperationType.DELETE.ordinal());
            AbstractDB bdb = dbmap.get(db);
            long time = System.currentTimeMillis();
            long timeNano = System.nanoTime();
            if (!bdb.out(binding.get(db).getKey(skey))) {
                WDBManager.showError("delete", bdb);
            }
            WDBManager.stopInstrumentation(call, null);
            WDBManager.hit(db, "delete", System.currentTimeMillis() - time);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "delete", 1, System.nanoTime() - timeNano);
            }
            syncstatus.put(db, Boolean.FALSE);
        }
        catch (Exception e) {
            WDBManager.stopInstrumentation(call, e);
            e.printStackTrace();
            logger.warning("Unable to delete record [" + db + "] [" + skey + "]");
            throw new WMSException("Unable to delete record [" + db + "] [" + skey + "]");
        }
    }

    public static void delete(String db, String[] keys) throws WMSException {
        for (String key : keys) {
            WDBManager.delete(db, key);
        }
    }

    public static long getAllRecordsCount(String db) throws WMSException {
        try {
            AbstractDB bdb = dbmap.get(db);
            return bdb.rnum();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warning("Unable to get count [" + db + "] ");
            throw new WMSException("Unable to get count [" + db + "] ");
        }
    }

    static WDBRecordBinding getBindingObject(String dbname) {
        return binding.get(dbname);
    }

    static AbstractDB getDB(String dbname) {
        return dbmap.get(dbname);
    }

    public static long getTransNCacheMiss() {
        return -1L;
    }

    public static long getCachePercent() {
        return -1L;
    }

    public static long getCacheSize() {
        return -1L;
    }

    public static void close() {
        Enumeration<AbstractDB> e = dbmap.elements();
        while (e.hasMoreElements()) {
            try {
                e.nextElement().close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void iterateDB(WDBIterator handler) {
        WDBManager.iterateDB(handler, true);
    }

    public static void iterateDB(WDBIterator handler, boolean async) {
        WDBManager.iterateDB(handler, async, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateDB(WDBIterator handler, boolean async, boolean retry) {
        int id;
        if (iterstatus.get(handler.getDBName()).booleanValue()) {
            throw new ConcurrentModificationException("Iteration already in progress. db=" + handler.getDBName());
        }
        iterstatus.put(handler.getDBName(), Boolean.TRUE);
        SortedSet<Integer> sortedSet = threadNameSet;
        synchronized (sortedSet) {
            try {
                id = threadNameSet.first();
                threadNameSet.remove(id);
            }
            catch (Exception e) {
                id = 1;
            }
        }
        if (async) {
            new Thread((Runnable)new DBIterator(handler, id), "WDB/WDBIterator-" + id).start();
        } else {
            WDBManager.dbIterator(handler, retry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dbIterator(WDBIterator handler, boolean retry) {
        long count = 0L;
        AbstractDB db = handler.getDB();
        WDBRecordBinding rbind = handler.getDBBinding();
        long time = System.currentTimeMillis();
        long timeNano = System.nanoTime();
        try {
            handler.handleInitialized();
            if (db.iterinit()) {
                String key;
                while ((key = WDBManager.getNextKeyString(db, retry)) != null) {
                    ++count;
                    try {
                        handler.handleRecord(key, rbind.deserialize(db.get(rbind.getKey(key))));
                    }
                    catch (Exception exception) {}
                }
                handler.handleClose(count);
            } else {
                logger.warning("DB IterInit failed for " + handler.getDBName() + " error " + db.errmsg());
                handler.handleFailure(db.rnum(), count);
            }
            iterstatus.put(handler.getDBName(), Boolean.FALSE);
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
                handler.handleFailure(db.rnum(), count);
                iterstatus.put(handler.getDBName(), Boolean.FALSE);
            }
            catch (Throwable throwable) {
                iterstatus.put(handler.getDBName(), Boolean.FALSE);
                WDBManager.hit(handler.getDBName(), "iterate", System.currentTimeMillis() - time);
                if (StatsConf.isWDBStatsEnabled()) {
                    StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "iterate", 1, System.nanoTime() - timeNano);
                }
                throw throwable;
            }
            WDBManager.hit(handler.getDBName(), "iterate", System.currentTimeMillis() - time);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "iterate", 1, System.nanoTime() - timeNano);
            }
        }
        WDBManager.hit(handler.getDBName(), "iterate", System.currentTimeMillis() - time);
        if (StatsConf.isWDBStatsEnabled()) {
            StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "iterate", 1, System.nanoTime() - timeNano);
        }
    }

    private static String getNextKeyString(AbstractDB db, boolean retry) {
        String key;
        if (!retry) {
            return db.nextKeyString();
        }
        int retrycount = 0;
        while ((key = db.nextKeyString()) == null && ++retrycount < 10) {
        }
        return key;
    }

    private static TCBCall getInstrumentation() {
        String[] asd = new String[]{ServerUtil.getServerIP()};
        return TCBCall.newInstance((String[])asd);
    }

    private static void hit(String dbname, String opr, long time) {
        String key = dbname + "." + opr;
        if (!wdbcounter.containsKey(key)) {
            HashMap<String, AtomicLong> m = new HashMap<String, AtomicLong>();
            m.put("hits", new AtomicLong(1L));
            m.put("maxduration", new AtomicLong(time));
            m.put("maxdurationtime", new AtomicLong(System.currentTimeMillis()));
            m.put("totalduration", new AtomicLong(time));
            wdbcounter.put(key, m);
            return;
        }
        wdbcounter.get(key).get("hits").incrementAndGet();
        if (time >= wdbcounter.get(key).get("maxduration").longValue()) {
            wdbcounter.get(key).get("maxduration").set(time);
            wdbcounter.get(key).get("maxdurationtime").set(System.currentTimeMillis());
        }
        wdbcounter.get(key).get("totalduration").addAndGet(time);
    }

    public static ConcurrentHashMap getStats() {
        return wdbcounter;
    }

    public static HashMap getInfo() {
        HashMap info = new HashMap();
        Enumeration<String> e = dbmap.keys();
        while (e.hasMoreElements()) {
            try {
                String dbname = e.nextElement();
                AbstractDB db = dbmap.get(dbname);
                HashMap<String, Object> details = new HashMap<String, Object>();
                details.put("size", db.fsiz());
                details.put("records", db.rnum());
                details.put("error", db.errmsg());
                info.put(dbname, details);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return info;
    }

    public static void recordDBInfo(long timems) {
        Enumeration<String> e = dbmap.keys();
        while (e.hasMoreElements()) {
            try {
                String dbname = e.nextElement();
                AbstractDB db = dbmap.get(dbname);
                StatsDB.addDataInstant(timems, "wdbstats", DC.getServertype(), dbname, db.errmsg(), db.fsiz(), db.rnum());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void resetStats() {
        wdbcounter = new ConcurrentHashMap(50, 0.75f, 50);
    }

    private static void showError(String e, AbstractDB db) {
        int ecode = db.ecode();
        if (ecode == 22) {
            return;
        }
        logger.info("DB error " + e + " [" + ecode + "] msg=" + db.errmsg(ecode));
    }

    private static void syncBDB(String db) {
        long lt = System.currentTimeMillis();
        long ltNano = System.nanoTime();
        AbstractDB bdb = dbmap.get(db);
        if (!bdb.sync()) {
            WDBManager.showError("sync", bdb);
        }
        long stime = System.currentTimeMillis() - lt;
        WDBManager.hit(db, "sync", stime);
        if (StatsConf.isWDBStatsEnabled()) {
            StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, db, "none", "sync", 1, System.nanoTime() - ltNano);
        }
    }

    static {
        for (int i = 0; i < 5000; ++i) {
            threadNameSet.add(i);
        }
    }

    static class AutoSync
    extends Thread {
        AutoSync() {
        }

        @Override
        public void run() {
            this.setName("WDB/AutoSync");
            block4: while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Enumeration e = syncstatus.keys();
                while (true) {
                    if (!e.hasMoreElements()) continue block4;
                    String dbname = (String)e.nextElement();
                    try {
                        if (((Boolean)syncstatus.get(dbname)).booleanValue()) continue;
                        WDBManager.syncBDB(dbname);
                        syncstatus.put(dbname, Boolean.TRUE);
                        continue;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        continue;
                    }
                    break;
                }
                break;
            }
        }
    }

    static class DBIterator
    implements Runnable {
        private WDBIterator handler;
        private Integer id;

        public DBIterator(WDBIterator handler, Integer id) {
            this.handler = handler;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object key;
            long count = 0L;
            AbstractDB db = this.handler.getDB();
            WDBRecordBinding rbind = this.handler.getDBBinding();
            long time = System.currentTimeMillis();
            long timeNano = System.nanoTime();
            try {
                this.handler.handleInitialized();
                if (db.iterinit()) {
                    while ((key = db.nextKeyString()) != null) {
                        ++count;
                        try {
                            this.handler.handleRecord((String)key, rbind.deserialize(db.get(rbind.getKey((String)key))));
                        }
                        catch (Exception exception) {}
                    }
                    this.handler.handleClose(count);
                } else {
                    logger.warning("DB IterInit failed for " + this.handler.getDBName() + " error " + db.errmsg());
                    this.handler.handleFailure(db.rnum(), count);
                }
                iterstatus.put(this.handler.getDBName(), Boolean.FALSE);
            }
            catch (Exception exp) {
                try {
                    exp.printStackTrace();
                    this.handler.handleFailure(db.rnum(), count);
                    iterstatus.put(this.handler.getDBName(), Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    iterstatus.put(this.handler.getDBName(), Boolean.FALSE);
                    WDBManager.hit(this.handler.getDBName(), "iterate", System.currentTimeMillis() - time);
                    if (StatsConf.isWDBStatsEnabled()) {
                        StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBManager.WDBTYPE, db, "none", "iterate", 1, System.nanoTime() - timeNano);
                    }
                    SortedSet sortedSet = threadNameSet;
                    synchronized (sortedSet) {
                        threadNameSet.add(this.id);
                    }
                    throw throwable;
                }
                WDBManager.hit(this.handler.getDBName(), "iterate", System.currentTimeMillis() - time);
                if (StatsConf.isWDBStatsEnabled()) {
                    StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBManager.WDBTYPE, db, "none", "iterate", 1, System.nanoTime() - timeNano);
                }
                SortedSet sortedSet = threadNameSet;
                synchronized (sortedSet) {
                    threadNameSet.add(this.id);
                }
            }
            WDBManager.hit(this.handler.getDBName(), "iterate", System.currentTimeMillis() - time);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBManager.WDBTYPE, db, "none", "iterate", 1, System.nanoTime() - timeNano);
            }
            key = threadNameSet;
            synchronized (key) {
                threadNameSet.add(this.id);
            }
        }
    }
}

