/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.util;

import com.adventnet.wms.common.util.CommonWMSUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WMSUtil {
    public static boolean isAnnonUser(String wmsid) {
        return CommonWMSUtil.isAnnonUser((String)wmsid);
    }

    public static boolean isMPUser(String wmsid) {
        return CommonWMSUtil.isMPUser((String)wmsid);
    }

    public static boolean isBotUser(String wmsid) {
        return CommonWMSUtil.isBotUser((String)wmsid);
    }

    public static boolean isChat(int type) {
        return type == 1 || type == 9 || type == 10 || type == 11;
    }

    public static boolean isCustomChat(int type) {
        return type == 4 || type == 5;
    }

    public static boolean isServiceChat(int type) {
        return type == 4;
    }

    public static boolean isCollaboration(int type) {
        return type == 2;
    }

    public static boolean isPresenceChat(int type) {
        return type == 6;
    }

    public static boolean isMultiRouteChat(int type, int config) {
        return type == 2 || (config & 0x20) != 0;
    }

    public static boolean isAllPrdCustomChat(int type) {
        return type == 5;
    }

    public static boolean isOrgChannel(int type) {
        return type == 8;
    }

    public static boolean isNOOPChat(int type) {
        return type == 9;
    }

    public static boolean isEntityChat(int type) {
        return type == 10;
    }

    public static boolean isSenderBot(int type) {
        return type == 1;
    }

    public static boolean isThreadChat(int type) {
        return type == 11;
    }

    public static boolean isEventChat(int type) {
        return type == 12;
    }

    public static int getInteger(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long getLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static class HumanReadable {
        public static String getDuration(long time) {
            String timestr = null;
            DecimalFormat numformat = new DecimalFormat("#.##");
            timestr = time > 86400000L ? numformat.format((float)(time * 24L / 86400000L) / 24.0f) + " Days" : (time > 3600000L ? numformat.format((float)(time * 60L / 3600000L) / 60.0f) + " Hours" : (time > 60000L ? numformat.format((float)(time * 60L / 60000L) / 60.0f) + " Minutes" : (time > 1000L ? numformat.format((float)(time * 1000L / 1000L) / 1000.0f) + " Seconds" : time + " Millis")));
            return timestr;
        }

        public static String getDuration(long duration, boolean inShortFormat) {
            String milliseconds;
            long s = duration / 1000L;
            long m = s / 60L;
            long h = m / 60L;
            long d = h / 24L;
            long w = d / 7L;
            String weeks = inShortFormat ? "w" : "Weeks";
            String days = inShortFormat ? "d" : "Days";
            String hours = inShortFormat ? "h" : "Hours";
            String minutes = inShortFormat ? "m" : "Minutes";
            String seconds = inShortFormat ? "s" : "Seconds";
            String string = milliseconds = inShortFormat ? "ms" : "millis";
            if (w == 0L && d != 0L && h != 0L && m != 0L) {
                String string2 = d % 7L + days + ":" + h % 24L + hours + ":" + m % 60L + minutes + ":" + s % 60L + seconds;
            }
            String time = w == 0L && d == 0L && h != 0L && m != 0L ? h % 24L + hours + ":" + m % 60L + minutes + ":" + s % 60L + seconds : (w == 0L && d == 0L && h == 0L && m != 0L ? m % 60L + minutes + ":" + s % 60L + seconds : (w == 0L && d == 0L && h == 0L && m == 0L && s != 0L ? s % 60L + seconds : duration + milliseconds));
            return time;
        }

        public static String getTime(long time) {
            SimpleDateFormat df = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss.SSS");
            String Time = df.format(new Date(time));
            return Time;
        }

        public static String getMemSize(long sizeInBytes) {
            String size = null;
            size = sizeInBytes > 0x10000000000L ? (float)(sizeInBytes * 100L / 0x10000000000L) / 100.0f + " TB" : (sizeInBytes > 0x40000000L ? (float)(sizeInBytes * 100L / 0x40000000L) / 100.0f + " GB" : (sizeInBytes > 0x100000L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes")));
            return size;
        }

        public static String getCountSize(long count) {
            String size = null;
            size = count > 1000000000L ? (float)(count * 100L / 1000000000L) / 100.0f + " B" : (count > 1000000L ? (float)(count * 100L / 1000000L) / 100.0f + " M" : (count > 1000L ? (float)(count * 100L / 1000L) / 100.0f + " K" : "" + count));
            return size;
        }

        public static String getPercentage(long value, long total) {
            return "" + (float)(value * 10000L / total) / 100.0f;
        }
    }
}

