/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.util;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailUtil {
    private static final Logger LOGGER = Logger.getLogger(MailUtil.class.getName());
    private static String confDir = ServerUtil.serverHome + File.separator + "conf" + File.separator;
    private static String fromAddress = "wms-team@zohocorp.com";
    private static Map config;

    private static void initialize() {
        Properties configprop = new Properties();
        configprop.put("mail.smtp.host", "localhost");
        try {
            File file = new File(confDir + "mail.properties");
            if (file.exists()) {
                configprop.load(new FileInputStream(file));
            }
            fromAddress = (String)configprop.remove("fromAddress");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        config = Collections.unmodifiableMap(configprop);
        LOGGER.info("Mail Util loaded " + config);
    }

    public static void sendAsText(String subject, String message, String toAddress, String ccaddress) {
        MailUtil.send(subject, message, toAddress, ccaddress, null, true);
    }

    public static void sendAsText(String subject, String message, String toAddress, String fromadd, String ccaddress) {
        MailUtil.send(subject, message, toAddress, ccaddress, fromadd, true);
    }

    public static void send(String subject, String message, String toAddress, String ccaddress, String fromadd, boolean isplaintext) {
        MailUtil.send(subject, message, toAddress, ccaddress, fromadd, isplaintext, true);
    }

    public static void send(String subject, String message, String toAddress, String ccaddress, String fromadd, boolean isplaintext, boolean suffix) {
        try {
            String mailingfrom = !CommonUtil.isEmpty((String)fromadd) ? fromadd : fromAddress;
            if (CommonUtil.isEmpty((String)toAddress)) {
                return;
            }
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)config);
            MimeMessage msg = new MimeMessage(Session.getInstance((Properties)prop, null));
            msg.setFrom((Address)new InternetAddress(mailingfrom));
            InternetAddress inetaddress = new InternetAddress();
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toAddress));
            if (ccaddress != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccaddress));
            }
            Address[] replyTo = new Address[]{new InternetAddress(mailingfrom)};
            msg.setReplyTo(replyTo);
            subject = subject.replaceAll("\\r\\n|\\r|\\n", " ");
            subject = "[WMS ADMIN] : " + subject;
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            if (isplaintext) {
                msg.setContent((Object)message, "text/plain");
            } else {
                String msgcontent = message;
                if (suffix) {
                    msgcontent = message + "<br><br>Mail sent from " + ServerUtil.getServerIP() + "<br>WMS Admin " + System.getProperty("admin.url");
                }
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setText(msgcontent, "UTF-8");
                mbp.setHeader("Content-Type", "text/html;charset=UTF-8");
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp);
                msg.setContent((Multipart)mp);
            }
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
            try {
                Throwable ex = mex;
                do {
                    Address[] validSent;
                    Address[] validUnsent;
                    if (!(ex instanceof SendFailedException)) continue;
                    SendFailedException sfex = (SendFailedException)ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (invalid != null) {
                        LOGGER.info("Invalid Addresses");
                    }
                    if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                        LOGGER.info("Valid Unsent Addresses");
                    }
                    if ((validSent = sfex.getValidSentAddresses()) == null) continue;
                    LOGGER.info("Sent Success");
                } while ((ex = ex.getNextException()) != null);
            }
            catch (Exception e) {
                LOGGER.warning("Error while sending email msg exp:" + e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.warning("Error while sending email exp:" + e.getMessage());
        }
    }

    public static void send(String subject, String message, String toemailids, String ccaddress) {
        MailUtil.send(subject, message, toemailids, ccaddress, null, false);
    }

    public static void send(String subject, String message, String toemailids) {
        MailUtil.send(subject, message, toemailids, null, null, false);
    }

    static {
        MailUtil.initialize();
    }
}

