/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.tpexecutor;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.tpexecutor.TPEStats;
import com.adventnet.wms.servercommon.util.CustomRejectedExecutionHandler;
import com.adventnet.wms.servercommon.util.CustomThreadFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TPExecutorFactory {
    private static Logger logger = Logger.getLogger(TPExecutorFactory.class.getName());
    private static String confFile = ServerUtil.serverHome + File.separator + "conf" + File.separator + "tpexecutor.properties";
    private static ConcurrentHashMap<String, ArrayList<ThreadPoolExecutor>> tpExecutorMap = new ConcurrentHashMap(100);
    private static ConcurrentHashMap<String, Integer> tpCounter = new ConcurrentHashMap(100);
    private static boolean reinitialize = false;

    public static boolean initialize() {
        try {
            Properties tpProps = new Properties();
            tpProps.load(new FileInputStream(confFile));
            Enumeration<?> e = tpProps.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] data = tpProps.getProperty(key).split(",");
                int min_thread = Integer.parseInt(data[0]);
                int max_thread = Integer.parseInt(data[1]);
                long kaTime = Long.parseLong(data[2]);
                int tpexecount = 1;
                int queueSize = -1;
                boolean customRejExeHandler = false;
                try {
                    tpexecount = Integer.parseInt(data[3]);
                    queueSize = Integer.parseInt(data[4]);
                    customRejExeHandler = Boolean.parseBoolean(data[5]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!reinitialize) {
                    TPExecutorFactory.initTPExecutor(key, min_thread, max_thread, kaTime, tpexecount, queueSize, customRejExeHandler);
                    continue;
                }
                TPExecutorFactory.updateTPExecutorFactory(key, min_thread, max_thread, kaTime, tpexecount, queueSize, customRejExeHandler);
            }
            reinitialize = false;
            logger.info("TPExecutorFactory Initialized..");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean initTPExecutor(String key, int min_thread, int max_thread, long kaTime, int tpexecount, int queueSize, boolean customRejExeHandler) throws Exception {
        if (tpExecutorMap.containsKey(key)) {
            logger.log(Level.SEVERE, "TPE already initialized for this key : {0}, value : {1}", new Object[]{key, tpExecutorMap.get(key)});
            return true;
        }
        ArrayList<ThreadPoolExecutor> tpexelist = new ArrayList<ThreadPoolExecutor>();
        for (int i = 0; i < tpexecount; ++i) {
            CustomThreadFactory tpexeTF = new CustomThreadFactory(key);
            tpexelist.add(TPExecutorFactory.initTPExecutor(key, min_thread, max_thread, kaTime, tpexeTF, queueSize, customRejExeHandler));
        }
        if (tpexecount > 1) {
            tpCounter.put(key, 0);
        }
        tpExecutorMap.put(key, tpexelist);
        return true;
    }

    private static ThreadPoolExecutor initTPExecutor(String key, int min_thread, int max_thread, long kaTime, CustomThreadFactory tpexeTF, int queueSize, boolean customRejExeHandler) throws Exception {
        logger.info("[TPExecutor Created][" + key + "][" + min_thread + "][" + max_thread + "][" + kaTime + "]");
        LinkedBlockingQueue<Runnable> queue = null;
        Object handler = null;
        queue = queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(min_thread, max_thread, kaTime, TimeUnit.MILLISECONDS, queue, tpexeTF);
        if (customRejExeHandler) {
            tpe.setRejectedExecutionHandler(new CustomRejectedExecutionHandler(key));
        }
        return tpe;
    }

    public static ThreadPoolExecutor getTPExecutor(String tpExecutorName) {
        ArrayList<ThreadPoolExecutor> tplist = tpExecutorMap.get(tpExecutorName);
        if (tplist.size() == 1) {
            return tplist.get(0);
        }
        Integer counter = tpCounter.get(tpExecutorName);
        int i = 0;
        int LIMIT = 3;
        while (i++ < LIMIT) {
            try {
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
                counter = counter % tplist.size();
                tpCounter.put(tpExecutorName, counter);
                return tplist.get(counter);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
            }
        }
        tpCounter.put(tpExecutorName, 0);
        return tplist.get(0);
    }

    public static boolean reInitializeTPExecutorFactory() {
        try {
            logger.info("[TPExecutor][Reinitialization]");
            reinitialize = true;
            return TPExecutorFactory.initialize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean updateTPExecutorFactory(String key, int min_thread, int max_thread, long kaTime, int tpexecount) {
        return TPExecutorFactory.updateTPExecutorFactory(key, min_thread, max_thread, kaTime, tpexecount, -1);
    }

    public static boolean updateTPExecutorFactory(String key, int min_thread, int max_thread, long kaTime, int tpexecount, int queueSize) {
        return TPExecutorFactory.updateTPExecutorFactory(key, min_thread, max_thread, kaTime, tpexecount, queueSize, false);
    }

    public static boolean updateTPExecutorFactory(String key, int min_thread, int max_thread, long kaTime, int tpexecount, int queueSize, boolean customRejExeHandler) {
        try {
            int i;
            if (tpexecount < 1 || min_thread < 0 || max_thread < min_thread || kaTime < 1L) {
                logger.info("[TPExecutor][Illegal arguments]");
                return false;
            }
            ArrayList<ThreadPoolExecutor> tplist = tpExecutorMap.get(key);
            logger.info("[TPExecutor Old Values][" + key + "][" + tplist.get(0).getCorePoolSize() + "][" + tplist.get(0).getMaximumPoolSize() + "][" + tplist.get(0).getKeepAliveTime(TimeUnit.MILLISECONDS) + "][" + tplist.size() + "][" + tplist.get(0).getQueue().size() + "]");
            logger.info("[TPExecutor To Be Updated][" + key + "][" + min_thread + "][" + max_thread + "][" + kaTime + "][" + tpexecount + "][" + queueSize + "]");
            ArrayList<ThreadPoolExecutor> excesstplist = new ArrayList<ThreadPoolExecutor>();
            for (i = 0; i < tplist.size() && i < tpexecount; ++i) {
                ThreadPoolExecutor tpexecutor = tplist.get(i);
                tpexecutor.setCorePoolSize(min_thread);
                tpexecutor.setMaximumPoolSize(max_thread);
                tpexecutor.setKeepAliveTime(kaTime, TimeUnit.MILLISECONDS);
                logger.info("[TPExecutor -" + i + "][" + key + "][Updated]");
            }
            if (tplist.size() > tpexecount) {
                while (tplist.size() > tpexecount) {
                    excesstplist.add(tplist.remove(tpexecount));
                    logger.info("[TPExecutor][" + key + "][Removed]");
                }
            } else if (tplist.size() < tpexecount) {
                for (i = tplist.size(); i < tpexecount; ++i) {
                    CustomThreadFactory tpexeTF = new CustomThreadFactory(key);
                    tplist.add(TPExecutorFactory.initTPExecutor(key, min_thread, max_thread, kaTime, tpexeTF, queueSize, customRejExeHandler));
                    logger.info("[TPExecutor " + i + "][" + key + "][Added]");
                }
            }
            tpExecutorMap.put(key, tplist);
            while (excesstplist.size() > 0) {
                ThreadPoolExecutor tpexecutor = (ThreadPoolExecutor)excesstplist.remove(0);
                tpexecutor.setCorePoolSize(0);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean updateTPExecutor(String threadPoolName, int newCorePoolSize, int newMaxPoolSize, long keepaliveTime, TimeUnit timeUnit) throws Exception {
        if (!tpExecutorMap.containsKey(threadPoolName)) {
            throw new Exception(threadPoolName + " is not registered.");
        }
        try {
            for (ThreadPoolExecutor executor : tpExecutorMap.get(threadPoolName)) {
                if (newCorePoolSize >= 0) {
                    executor.setCorePoolSize(newCorePoolSize);
                }
                if (newMaxPoolSize > 0 && newMaxPoolSize >= newCorePoolSize) {
                    executor.setMaximumPoolSize(newMaxPoolSize);
                }
                if (keepaliveTime <= 0L || timeUnit == null) continue;
                executor.setKeepAliveTime(keepaliveTime, timeUnit);
            }
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "[Exception][TPExecutorFactory - Update TPE] [threadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static void punchThreadStats() {
        try {
            for (String key : tpExecutorMap.keySet()) {
                ArrayList<ThreadPoolExecutor> tplist = tpExecutorMap.get(key);
                for (ThreadPoolExecutor tpe : tplist) {
                    TPEStats.addTPEActiveThreadStats(key, tpe.getPoolSize());
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "[Exception][TPExecutorFactory - punchThreadStats]", ex);
        }
    }

    public static Hashtable getStats() throws Exception {
        Hashtable stats = new Hashtable();
        try {
            for (String key : tpExecutorMap.keySet()) {
                Hashtable<String, Object> tpestat = new Hashtable<String, Object>();
                int counter = 0;
                ArrayList<ThreadPoolExecutor> tplist = tpExecutorMap.get(key);
                for (ThreadPoolExecutor tpe : tplist) {
                    tpestat.put("tpe_stats", tpe.toString());
                    tpestat.put("active_count", tpe.getActiveCount());
                    tpestat.put("task_count", tpe.getTaskCount());
                    tpestat.put("completed_task_count", tpe.getCompletedTaskCount());
                    tpestat.put("largest_pool", tpe.getLargestPoolSize());
                    tpestat.put("pool_size", tpe.getPoolSize());
                    tpestat.put("remaining_queue_capacity", tpe.getQueue().remainingCapacity());
                    stats.put(key + "_" + counter++, tpestat);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - getStats]", ex);
            throw ex;
        }
        return stats;
    }

    public static Hashtable getStats(String threadPoolName) throws Exception {
        if (threadPoolName == null || threadPoolName.length() <= 0) {
            logger.log(Level.SEVERE, "[TPExecutorFactory - getStats] ThreadName should not be null. [ThreadPoolName] [{0}]", new Object[]{threadPoolName});
            throw new Exception("threadPoolName should not be null.");
        }
        Hashtable<String, Serializable> stats = new Hashtable<String, Serializable>();
        try {
            for (String key : tpExecutorMap.keySet()) {
                if (!key.toLowerCase().contains(threadPoolName.toLowerCase())) continue;
                Hashtable<String, Object> tpestat = new Hashtable<String, Object>();
                int counter = 0;
                ArrayList<ThreadPoolExecutor> tplist = tpExecutorMap.get(key);
                for (ThreadPoolExecutor tpe : tplist) {
                    tpestat.put("tpe_stats", tpe.toString());
                    tpestat.put("active_count", tpe.getActiveCount());
                    tpestat.put("task_count", tpe.getTaskCount());
                    tpestat.put("completed_task_count", tpe.getCompletedTaskCount());
                    tpestat.put("largest_pool", tpe.getLargestPoolSize());
                    tpestat.put("pool_size", tpe.getPoolSize());
                    tpestat.put("remaining_queue_capacity", tpe.getQueue().remainingCapacity());
                    stats.put(key + "_" + counter++, tpestat);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - getStats] [ThreadPoolName] " + threadPoolName, ex);
            stats.put("Exception", ex);
            throw ex;
        }
        return stats;
    }

    public static ArrayList<String> getThreadPoolStats(String threadPoolName) throws Exception {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().toString());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE Stats] ", ex);
            throw ex;
        }
    }

    public static ArrayList<Integer> getActiveCount(String threadPoolName) throws Exception {
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getActiveCount());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE ActiveCount] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static ArrayList<Long> getTaskCount(String threadPoolName) throws Exception {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getTaskCount());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE TaskCount] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static ArrayList<Long> getCompletedTaskCount(String threadPoolName) throws Exception {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getCompletedTaskCount());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE CompletedTaskCount] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static ArrayList<Integer> getLargestPoolSize(String threadPoolName) throws Exception {
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getLargestPoolSize());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE LargestPoolSize] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static ArrayList<Integer> getPoolSize(String threadPoolName) throws Exception {
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getPoolSize());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE PoolSize] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static ArrayList<Integer> getRemainingQueueCapacity(String threadPoolName) throws Exception {
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Iterator<ThreadPoolExecutor> iterator = tpExecutorMap.get(threadPoolName).iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next().getQueue().remainingCapacity());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE RemainingQueueCapacity] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    public static ArrayList<Long> getQueuedTaskCount(String threadPoolName) throws Exception {
        try {
            ArrayList<Long> list = new ArrayList<Long>();
            for (ThreadPoolExecutor executor : tpExecutorMap.get(threadPoolName)) {
                list.add(executor.getTaskCount() - executor.getCompletedTaskCount());
            }
            return list;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "[Exception][TPExecutorFactory - TPE QueuedTaskCount] [ThreadPoolName] " + threadPoolName, ex);
            throw ex;
        }
    }

    static {
        TPEStats.initialize();
    }
}

