/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.tpexecutor;

import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.tpexecutor.TPExecutorFactory;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TPEStats
extends WmsRuntime {
    private static Logger logger = Logger.getLogger(TPEStats.class.getName());
    private static String serverType = DC.getServertype();
    private static boolean initialized = false;

    public static void initialize() {
        if (DC.getServertype() == null) {
            logger.log(Level.INFO, "Servertype is Null. Abort Stats Initialization.");
            return;
        }
        if (initialized) {
            logger.log(Level.INFO, "TPEStats Already initialized.");
            return;
        }
        Hashtable<String, String> statsDefs = new Hashtable<String, String>();
        statsDefs.put("tpe_rate", "[[\"qos\",\"qos_tpe\",\"\",\"tpe_rate\",false],[\"servertype\",\"tpe_name\"],[],[\"in_count\",\"out_count\",\"failed_count\"]]");
        statsDefs.put("tpe_exetime", "[[\"qos\",\"qos_tpe\",\"\",\"tpe_exetime\",false],[\"servertype\",\"tpe_name\"],[],[\"exe_time\",\"count\"]]");
        statsDefs.put("tpe_activethrd", "[[\"qos\",\"qos_tpe\",\"\",\"tpe_activethrd\",false],[\"servertype\",\"tpe_name\"],[],[\"thrd_count\"]]");
        statsDefs.put("tpe_failed", "[[\"qos\",\"qos_tpe\",\"\",\"tpe_failed\",false],[\"servertype\",\"tpe_name\"],[],[\"exp_count\"]]");
        if (StatsConf.loadStatsKeyDef(statsDefs)) {
            StatsDB.initialize();
            logger.info("[TPExecutorFactory - Influx Stats Initialized!!]");
        }
        initialized = true;
    }

    public static void addTPERateStats(String tpe_name, int type) {
        if (!initialized) {
            return;
        }
        try {
            switch (type) {
                case 1: {
                    StatsDB.addData("tpe_rate", serverType, tpe_name, 1, 0, 0);
                    break;
                }
                case 2: {
                    StatsDB.addData("tpe_rate", serverType, tpe_name, 0, 1, 0);
                    break;
                }
                case 3: {
                    StatsDB.addData("tpe_rate", serverType, tpe_name, 0, 0, 1);
                }
            }
        }
        catch (Exception ex) {
            logger.info("[Exception][TPEStats - addTPERateStats][Can't Collect Stats]");
        }
    }

    public static void addTPEExeTimeStats(String tpe_name, long time) {
        if (!initialized) {
            return;
        }
        try {
            StatsDB.addData("tpe_exetime", serverType, tpe_name, time, 1);
        }
        catch (Exception ex) {
            logger.info("[Exception][TPEStats - addTPEExeTimeStats][Can't Collect Stats]");
        }
    }

    public static void addTPEActiveThreadStats(String tpe_name, int count) {
        if (!initialized) {
            return;
        }
        try {
            StatsDB.addData("tpe_activethrd", serverType, tpe_name, count);
        }
        catch (Exception ex) {
            logger.info("[Exception][TPEStats - addTPEActiveThreadStats][Can't Collect Stats]");
        }
    }

    public static void addTPEFailedStats(String tpe_name) {
        if (!initialized) {
            return;
        }
        try {
            StatsDB.addData("tpe_failed", serverType, tpe_name, 1);
        }
        catch (Exception ex) {
            logger.info("[Exception][TPEStats - addTPEFailedStats][Can't Collect Stats]");
        }
    }

    @Override
    public Hashtable getInfo(Hashtable params) {
        Hashtable data;
        if (!initialized) {
            return new Hashtable();
        }
        if (params != null && params.isEmpty()) {
            TPExecutorFactory.punchThreadStats();
            return new Hashtable();
        }
        try {
            data = params.containsKey("tname") ? TPExecutorFactory.getStats((String)params.get("tname")) : TPExecutorFactory.getStats();
        }
        catch (Exception ex) {
            data = new Hashtable();
            data.put("Exception", ex);
        }
        return data;
    }
}

