/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.timertask;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.timertask.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class TimerManager {
    private static final Logger LOGGER = Logger.getLogger(TimerManager.class.getName());
    private ScheduledThreadPoolExecutor stpe = null;
    private boolean initialized = false;
    private static TimerManager timermanager = null;

    public static TimerManager getInstance() {
        if (timermanager == null) {
            timermanager = new TimerManager();
        }
        return timermanager;
    }

    public boolean initialize() {
        if (this.initialized) {
            return true;
        }
        this.stpe = new ScheduledThreadPoolExecutor(ServerUtil.getThreadPoolCount());
        this.initialized = true;
        return true;
    }

    public void process(TimerTask task, long startDelay) {
        if (!this.initialized) {
            this.initialize();
        }
        try {
            ScheduledFuture<?> scheduledFuture = this.stpe.schedule(task, startDelay, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.info("RK -- >TimerManager process not identified");
            e.printStackTrace();
        }
    }

    public void process(TimerTask task, long startDelay, long executionInterval) {
        if (!this.initialized) {
            this.initialize();
        }
        try {
            ScheduledFuture<?> sf = this.stpe.scheduleAtFixedRate(task, startDelay, executionInterval, TimeUnit.MILLISECONDS);
            task.setTask(sf);
        }
        catch (Exception e) {
            LOGGER.info(" RK -- > TimerManager process Task not identified");
            e.printStackTrace();
        }
    }

    public void purgeTask() {
        this.stpe.purge();
    }
}

