/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.taskengine;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.exception.WMSEventException;
import com.adventnet.wms.common.exception.WMSTaskNotFoundException;
import com.adventnet.wms.servercommon.BufferedQueue;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.taskengine.WmsTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskEngine {
    private static Logger logger = Logger.getLogger(TaskEngine.class.getName());
    private static String taskConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskengine" + File.separator;
    private final String name;
    private final int inMemBufSize;
    private final int workerThreads;
    private final int lowPriorityWorkerThreads;
    private final int highPriorityWorkerThreads;
    private final boolean fifo;
    private boolean drain;
    private boolean stopEngine = false;
    private static final int REQUEST_TYPE = 121;
    private TaskQueue hpqueue;
    private TaskQueue queue;
    private TaskQueue lpqueue;
    private ConcurrentHashMap<Integer, TaskQueue> queueMap;
    private HashMap<String, WmsTask> taskMap = new HashMap();

    public TaskEngine(String name, int bufSize, int threads, boolean fifo) {
        this.name = name;
        this.inMemBufSize = bufSize;
        this.workerThreads = threads;
        this.highPriorityWorkerThreads = 0;
        this.lowPriorityWorkerThreads = 0;
        this.fifo = fifo;
    }

    public TaskEngine(String name, int bufSize, int threads, int highprioritythreads, int lowprioritythreads, boolean fifo) {
        this.name = name;
        this.inMemBufSize = bufSize;
        this.workerThreads = threads;
        this.highPriorityWorkerThreads = highprioritythreads;
        this.lowPriorityWorkerThreads = lowprioritythreads;
        this.fifo = fifo;
    }

    public String getName() {
        return this.name;
    }

    public boolean start() {
        Properties classMap = ServerUtil.getProperties(taskConfDir + this.name + ".properties");
        Enumeration<?> e = classMap.propertyNames();
        while (e.hasMoreElements()) {
            String taskName = (String)e.nextElement();
            String taskClass = (String)classMap.get(taskName);
            try {
                this.taskMap.put(taskName, (WmsTask)Class.forName(taskClass).newInstance());
            }
            catch (Exception exp) {
                logger.info("Unable to load task " + taskName + " engine=" + this.name);
            }
        }
        if (this.fifo) {
            this.queueMap = new ConcurrentHashMap();
            for (int i = 0; i < this.workerThreads; ++i) {
                TaskQueue que = new TaskQueue(this.name + "-" + i);
                this.queueMap.put(i, que);
                new TaskDispatcher("TaskEngine-" + this.name, que, i).start();
            }
        } else {
            if (this.highPriorityWorkerThreads > 0) {
                this.hpqueue = new TaskQueue("h-" + this.name);
                for (int i = 0; i < this.highPriorityWorkerThreads; ++i) {
                    new TaskDispatcher("TaskEngine-h-" + this.name, this.hpqueue, i).start();
                }
            }
            if (this.lowPriorityWorkerThreads > 0) {
                this.lpqueue = new TaskQueue("l-" + this.name);
                for (int i = 0; i < this.lowPriorityWorkerThreads; ++i) {
                    new TaskDispatcher("TaskEngine-l-" + this.name, this.lpqueue, i).start();
                }
            }
            this.queue = new TaskQueue(this.name);
            for (int i = 0; i < this.workerThreads; ++i) {
                new TaskDispatcher("TaskEngine-" + this.name, this.queue, i).start();
            }
        }
        return true;
    }

    public void shutdown() {
        if (this.fifo) {
            for (TaskQueue que : this.queueMap.values()) {
                if (que == null) continue;
                que.close();
            }
        } else {
            if (this.hpqueue != null) {
                this.hpqueue.close();
            }
            if (this.lpqueue != null) {
                this.lpqueue.close();
            }
            this.queue.close();
        }
    }

    public void restart() {
        if (this.fifo) {
            for (TaskQueue que : this.queueMap.values()) {
                if (que == null) continue;
                que.open();
            }
        } else {
            if (this.hpqueue != null) {
                this.hpqueue.open();
            }
            if (this.lpqueue != null) {
                this.lpqueue.open();
            }
            this.queue.open();
        }
    }

    public void setDrain(boolean isdrain) {
        this.drain = isdrain;
    }

    public void stop() {
        this.stopEngine = true;
    }

    public void handle(WmsEvent event) {
        if (this.stopEngine) {
            logger.info("TaskEngine has been stopped; Dropping event inside handle; " + event.getOpr());
            return;
        }
        if (this.fifo) {
            int code = event.getRKey() != null ? event.getRKey().hashCode() : event.hashCode();
            this.queueMap.get(Math.abs(code % this.workerThreads)).add(event);
        } else if (event.getTaskPriority() == 1 && this.hpqueue != null) {
            this.hpqueue.add(event);
        } else if (event.getTaskPriority() == -1 && this.lpqueue != null) {
            this.lpqueue.add(event);
        } else {
            this.queue.add(event);
        }
    }

    public boolean chain(WmsEvent event) {
        if (this.stopEngine) {
            logger.info("TaskEngine has been stopped; Dropping event inside chain; " + event.getOpr());
            return false;
        }
        try {
            if (event.getOpr() == null) {
                throw new WMSEventException("Operation Not Defined");
            }
            WmsTask task = this.taskMap.get(event.getOpr().split("\\.")[1]);
            if (task == null) {
                throw new WMSTaskNotFoundException("Task " + event.getOpr() + " not found");
            }
            if (!event.isBounced()) {
                event.putData("inqueuetime", (Object)("" + System.currentTimeMillis()));
                task.handle(event);
                return true;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            logger.info("Unable to chain task : " + exp.getMessage() + " : " + event);
        }
        return false;
    }

    public Hashtable getStats() {
        if (this.fifo) {
            int in = 0;
            int out = 0;
            int size = 0;
            int waiting = 0;
            for (TaskQueue que : this.queueMap.values()) {
                if (que == null) continue;
                Hashtable stats = que.getStats();
                in += Integer.parseInt((String)stats.get("in"));
                out += Integer.parseInt((String)stats.get("out"));
                size += Integer.parseInt((String)stats.get("size"));
                waiting += Integer.parseInt((String)stats.get("waitingthreads"));
            }
            boolean overflow = size > this.workerThreads * this.inMemBufSize;
            Hashtable<String, String> returnhash = new Hashtable<String, String>();
            returnhash.put("in", "" + in);
            returnhash.put("out", "" + out);
            returnhash.put("size", "" + size);
            returnhash.put("overflow", "" + overflow);
            returnhash.put("waitingthreads", "" + waiting);
            returnhash.put("totalthreads", "" + this.workerThreads);
            return returnhash;
        }
        Hashtable stats = this.queue.getStats();
        int in = Integer.parseInt((String)stats.get("in"));
        int out = Integer.parseInt((String)stats.get("out"));
        int size = Integer.parseInt((String)stats.get("size"));
        int waiting = Integer.parseInt((String)stats.get("waitingthreads"));
        if (this.hpqueue != null) {
            stats = this.hpqueue.getStats();
            in += Integer.parseInt((String)stats.get("in"));
            out += Integer.parseInt((String)stats.get("out"));
            size += Integer.parseInt((String)stats.get("size"));
            waiting += Integer.parseInt((String)stats.get("waitingthreads"));
        }
        if (this.lpqueue != null) {
            stats = this.lpqueue.getStats();
            in += Integer.parseInt((String)stats.get("in"));
            out += Integer.parseInt((String)stats.get("out"));
            size += Integer.parseInt((String)stats.get("size"));
            waiting += Integer.parseInt((String)stats.get("waitingthreads"));
        }
        boolean overflow = size > this.workerThreads * this.inMemBufSize;
        Hashtable<String, String> returnhash = new Hashtable<String, String>();
        returnhash.put("in", "" + in);
        returnhash.put("out", "" + out);
        returnhash.put("size", "" + size);
        returnhash.put("overflow", "" + overflow);
        returnhash.put("waitingthreads", "" + waiting);
        returnhash.put("totalthreads", "" + this.workerThreads);
        return returnhash;
    }

    public ArrayList<Hashtable<String, String>> getWmsQStats() {
        ArrayList<Hashtable<String, String>> qstats = new ArrayList<Hashtable<String, String>>();
        if (this.fifo) {
            long in = 0L;
            long out = 0L;
            long size = 0L;
            long createdfiles = 0L;
            long proccesdfiles = 0L;
            long savetofiletime = 0L;
            long loadfromfiletime = 0L;
            long remainingfiles = 0L;
            for (TaskQueue que : this.queueMap.values()) {
                if (que == null) continue;
                Hashtable<String, String> stats = que.getWmsQStats();
                in += Long.parseLong("" + stats.get("in"));
                out += Long.parseLong("" + stats.get("out"));
                size += Long.parseLong("" + stats.get("size"));
                createdfiles += Long.parseLong("" + stats.get("createdfiles"));
                proccesdfiles += Long.parseLong("" + stats.get("proccesdfiles"));
                savetofiletime += Long.parseLong("" + stats.get("savetofiletime"));
                loadfromfiletime += Long.parseLong("" + stats.get("loadfromfiletime"));
                remainingfiles += Long.parseLong("" + stats.get("remainingfiles"));
            }
            boolean overflow = size > (long)(this.workerThreads * this.inMemBufSize);
            Hashtable<String, String> returnhash = new Hashtable<String, String>();
            returnhash.put("in", "" + in);
            returnhash.put("out", "" + out);
            returnhash.put("size", "" + size);
            returnhash.put("bqname", "fifo-" + this.name);
            returnhash.put("overflow", "" + overflow);
            returnhash.put("createdfiles", "" + createdfiles);
            returnhash.put("proccesdfiles", "" + proccesdfiles);
            returnhash.put("savetofiletime", "" + savetofiletime);
            returnhash.put("loadfromfiletime", "" + loadfromfiletime);
            returnhash.put("remainingfiles", "" + remainingfiles);
            qstats.add(returnhash);
        } else {
            if (this.queue != null) {
                qstats.add(this.queue.getWmsQStats());
            }
            if (this.hpqueue != null) {
                qstats.add(this.hpqueue.getWmsQStats());
            }
            if (this.lpqueue != null) {
                qstats.add(this.lpqueue.getWmsQStats());
            }
        }
        return qstats;
    }

    public void clearStats() {
        if (this.fifo) {
            for (TaskQueue que : this.queueMap.values()) {
                if (que == null) continue;
                que.clearStats();
            }
        } else {
            if (this.hpqueue != null) {
                this.hpqueue.clearStats();
            }
            if (this.lpqueue != null) {
                this.lpqueue.clearStats();
            }
            this.queue.clearStats();
        }
    }

    public String toString() {
        return "Task Engine : " + this.name + " - " + this.inMemBufSize + " - " + this.workerThreads;
    }

    class TaskQueue {
        private BufferedQueue bq;
        private int waitingThreads = 0;

        public TaskQueue(String name) {
            this.bq = new BufferedQueue(ServerUtil.dataHome + "bqueue" + File.separator + name + "_tmp", name, TaskEngine.this.inMemBufSize);
        }

        public synchronized void add(Object obj) {
            this.bq.add(obj);
            this.notify();
        }

        public synchronized Object remove() {
            if (this.bq.isEmpty()) {
                try {
                    ++this.waitingThreads;
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                --this.waitingThreads;
            }
            Object obj = this.bq.get();
            return obj;
        }

        public synchronized int size() {
            return this.bq.size();
        }

        public synchronized boolean isEmpty() {
            return this.bq.isEmpty();
        }

        public Hashtable getStats() {
            Hashtable stats = this.bq.getStats();
            stats.put("waitingthreads", "" + this.waitingThreads);
            return stats;
        }

        public Hashtable<String, String> getWmsQStats() {
            return this.bq.getWmsQStats();
        }

        public void clearStats() {
            this.bq.clearStats();
        }

        public synchronized void close() {
            this.bq.close();
        }

        public synchronized void open() {
            this.bq.open();
        }
    }

    class TaskDispatcher
    extends Thread {
        private TaskQueue queue;
        private int index;
        private String enginename;
        private String enginenameforstats;

        public TaskDispatcher(String enginename, TaskQueue queue, int index) {
            super(enginename + "-" + index);
            this.enginename = enginename;
            this.queue = queue;
            this.index = index;
            this.enginenameforstats = enginename.split("TaskEngine-")[1];
        }

        @Override
        public void run() {
            boolean dispatchTask = true;
            while (dispatchTask) {
                WmsEvent event = null;
                try {
                    event = (WmsEvent)this.queue.remove();
                    if (event == null) continue;
                    if ("route.sendchatmsg".equals(event.getOpr()) || "chat.sendmessage".equals(event.getOpr())) {
                        logger.info("Started event processing from queue. Opr : " + event.getOpr() + " reqid " + event.getData("reqid"));
                    }
                    Thread.currentThread().setName(event.getOpr() + "-" + event.getDataAsString("reqid") + "-" + event.isBounced() + "-" + this.index);
                    long inqtime = -1L;
                    if (event.getData("inqueuetime") != null) {
                        inqtime = Long.parseLong((String)event.getData("inqueuetime"));
                    }
                    if (event.getOpr() == null) {
                        throw new WMSEventException("Operation Not Defined");
                    }
                    WmsTask task = (WmsTask)TaskEngine.this.taskMap.get(event.getOpr().split("\\.")[1]);
                    if (task == null) {
                        throw new WMSTaskNotFoundException("Task " + event.getOpr() + " not found");
                    }
                    long stime = System.currentTimeMillis();
                    if (TaskEngine.this.drain) {
                        task.handleDrain(event);
                    } else if (event.isBounced()) {
                        task.handleBounce(event.getBounceDetails(), event);
                    } else {
                        task.handle(event);
                    }
                    long currenttime = System.currentTimeMillis();
                    long executiontime = currenttime - stime;
                    StatsDB.addData("taskenginetime", "old", this.enginenameforstats, event.getOpr(), 1, currenttime - inqtime - executiontime, executiontime);
                    ServerUtil.logExternal(event, "delegate", "event_end");
                    if ("route.sendchatmsg".equals(event.getOpr()) || "chat.sendmessage".equals(event.getOpr())) {
                        logger.info("Event processed from queue. Opr : " + event.getOpr() + " reqid " + event.getData("reqid"));
                    }
                }
                catch (Exception exp) {
                    logger.log(Level.INFO, "Error in task evt: " + event, exp);
                    exp.printStackTrace();
                    ServerUtil.logExternal(event, "delegate", "event_error:" + exp.getMessage());
                }
                if (!TaskEngine.this.stopEngine || !this.queue.isEmpty()) continue;
                dispatchTask = false;
            }
        }
    }
}

