/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx.conf;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.components.event.WmsEventMetricListener;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.event.WmsEventMetricListenerImpl;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.taskengine.TaskManager;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsConf {
    private static final Logger LOGGER = Logger.getLogger(StatsConf.class.getName());
    private static boolean initialized = false;
    private static String serverIP;
    private static Map<String, String> statsConfMap;
    private static Map<String, String> influxInventoryMap;
    private static Map<String, String> influxAuthMap;
    private static ConcurrentHashMap<String, String> statsDefs;

    public static boolean initialiseInfluxInventory(Map<String, String> influxInventory) {
        try {
            for (String key : influxInventory.keySet()) {
                String[] authDetails;
                String[] wnetWithAuth = influxInventory.get(key).split("==");
                influxInventoryMap.put(key, wnetWithAuth[0]);
                if (wnetWithAuth.length != 2 || (authDetails = wnetWithAuth[1].split(":")).length != 2) continue;
                String auth = "u=" + authDetails[0] + "&p=" + authDetails[1];
                influxAuthMap.put(key, auth);
            }
            LOGGER.info("Stats Inventory updated successfully influxInventoryMap=" + influxInventoryMap + " ::: influxInventory which came in=" + influxInventory);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error inside initialiseInfluxInventory. influxInventory=" + influxInventory + " existing map =" + influxInventoryMap, e);
            return false;
        }
    }

    public static boolean initialize(Hashtable<String, String> conf) {
        return StatsConf.initialize(conf, null);
    }

    public static boolean initialize(Hashtable<String, String> conf, String serverHome) {
        try {
            String serverhome = null;
            if (conf != null) {
                statsConfMap.putAll(conf);
                serverhome = conf.get("serverhome");
            }
            try {
                String keyfile = ServerUtil.serverHome + File.separator + "conf" + File.separator + "influxstats.properties";
                if (serverhome != null) {
                    keyfile = serverhome + File.separator + "conf" + File.separator + "influxstats.properties";
                } else if (serverHome != null) {
                    keyfile = serverHome + File.separator + "conf" + File.separator + "influxstats.properties";
                }
                StatsConf.systemStatKeys();
                Properties statprops = ServerUtil.getProperties(keyfile);
                if (statprops != null) {
                    for (Object key : statprops.keySet()) {
                        String keyDef = statprops.getProperty("" + key);
                        statsDefs.put("" + key, keyDef);
                    }
                }
            }
            catch (Exception e) {
                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATSCONF_NOT_INITIALIZED.getErrorCode(), 1L);
                LOGGER.log(Level.SEVERE, "PS --> :: STATSCONF_NOT_INITIALIZED :: Exception in initialize for StatsConf...", e);
            }
            StatsDB.resetConfiguration();
            if (StatsConf.isTaskEngineStatsEnabled()) {
                TaskManager.enablePrdStats();
                TaskExecutorService.enablePrdStats();
            }
            LOGGER.info("PS --> StatsConf loaded StatsDefs " + statsDefs);
            LOGGER.info("PS --> StatsConf loaded ServerIP :" + serverIP);
            LOGGER.info("PS --> StatsConf loaded successfully");
            initialized = true;
            return true;
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATSCONF_NOT_INITIALIZED.getErrorCode(), 1L);
            LOGGER.log(Level.SEVERE, "PS --> :: STATSCONF_NOT_INITIALIZED :: StatsConf Cannot be initialized", e);
            return false;
        }
    }

    public static void systemStatKeys() {
        try {
            if (statsDefs == null) {
                statsDefs = new ConcurrentHashMap();
            }
            statsDefs.put("bandwidth", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"bandwidth\",true],[\"servertype\",\"access\",\"schema\"],[],[\"writebytes\",\"readbytes\"]]");
            statsDefs.put("meminfo", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"meminfo\",true],[\"servertype\"],[],[\"total\",\"used\"]]");
            statsDefs.put("httphits", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"httphits\",false],[\"servertype\",\"domain\",\"access\",\"schema\"],[],[\"count\"]]");
            statsDefs.put("gc", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"gc\",true],[\"servertype\",\"gcname\"],[],[\"gctime\",\"gccount\"]]");
            statsDefs.put("diskusage", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"diskusage\",true],[\"servertype\"],[],[\"totalspace\",\"usedspace\",\"freespace\",\"usedpercentage\",\"freepercentage\"]]");
            statsDefs.put("influx_write_usage", "[[\"qos\",\"qos_statsdb\",\"\",\"influx_write_usage\",false],[\"stat_type\",\"db\",\"rp\",\"msr\",\"stat_datatype\",\"servertype\"],[],[\"count\"]]");
            statsDefs.put("influx_read_usage", "[[\"qos\",\"qos_statsdb\",\"\",\"influx_read_usage\",false],[\"stat_type\",\"db\",\"msr\",\"servertype\",\"http_req_method\",\"result_format\"],[],[\"count\",\"duration\"]]");
            statsDefs.put("influx_db_created", "[[\"qos\",\"qos_statsdb\",\"\",\"influx_db_created\",false],[\"stat_type\",\"db\"],[],[\"count\"]]");
            statsDefs.put("cpu_info", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"cpu_info\",true],[\"servertype\"],[],[\"load_avg\",\"load_percentage\",\"system_cpu_percentage\",\"process_cpu_percentage\",\"cpu_time\",\"thread_count\",\"no_of_cpus\",\"no_of_cores\",\"count\"]]");
            statsDefs.put("pidstats", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"pidstats\",true],[\"servertype\"],[\"pid\"],[]]");
            statsDefs.put("gridoperation", "[[\"metric\",\"admin\",\"\",\"gridoperation\",\"false\"],[\"opr\",\"cluster\"],[],[\"count\",\"exectime\"]]");
            if (StatsConf.isSessionStatsEnabled()) {
                statsDefs.put("wmssessions", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"wmssessions\",true],[\"servertype\",\"prd\",\"ctype\",\"sessiontype\",\"access\",\"domain\",\"port\"],[],[\"count\"]]");
            }
            statsDefs.put("wdbhits", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"wdbhits\",false],[\"servertype\",\"clustername\",\"wdbtype\",\"dbname\",\"cfname\",\"opr\"],[],[\"hcount\",\"hduration\"]]");
            statsDefs.put("wdbstats", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"wdbstats\",true],[\"servertype\",\"dbname\"],[\"errormsg\"],[\"sizebytes\",\"records\"]]");
            statsDefs.put("wdbsizemetric", "[[\"qos\", \"qos_gridandsysteminfo\", \"\", \"wdbsizemetric\", false, true, \"1\"],[\"servertype\",\"clustername\",\"dbname\",\"cfname\"],[],[\"objsize\"]]");
            if (StatsConf.isTaskEngineStatsEnabled()) {
                statsDefs.put("tesinstats", "[[\"qos\",\"qos_executor\",\"\",\"tesinstats\",false],[\"servertype\",\"cluster\",\"prd\",\"tmname\",\"engine\",\"task\"],[],[\"count\"]]");
                statsDefs.put("blockedevents", "[[\"qos\",\"qos_executor\",\"\",\"blockedevents\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"task\"],[],[\"count\"]]");
                statsDefs.put("droppedevents", "[[\"qos\",\"qos_executor\",\"\",\"droppedevents\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"task\"],[],[\"count\"]]");
                statsDefs.put("tesoutstats", "[[\"qos\",\"qos_executor\",\"\",\"tesoutstats\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"task\",\"handletype\"],[],[\"count\",\"tenginetime\",\"exectime\"]]");
                statsDefs.put("seqstats", "[[\"qos\",\"qos_executor\",\"\",\"seqstats\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"task\",\"queueID\"],[],[\"count\",\"tenginetime\",\"exectime\"]]");
                statsDefs.put("seqdebug", "[[\"metric\",\"metric_executor\",\"\",\"seqdebug\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"task\"],[\"seqid\"],[\"count\"]]");
                statsDefs.put("tesbklg", "[[\"qos\",\"qos_executor\",\"\",\"tesbklg\",true],[\"servertype\",\"cluster\",\"tmname\",\"queue\"],[],[\"inq\",\"outq\",\"qsize\"]]");
                statsDefs.put("tethreadallocation", "[[\"qos\",\"qos_executor\",\"\",\"tethreadallocation\",true],[\"servertype\",\"cluster\",\"tmname\",\"engine\"],[],[\"count\"]]");
                statsDefs.put("tefpstats", "[[\"qos\",\"qos_executor\",\"\",\"tefpstats\",true],[\"servertype\",\"cluster\",\"tmname\"],[],[\"maxactivethreads\",\"totalthreads\",\"maxpoolsize\"]]");
                statsDefs.put("isolationstats", "[[\"qos\",\"qos_executor\",\"\",\"isostats\",true],[\"servertype\",\"cluster\",\"tmname\",\"engine\"],[],[\"isolatedseqids\",\"isolationthreads\",\"maxpoolsize\"]]");
                statsDefs.put("isolationcount", "[[\"qos\",\"qos_executor\",\"\",\"isolationcount\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"task\"],[],[\"count\"]]");
                statsDefs.put("drainstats", "[[\"qos\",\"qos_executor\",\"\",\"drainstats\",true],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"queueid\"],[],[\"count\"]]");
                statsDefs.put("stopengine", "[[\"qos\",\"qos_executor\",\"\",\"stopengine\",false],[\"servertype\",\"cluster\",\"tmname\",\"engine\",\"taskname\"],[],[\"count\"]]");
            }
            if (StatsConf.isDESStatsEnabled()) {
                statsDefs.put("desinstats", "[[\"qos\",\"qos_executor\",\"\",\"desinstats\",false],[\"servertype\",\"cluster\",\"engine\"],[],[\"eventcount\"]]");
                statsDefs.put("desoutstats", "[[\"qos\",\"qos_executor\",\"\",\"desoutstats\",false],[\"servertype\",\"cluster\",\"engine\"],[],[\"eventcount\",\"count\"]]");
            }
            if (StatsConf.isWMSTPEStatsEnabled()) {
                statsDefs.put("tpeinstats", "[[\"qos\",\"qos_executor\",\"\",\"tpeinstats\",false],[\"servertype\",\"cluster\",\"executor\"],[],[\"eventcount\"]]");
                statsDefs.put("tpeoutstats", "[[\"qos\",\"qos_executor\",\"\",\"tpeoutstats\",false],[\"servertype\",\"cluster\",\"executor\"],[],[\"eventcount\",\"executiontime\"]]");
                statsDefs.put("tpethreadstats", "[[\"qos\",\"qos_executor\",\"\",\"tpethreadstats\",true],[\"servertype\",\"cluster\",\"executor\"],[],[\"corepoolsize\",\"maxpoolsize\",\"largestpoolsize\",\"activepoolsize\"]]");
                statsDefs.put("tpebqstats", "[[\"qos\",\"qos_executor\",\"\",\"tpebqstats\",true],[\"servertype\",\"cluster\",\"executor\"],[],[\"size\"]]");
            }
            if (StatsConf.isWmsLoggerStatsEnabled()) {
                statsDefs.put("sst_server_side_usage", "[[\"qos\",\"qos_wmslogger\",\"\",\"sst_server_side_usage\",false],[\"service\",\"prd\",\"category\",\"status\"],[],[\"count\"]]");
            }
            statsDefs.put("wms_events_usage", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"wms_events_usage\",false],[\"cluster\",\"operation_name\",\"type\",\"task_manager\",\"task_engine\",\"task_name\"],[],[\"count\"]]");
            WmsEvent.registerEventListner((WmsEventMetricListener)new WmsEventMetricListenerImpl());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Exception in systemStatKeys", e);
        }
    }

    private static void errorInstrumentation() {
        if (statsDefs == null) {
            statsDefs = new ConcurrentHashMap();
        }
        statsDefs.put("statsdberror", "[[\"metric\",\"statsdb\",\"\",\"error\",false],[\"statskey\",\"responsecode\",\"cluster\",\"servertype\",\"errortype\"],[],[\"count\"]]");
    }

    private static void moduleInstrumentation() {
        if (statsDefs == null) {
            statsDefs = new ConcurrentHashMap();
        }
        statsDefs.put("moduleerror", "[[\"metric\",\"errorinfo\",\"\",\"" + DC.getServertype() + "_error\",false],[\"modulecode\",\"errorcode\"],[],[\"count\"]]");
        statsDefs.put("modulefailure", "[[\"metric\",\"errorinfo\",\"\",\"overall\",false],[\"servertype\",\"modulecode\"],[],[\"count\"]]");
    }

    public static boolean loadStatsKeyDef(Hashtable<String, String> defs) {
        try {
            if (statsDefs == null) {
                statsDefs = new ConcurrentHashMap();
            }
            statsDefs.putAll(defs);
            LOGGER.info("PS --> StatsKeys loaded successfully");
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Error while loading stats Keys. Exception...", e);
            return false;
        }
    }

    public static boolean loadInfluxConf(Map<String, String> statsConf) {
        try {
            if (statsConfMap == null) {
                statsConfMap = new Hashtable<String, String>();
            }
            statsConfMap.putAll(statsConf);
            LOGGER.info("PS --> StatsConf loaded successfully");
            initialized = true;
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Error while loading InfluxConf. Exception...", e);
            return false;
        }
    }

    public static ConcurrentHashMap<String, String> getStatDefs() {
        return statsDefs;
    }

    public static String getStatDef(String statKey) {
        return statsDefs.get(statKey);
    }

    public static String getServerIp() {
        return serverIP;
    }

    public static boolean isIpPresentForStatType(String statType) {
        if (statType != null) {
            return statsConfMap.containsKey(statType);
        }
        return false;
    }

    public static String getDefaultWnet() {
        return StatsConf.getWnet("qos");
    }

    public static String getDefaultAuth() {
        return StatsConf.getWnet("qos");
    }

    public static String getWnet(String stype) {
        return influxInventoryMap.get(stype);
    }

    public static String getAuth(String stype) {
        return influxAuthMap.getOrDefault(stype, "");
    }

    public static String getDirectory() {
        if (statsConfMap.containsKey("directory")) {
            return statsConfMap.get("directory");
        }
        return ServerUtil.dataHome;
    }

    public static int getDispatchQueueSize() {
        if (statsConfMap.containsKey("qsize")) {
            return Integer.parseInt(statsConfMap.get("qsize"));
        }
        return 5000;
    }

    public static int getBatchSize() {
        if (statsConfMap.containsKey("batchsize")) {
            return Integer.parseInt(statsConfMap.get("batchsize"));
        }
        return -1;
    }

    public static int getBatchTime() {
        if (statsConfMap.containsKey("batchtime")) {
            return Integer.parseInt(statsConfMap.get("batchtime"));
        }
        return -1;
    }

    public static int getProfilerInterval() {
        if (statsConfMap.containsKey("profilerinterval")) {
            return Integer.parseInt(statsConfMap.get("profilerinterval"));
        }
        return 60000;
    }

    public static boolean isSessionStatsEnabled() {
        if (statsConfMap.containsKey("recordsessions")) {
            return Boolean.parseBoolean("" + statsConfMap.get("recordsessions"));
        }
        return false;
    }

    public static boolean isWDBStatsEnabled() {
        if (statsConfMap.containsKey("wdbstatsenabled")) {
            return Boolean.parseBoolean("" + statsConfMap.get("wdbstatsenabled"));
        }
        return false;
    }

    public static boolean isTaskEngineStatsEnabled() {
        if (statsConfMap.containsKey("taskenginestatsenabled")) {
            return Boolean.parseBoolean("" + statsConfMap.get("taskenginestatsenabled"));
        }
        return true;
    }

    public static boolean isDESStatsEnabled() {
        if (statsConfMap.containsKey("desstatsenabled")) {
            return Boolean.parseBoolean("" + statsConfMap.get("desstatsenabled"));
        }
        return true;
    }

    public static boolean isWMSTPEStatsEnabled() {
        if (statsConfMap.containsKey("wmstpestatsenabled")) {
            return Boolean.parseBoolean("" + statsConfMap.get("wmstpestatsenabled"));
        }
        return true;
    }

    public static boolean isTaskEngineBbklgEnabled() {
        if (StatsConf.isTaskEngineStatsEnabled() && !statsConfMap.containsKey("taskenginebklgenabled")) {
            return true;
        }
        if (statsConfMap.containsKey("taskenginebklgenabled")) {
            return Boolean.parseBoolean("" + statsConfMap.get("taskenginebklgenabled"));
        }
        return false;
    }

    public static boolean isStatsEnabled() {
        if (statsConfMap.containsKey("statsenabled")) {
            return Boolean.parseBoolean("" + statsConfMap.get("statsenabled"));
        }
        return true;
    }

    public static boolean isDataDebugEnabled() {
        if (statsConfMap.containsKey("datadebug")) {
            return Boolean.parseBoolean("" + statsConfMap.get("datadebug"));
        }
        return false;
    }

    public static String getDB() {
        return StatsConf.getDB("defaultdb");
    }

    public static String getDB(String dbname) {
        return statsConfMap.get(dbname);
    }

    public static int getHttpConnectTimeout() {
        try {
            if (statsConfMap.containsKey("connecttimeout")) {
                return Integer.parseInt(statsConfMap.get("connecttimeout"));
            }
        }
        catch (Exception e) {
            LOGGER.severe("NS--> Error while getting HttpConnectTimeout from StatsConf" + e.getMessage());
        }
        return 3000;
    }

    public static int getHttpReadTimeout() {
        try {
            if (statsConfMap.containsKey("readtimeout")) {
                return Integer.parseInt(statsConfMap.get("readtimeout"));
            }
        }
        catch (Exception e) {
            LOGGER.severe("NS--> Error while getting HttpReadTimeout from StatsConf" + e.getMessage());
        }
        return 20000;
    }

    public static int getNetworkCheckerInterval() {
        if (statsConfMap.containsKey("networkcheckerinterval")) {
            return Integer.parseInt(statsConfMap.get("networkcheckerinterval"));
        }
        return 180000;
    }

    public static int getDispatchersCount() {
        if (statsConfMap.containsKey("dispatchercount")) {
            return Integer.parseInt(statsConfMap.get("dispatchercount"));
        }
        return 1;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static boolean collectAtStartofMin() {
        if (statsConfMap.containsKey("periodiccollector")) {
            return Boolean.parseBoolean(statsConfMap.get("periodiccollector"));
        }
        return true;
    }

    public static boolean isWmsLoggerStatsEnabled() {
        if (statsConfMap.containsKey("wmsloggerstatsenabled")) {
            return Boolean.parseBoolean(statsConfMap.get("wmsloggerstatsenabled"));
        }
        return true;
    }

    public static boolean isWmsEventStatsEnabled() {
        if (statsConfMap.containsKey("wmseventstatsenabled")) {
            return Boolean.parseBoolean(statsConfMap.get("wmseventstatsenabled"));
        }
        return true;
    }

    static {
        statsConfMap = new HashMap<String, String>();
        influxInventoryMap = new HashMap<String, String>();
        influxAuthMap = new HashMap<String, String>();
        statsDefs = new ConcurrentHashMap();
        StatsConf.errorInstrumentation();
        StatsConf.moduleInstrumentation();
        try {
            serverIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "PS --> Error for serverIP in StatsConf.", e);
        }
    }
}

