/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutorInventory;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import com.adventnet.wms.servercommon.runtime.RuntimeAdmin;
import com.adventnet.wms.servercommon.stats.influx.Stats;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.taskengine.TaskManager;
import com.adventnet.wms.servercommon.wdb.engine.WDBManager;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.math.RoundingMode;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class SystemStats
extends Stats {
    private static final Logger LOGGER = Logger.getLogger(SystemStats.class.getName());
    private static Hashtable<String, Long> gctimeDetails = new Hashtable();
    private static Hashtable<String, Long> gccountDetails = new Hashtable();
    private static long totalmem = Runtime.getRuntime().totalMemory();
    private static long usedmem = 0L;
    private static FileStore homeFileStore = null;
    private static int fileStoreTime = 0;
    private static long lastCpuTime = 0L;

    SystemStats(long timekey) {
        this.timeKey = timekey;
    }

    @Override
    protected void dispatch() {
        try {
            Hashtable<String, Boolean> params = new Hashtable<String, Boolean>();
            params.put("reset_and_getstats", true);
            this.getTPEStats();
            Hashtable hits = this.getHits(params);
            Hashtable bandwidth = this.getBandwidthStats(params);
            Hashtable connectionsStatsMap = this.getSessions(params);
            List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
            Hashtable<String, ArrayList<Hashtable<String, String>>> tqstats = TaskManager.getWmsQStats();
            Hashtable<String, Hashtable<String, ArrayList<Hashtable<String, String>>>> newTQStats = TaskExecutorService.getWmsQStats();
            this.recordHitsInfo(this.timeKey, hits);
            this.recordMemInfo(this.timeKey);
            this.recordBandWidth(this.timeKey, bandwidth);
            this.recordGCStats(this.timeKey, gcbeans);
            this.recordDiskUsage(this.timeKey);
            this.recordCPUInfo();
            if (StatsConf.isTaskEngineBbklgEnabled()) {
                this.recordTaskQBklgData(this.timeKey, tqstats);
                for (String tmName : newTQStats.keySet()) {
                    this.recordTaskQBklgData(this.timeKey, newTQStats.get(tmName), tmName);
                }
            }
            if (StatsConf.isTaskEngineStatsEnabled()) {
                HashMap<String, Integer> currentThreadCountMap = TaskExecutorService.getCurrentThreadCount();
                HashMap<String, ConcurrentHashMap<String, Long>> map = TaskExecutorService.resetAndGetMaxThreadAllotmentDetails();
                if (map != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                        String tmname = entry.getKey();
                        ConcurrentHashMap threadAllocationMap = (ConcurrentHashMap)entry.getValue();
                        long maxThreads = (Long)threadAllocationMap.remove("maxThreads");
                        for (Map.Entry threadAllocationMapEntry : threadAllocationMap.entrySet()) {
                            StatsDB.addDataInstant(this.timeKey, "tethreadallocation", DC.getServertype(), DC.getCluster(), tmname, threadAllocationMapEntry.getKey(), threadAllocationMapEntry.getValue());
                        }
                        StatsDB.addDataInstant(this.timeKey, "tefpstats", DC.getServertype(), DC.getCluster(), tmname, maxThreads, currentThreadCountMap.get(entry.getKey()), TaskExecutorService.getPoolSize(entry.getKey()));
                    }
                }
                HashMap<String, HashMap<String, HashMap<String, Long>>> isoDetails = TaskExecutorService.getIsolationDetails();
                for (Map.Entry<String, HashMap<String, HashMap<String, Long>>> entry : isoDetails.entrySet()) {
                    String tmname = entry.getKey();
                    HashMap<String, HashMap<String, Long>> isoMap = entry.getValue();
                    for (Map.Entry<String, HashMap<String, Long>> isoMapEntry : isoMap.entrySet()) {
                        StatsDB.addDataInstant(this.timeKey, "isolationstats", DC.getServertype(), DC.getCluster(), tmname, isoMapEntry.getKey(), isoMapEntry.getValue().get("seqidcount"), isoMapEntry.getValue().get("isothreadcount"), isoMapEntry.getValue().get("poolsize"));
                    }
                }
            }
            if (StatsConf.isWMSTPEStatsEnabled()) {
                Hashtable<String, Hashtable<String, String>> threadStats = WMSThreadPoolExecutorInventory.getThreadStats();
                Hashtable<String, String> bqStats = WMSThreadPoolExecutorInventory.getBQStats();
                for (Map.Entry<String, Map<String, Object>> entry : threadStats.entrySet()) {
                    String executor = entry.getKey();
                    Hashtable stats = (Hashtable)entry.getValue();
                    StatsDB.addDataInstant(this.timeKey, "tpethreadstats", DC.getServertype(), DC.getCluster(), executor, stats.get("CorePoolSize"), stats.get("MaxPoolSize"), stats.get("LargestPoolSize"), stats.get("LargestActivePoolSize"));
                    if (!bqStats.containsKey(executor)) continue;
                    StatsDB.addDataInstant(this.timeKey, "tpebqstats", DC.getServertype(), DC.getCluster(), executor, bqStats.get(executor));
                }
            }
            if (StatsConf.isSessionStatsEnabled()) {
                this.recordSessions(this.timeKey, connectionsStatsMap);
            }
            if (StatsConf.isWDBStatsEnabled()) {
                WDBManager.recordDBInfo(this.timeKey);
                RocksDBManager.recordDBInfo(this.timeKey);
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.EXCEPTION_IN_SYSTEM_STATS.getErrorCode(), 1L);
            LOGGER.log(Level.INFO, "PS --> :: EXCEPTION_IN_SYSTEM_STATS :: Cant collect grid and system stats due to : ", e);
        }
    }

    private void recordTaskQBklgData(long timems, Hashtable<String, ArrayList<Hashtable<String, String>>> tqstats) {
        this.recordTaskQBklgData(timems, tqstats, "old");
    }

    private void recordTaskQBklgData(long timems, Hashtable<String, ArrayList<Hashtable<String, String>>> tqstats, String tmName) {
        try {
            Enumeration<String> qenum = tqstats.keys();
            while (qenum.hasMoreElements()) {
                String taskname = qenum.nextElement();
                ArrayList<Hashtable<String, String>> qstatsarray = tqstats.get(taskname);
                for (Hashtable<String, String> qstats : qstatsarray) {
                    String qSize = qstats.get("size");
                    if (qstats.isEmpty() || qSize != null && qSize.equals("0")) continue;
                    try {
                        StatsDB.addDataInstant(timems, "taskqueue", tmName, qstats.get("bqname"), qstats.get("in"), qstats.get("out"), qSize);
                        StatsDB.addDataInstant(timems, "tesbklg", DC.getServertype(), DC.getCluster(), tmName, qstats.get("bqname"), qstats.get("in"), qstats.get("out"), qSize);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "PS --> CANT UPLOAD TASKQSIZE STATS DATA ", e);
                    }
                    try {
                        long createdfiles = Long.parseLong("" + qstats.get("createdfiles"));
                        long proccesdfiles = Long.parseLong("" + qstats.get("proccesdfiles"));
                        long savetofiletime = Long.parseLong("" + qstats.get("savetofiletime"));
                        long loadfromfiletime = Long.parseLong("" + qstats.get("loadfromfiletime"));
                        long remainingfiles = Long.parseLong("" + qstats.get("remainingfiles"));
                        if (createdfiles <= 0L && proccesdfiles <= 0L && savetofiletime <= 0L && loadfromfiletime <= 0L && remainingfiles <= 0L) continue;
                        StatsDB.addDataInstant(timems, "bq", "taskengine", tmName + "_" + qstats.get("bqname"), createdfiles, proccesdfiles, savetofiletime, loadfromfiletime, remainingfiles);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "PS --> CANT UPLOAD TASKBQ STATS DATA ", e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning("PS --> CANT UPLOAD STATS DATA " + e.toString());
        }
    }

    private void recordHitsInfo(long timems, Hashtable<String, Hashtable> hits) {
        try {
            Enumeration<String> domainEnum = hits.keys();
            while (domainEnum.hasMoreElements()) {
                String domain = domainEnum.nextElement();
                Hashtable accessTable = hits.get(domain);
                Enumeration accessEnum = accessTable.keys();
                while (accessEnum.hasMoreElements()) {
                    String access = (String)accessEnum.nextElement();
                    Hashtable schematable = (Hashtable)accessTable.get(access);
                    Enumeration schemaenum = schematable.keys();
                    while (schemaenum.hasMoreElements()) {
                        String schema = (String)schemaenum.nextElement();
                        Hashtable readandwrite = (Hashtable)schematable.get(schema);
                        long totalhit = Long.parseLong((String)readandwrite.get("total"));
                        if (totalhit == 0L) continue;
                        StatsDB.addData("httphits", DC.getServertype(), domain, access, schema, totalhit);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "PS --> Cant upload httphits data ", e);
        }
    }

    private void recordMemInfo(long timems) {
        try {
            long temp = totalmem - Runtime.getRuntime().freeMemory();
            usedmem = temp > 0L ? temp : usedmem;
            StatsDB.addDataInstant(timems, "meminfo", DC.getServertype(), totalmem, usedmem);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "PS --> Cant meminfo httphits data ", e);
        }
    }

    private void recordBandWidth(long timems, Hashtable<String, Hashtable> bandwidth) {
        try {
            Enumeration<String> accessEnum = bandwidth.keys();
            while (accessEnum.hasMoreElements()) {
                String access = accessEnum.nextElement();
                Hashtable schematable = bandwidth.get(access);
                Enumeration schemaenum = schematable.keys();
                while (schemaenum.hasMoreElements()) {
                    String schema = (String)schemaenum.nextElement();
                    Hashtable readandwrite = (Hashtable)schematable.get(schema);
                    long totalwrite = Long.parseLong((String)readandwrite.get("totalwrite"));
                    long totalread = Long.parseLong((String)readandwrite.get("totalread"));
                    if (totalwrite == 0L && totalread == 0L) continue;
                    StatsDB.addDataInstant(timems, "bandwidth", DC.getServertype(), access, schema, totalwrite, totalread);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "PS --> Cant bandwidth httphits data ", e);
        }
    }

    private void recordGCStats(long timems, List<GarbageCollectorMXBean> gcbeans) {
        try {
            for (GarbageCollectorMXBean gcbean : gcbeans) {
                long ctime;
                long ccount = gcbean.getCollectionCount();
                long inttime = ctime = gcbean.getCollectionTime();
                long intcnt = ccount;
                String gcname = gcbean.getName();
                if (gcname == null) continue;
                if (gctimeDetails.get(gcname) != null) {
                    inttime = ctime - gctimeDetails.get(gcname);
                }
                if (gccountDetails.get(gcname) != null) {
                    intcnt = ccount - gccountDetails.get(gcname);
                }
                gctimeDetails.put(gcname, ctime);
                gccountDetails.put(gcname, ccount);
                if (inttime == 0L && intcnt == 0L) continue;
                StatsDB.addDataInstant(timems, "gc", DC.getServertype(), gcname, inttime, intcnt);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "PS --> Cant gc httphits data ", e);
        }
    }

    private void recordDiskUsage(long timems) {
        try {
            if (homeFileStore == null || fileStoreTime++ > 60) {
                this.initFileStorage();
                fileStoreTime = 0;
            }
            long totalSize = homeFileStore.getTotalSpace();
            long freeSize = homeFileStore.getUsableSpace();
            long usedSize = homeFileStore.getTotalSpace() - homeFileStore.getUnallocatedSpace();
            String usedPercentage = String.format("%.2f", (double)usedSize * 100.0 / (double)totalSize);
            String freePercentage = String.format("%.2f", (double)freeSize * 100.0 / (double)totalSize);
            StatsDB.addDataInstant(timems, "diskusage", DC.getServertype(), totalSize, usedSize, freeSize, usedPercentage, freePercentage);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "PS --> StatsDB --> Error in recordDiskUsage ", e);
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.EXCEPTION_IN_DISK_USAGE.getErrorCode(), 1L);
        }
    }

    private void recordCPUInfo() {
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            int availableProcessors = osBean.getAvailableProcessors();
            DecimalFormat df = new DecimalFormat("#.###");
            df.setRoundingMode(RoundingMode.HALF_UP);
            try {
                double loadAverage = osBean.getSystemLoadAverage();
                String loadPercentage = df.format(loadAverage * 100.0 / (double)availableProcessors);
                int threadCount = threadBean.getThreadCount();
                String systemCpuLoad = df.format(osBean.getSystemCpuLoad() * 100.0);
                String processCpuLoad = df.format(osBean.getProcessCpuLoad() * 100.0);
                long processCpuTime = osBean.getProcessCpuTime() / 1000000L;
                String cpuTime = df.format(processCpuTime - lastCpuTime);
                lastCpuTime = processCpuTime;
                LOGGER.fine("PS --> CPUInfo --> [ loadAvg : " + df.format(loadAverage) + " ] [ loadPercentage : " + loadPercentage + " ] [ systemCpuPercentage : " + systemCpuLoad + " ] [ processCpuPercentage : " + processCpuLoad + " ] [ cpuTime : " + cpuTime + " ] [ threadCount : " + threadCount + " ]");
                StatsDB.addDataInstant(this.timeKey, "cpu_info", DC.getServertype(), df.format(loadAverage), loadPercentage, systemCpuLoad, processCpuLoad, cpuTime, threadCount, availableProcessors, availableProcessors / 2, 1);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "PS --> Exception in CPUMonitor", e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Exception in CPUMonitor", e);
        }
    }

    private void recordSessions(long timems, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, AtomicLong>>>>>> connectionsStatsMap) {
        try {
            if (connectionsStatsMap != null) {
                Enumeration<String> cenu = connectionsStatsMap.keys();
                while (cenu.hasMoreElements()) {
                    String prd = cenu.nextElement();
                    Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, AtomicLong>>>>> connection = connectionsStatsMap.get(prd);
                    try {
                        Enumeration<String> ctypeenum = connection.keys();
                        while (ctypeenum.hasMoreElements()) {
                            String ctype = ctypeenum.nextElement();
                            Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, AtomicLong>>>> sessiontypemap = connection.get(ctype);
                            Enumeration<String> sessiontypemapenum = sessiontypemap.keys();
                            while (sessiontypemapenum.hasMoreElements()) {
                                String sessiontype = sessiontypemapenum.nextElement();
                                Hashtable<String, Hashtable<String, Hashtable<String, AtomicLong>>> accesssmap = sessiontypemap.get(sessiontype);
                                Enumeration<String> accesssmapenum = accesssmap.keys();
                                while (accesssmapenum.hasMoreElements()) {
                                    String access = accesssmapenum.nextElement();
                                    Hashtable<String, Hashtable<String, AtomicLong>> portmap = accesssmap.get(access);
                                    Enumeration<String> portmapenum = portmap.keys();
                                    while (portmapenum.hasMoreElements()) {
                                        String domain = portmapenum.nextElement();
                                        Hashtable<String, AtomicLong> domains = portmap.get(domain);
                                        Enumeration<String> domainsenum = domains.keys();
                                        while (domainsenum.hasMoreElements()) {
                                            String port = domainsenum.nextElement();
                                            AtomicLong al = domains.get(port);
                                            StatsDB.addDataInstant(timems, "wmssessions", DC.getServertype(), prd, ctype, sessiontype, access, domain, port, al.longValue());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "PS --> Cant wmssessions httphits data ", e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "PS --> Cant session httphits data ", e);
        }
    }

    private Hashtable getBandwidthStats(Hashtable params) {
        try {
            return RuntimeAdmin.execute("bw", params);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "PS --> Error while getting stats info from runtime for bandwidth due to ", ex);
            return new Hashtable();
        }
    }

    private Hashtable getHits(Hashtable params) {
        try {
            return RuntimeAdmin.execute("hits", params);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "PS --> Error while getting stats info from runtime for hits due to ", ex);
            return new Hashtable();
        }
    }

    private void getTPEStats() {
        try {
            RuntimeAdmin.execute("tpestats", new Hashtable());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "RPT->Error while getting stats info from tpestats due to", ex);
        }
    }

    private Hashtable getSessions(Hashtable params) {
        if (StatsConf.isSessionStatsEnabled()) {
            try {
                params.put("getsessionsstats", true);
                return RuntimeAdmin.execute("session", params);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "PS --> Error while getting stats info from runtime for sessions due to ", ex);
            }
        }
        return new Hashtable();
    }

    private void initFileStorage() {
        try {
            homeFileStore = Files.getFileStore(Paths.get(File.separator + "home", new String[0]));
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "PS --> StatsDB --> Error in homeFileStore ", e);
        }
    }
}

