/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatementResult {
    private int statementid;
    private List<String> fnames;
    private boolean isgby_by_tagquery;
    private ArrayList<Hashtable> series;
    private final Hashtable<Object, ArrayList> resulttable = new Hashtable();

    public StatementResult(Hashtable result) {
        this.statementid = (Integer)result.get("statement_id");
        this.series = (ArrayList)result.get("series");
        this.fnames = (List)this.series.get(0).get("columns");
        this.isgby_by_tagquery = this.series.get(0).containsKey("tags");
        if (!this.isgby_by_tagquery) {
            Hashtable seriesElement = this.series.get(0);
            ArrayList value = (ArrayList)seriesElement.get("values");
            if (value != null) {
                this.resulttable.put("default", value);
            }
        } else {
            for (Hashtable seriesElement : this.series) {
                Hashtable tags = (Hashtable)seriesElement.get("tags");
                Iterator itr = tags.values().iterator();
                StringBuilder value = new StringBuilder((String)itr.next());
                while (itr.hasNext()) {
                    value.append("$").append((String)itr.next());
                }
                this.resulttable.put(value.toString(), (ArrayList)seriesElement.get("values"));
            }
        }
    }

    public Object getFieldValue(String fname) throws Exception {
        int findex;
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        List values = (List)this.resulttable.get("default").get(0);
        Object fvalue = values.get(findex = this.fnames.indexOf(fname));
        if (this.isNull(fvalue)) {
            return 0;
        }
        return fvalue;
    }

    public List getFieldSeries(String fname) throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        try {
            ArrayList<List<Object>> resultlist = new ArrayList<List<Object>>();
            List values = this.resulttable.get("default");
            int findex = this.fnames.indexOf(fname);
            for (int i = 0; i < values.size(); ++i) {
                List valueList = (List)values.get(i);
                Object fvalue = valueList.get(findex);
                if (this.isNull(fvalue)) continue;
                resultlist.add(Arrays.asList(valueList.get(0), fvalue));
            }
            return resultlist;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<Object> getFieldSeriesWithoutTime(String fname) throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        try {
            ArrayList<Object> resultlist = new ArrayList<Object>();
            List values = this.resulttable.get("default");
            int findex = this.fnames.indexOf(fname);
            for (int i = 0; i < values.size(); ++i) {
                List valueList = (List)values.get(i);
                Object fvalue = valueList.get(findex);
                if (this.isNull(fvalue)) continue;
                resultlist.add(fvalue);
            }
            return resultlist;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Double getFieldSeriesSum(String fname) throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        Double sum = 0.0;
        List values = this.resulttable.get("default");
        int findex = this.fnames.indexOf(fname);
        for (int i = 0; i < values.size(); ++i) {
            List valueList = (List)values.get(i);
            Object fvalue = valueList.get(findex);
            if (this.isNull(fvalue)) continue;
            sum = sum + Double.valueOf("" + fvalue);
        }
        return sum;
    }

    public ArrayList getFieldsAsKeyValuePair(String fnamekey, String fnamevalue) throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        List values = this.resulttable.get("default");
        int fkeyindex = this.fnames.indexOf(fnamekey);
        int fvalueindex = this.fnames.indexOf(fnamevalue);
        ArrayList result = new ArrayList();
        HashMap<Object, Double> tempmap = new HashMap<Object, Double>();
        for (int i = 0; i < values.size(); ++i) {
            List valueList = (List)values.get(i);
            Object fkey = valueList.get(fkeyindex);
            Double fvalue = Double.parseDouble("" + valueList.get(fvalueindex));
            if (this.isNull(fvalue)) continue;
            tempmap.put(fkey, fvalue);
        }
        ArrayList list = StatementResult.sortMap(tempmap);
        for (int i = 0; i < list.size(); ++i) {
            try {
                Map.Entry entry = (Map.Entry)list.get(i);
                if (entry == null) continue;
                ArrayList<Object> newlist = new ArrayList<Object>();
                newlist.add(entry.getKey());
                newlist.add(entry.getValue());
                result.add(newlist);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return result;
    }

    public List getTagSeries(String tname) throws Exception {
        if (!this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible WITHOUT group_by query");
        }
        try {
            ArrayList<List<Object>> resultlist = new ArrayList<List<Object>>();
            List values = this.resulttable.get(tname);
            for (int i = 0; i < values.size(); ++i) {
                List valueList = (List)values.get(i);
                Object fvalue = valueList.get(1);
                if (this.isNull(fvalue)) continue;
                resultlist.add(Arrays.asList(valueList.get(0), fvalue));
            }
            return resultlist;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List getTagSeries(String tname, String fname) throws Exception {
        if (!this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible WITHOUT group_by query");
        }
        List values = this.resulttable.get(tname);
        int findex = this.fnames.indexOf(fname);
        ArrayList<List<Object>> resultlist = new ArrayList<List<Object>>();
        for (int i = 0; i < values.size(); ++i) {
            List valueList = (List)values.get(i);
            Object fvalue = valueList.get(findex);
            if (this.isNull(fvalue)) continue;
            resultlist.add(Arrays.asList(valueList.get(0), fvalue));
        }
        return resultlist;
    }

    public ArrayList getTopTagKeys(String fname) throws Exception {
        return this.getTopTagKeys(fname, Integer.MAX_VALUE);
    }

    public ArrayList getTopTagKeys(String fname, int count) throws Exception {
        if (!this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible WITHOUT group_by query");
        }
        int findex = this.fnames.indexOf(fname);
        ArrayList sortedlist = new ArrayList();
        HashMap<Object, Double> sortedmap = new HashMap<Object, Double>();
        Enumeration<Object> tnames = this.resulttable.keys();
        while (tnames.hasMoreElements()) {
            Object tname = tnames.nextElement();
            Object objVal = ((List)this.resulttable.get(tname).get(0)).get(findex);
            if (this.isNull(objVal)) continue;
            Double value = Double.parseDouble("" + objVal);
            sortedmap.put(tname, value);
        }
        ArrayList list = StatementResult.sortMap(sortedmap);
        for (int i = 0; i < count; ++i) {
            try {
                Map.Entry entry = (Map.Entry)list.get(i);
                if (entry == null) continue;
                sortedlist.add(entry.getKey());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return sortedlist;
    }

    public LinkedHashMap getTopTagKeysWithSize(String fname) throws Exception {
        return this.getTopTagKeysWithSize(fname, Integer.MAX_VALUE);
    }

    public LinkedHashMap getTopTagKeysWithSize(String fname, int count) throws Exception {
        if (!this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible WITHOUT group_by query");
        }
        int findex = this.fnames.indexOf(fname);
        LinkedHashMap<Object, Double> sortedmap = new LinkedHashMap<Object, Double>();
        Enumeration<Object> tnames = this.resulttable.keys();
        while (tnames.hasMoreElements()) {
            Object tname = tnames.nextElement();
            Object objVal = ((List)this.resulttable.get(tname).get(0)).get(findex);
            if (this.isNull(objVal)) continue;
            Double value = Double.parseDouble("" + objVal);
            sortedmap.put(tname, value);
        }
        ArrayList list = StatementResult.sortMap(sortedmap);
        sortedmap = new LinkedHashMap();
        for (int i = 0; i < count; ++i) {
            try {
                Map.Entry entry = (Map.Entry)list.get(i);
                if (entry == null) continue;
                sortedmap.put(entry.getKey(), (Double)entry.getValue());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return sortedmap;
    }

    private static ArrayList sortMap(Map<Object, Double> map) {
        ArrayList<Map.Entry<Object, Double>> list = new ArrayList<Map.Entry<Object, Double>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Object, Double>>(){

            @Override
            public int compare(Map.Entry<Object, Double> first, Map.Entry<Object, Double> second) {
                return second.getValue().compareTo(first.getValue());
            }
        });
        return list;
    }

    public ArrayList<String> getTagKeys() throws Exception {
        if (!this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible WITHOUT group_by query");
        }
        return new ArrayList<Object>(this.resulttable.keySet());
    }

    public ArrayList<String> getDatabases() {
        ArrayList<String> databases = new ArrayList<String>();
        if (this.series.get(0).get("values") != null) {
            ArrayList list = (ArrayList)this.series.get(0).get("values");
            for (int k = 0; k < list.size(); ++k) {
                databases.add((String)((ArrayList)list.get(k)).get(0));
            }
        }
        return databases;
    }

    public ArrayList<String> getCQueries() {
        ArrayList<String> cqs = new ArrayList<String>();
        for (int i = 0; i < this.series.size(); ++i) {
            Hashtable databasetable = this.series.get(i);
            if (databasetable.get("values") == null) continue;
            ArrayList list = (ArrayList)databasetable.get("values");
            for (int k = 0; k < list.size(); ++k) {
                cqs.add((String)((ArrayList)list.get(k)).get(1));
            }
        }
        return cqs;
    }

    public int getStatementId() {
        return this.statementid;
    }

    private boolean isNull(Object o) {
        String s = "" + o;
        return s.equals("null") || s.trim().isEmpty();
    }

    public ArrayList getDefaultResultValues() {
        try {
            return this.resulttable.get("default");
        }
        catch (Exception e) {
            return null;
        }
    }

    public Hashtable<Object, ArrayList> getResultMap() {
        try {
            return this.resulttable;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getFieldnames() {
        try {
            return this.fnames;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList<Hashtable> getSeries() {
        try {
            return this.series;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList getTimeAndFValueAsList(String fname) throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        int timeIndex = this.fnames.indexOf("time");
        int fnameIndex = this.fnames.indexOf(fname);
        ArrayList result = new ArrayList();
        ArrayList timeValuesList = new ArrayList();
        ArrayList<Double> fieldValuesList = new ArrayList<Double>();
        List values = this.resulttable.get("default");
        for (List list : values) {
            timeValuesList.add(list.get(timeIndex));
            fieldValuesList.add(Double.valueOf(list.get(fnameIndex).toString()));
        }
        result.add(timeValuesList);
        result.add(fieldValuesList);
        return result;
    }

    public long[] getTimeValuesAsLongArray() throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        int timeIndex = this.fnames.indexOf("time");
        int pos = 0;
        List values = this.resulttable.get("default");
        long[] longArray = new long[values.size()];
        for (List list : values) {
            longArray[pos++] = Long.valueOf(list.get(timeIndex).toString());
        }
        return longArray;
    }

    public double[] getFValueAsDoubleArray(String fname) throws Exception {
        if (this.isgby_by_tagquery) {
            throw new Exception("StatsException: Incompatible with group_by query");
        }
        int fnameIndex = this.fnames.indexOf(fname);
        int pos = 0;
        List values = this.resulttable.get("default");
        double[] doubleArray = new double[values.size()];
        for (List list : values) {
            doubleArray[pos++] = Double.valueOf(list.get(fnameIndex).toString());
        }
        return doubleArray;
    }
}

