/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.runtime.cli;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.runtime.RuntimeAdmin;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import com.adventnet.wms.servercommon.runtime.cli.CLICommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CLIRuntime
extends WmsRuntime {
    private static final Logger LOGGER = Logger.getLogger(CLIRuntime.class.getName());
    private static final String DATA = "data";
    private static final String FAILED = "failed";
    private static final String SUCCESS = "success";
    private static final String COMMAND_STATUS = "cmdStatus";
    private static final String INVALID_COMMAND = "Invalid command/command params";
    private static boolean initialize = false;
    private static final ArrayList<String> SYSTEM_COMMAND = new ArrayList();
    private static ConcurrentHashMap<String, CLICommand> commandMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> commandUsageMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> devCommandUsageMap = new ConcurrentHashMap();
    private static String cliConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "cli" + File.separator;

    @Override
    public Hashtable<String, Object> getInfo(Hashtable params) {
        Hashtable<String, Object> cmdOutput = new Hashtable<String, Object>();
        try {
            String command = (String)params.get("command");
            String zuid = (String)params.get("_zuid");
            String role = (String)params.get("_role");
            String prd = (String)params.get("_prd");
            cmdOutput = CLIRuntime.executeCommand(command, zuid, role, prd);
        }
        catch (Exception e) {
            e.printStackTrace();
            cmdOutput.put("error", "Exception while executing. Exception: " + e.getMessage());
        }
        return cmdOutput;
    }

    public static boolean initialize() {
        Properties commandConf = ServerUtil.getProperties(cliConfDir + "command.conf");
        if (commandConf == null) {
            commandConf = new Properties();
        }
        CLIRuntime.putCommonCommandNames(commandConf);
        for (String command : commandConf.stringPropertyNames()) {
            String runtimeKey = (String)commandConf.get(command);
            try {
                CLICommand cliCommand = new CLICommand(command, runtimeKey);
                String usage = cliCommand.getCmdHeaders("usage");
                if (usage != null) {
                    String role = cliCommand.getCmdHeaders("role");
                    if (role != null && role.contains("dev")) {
                        devCommandUsageMap.put(command, usage);
                    }
                    commandUsageMap.put(command, usage);
                }
                commandMap.put(command, cliCommand);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NSERR--> Error while loading command `" + command + "` for runtimeKey `" + runtimeKey + "`", e);
            }
        }
        return true;
    }

    private static void putCommonCommandNames(Properties commandConf) {
        commandConf.put("statsdb", "statsdb");
        commandConf.put("status", "status");
        commandConf.put("arstatus", "arstatus");
        commandConf.put("testhreadstats", "testhreadstats");
        commandConf.put("seqtes", "seqtes");
        commandConf.put("tesblock", "tesblock");
        commandConf.put("tesiso", "tesiso");
        commandConf.put("tesdebug", "tesdebug");
        commandConf.put("tesdrain", "tesdrain");
        commandConf.put("tpestats", "tpestats");
        commandConf.put("desconfig", "desconfig");
        commandConf.put("wcp", "wcp");
        commandConf.put("loglevel", "loglevel");
        commandConf.put("wmslogger", "wmslogger");
        commandConf.put("idbloadtest", "idbloadtest");
        CLIRuntime.addAWSCommandConf(commandConf);
    }

    private static void addAWSCommandConf(Properties commandConf) {
        commandConf.put("viewawsadapterconf", "aws/updateconf");
        commandConf.put("editawsadapterconf", "aws/updateconf");
        commandConf.put("removeawsadapterconf", "aws/updateconf");
        commandConf.put("viewawswebengineconf", "aws/updateconf");
        commandConf.put("viewawsdomainmap", "aws/updateconf");
        commandConf.put("viewawsportmap", "aws/updateconf");
        commandConf.put("awstpestats", "aws/tpe");
    }

    public static Hashtable<String, Object> executeCommand(String cmdStr, String zuid, String role, String prd) {
        Hashtable<String, Object> cmdOutput = new Hashtable<String, Object>();
        try {
            Hashtable output;
            Hashtable<String, Object> parsedCommand;
            if (!initialize) {
                initialize = CLIRuntime.initialize();
            }
            if ((parsedCommand = CLIRuntime.parseCommand(cmdStr, false)) == null) {
                cmdOutput.put(DATA, INVALID_COMMAND);
                cmdOutput.put(COMMAND_STATUS, FAILED);
                return cmdOutput;
            }
            String command = (String)parsedCommand.get("command");
            if (!commandMap.containsKey(command) && !CLIRuntime.isSystemCommand(command)) {
                cmdOutput.put(DATA, INVALID_COMMAND);
                cmdOutput.put(COMMAND_STATUS, FAILED);
                return cmdOutput;
            }
            String arguments = (String)parsedCommand.get("arguments");
            Hashtable options = (Hashtable)parsedCommand.get("options");
            if (!arguments.isEmpty() && !options.isEmpty()) {
                cmdOutput.put(DATA, INVALID_COMMAND);
                cmdOutput.put(COMMAND_STATUS, FAILED);
                return cmdOutput;
            }
            if (CLIRuntime.isSystemCommand(command)) {
                return CLIRuntime.executeSystemCommand(command, options, arguments, role);
            }
            if (role.equals("dev") && !devCommandUsageMap.containsKey(command)) {
                cmdOutput.put(DATA, "You are not allowed to execute this command.");
                cmdOutput.put(COMMAND_STATUS, FAILED);
                return cmdOutput;
            }
            Hashtable<String, String> paramsMap = CLIRuntime.replaceParamName(command, options);
            if (paramsMap == null) {
                cmdOutput.put(DATA, INVALID_COMMAND);
                cmdOutput.put(COMMAND_STATUS, FAILED);
                return cmdOutput;
            }
            CLICommand cliCommand = commandMap.get(command);
            Hashtable staticParams = cliCommand.getStaticParams();
            if (!staticParams.isEmpty()) {
                paramsMap.putAll(staticParams);
            }
            if (zuid != null) {
                paramsMap.put("_zuid", zuid);
            }
            if (role != null) {
                paramsMap.put("_role", role);
            }
            if (prd != null) {
                paramsMap.put("_prd", prd);
            }
            if ((output = RuntimeAdmin.execute(cliCommand.getRuntimeKey(), paramsMap)).containsKey("error")) {
                cmdOutput.put(DATA, output);
                cmdOutput.put(COMMAND_STATUS, FAILED);
            } else if (output.containsKey("unauthorized")) {
                cmdOutput.put(DATA, "Access Denied. Contact Super Admin.");
                cmdOutput.put(COMMAND_STATUS, SUCCESS);
            } else {
                cmdOutput.put(DATA, output);
                cmdOutput.put(COMMAND_STATUS, SUCCESS);
            }
            Properties cmdHeaders = cliCommand.getCmdHeaders();
            for (String cmdHeaderName : cmdHeaders.stringPropertyNames()) {
                if (cmdHeaderName.equals("usage")) continue;
                String value = (String)cmdHeaders.get(cmdHeaderName);
                cmdOutput.put(cmdHeaderName, value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while executing command = " + cmdStr + " zuid = " + zuid + " prd = " + prd + " role = " + role, e);
            cmdOutput.put(DATA, e.getMessage() != null ? e.getMessage() : "Unknown");
            cmdOutput.put(COMMAND_STATUS, FAILED);
        }
        return cmdOutput;
    }

    private static Hashtable<String, Object> parseCommand(String cmdStr, boolean suggestions) {
        String[] cmdopts = cmdStr.split(" ", 2);
        String command = cmdopts[0];
        Hashtable<String, String> options = new Hashtable<String, String>();
        Hashtable<String, Object> parsedCommand = new Hashtable<String, Object>();
        String arguments = "";
        if (cmdopts.length > 1) {
            arguments = cmdopts[1].trim();
            String[] optsstr = arguments.split(" ");
            for (int i = 0; i < optsstr.length; ++i) {
                if (optsstr[i].length() <= 0 || optsstr[i].charAt(0) != '-') continue;
                String cmdopt = optsstr[i].substring(1);
                if (i + 1 < optsstr.length) {
                    String value;
                    if ((value = optsstr[++i]).charAt(0) == '\"') {
                        StringBuilder opt_value = new StringBuilder(value);
                        while (!value.endsWith("\"") && i + 1 < optsstr.length) {
                            value = optsstr[++i];
                            opt_value.append(" ").append(value);
                        }
                        arguments = arguments.replaceFirst(Pattern.quote("-" + cmdopt + " " + opt_value), "");
                        options.put(cmdopt, opt_value.substring(1, opt_value.length() - 1));
                        continue;
                    }
                    if (value.charAt(0) == '-') {
                        --i;
                        value = "";
                    }
                    if (suggestions && (!suggestions || i >= optsstr.length - 1)) continue;
                    arguments = arguments.replaceFirst(Pattern.quote("-" + cmdopt + " " + value), "");
                    options.put(cmdopt, value);
                    continue;
                }
                options.put(cmdopt, "");
                arguments = arguments.replaceFirst(Pattern.quote("-" + cmdopt), "");
            }
        }
        arguments = arguments.trim();
        parsedCommand.put("command", command);
        parsedCommand.put("options", options);
        parsedCommand.put("arguments", arguments);
        return parsedCommand;
    }

    private static Hashtable<String, String> replaceParamName(String command, Hashtable<String, String> options) {
        CLICommand cliCommand = commandMap.get(command);
        Hashtable<String, String> params = new Hashtable<String, String>();
        Enumeration<String> e = options.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = options.get(key);
            String newKey = cliCommand.getCmdParams(key);
            if (newKey == null) {
                return null;
            }
            if (newKey == null) continue;
            params.put(newKey, value);
        }
        return params;
    }

    private static boolean isSystemCommand(String command) {
        return SYSTEM_COMMAND.contains(command);
    }

    private static Hashtable<String, Object> executeSystemCommand(String command, Hashtable<String, String> params, String arguments, String role) {
        if (command.equals("usage")) {
            return CLIRuntime.executeUsageCommand(arguments, role);
        }
        if (command.equals("man")) {
            return CLIRuntime.executeManCommand(arguments, role);
        }
        return null;
    }

    private static Hashtable<String, Object> executeUsageCommand(String command, String role) {
        Hashtable<String, Object> cmdOutput = new Hashtable<String, Object>();
        try {
            if (command == null || command.isEmpty()) {
                if (role.equals("dev")) {
                    cmdOutput.put(DATA, devCommandUsageMap);
                } else if (role.equals("admin")) {
                    cmdOutput.put(DATA, commandUsageMap);
                }
                cmdOutput.put(COMMAND_STATUS, SUCCESS);
                return cmdOutput;
            }
            if (commandUsageMap.containsKey(command)) {
                if (role.equals("dev")) {
                    if (devCommandUsageMap.containsKey(command)) {
                        cmdOutput.put(DATA, devCommandUsageMap.get(command));
                    } else {
                        cmdOutput.put(DATA, "You are not allowed to view the Usage of this command : " + command);
                    }
                    cmdOutput.put(COMMAND_STATUS, SUCCESS);
                    return cmdOutput;
                }
                if (role.equals("admin")) {
                    cmdOutput.put(DATA, commandUsageMap.get(command));
                    cmdOutput.put(COMMAND_STATUS, SUCCESS);
                    return cmdOutput;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting usage for command = " + command + " role = " + role, e);
        }
        cmdOutput.put(DATA, INVALID_COMMAND);
        cmdOutput.put(COMMAND_STATUS, FAILED);
        return cmdOutput;
    }

    private static Hashtable<String, Object> executeManCommand(String command, String role) {
        Hashtable<String, Object> cmdOutput = new Hashtable<String, Object>();
        try {
            if (command != null && commandMap.containsKey(command) && (role.equals("dev") && devCommandUsageMap.containsKey(command) || role.equals("admin"))) {
                CLICommand cliCommand = commandMap.get(command);
                cmdOutput.put(DATA, cliCommand.getMan());
                cmdOutput.put(COMMAND_STATUS, SUCCESS);
                cmdOutput.put("render", "man");
                return cmdOutput;
            }
            if (role.equals("dev") && !devCommandUsageMap.containsKey(command)) {
                cmdOutput.put(DATA, "You are not allowed to view the Man Pages of this command : " + command);
                cmdOutput.put(COMMAND_STATUS, SUCCESS);
                return cmdOutput;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting man for command = " + command + " role = " + role, e);
        }
        cmdOutput.put(DATA, INVALID_COMMAND);
        cmdOutput.put(COMMAND_STATUS, FAILED);
        return cmdOutput;
    }

    static {
        SYSTEM_COMMAND.add("usage");
        SYSTEM_COMMAND.add("man");
    }
}

