/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.runtime;

import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.arstatus.ARStatus;
import com.adventnet.wms.servercommon.components.executor.DESRuntime;
import com.adventnet.wms.servercommon.components.executor.LogLevelRuntime;
import com.adventnet.wms.servercommon.components.executor.SequentialIsolationHandler;
import com.adventnet.wms.servercommon.components.executor.StatusCollectorRuntime;
import com.adventnet.wms.servercommon.components.executor.TESBlockingHandler;
import com.adventnet.wms.servercommon.components.executor.TESDebugHandler;
import com.adventnet.wms.servercommon.components.executor.TESIsolationRuntime;
import com.adventnet.wms.servercommon.components.executor.TEThreadAllocationstats;
import com.adventnet.wms.servercommon.components.executor.TaskQueueDrainManager;
import com.adventnet.wms.servercommon.components.executor.WmsLoggerRuntime;
import com.adventnet.wms.servercommon.components.net.WCPCLIRuntime;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTest;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import com.adventnet.wms.servercommon.stats.influx.StatsCLIRuntime;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeAdmin {
    private static Logger logger = Logger.getLogger(RuntimeAdmin.class.getName());
    private static String runtimeConfFile;
    private static HashMap<String, WmsRuntime> runtimeMap;
    private static HashMap<String, WmsRuntime> periodicruntimeMap;
    private static String clusterIP;

    public static boolean initialize(String clusterip) {
        return RuntimeAdmin.initialize(clusterip, null);
    }

    public static boolean initialize(String clusterip, String serverhome) {
        try {
            runtimeConfFile = serverhome == null ? ServerUtil.serverHome + File.separator + "conf" + File.separator + "runtime.properties" : serverhome + File.separator + "conf" + File.separator + "runtime.properties";
            Properties runtimeConf = ServerUtil.getProperties(runtimeConfFile);
            runtimeConf.setProperty("tpestats", "com.adventnet.wms.servercommon.tpexecutor.TPEStats,1");
            clusterIP = clusterip;
            long intdiff = 0L;
            Enumeration<Object> e = runtimeConf.keys();
            while (e.hasMoreElements()) {
                String runtimeName = (String)e.nextElement();
                String[] runtimeValues = ((String)runtimeConf.get(runtimeName)).split(",");
                Timer profiler = new Timer("WmsRuntimeProfiler/" + runtimeName);
                WmsRuntime wrt = (WmsRuntime)Class.forName(runtimeValues[0]).newInstance();
                wrt.setName(runtimeName);
                runtimeMap.put(runtimeName, wrt);
                if (runtimeValues.length != 2) continue;
                periodicruntimeMap.put(runtimeName, wrt);
                long interval = Long.parseLong(runtimeValues[1]) * 60L * 1000L;
                profiler.scheduleAtFixedRate((TimerTask)wrt, interval + intdiff, interval);
                intdiff += 10000L;
            }
            runtimeMap.put("statsdb", new StatsCLIRuntime());
            runtimeMap.put("testhreadstats", new TEThreadAllocationstats());
            runtimeMap.put("seqtes", new SequentialIsolationHandler());
            runtimeMap.put("tesdrain", new TaskQueueDrainManager());
            runtimeMap.put("desconfig", new DESRuntime());
            runtimeMap.put("tesblock", new TESBlockingHandler());
            runtimeMap.put("tesiso", new TESIsolationRuntime());
            runtimeMap.put("tesdebug", new TESDebugHandler());
            runtimeMap.put("status", new StatusCollectorRuntime());
            runtimeMap.put("arstatus", new ARStatus());
            runtimeMap.put("wcp", new WCPCLIRuntime());
            runtimeMap.put("loglevel", new LogLevelRuntime());
            runtimeMap.put("wmslogger", new WmsLoggerRuntime());
            runtimeMap.put("idbloadtest", new IDBLoadTest());
            logger.info("NS--> WmsRuntime initialized successfully;");
            return true;
        }
        catch (Exception exp) {
            logger.log(Level.SEVERE, "PS --> Unable to initialize RuntimeAdmin.", exp);
            return false;
        }
    }

    public static synchronized boolean registerRuntime(String runtimeName, WmsRuntime runtime) {
        return RuntimeAdmin.registerRuntime(runtimeName, runtime, -1L);
    }

    public static synchronized boolean registerRuntime(String runtimeName, WmsRuntime runtime, long periodicInterval) {
        if (runtimeMap.containsKey(runtimeName)) {
            logger.warning("NS--> WmsRuntime already exists. runtimename=" + runtimeName);
            return false;
        }
        runtimeMap.put(runtimeName, runtime);
        if (periodicInterval > 0L) {
            periodicruntimeMap.put(runtimeName, runtime);
            long interval = periodicInterval * 60L * 1000L;
            Timer profiler = new Timer("WmsRuntimeProfiler/" + runtimeName);
            profiler.scheduleAtFixedRate((TimerTask)runtime, interval, interval);
        }
        return true;
    }

    public static Hashtable execute(String rkey, Hashtable params) {
        Hashtable rhash = new Hashtable();
        try {
            rhash = runtimeMap.get(rkey).getInfo(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rhash;
    }

    public static Hashtable getInfo(Hashtable rkeys) {
        Hashtable retval = new Hashtable();
        Enumeration e = rkeys.keys();
        while (e.hasMoreElements()) {
            String rkey = (String)e.nextElement();
            try {
                Hashtable params = (Hashtable)rkeys.get(rkey);
                Hashtable rhash = runtimeMap.get(rkey).getInfo(params);
                retval.put(rkey, rhash);
            }
            catch (Exception exp) {
                retval.put(rkey, new Hashtable());
            }
        }
        return retval;
    }

    public static Hashtable collectInfo(Hashtable serversHash, Hashtable rkeys) {
        Hashtable<String, Hashtable> retHash = new Hashtable<String, Hashtable>();
        Enumeration e = serversHash.keys();
        while (e.hasMoreElements()) {
            String wnet = (String)e.nextElement();
            try {
                HttpConnection con = new HttpConnection("http://" + wnet + "/runtime");
                con.addParameter("opr", (Object)"getinfo");
                con.addParameter("details", (Object)rkeys);
                Hashtable retval = (Hashtable)con.doGet();
                retHash.put(wnet, retval);
            }
            catch (Exception exp) {
                logger.info("unable to collect info from " + wnet + " details " + rkeys + "" + exp.getMessage());
            }
        }
        return retHash;
    }

    public static Hashtable postInfo(Hashtable serversHash, Hashtable rkeys) {
        Hashtable<String, Hashtable> retHash = new Hashtable<String, Hashtable>();
        Enumeration e = serversHash.keys();
        while (e.hasMoreElements()) {
            String wnet = (String)e.nextElement();
            try {
                HttpConnection con = new HttpConnection("http://" + wnet + "/runtime");
                con.addParameter("opr", (Object)"getinfo");
                con.addParameter("details", (Object)rkeys);
                Hashtable retval = (Hashtable)con.doPost();
                retHash.put(wnet, retval);
            }
            catch (Exception exp) {
                logger.info("unable to collect info from " + wnet + " details " + rkeys + "" + exp.getMessage());
            }
        }
        return retHash;
    }

    public static void audit(String msg) {
        try {
            HttpConnection con = new HttpConnection("http://" + clusterIP + "/runtime");
            con.addParameter("opr", (Object)"audit");
            con.addParameter("msg", (Object)msg);
            con.doGet();
        }
        catch (Exception e) {
            logger.info("unable to log the message " + msg + " details " + e.getMessage());
        }
    }

    static {
        runtimeMap = new HashMap();
        periodicruntimeMap = new HashMap();
    }
}

