/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.callback.WCPListener;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.rocksdb.RocksDBBackupManager;
import com.adventnet.wms.servercommon.rocksdb.RocksDBCommunicator;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RocksDBListener
implements WCPListener {
    private static final Logger LOGGER = Logger.getLogger(RocksDBListener.class.getName());

    @Override
    public void onMessage(String source, int dataType, String data) {
        LOGGER.log(Level.INFO, "SNA-- RocksDBListener.OnMessage dataType:{0}, data:{1}", new Object[]{dataType, data});
        switch (dataType) {
            case 101: {
                try {
                    if (ARManager.getServerMode() == 2) {
                        RocksDBBackupManager.clearDir(new File(RocksDBBackupManager.rocksDBBackupDirPath));
                        if (!RocksDBBackupManager.unTar(data)) {
                            LOGGER.log(Level.WARNING, "SNA-- RocksDB - restore init - untar failed");
                            WCPDispatcher.sendData("rocksdbconpool", source.split(":")[0], 104, "data");
                        }
                        if (!RocksDBBackupManager.initialize()) {
                            LOGGER.log(Level.WARNING, "SNA-- RocksDB - restore init - backupmanager failed to initialize");
                            WCPDispatcher.sendData("rocksdbconpool", source.split(":")[0], 104, "data");
                        }
                        if (!RocksDBBackupManager.executeRestore()) {
                            LOGGER.log(Level.WARNING, "SNA-- RocksDB - restore init - Execute Restore failed");
                            WCPDispatcher.sendData("rocksdbconpool", source.split(":")[0], 104, "data");
                        }
                        LOGGER.log(Level.INFO, "SNA-- initializing rocksdb");
                        if (!RocksDBManager.initialize(true)) {
                            LOGGER.log(Level.WARNING, "SNA-- RocksDB - restore init - RocksDB initialize failed");
                            WCPDispatcher.sendData("rocksdbconpool", source.split(":")[0], 104, "data");
                        }
                        LOGGER.log(Level.INFO, "SNA-- sending restore success response");
                        WCPDispatcher.sendData("rocksdbconpool", source.split(":")[0], 103, "data");
                        break;
                    }
                    LOGGER.log(Level.WARNING, "SNA-- RocksDB - restore message sent to wrong machine");
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "SNA-- Exception while handing restore init request", e);
                }
                break;
            }
            case 103: 
            case 104: {
                if (ARManager.getServerMode() == 1) {
                    LOGGER.log(Level.INFO, "SNA-- RocksDB - Notifying restore status to Communicator");
                    RocksDBCommunicator.notifyRestoreComplete(dataType);
                    break;
                }
                LOGGER.log(Level.WARNING, "SNA-- RocksDB - restore completion message sent to wrong machine");
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "SNA-- RocksDB - Invalid Datatype received by RocksDBListener");
            }
        }
    }

    @Override
    public void onError(String poolName, int dataType, String data, String reason) {
    }

    @Override
    public Hashtable handleForward(String source, Hashtable header) {
        return null;
    }
}

