/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.rocksdb.RocksDBAdapter;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.wdb.engine.WDBRecordBinding;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.BackupEngine;
import org.rocksdb.RocksDBException;
import org.rocksdb.TransactionLogIterator;

public class RocksDBInstance {
    private static Logger logger = Logger.getLogger(RocksDBInstance.class.getName());
    private static final String WDBTYPE = "rocksdb";
    private String dbName = null;
    public String rocksDBDataDir = null;
    private RocksDBAdapter rocksDB = null;
    private boolean isClosed = false;
    private boolean recordStats = false;
    private ConcurrentHashMap<String, WDBRecordBinding> binding = new ConcurrentHashMap();

    public RocksDBInstance(String dbName, boolean recordStats) throws Exception {
        try {
            this.recordStats = recordStats;
            this.dbName = dbName;
            this.rocksDBDataDir = dbName.equals("rocksdbfiles") ? ServerUtil.dataHome + File.separator + dbName + File.separator : ServerUtil.dataHome + File.separator + WDBTYPE + File.separator + dbName + File.separator;
            File dir = new File(this.rocksDBDataDir);
            if (!dir.isDirectory()) {
                dir.mkdirs();
            }
            if (!dir.exists()) {
                throw new Exception("Unable to setup rocksdb data home " + ServerUtil.dataHome + " for db=" + dbName);
            }
            logger.log(Level.INFO, "Initializing RocksDB Database dbName={0}", dbName);
            this.rocksDB = new RocksDBAdapter(recordStats);
            if (!this.rocksDB.open(this.rocksDBDataDir)) {
                logger.info("RocksDB failed to initialize - Unable to open rocksdb directory");
            }
            Properties dbconf = ServerUtil.getProperties(RocksDBManager.ROCKSDB_CONF_FILE_DIR + dbName + File.separator + dbName + ".cf");
            Enumeration<?> e = dbconf.propertyNames();
            while (e.hasMoreElements()) {
                String cfName = (String)e.nextElement();
                String bindClass = (String)dbconf.get(cfName);
                WDBRecordBinding bindObject = (WDBRecordBinding)Class.forName(bindClass).newInstance();
                this.binding.put(cfName, bindObject);
                if (!this.rocksDB.createColumnFamily(cfName)) {
                    logger.log(Level.SEVERE, "Unable to create Column Family: {0}", cfName);
                }
                logger.log(Level.INFO, "Column Family Initialized: {0}", cfName);
            }
            logger.info("RocksDB initialized successfully");
        }
        catch (Exception exp) {
            logger.log(Level.SEVERE, "Unable to setup RocksDB", exp);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBDataDir() {
        return this.rocksDBDataDir;
    }

    public RocksDBAdapter getDBAdaptor() {
        return this.rocksDB;
    }

    public WDBRecordBinding getCFRecordBinding(String cfName) {
        return this.binding.get(cfName);
    }

    public long put(String cfName, String skey, Object value) throws WMSException {
        try {
            WDBRecordBinding rbind = this.binding.get(cfName);
            long startTime = System.nanoTime();
            byte[] serializedData = rbind.serialize(value);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "putbind", 0, System.nanoTime() - startTime);
            }
            startTime = System.nanoTime();
            if (!this.rocksDB.put(cfName, rbind.getKey(skey), serializedData)) {
                throw new WMSException("Unable to put record for " + cfName);
            }
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "putdb", 1, System.nanoTime() - startTime);
                StatsDB.addData("wdbsizemetric", DC.getServertype(), DC.getCluster(), this.dbName, cfName, serializedData.length);
            }
            return serializedData.length;
        }
        catch (Exception e) {
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "putfail", 1, 0);
            }
            logger.log(Level.WARNING, "Unable to put the record from rocksdb; cfNsame:=" + cfName + " skey :" + skey, e);
            throw new WMSException("Unable to put record [" + cfName + "] [" + skey + "]");
        }
    }

    public Object get(String cfName, String skey) throws WMSException {
        try {
            WDBRecordBinding rbind = this.binding.get(cfName);
            long startTime = System.nanoTime();
            byte[] serializedData = this.rocksDB.get(cfName, rbind.getKey(skey));
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "getdb", 1, System.nanoTime() - startTime);
            }
            startTime = System.nanoTime();
            Object obj = rbind.deserialize(serializedData);
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "getbind", 0, System.nanoTime() - startTime);
            }
            return obj;
        }
        catch (Exception e) {
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "getfail", 1, 0);
            }
            logger.log(Level.WARNING, "Unable to get the record from rocksdb;  cfName=" + cfName + " skey :" + skey, e);
            throw new WMSException("Unable to get record [" + cfName + "] [" + skey + "]");
        }
    }

    public void delete(String cfName, String skey) throws WMSException {
        try {
            WDBRecordBinding rbind = this.binding.get(cfName);
            long startTime = System.nanoTime();
            if (!this.rocksDB.out(cfName, rbind.getKey(skey))) {
                throw new WMSException("Unable to delete record");
            }
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "deletedb", 1, System.nanoTime() - startTime);
            }
        }
        catch (Exception e) {
            if (StatsConf.isWDBStatsEnabled()) {
                StatsDB.addData("wdbhits", DC.getServertype(), DC.getCluster(), WDBTYPE, this.dbName, cfName, "deletefail", 1, 0);
            }
            logger.log(Level.WARNING, "Unable to delete the record from rocksdb " + cfName + " skey :" + skey, e);
            throw new WMSException("Unable to delete record [" + cfName + "] [" + skey + "]");
        }
    }

    public String putVerificationRecord() throws Exception {
        String verifyTime = String.valueOf(System.currentTimeMillis());
        if (!this.rocksDB.put("verification".getBytes(), verifyTime.getBytes())) {
            throw new Exception("verification record put failed");
        }
        return verifyTime;
    }

    public String getVerificationRecord() {
        try {
            return new String(this.rocksDB.get("verification".getBytes()));
        }
        catch (Exception e) {
            return "null";
        }
    }

    public boolean write(byte[] writeBatchData) {
        return this.rocksDB.write(writeBatchData);
    }

    public void createBackup(BackupEngine backupEngine) throws RocksDBException {
        this.rocksDB.createBackup(backupEngine);
    }

    public void recordDBInfo(long timems) {
        if (this.recordStats) {
            for (String colName : this.binding.keySet()) {
                StatsDB.addDataInstant(timems, "rocksdbstats", this.getDBName(), colName, this.rocksDB.getNumRecords(colName), this.rocksDB.getDBSize(colName), 0, 0);
            }
            HashMap<String, Double> stats = this.rocksDB.getStatistics();
            StatsDB.addDataInstant(timems, "rocksdbstats", this.getDBName(), "all", 0, 0, stats.get("wal_sync_micros"), stats.get("write_stall"));
        }
    }

    public boolean flushDB() {
        return this.rocksDB.flushDB();
    }

    public boolean disableFileDeletions() {
        return this.rocksDB.disableFileDeletions();
    }

    public boolean enableFileDeletions() {
        return this.rocksDB.enableFileDeletions();
    }

    public long getLatestSequenceNumber() {
        return this.rocksDB.getLatestSequenceNumber();
    }

    protected TransactionLogIterator getUpdatesSince(long seqNo) throws Exception {
        return this.rocksDB.getUpdatesSince(seqNo);
    }

    public void close() {
        this.rocksDB.close();
        this.isClosed = true;
    }
}

