/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.nioclient.http.HttpRequest;
import com.adventnet.wms.nioclient.http.HttpRequestEventListener;
import com.adventnet.wms.nioclient.http.HttpRequestWrapper;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.rocksdb.RocksDBARModule;
import com.adventnet.wms.servercommon.rocksdb.RocksDBCommunicator;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.util.DeflaterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class RocksDBHttpRequestEventListener
implements HttpRequestEventListener {
    private static final Logger LOGGER = Logger.getLogger(RocksDBHttpRequestEventListener.class.getName());
    private File fileToUpload;
    private FileInputStream fis;
    private DeflaterUtil deflater;
    private Object lock;
    private boolean compress;
    private long totalBytesRead = 0L;
    private long totalBytesSent = 0L;
    private long transferStartTime;
    private int status = 200;

    RocksDBHttpRequestEventListener(File file, Object lock, boolean compress) throws Exception {
        this.fileToUpload = file;
        this.fis = new FileInputStream(this.fileToUpload);
        this.deflater = new DeflaterUtil();
        this.lock = lock;
        this.compress = compress;
        this.transferStartTime = System.currentTimeMillis();
    }

    public void onConnectError(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.WARNING, "SNA--> RocksDB - File Transfer onConnect Error");
        this.notifyComplete(204);
    }

    public void onReadTimeout(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.WARNING, "SNA--> RocksDB - File Transfer Read Timeout");
        this.notifyComplete(204);
    }

    public void onConnect(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.WARNING, "SNA--> RocksDB - File Transfer onConnect");
    }

    public void onSubmit(HttpRequestWrapper wrapper) {
    }

    public void onSubmitError(HttpRequestWrapper wrapper) {
        this.notifyComplete(204);
    }

    public void onResponse(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.INFO, "SNA-- Response Code {0}", wrapper.getResponse().getResponseCode());
        switch (wrapper.getResponse().getResponseCode()) {
            case 200: {
                LOGGER.log(Level.INFO, "SNA-- RocksDB - File Transfer Success response");
                StatsDB.addDataInstant(System.currentTimeMillis(), "rocksdbarfiletransfer", DC.getServertype(), this.fileToUpload.length(), System.currentTimeMillis() - this.transferStartTime);
                this.notifyComplete(203);
                break;
            }
            case 400: {
                LOGGER.log(Level.WARNING, "SNA-- RocksDB - File Transfer Fail - {0}", wrapper.getResponse().getResponseMessage());
                this.notifyComplete(204);
                break;
            }
            case 500: {
                LOGGER.log(Level.WARNING, "SNA-- RocksDB - File Transfer Server Error - {0}", wrapper.getResponse().getResponseMessage());
                this.notifyComplete(204);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "SNA-- RocksDB - File Transfer Invalid response code");
                this.notifyComplete(204);
            }
        }
    }

    public void onResponseError(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.INFO, "SNA-- Response Message {0}", wrapper.getResponse().getResponseMessage());
        LOGGER.log(Level.WARNING, "SNA--> RocksDB - File Transfer onResponseError");
        this.notifyComplete(204);
    }

    public void onDisconnect(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.INFO, "SNA--> RocksDB - File Transfer client onDisconnect");
        LOGGER.log(Level.INFO, "SNA--> RocksDB - Total Bytes Read - {0}", this.totalBytesRead);
        LOGGER.log(Level.INFO, "SNA--> RocksDB - Total Bytes Sent - {0}", this.totalBytesSent);
        LOGGER.log(Level.INFO, "SNA--> RocksDB - Compression Ratio - {0}", Float.valueOf((float)this.totalBytesSent / (float)this.totalBytesRead));
        RocksDBARModule.updateStatus("Total Bytes Sent ", this.totalBytesSent);
        RocksDBARModule.updateStatus("Total Bytes Read", this.totalBytesRead);
        RocksDBARModule.updateStatus("Compression Ratio ", Float.valueOf((float)this.totalBytesSent / (float)this.totalBytesRead));
        RocksDBARModule.setFileTransferData(this.totalBytesRead);
        this.deflater.close();
    }

    public void onWriteRefill(HttpRequestWrapper wrapper) {
        LOGGER.log(Level.INFO, "SNA--> RocksDB - File Transfer client onWriteRefill");
        try {
            HttpRequest request = wrapper.getRequest();
            int bytesRead = 0;
            byte[] dataBuffer = new byte[RocksDBCommunicator.getBufferSize()];
            bytesRead = this.fis.read(dataBuffer);
            this.totalBytesRead += (long)bytesRead;
            byte[] defBytes = this.deflater.deflate(dataBuffer, 0, bytesRead);
            this.totalBytesSent += (long)defBytes.length;
            request.writeToStream(this.compress ? defBytes : dataBuffer, this.totalBytesRead == this.fileToUpload.length());
            RocksDBARModule.updateProgress(this.totalBytesSent + "/" + this.fileToUpload.length(), "" + this.totalBytesSent / this.fileToUpload.length() * 100L);
        }
        catch (Exception e) {
            this.notifyComplete(204);
            LOGGER.log(Level.WARNING, "SNA--> RocksDB - Exception During onWriteRefill", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyComplete(int status) {
        LOGGER.log(Level.INFO, "SNA--Started notifying the complete. Status {0} : ", status);
        this.status = status;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        LOGGER.log(Level.INFO, "SNA-- Notified the complete. Status {0}: ", status);
    }

    public int getCompletionStatus() {
        return this.status;
    }
}

