/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import com.adventnet.wms.servercommon.util.TarUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.BackupEngine;
import org.rocksdb.BackupableDBOptions;
import org.rocksdb.Env;
import org.rocksdb.RestoreOptions;
import org.rocksdb.RocksDB;

public class RocksDBBackupManager {
    private static final Logger LOGGER;
    private static BackupableDBOptions backupableDBOptions;
    private static BackupEngine backupEngine;
    private static boolean backupInProgress;
    private static boolean restoreInProgress;
    public static String rocksDBBackupDirPath;
    public static String rocksDBTarDirPath;

    public static boolean initialize() {
        LOGGER.log(Level.INFO, "SNA-- RocksDB - initializing RocksDBBackupManager");
        try {
            File rocksDBBackupDir = new File(rocksDBBackupDirPath);
            File rocksDBTarDir = new File(rocksDBTarDirPath);
            if (!rocksDBBackupDir.isDirectory() && rocksDBBackupDir.mkdirs()) {
                LOGGER.log(Level.INFO, "SNA-- RocksDB - Created Backup Directory");
            }
            if (!rocksDBTarDir.isDirectory() && rocksDBTarDir.mkdirs()) {
                LOGGER.log(Level.INFO, "SNA-- RocksDB - Created Tar Directory");
            }
            LOGGER.log(Level.INFO, "SNA-- RocksDB Directories Ready");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Failed to create directory for backup", e);
            return false;
        }
        LOGGER.log(Level.INFO, "SNA-- initializing RocksDB BackupEngine");
        try {
            backupableDBOptions = new BackupableDBOptions(rocksDBBackupDirPath);
            backupEngine = BackupEngine.open((Env)Env.getDefault(), (BackupableDBOptions)backupableDBOptions);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - RocksDBBackupManager initialize failed", e);
            return false;
        }
        return true;
    }

    public static void clearDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                RocksDBBackupManager.clearDir(file);
            }
            file.delete();
        }
    }

    public static boolean createBackup() {
        if (backupInProgress) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Backup Already in progress");
            return false;
        }
        try {
            backupInProgress = true;
            RocksDBManager.createBackup(backupEngine);
            backupEngine.garbageCollect();
            backupInProgress = false;
            return true;
        }
        catch (Exception e) {
            backupInProgress = false;
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - createBackup failed", e);
            return false;
        }
    }

    public static void close() {
        backupEngine.close();
        backupableDBOptions.close();
    }

    public static String createTar() throws Exception {
        String outputTarFileName = "backup_" + System.currentTimeMillis() + ".tar";
        LOGGER.log(Level.INFO, "SNA-- creating tar");
        TarUtil.compress(rocksDBTarDirPath + File.separator + outputTarFileName, new File(rocksDBBackupDirPath));
        LOGGER.log(Level.INFO, "SNA-- tar created successfull");
        return outputTarFileName;
    }

    public static boolean unTar(String tarFile) {
        try {
            LOGGER.log(Level.INFO, "SNA-- urtar init");
            TarUtil.decompress(rocksDBTarDirPath + File.separator + tarFile, new File(RocksDBManager.rocksDBDir));
            LOGGER.log(Level.INFO, "SNA-- untar successfull");
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "SNA-- untar unsuccessfull", e);
            return false;
        }
    }

    public static boolean executeRestore() {
        if (restoreInProgress) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Restore already in progress");
            return false;
        }
        LOGGER.log(Level.INFO, "SNA-- Restore initiated");
        try (RestoreOptions restoreOptions = null;){
            restoreOptions = new RestoreOptions(false);
            RocksDBBackupManager.initialize();
            backupEngine.restoreDbFromLatestBackup(RocksDBManager.rocksDBDir, RocksDBManager.rocksDBDir, restoreOptions);
        }
        return true;
    }

    static {
        RocksDB.loadLibrary();
        LOGGER = Logger.getLogger(RocksDBBackupManager.class.getName());
        backupInProgress = false;
        restoreInProgress = false;
        rocksDBBackupDirPath = RocksDBManager.rocksDBDir + File.separator + "backup";
        rocksDBTarDirPath = RocksDBManager.rocksDBDir + File.separator + "tarfiles";
    }
}

