/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.rocksdb.RocksDBIteratorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rocksdb.BackupEngine;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.FlushOptions;
import org.rocksdb.HistogramType;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TransactionDB;
import org.rocksdb.TransactionDBOptions;
import org.rocksdb.TransactionLogIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBAdapter {
    private static Logger logger;
    public static final String DEFAULT_COLUMN_FAMILY_NAME;
    private RocksDB rocksDB;
    private DBOptions dbOptions;
    private WriteOptions writeOptions;
    private ReadOptions readOptions;
    private TransactionDBOptions txnDBOptions;
    private HashMap<String, ColumnFamilyHandle> colMap;
    private HashMap<String, RocksIterator> iterMap;
    private Statistics dbStatistics;
    private boolean recordStats;

    public RocksDBAdapter(boolean recordStats) {
        this.recordStats = recordStats;
        this.dbOptions = new DBOptions();
        this.dbOptions.setCreateIfMissing(true);
        this.dbOptions.setIncreaseParallelism(40);
        this.dbOptions.setMaxTotalWalSize(0x80000000L);
        this.dbOptions.setMaxManifestFileSize(0x80000000L);
        if (recordStats) {
            this.dbStatistics = new Statistics();
            this.dbOptions.setStatistics(this.dbStatistics);
        }
        this.readOptions = new ReadOptions();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setDisableWAL(false);
        this.writeOptions.setSync(false);
        this.txnDBOptions = new TransactionDBOptions();
        this.colMap = new HashMap();
        this.iterMap = new HashMap();
    }

    public boolean open(String dbPath) {
        try {
            ArrayList colHandleList = new ArrayList();
            ArrayList<ColumnFamilyDescriptor> colDescriptorList = new ArrayList<ColumnFamilyDescriptor>();
            colDescriptorList.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY));
            Options options = new Options();
            for (byte[] colName : RocksDB.listColumnFamilies((Options)options, (String)dbPath)) {
                colDescriptorList.add(new ColumnFamilyDescriptor(colName));
            }
            options.close();
            this.rocksDB = TransactionDB.open((DBOptions)this.dbOptions, (TransactionDBOptions)this.txnDBOptions, (String)dbPath, colDescriptorList, colHandleList);
            for (ColumnFamilyHandle colHandle : colHandleList) {
                String colName = new String(colHandle.getName());
                this.colMap.put(colName, colHandle);
                this.iterMap.put(colName, null);
            }
            return true;
        }
        catch (RocksDBException e) {
            logger.log(Level.SEVERE, "Unable to open RocksDB", e);
            return false;
        }
    }

    public synchronized boolean createColumnFamily(String colName) {
        try {
            if (colName == null) {
                logger.log(Level.SEVERE, "Column Family Name cannot be NULL");
                return false;
            }
            if (this.colMap.get(colName) != null) {
                return true;
            }
            this.colMap.put(colName, this.rocksDB.createColumnFamily(new ColumnFamilyDescriptor(colName.getBytes())));
            return true;
        }
        catch (RocksDBException e) {
            logger.log(Level.WARNING, "Unable to create column family in RocksDB", e);
            return false;
        }
    }

    public boolean put(byte[] key, byte[] value) {
        try {
            this.rocksDB.put(this.writeOptions, key, value);
            return true;
        }
        catch (RocksDBException e) {
            logger.log(Level.WARNING, "RocksDB put operation failed", e);
            return false;
        }
    }

    public boolean put(String colName, byte[] key, byte[] value) {
        try {
            this.rocksDB.put(this.getColHandle(colName), this.writeOptions, key, value);
            return true;
        }
        catch (RocksDBException r) {
            logger.log(Level.WARNING, "RocksDB put operation failed", r);
            return false;
        }
        catch (WMSException w) {
            return false;
        }
    }

    public byte[] get(byte[] key) {
        try {
            return this.rocksDB.get(this.readOptions, key);
        }
        catch (RocksDBException e) {
            logger.log(Level.WARNING, "RocksDB get operation failed", e);
            return null;
        }
    }

    public byte[] get(String colName, byte[] key) {
        try {
            return this.rocksDB.get(this.getColHandle(colName), this.readOptions, key);
        }
        catch (RocksDBException r) {
            logger.log(Level.WARNING, "RocksDB get operation failed", r);
            return null;
        }
        catch (WMSException w) {
            return null;
        }
    }

    public boolean out(byte[] key) {
        try {
            this.rocksDB.delete(this.writeOptions, key);
            return true;
        }
        catch (RocksDBException e) {
            logger.log(Level.WARNING, "RocksDB delete operation failed", e);
            return false;
        }
    }

    public boolean out(String colName, byte[] key) {
        try {
            this.rocksDB.delete(this.getColHandle(colName), this.writeOptions, key);
            return true;
        }
        catch (RocksDBException r) {
            logger.log(Level.WARNING, "RocksDB delete operation failed", r);
            return false;
        }
        catch (WMSException w) {
            return false;
        }
    }

    public boolean write(byte[] writeBatchData) {
        try {
            this.rocksDB.write(this.writeOptions, new WriteBatch(writeBatchData));
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Rocksdb write operation failed", e);
            return false;
        }
    }

    void createBackup(BackupEngine backupEngine) throws RocksDBException {
        backupEngine.createNewBackup(this.rocksDB, true);
    }

    long getLatestSequenceNumber() {
        return this.rocksDB.getLatestSequenceNumber();
    }

    TransactionLogIterator getUpdatesSince(long seqNo) throws RocksDBException {
        return this.rocksDB.getUpdatesSince(seqNo);
    }

    ColumnFamilyHandle getColHandle(String colName) throws WMSException {
        ColumnFamilyHandle colHandle = null;
        colHandle = this.colMap.get(colName);
        if (colHandle == null) {
            logger.warning("RocksDB Column Family doe not exist: " + colName);
            throw new WMSException("RocksDB Column Family Does not exist: " + colName);
        }
        return colHandle;
    }

    public RocksDBIteratorAdapter iterinit() {
        return this.iterinit(DEFAULT_COLUMN_FAMILY_NAME);
    }

    public RocksDBIteratorAdapter iterinit(String colName) {
        return new RocksDBIteratorAdapter(this.rocksDB.newIterator(this.colMap.get(colName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushDB() {
        try (FlushOptions flushOptions = new FlushOptions();){
            this.rocksDB.flush(flushOptions);
            boolean bl = true;
            return bl;
        }
    }

    public boolean disableFileDeletions() {
        try {
            this.rocksDB.disableFileDeletions();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RocksDB failed to disable file deletions");
            return false;
        }
    }

    public boolean enableFileDeletions() {
        try {
            this.rocksDB.enableFileDeletions(true);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RocksDB failed to enable file deletions");
            return false;
        }
    }

    public HashMap<String, Double> getStatistics() {
        HashMap<String, Double> dbStatsMap = new HashMap<String, Double>();
        try {
            Double writeStallCount = Double.parseDouble(this.dbStatistics.getHistogramString(HistogramType.WRITE_STALL).split("Count: ", 2)[1].split(" ", 2)[0]);
            Double walFileSyncMicrosCount = Double.parseDouble(this.dbStatistics.getHistogramString(HistogramType.WAL_FILE_SYNC_MICROS).split("Count: ", 2)[1].split(" ", 2)[0]);
            dbStatsMap.put("write_stall", writeStallCount);
            dbStatsMap.put("wal_sync_micros", walFileSyncMicrosCount);
            return dbStatsMap;
        }
        catch (Exception e) {
            dbStatsMap.put("write_stall", new Double(-1.0));
            dbStatsMap.put("wal_sync_micros", new Double(-1.0));
            return dbStatsMap;
        }
    }

    public boolean close() {
        this.rocksDB.close();
        this.rocksDB = null;
        return true;
    }

    public long getNumRecords(String colName) {
        try {
            return this.rocksDB.getLongProperty(this.getColHandle(colName), "rocksdb.estimate-num-keys");
        }
        catch (RocksDBException r) {
            logger.log(Level.WARNING, "Unable to estimate number of keys in the column family: " + colName, r);
            return 0L;
        }
        catch (WMSException w) {
            return 0L;
        }
    }

    public long getDBSize(String colName) {
        try {
            return this.rocksDB.getLongProperty(this.getColHandle(colName), "rocksdb.estimate-live-data-size");
        }
        catch (RocksDBException r) {
            logger.log(Level.WARNING, "Unable to estimate DB size", r);
            return 0L;
        }
        catch (WMSException w) {
            return 0L;
        }
    }

    static {
        RocksDB.loadLibrary();
        logger = Logger.getLogger(RocksDBAdapter.class.getName());
        DEFAULT_COLUMN_FAMILY_NAME = new String(RocksDB.DEFAULT_COLUMN_FAMILY);
    }
}

