/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.rocksdb;

import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.grid.ar.ARModule;
import com.adventnet.wms.servercommon.rocksdb.RocksDBBackupManager;
import com.adventnet.wms.servercommon.rocksdb.RocksDBCommunicator;
import com.adventnet.wms.servercommon.rocksdb.RocksDBManager;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RocksDBARModule
implements ARModule {
    private static final Logger LOGGER = Logger.getLogger(RocksDBARModule.class.getName());
    public static final int FILE_STREAM_MODE = 2;
    public static final int MULTI_FILE_STREAM_MODE = 3;
    private static String tarFile;
    private static HashMap<String, String> progressMap;
    private static Hashtable<String, Object> statusMap;
    private long maximumPrepareTimeInMillis = 60000L;
    private static long maximumPerformTimeInMillis;
    private static int maxThreadForIncrementalBackup;
    private static long tarFileSize;
    private static long numRecordsSent;
    private long tarFileSendTimeTaken = 0L;
    private boolean abortFlag = false;
    private int incrementalBackupFileCount = -1;
    private long incrementalBackupFileTotalSize = 0L;
    private long incrementalBackupTransferTime = 0L;
    private long backupStartTime = -1L;
    private long backupEndTime = -1L;
    private int arMode = 2;
    private int executionType = 1;

    @Override
    public boolean init(int serverMode) {
        LOGGER.log(Level.INFO, "SNA-- RocksDBARModule init");
        tarFile = "";
        this.incrementalBackupFileCount = -1;
        return true;
    }

    @Override
    public void prepare() {
        this.abortFlag = false;
        try {
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Prepare : RocksDB for Active Replacement");
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Prepare : Disabling file deletions");
            RocksDBARModule.updateProgress("Disabling file deletions", "0");
            if (this.abortFlag || !RocksDBManager.disableFileDeletions()) {
                LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Prepare : Failed because rocksdb failed to disable file deletion");
                ARManager.updateStatus(this, 101, "failed to disable file deletion");
                return;
            }
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Prepare: Creating Backup");
            RocksDBARModule.updateProgress("Creating Backup", "5");
            this.backupStartTime = -1L;
            if (this.abortFlag || !this.createBackup()) {
                LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Prepare : Failed because error in creating rocksdb backup");
                ARManager.updateStatus(this, 101, "unable to create the rocksdb backup");
                return;
            }
            this.backupEndTime = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "SNA-- RocksDB Prepare: Backup Created");
            if (this.arMode == 3) {
                LOGGER.log(Level.INFO, "SNA-- RocksDB Prepare: Initiating Multiple File Transfer Process");
                RocksDBARModule.updateProgress("Transferring All Backup Files", "20");
                if (this.abortFlag || !this.transferIncrementalBackupFiles(this.backupStartTime, this.maximumPrepareTimeInMillis)) {
                    LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Prepare : Failed because all backup files was not transferred");
                    ARManager.updateStatus(this, 101, "all backup files were not transferred");
                    return;
                }
            }
            if (this.arMode == 2) {
                LOGGER.log(Level.INFO, "SNA-- RocksDB Prepare: Initiating File Transfer Process");
                RocksDBARModule.updateProgress("Streaming Tar File", "20");
                if (this.abortFlag || !this.transferBackupFiles()) {
                    LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Prepare : Failed because backup files was not transferred");
                    ARManager.updateStatus(this, 101, "backup files were not transferred");
                    return;
                }
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Prepare: File Transfer Process Completed");
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR --  Prepare : Initiating remote untar");
                RocksDBARModule.updateProgress("Executing remote restore", "80");
                if (this.abortFlag || !this.executeRemoteUntar()) {
                    LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Prepare : Failed because remote restore was not successful");
                    ARManager.updateStatus(this, 101, "remote restore was not successful");
                    return;
                }
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Prepare: Restore Process Completed");
            }
            RocksDBARModule.updateProgress("Success", "100");
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Prepare: Finished for Active Replacement");
            ARManager.updateStatus(this, 100, String.format("%s -- Completed -- AR Mode - %d", this.getFileTransferData(), this.arMode));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SNA-- RocksDB Prepare Failed - Exception occurred", e);
            try {
                ARManager.updateStatus(this, 101, "Exception occurred in prepare");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "SNA-- Exception occurred in failure update status inside prepare", ex);
            }
        }
    }

    @Override
    public void perform() {
        try {
            LOGGER.log(Level.INFO, "SNA--RocksDBAR -- Perform : Starting in mode : {0}", this.arMode);
            if (this.arMode == 2 || this.arMode == 3) {
                if (this.abortFlag || !this.takeIncrementalBackup()) {
                    LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Perform : Failed because of incremental backup was not created");
                    ARManager.updateStatus(this, 201, "failed because incremental backup was not created");
                    return;
                }
                RocksDBARModule.updateProgress("Took Incremental Backup", "20");
                if (this.abortFlag || !this.transferIncrementalBackupFiles(this.backupEndTime, maximumPerformTimeInMillis)) {
                    LOGGER.log(Level.SEVERE, "SNA-- RockDBAR -- Perform : Incremental backup files has been failed to transferred");
                    ARManager.updateStatus(this, 201, "failed because incremental files were not transferred");
                    return;
                }
                LOGGER.log(Level.INFO, "SNA--RocksDBAR - Incremental files has been transferred successfully");
                RocksDBARModule.updateProgress("Initiating RocksDB in AR ip", "80");
                if (this.abortFlag || !this.executeRemoteRocksDBInit()) {
                    LOGGER.log(Level.WARNING, "SNA-- RocksDBAR -- Perform : failed because remote rocksdb init and restore was not successful");
                    ARManager.updateStatus(this, 201, "remote rocksdb init and restore was not successful");
                    return;
                }
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Perform : Restore Process Completed");
                RocksDBARModule.updateProgress(this.incrementalBackupFileCount + " Incremental backup files Successfully Transfer", "100");
                ARManager.updateStatus(this, 200, "");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDBAR - Perform : Failed - Exception in perform", e);
            try {
                ARManager.updateStatus(this, 201, "Exception in perform");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "SNA-- RocksDBAR -- Perform : Failure occurred in failure updating the status", ex);
            }
        }
        progressMap.clear();
    }

    public void setMaximumPrepareTime(long maximumPrepareTimeInMillis) {
        this.maximumPrepareTimeInMillis = maximumPrepareTimeInMillis;
    }

    public void setARMode(int arMode) {
        this.arMode = arMode;
    }

    @Override
    public long getMaximumPrepareTime() {
        return this.maximumPrepareTimeInMillis;
    }

    public static void setMaximumPerformTime(long maximumPerformTimeInMillis) {
        RocksDBARModule.maximumPerformTimeInMillis = maximumPerformTimeInMillis;
    }

    @Override
    public long getMaximumPerformTime() {
        return maximumPerformTimeInMillis;
    }

    @Override
    public void onComplete(int serverMode) {
        RocksDBCommunicator.close();
    }

    @Override
    public void abort() {
        LOGGER.log(Level.WARNING, "SNA-- RocksDB - RocksDBARModule Abort Request received");
        this.abortFlag = true;
        RocksDBManager.enableFileDeletions();
        RocksDBCommunicator.abortStreaming();
        RocksDBBackupManager.close();
    }

    @Override
    public Map<String, String> getProgress() {
        return progressMap;
    }

    @Override
    public int getExecutionType() {
        return this.executionType;
    }

    public void setExecutionSequential() {
        this.executionType = 2;
    }

    public void setExecutionParallel() {
        this.executionType = 1;
    }

    @Override
    public int getModuleId() {
        return 104;
    }

    @Override
    public String getModuleName() {
        return "RocksDB";
    }

    @Override
    public Hashtable<String, Object> getStatus(int serverMode) {
        return statusMap;
    }

    @Override
    public Hashtable<String, Object> getDetailedStatus(int serverMode) {
        return null;
    }

    private boolean createBackup() {
        LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Clearing backup dir");
        RocksDBBackupManager.clearDir(new File(RocksDBBackupManager.rocksDBBackupDirPath));
        if (!RocksDBBackupManager.initialize()) {
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Backup Manager Initialize Failed");
            return false;
        }
        long backupStartTime = System.currentTimeMillis();
        if (!RocksDBBackupManager.createBackup()) {
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Create Backup Failed");
            return false;
        }
        LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Time taken for creating the backup : {0}", System.currentTimeMillis() - backupStartTime);
        RocksDBARModule.updateStatus("backup time", System.currentTimeMillis() - backupStartTime);
        return true;
    }

    private boolean takeIncrementalBackup() {
        LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- creating the incremental backup");
        long backupStartTime = System.currentTimeMillis();
        if (!RocksDBBackupManager.createBackup()) {
            LOGGER.log(Level.INFO, "SNA -- RocksDBAR - Incremental backup has been failed");
            return false;
        }
        LOGGER.log(Level.INFO, "SNA -- RocksDBAR - Incremental backup created successfully. Time Taken :{0}", System.currentTimeMillis() - backupStartTime);
        RocksDBARModule.updateStatus("Incremental Backup time", System.currentTimeMillis() - backupStartTime);
        return true;
    }

    private boolean transferBackupFiles() {
        try {
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Creating tar to send the backup files");
            long tarCreationStartTime = System.currentTimeMillis();
            tarFile = RocksDBBackupManager.createTar();
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Tar creation completed {0} : Time taken : {1}", new Object[]{tarFile, System.currentTimeMillis() - tarCreationStartTime});
            RocksDBARModule.updateProgress("Tar file created", "30");
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Started Sending tar files : {0} ", tarFile);
            long transferStartTime = System.currentTimeMillis();
            String tarFilePath = RocksDBBackupManager.rocksDBTarDirPath + File.separator + tarFile;
            boolean result = RocksDBCommunicator.transferFile(tarFilePath, tarFilePath);
            this.tarFileSendTimeTaken = System.currentTimeMillis() - transferStartTime;
            RocksDBARModule.updateStatus("tar file transfer time", this.tarFileSendTimeTaken);
            RocksDBARModule.updateProgress("Tar file sent successfully", "50");
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Tar file streaming successfully ended : {0} , TimeTaken :{1}", new Object[]{tarFile, this.tarFileSendTimeTaken});
            return result;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - ARModule - File Transfer failed", e);
            return false;
        }
    }

    private boolean transferIncrementalBackupFiles(long fileSinceTime, long maximumTransferTime) {
        try {
            long startTime = System.currentTimeMillis();
            ArrayList<File> fileList = RocksDBARModule.getFileSince(fileSinceTime);
            this.incrementalBackupFileCount = fileList.size();
            RocksDBARModule.updateProgress("Got the modified files", "40");
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR-- No of files need to backuped from incremental backup filelist:{0}-TimeTaken:{1}-maxThreads :{2}:", new Object[]{fileList.size(), System.currentTimeMillis() - startTime, maxThreadForIncrementalBackup});
            ExecutorService workers = Executors.newFixedThreadPool(maxThreadForIncrementalBackup);
            ArrayList<FileTransferExecutor> joblist = new ArrayList<FileTransferExecutor>();
            fileList.sort((o1, o2) -> {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return 0;
            });
            this.incrementalBackupFileTotalSize = 0L;
            for (File f : fileList) {
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Adding incremental file {0}", f.getAbsolutePath());
                joblist.add(new FileTransferExecutor(f));
                this.incrementalBackupFileTotalSize += f.length();
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Added incremental file  {0}", f.getAbsolutePath());
            }
            LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- Size of the jobslist {0}", joblist.size());
            RocksDBARModule.updateProgress("Started Streaming Files", "60");
            startTime = System.currentTimeMillis();
            List futureList = workers.invokeAll(joblist, maximumTransferTime, TimeUnit.MILLISECONDS);
            if (futureList == null) {
                LOGGER.log(Level.INFO, "SNA- RocksDBAR -- Future List is Empty");
                return false;
            }
            LOGGER.log(Level.INFO, "SNA- RocksDBAR -- Size of the Jobs list {0} and Future List :{1}", new Object[]{joblist.size(), futureList.size()});
            if (futureList.size() < joblist.size()) {
                return false;
            }
            for (Future f : futureList) {
                LOGGER.log(Level.INFO, "SNA-- RocksDBAR -- status of the incremental backup status {0}", f.get());
                if (((Boolean)f.get()).booleanValue()) continue;
                LOGGER.log(Level.INFO, "SNA- RocksDBAR -- Incremental Backup failed due to Rocksdb incremental backup is not transferred");
                return false;
            }
            this.incrementalBackupTransferTime = System.currentTimeMillis() - startTime;
            return true;
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "SNA-- RocksDBAR -- Incremental file transfer failed", exp);
            return false;
        }
    }

    private boolean executeRemoteUntar() {
        try {
            LOGGER.log(Level.INFO, "SNA-- remote untar call tar file: {0}", tarFile);
            return RocksDBCommunicator.executeRemoteUntar(tarFile);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SNA-- Remote untar fail", e);
            return false;
        }
    }

    private boolean executeRemoteRocksDBInit() {
        try {
            LOGGER.log(Level.INFO, "SNA-- sending remote rocksdb init call ");
            return RocksDBCommunicator.executeRemoteRocksDBInit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SNA-- Remote untar fail", e);
            return false;
        }
    }

    private static ArrayList<File> getFileSince(long time) {
        return RocksDBARModule.getFiles(new File(RocksDBBackupManager.rocksDBBackupDirPath), time);
    }

    private static ArrayList<File> getFiles(File file, final long since) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File newfile) {
                return newfile.lastModified() > since;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                list.addAll(RocksDBARModule.getFiles(files[i], since));
                continue;
            }
            if (!files[i].isFile()) continue;
            list.add(files[i]);
        }
        return list;
    }

    private static boolean executeRemoteRestore() {
        try {
            return RocksDBCommunicator.executeRemoteRestore(tarFile);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - Execute Remote Restore failed", e);
            return false;
        }
    }

    private static boolean startStreaming() {
        return RocksDBCommunicator.startStreaming();
    }

    private static boolean endStreaming() {
        try {
            return RocksDBCommunicator.endStreaming();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SNA-- RocksDB - End streaming failed", e);
            return false;
        }
    }

    static void setFileTransferData(long tarFileSize) {
        RocksDBARModule.tarFileSize = tarFileSize;
    }

    private String getFileTransferData() {
        if (this.arMode == 3) {
            return String.format("[%s@%s]", WMSUtil.HumanReadable.getMemSize(this.incrementalBackupFileTotalSize), WMSUtil.HumanReadable.getDuration(this.incrementalBackupTransferTime, true));
        }
        if (this.arMode == 2) {
            return String.format("[%s@%s]", WMSUtil.HumanReadable.getMemSize(tarFileSize), WMSUtil.HumanReadable.getDuration(this.tarFileSendTimeTaken, true));
        }
        return "file transfer data";
    }

    public static void setMaxThreadsForIncrementalBackup(int maxThreads) {
        maxThreadForIncrementalBackup = maxThreads;
    }

    public static int getMaxThreadsForIncrementalBackup() {
        return maxThreadForIncrementalBackup;
    }

    static void setNumRecordsSent(long numRecordsSent) {
        RocksDBARModule.numRecordsSent = numRecordsSent;
    }

    static void updateProgress(String title, String progress) {
        if (title != null) {
            progressMap.put("Title", title);
        }
        if (progress != null) {
            progressMap.put("Progress", progress);
        }
    }

    static void updateStatus(String key, Object value) {
        statusMap.put(key, value);
    }

    static {
        progressMap = new HashMap();
        statusMap = new Hashtable();
        maximumPerformTimeInMillis = 30000L;
        maxThreadForIncrementalBackup = 5;
        tarFileSize = 0L;
        numRecordsSent = 0L;
    }

    static class FileTransferExecutor
    implements Callable<Object> {
        private File file = null;

        public FileTransferExecutor(File file) {
            this.file = file;
        }

        @Override
        public Object call() {
            try {
                LOGGER.log(Level.INFO, "SNA-- sending incremental file {0}", this.file.getAbsolutePath());
                long transferStartingTime = System.currentTimeMillis();
                if (!RocksDBCommunicator.transferFile(this.file.getAbsolutePath(), this.file.getAbsolutePath(), true)) {
                    LOGGER.log(Level.WARNING, "SNA-- failed to transfer incremental file {0}", this.file.getAbsolutePath());
                    return false;
                }
                LOGGER.log(Level.INFO, "SNA--RocksDBAR -- Incremental backup file has been transferred filePath:{0} fileSize:{1} transferTime:{2}", new Object[]{this.file.getAbsolutePath(), this.file.length(), System.currentTimeMillis() - transferStartingTime});
                LOGGER.log(Level.INFO, "SNA-- sent incremental file {0}", this.file.getAbsolutePath());
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "SNA-- unable to transfer the file", exp);
                return false;
            }
            return true;
        }
    }
}

