/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.qos;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketFactory;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.DistributionManager;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QOSClient {
    private static QOSDispatcher qosDispatcher = new QOSDispatcher();
    private static WebSocket ws;
    private static WSHandler wsHandler;
    private static String sockurl;
    private static HashMap<String, String> headers;
    private static boolean isInitialised;
    private static boolean isReConnecting;
    private static boolean dispatchMsg;
    private static BlockingQueue<String> blockingQueue;
    private static final Logger LOGGER;

    public static void init(String url, boolean reInitialize) throws WMSCommunicationException {
        QOSClient.init(url, null, reInitialize);
    }

    public static void init(String url, HashMap<String, String> headers, boolean reInitialize) throws WMSCommunicationException {
        if (DC.isExternal()) {
            return;
        }
        try {
            if (!isInitialised || reInitialize) {
                if (url == null) {
                    throw new Exception("NS--> QOS Connecting url is null. Unable to establish connection.");
                }
                ws = WebSocketFactory.createSocket((String)url);
                sockurl = url;
                if (headers != null && !headers.isEmpty()) {
                    QOSClient.headers = headers;
                    ws.addHeaders(headers);
                }
                ws.setHandler((WebSocketHandler)wsHandler);
                ws.connect();
                isInitialised = true;
            } else {
                LOGGER.info("NS--> QOSClient is already initialised. ");
            }
        }
        catch (Exception e) {
            LOGGER.severe("NS--> Exception while initializing QOSClient. Exception: " + e.getMessage());
            isInitialised = false;
        }
    }

    private static void reconnect() throws WMSCommunicationException {
        ws = WebSocketFactory.createSocket((String)sockurl);
        if (headers != null && !headers.isEmpty()) {
            ws.addHeaders(headers);
        }
        ws.setHandler((WebSocketHandler)wsHandler);
        ws.connect();
    }

    private static void sendMessage(String msg) throws WMSCommunicationException {
        ws.write(msg);
    }

    public static void send(String msg) {
        if (DC.isExternal()) {
            return;
        }
        try {
            blockingQueue.put(msg);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Discarding message " + msg + " due to error while sending it. ", e);
        }
    }

    public static void startQOSDispatcher() {
        try {
            if (!qosDispatcher.isAlive() || !dispatchMsg) {
                dispatchMsg = true;
                qosDispatcher.start();
            } else {
                LOGGER.severe("NS--> QOSDispatcher is alive.");
            }
        }
        catch (Exception e) {
            LOGGER.info("NS--> Exception while starting QOSDispatcher.. Exception: " + e.getMessage());
        }
    }

    public static void stopQOSDispatcher() {
        dispatchMsg = false;
    }

    static {
        wsHandler = new WSHandler();
        isInitialised = false;
        isReConnecting = false;
        dispatchMsg = false;
        blockingQueue = new ArrayBlockingQueue<String>(50);
        LOGGER = Logger.getLogger(QOSClient.class.getName());
    }

    public static class GridLogger {

        public static class ActiveReplacement {
            public static void send(Hashtable<String, Object> message) {
                message.put("__activerep", "");
                QOSClient.send(HttpDataWraper.getString(message));
            }
        }
    }

    private static class ReConnector
    extends Thread {
        private int[] reconnectiontime = new int[]{1, 2, 5, 10, 30, 60};

        public ReConnector() {
            super("QOSReconnector/ReConnector");
        }

        @Override
        public void run() {
            int i = 0;
            try {
                LOGGER.info("NS--> QOS ReConnector Thread started.");
                while (isReConnecting) {
                    QOSClient.reconnect();
                    if (i < this.reconnectiontime.length - 1) {
                        Thread.sleep(this.reconnectiontime[i] * 1000);
                        ++i;
                        continue;
                    }
                    Thread.sleep(this.reconnectiontime[i] * 1000);
                }
                LOGGER.info("NS--> QOS ReConnector Thread closed.");
            }
            catch (Exception e) {
                LOGGER.severe("NS--> Error whhile re-connecting websocket connection. Exception: " + e.getMessage());
            }
        }
    }

    private static class WSHandler
    implements WebSocketHandler {
        private WSHandler() {
        }

        public void onOpen() {
            isReConnecting = false;
            LOGGER.info("NS--> QOS Connection opened.");
        }

        public void onMessage(String data) {
            try {
                Map message = (Map)HttpDataWraper.getObject((String)data);
                if (message == null) {
                    LOGGER.severe("DK--> WSHandler Message is null");
                } else if (message.containsKey("refreshCD")) {
                    Map dataMap = (Map)message.get("refreshCD");
                    String cluster = (String)dataMap.get("cluster");
                    DistributionManager.refreshClusterVersion(cluster);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "DK--> Error while WSHandler message : " + data, e);
            }
        }

        public void onClose(int code) {
            LOGGER.info("NS--> QOS Connection closed. Status Code: " + code);
            if (!isReConnecting) {
                isReConnecting = true;
                new ReConnector().start();
            }
        }
    }

    static class QOSDispatcher
    extends Thread {
        public QOSDispatcher() {
            super("QOS/QOSDispatcher");
        }

        @Override
        public void run() {
            while (dispatchMsg) {
                try {
                    if (!isReConnecting) {
                        String msg = (String)blockingQueue.poll(4L, TimeUnit.SECONDS);
                        if (msg != null) {
                            QOSClient.sendMessage(msg);
                            continue;
                        }
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("ping", "sastrue");
                        QOSClient.sendMessage(HttpDataWraper.getString(data));
                        continue;
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LOGGER.severe("Error inside QOSDispatcher. Unable to dispatch QOS message.  Exception: " + e);
                }
            }
        }
    }
}

