/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.monitor;

import com.adventnet.wms.servercommon.util.MailUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public abstract class DeadLockMonitor
extends Thread {
    private static Logger logger = Logger.getLogger(DeadLockMonitor.class.getName());
    private static int monitorInterval = 10;
    private static boolean mail_alert = true;
    private static String mail_subject = "Alert - DeadLock!!!";
    private static String mail_toAddress = "wms-team@zohocorp.com";

    public DeadLockMonitor() {
    }

    public DeadLockMonitor(boolean mail_alert) {
        DeadLockMonitor.mail_alert = mail_alert;
    }

    public DeadLockMonitor(int monitorInterval) {
        DeadLockMonitor.monitorInterval = monitorInterval;
    }

    public DeadLockMonitor(int monitorInterval, boolean mail_alert) {
        DeadLockMonitor.monitorInterval = monitorInterval;
        DeadLockMonitor.mail_alert = mail_alert;
    }

    public DeadLockMonitor(int monitorInterval, boolean mail_alert, String mail_toAddress) {
        DeadLockMonitor.monitorInterval = monitorInterval;
        DeadLockMonitor.mail_alert = mail_alert;
        DeadLockMonitor.mail_toAddress = mail_toAddress;
    }

    public DeadLockMonitor(int monitorInterval, boolean mail_alert, String mail_toAddress, String mail_subject) {
        DeadLockMonitor.monitorInterval = monitorInterval;
        DeadLockMonitor.mail_alert = mail_alert;
        DeadLockMonitor.mail_toAddress = mail_toAddress;
        DeadLockMonitor.mail_subject = mail_subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("DeadLock Monitor Initialized and Running...");
        this.setName("DeadLockMonitor/");
        while (true) {
            try {
                Thread.sleep(monitorInterval * 60 * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                File file;
                ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
                long[] lockedIds = mxBean.findDeadlockedThreads();
                if (lockedIds == null) continue;
                StringBuilder deadLockInfo = new StringBuilder();
                deadLockInfo.append("DeadLock Info : <br>");
                for (ThreadInfo threadInfo : mxBean.getThreadInfo(lockedIds, true, true)) {
                    try {
                        logger.severe("DeadLockMonitor ::: ThreadID " + threadInfo.getThreadId());
                        deadLockInfo.append(threadInfo.toString() + "<br>");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (lockedIds.length <= 0) continue;
                if (mail_alert) {
                    MailUtil.send(mail_subject, deadLockInfo.toString(), mail_toAddress);
                }
                if (!(file = new File(System.getProperty("wmsdata.home") + "/threaddump")).exists()) {
                    if (file.mkdirs()) {
                        logger.info("new threaddump directory created");
                    } else {
                        logger.info("new threaddump directory can not be created");
                    }
                }
                file = new File(System.getProperty("wmsdata.home") + "/threaddump/nohup" + new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS").format(new Date()).toString() + ".txt");
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                ObjectOutputStream outputstream = new ObjectOutputStream(fileoutputstream);
                try {
                    mxBean = ManagementFactory.getThreadMXBean();
                    for (ThreadInfo tinfo : mxBean.dumpAllThreads(true, true)) {
                        outputstream.writeObject(tinfo.toString() + "\n");
                    }
                    outputstream.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    fileoutputstream.close();
                    outputstream.close();
                }
                logger.warning("[DeadLock Identified][ServerCheckStatus - False]");
                this.setServerCheckStatus(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public abstract void setServerCheckStatus(boolean var1);
}

