/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.logging;

import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;

public class WmsLogger {
    private static String clusterip = null;

    public static boolean initialize(String ip) {
        clusterip = ip;
        return true;
    }

    public static void log(String msg) {
        WmsLogger.notifylog(msg, "log");
    }

    public static void updatelog(String msg) {
        WmsLogger.notifylog(msg, "update");
    }

    public static void audit(String msg) {
        Audit.info(msg);
    }

    private static void notifylog(String msg, String type) {
        try {
            if (clusterip == null) {
                return;
            }
            WmsEvent logevt = new WmsEvent();
            logevt.setOpr("gridlog.log");
            logevt.putData("msg", (Object)msg);
            logevt.putData("type", (Object)type);
            logevt.putData("ip", (Object)("" + ServerUtil.getServerIP()));
            HttpConnection con = new HttpConnection("http://" + clusterip + "/gridlog");
            con.addParameter("event", (Object)logevt);
            con.doPost();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static class Audit {
        public static void info(String msg) {
            WmsLogger.notifylog("800|" + msg, "audit");
        }

        public static void warning(String msg) {
            WmsLogger.notifylog("900|" + msg, "audit");
        }

        public static void severe(String msg) {
            WmsLogger.notifylog("1000|" + msg, "audit");
        }
    }
}

