/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.logging;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.qos.QOSClient;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class TraceLogger {
    private static Logger logger = Logger.getLogger(TraceLogger.class.getName());
    private static boolean isTailingEnabled = false;
    private static boolean isTrackingEnabled = false;
    private static Map<String, List<String>> tailMap = new HashMap<String, List<String>>();
    private static Map<String, List<String>> trackMap = new HashMap<String, List<String>>();

    public static boolean updateTraceConf(Map<String, List<String>> trackmap, Map<String, List<String>> tailmap) {
        try {
            if (trackmap != null) {
                trackMap = trackmap;
                isTrackingEnabled = trackMap.containsKey("*");
            }
            if (tailmap != null) {
                tailMap = tailmap;
                isTailingEnabled = !tailMap.isEmpty();
            }
            logger.info("NS--> Updated trace conf successfully");
            return true;
        }
        catch (Exception e) {
            logger.severe("NS--> Error while updating Trace Conf. Exception: " + e.getMessage());
            return false;
        }
    }

    public static void checkAndUpdateTraceMap(WmsEvent event) {
        ArrayList rKeyList = CommonUtil.getList((String)event.getRKey());
        try {
            if (isTrackingEnabled && StatsConf.isIpPresentForStatType("metric")) {
                rKeyList.retainAll((Collection)trackMap.get("*"));
                event.putHeader("tracklist", HttpDataWraper.getString((Object)rKeyList));
            }
        }
        catch (Exception exp) {
            logger.severe("NS--> Error while checking/updating track map in event: " + event.toString() + " Exception: " + exp.getMessage());
        }
        try {
            if (isTailingEnabled) {
                ArrayList backTrackList = new ArrayList();
                for (String rKey : rKeyList) {
                    if (!tailMap.containsKey(rKey)) continue;
                    backTrackList.addAll(tailMap.get(rKey));
                }
                if (!backTrackList.isEmpty()) {
                    event.putHeader("taillist", HttpDataWraper.getString(backTrackList));
                }
            }
        }
        catch (Exception e) {
            logger.severe("NS--> Error while checking/updating tail in event: " + event.toString() + " Exception: " + e.getMessage());
        }
    }

    public static void log(WmsEvent event, String msg) {
        try {
            if (event.getHeader("tracklist") != null && !event.getHeader("tracklist").isEmpty()) {
                List rKeyList = (List)HttpDataWraper.getObject((String)event.getHeader("tracklist"));
                for (String rKey : rKeyList) {
                    try {
                        StatsDB.addDataInstant(System.currentTimeMillis(), "track", DC.getCluster(), event.getHeader("prd"), event.getOpr(), rKey, event.getHeader("reqid"), msg);
                    }
                    catch (Exception exp) {
                        logger.severe("NS--> Error while storing writing data in database. Exception: " + exp.getMessage());
                        exp.printStackTrace();
                    }
                }
            }
            if (event.getHeader("taillist") != null && !event.getHeader("taillist").isEmpty()) {
                HashMap tailData = new HashMap();
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("msg", msg);
                data.put("cluster", DC.getCluster());
                data.put("opr", event.getOpr());
                data.put("reqid", event.getHeader("reqid"));
                data.put("ip", InetAddress.getLocalHost().getHostAddress());
                data.put("backTrackID", event.getHeader("taillist"));
                data.put("time", new SimpleDateFormat("dd/MM/yy HH:mm:ss").format(new Date()));
                tailData.put("tail", data);
                QOSClient.send(HttpDataWraper.getString(tailData));
            }
        }
        catch (Exception e) {
            logger.severe("NS--> Error while logging message. Message: " + msg + " Event: " + event.toString() + " Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void transferTraceConf(WmsEvent newEvent, WmsEvent oldEvent) {
        if (oldEvent.getHeader("tracklist") != null) {
            newEvent.putHeader("tracklist", oldEvent.getHeader("tracklist"));
            if (oldEvent.getHeader("taillist") != null) {
                newEvent.putHeader("taillist", oldEvent.getHeader("taillist"));
            }
        }
    }
}

