/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.kafka;

import com.adventnet.wms.servercommon.constants.KafkaConstants;
import com.adventnet.wms.servercommon.kafka.WMSKafkaProperties;
import java.util.ArrayList;

public class WMSKafkaQUtil {
    public static int getUniqueInt(String uniqueKey, int a_partitioncount) {
        int uniquePart = 0;
        if (uniqueKey != null) {
            int hashInt = Math.abs(uniqueKey.hashCode());
            uniquePart = hashInt % a_partitioncount;
        }
        return uniquePart;
    }

    public static String getTopic(String category, String uniqueKey) {
        ArrayList topicsList = WMSKafkaProperties.getCategoryTopicsList(category);
        int uniqueIndex = WMSKafkaQUtil.getUniqueInt(uniqueKey, topicsList.size());
        String[] topicWithPartition = ((String)topicsList.get(uniqueIndex)).split("\\|");
        String topic = topicWithPartition[0];
        return topic;
    }

    public static String getProducerTypeStr(KafkaConstants.ProducerType type) {
        String typeStr = null;
        if (type == KafkaConstants.ProducerType.ASYNC) {
            typeStr = "async";
        } else if (type == KafkaConstants.ProducerType.SYNC) {
            typeStr = "sync";
        }
        return typeStr;
    }
}

