/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.kafka;

import com.adventnet.wms.servercommon.constants.KafkaConstants;
import com.adventnet.wms.servercommon.kafka.KafkaProducer;
import com.adventnet.wms.servercommon.kafka.KafkaWMSListener;
import com.adventnet.wms.servercommon.kafka.WMSKafkaProperties;
import com.adventnet.wms.servercommon.kafka.WMSKafkaQUtil;
import com.adventnet.wms.servercommon.kafka.WMSKafkaQueueException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerImpl
extends KafkaProducer {
    private static Logger logger = Logger.getLogger(KafkaProducerImpl.class.getName());
    private ArrayList<org.apache.kafka.clients.producer.KafkaProducer> producersList = new ArrayList();
    private int producer_max_count = 0;
    private ArrayList pulledTopics = new ArrayList();
    private Properties producerProps = WMSKafkaProperties.getKafkaProps();

    public KafkaProducerImpl(int count) {
        this.connect(count);
    }

    public KafkaProducerImpl(int count, KafkaConstants.ProducerType type, Properties producerProp, KafkaWMSListener listener) {
        if (producerProp != null) {
            Properties confProperties = this.producerProps;
            ((Hashtable)confProperties).putAll(producerProp);
        }
        if (type != null && WMSKafkaQUtil.getProducerTypeStr(type) != null) {
            this.producerProps.setProperty("producer.type", WMSKafkaQUtil.getProducerTypeStr(type));
        }
        if (listener != null) {
            this.listener = listener;
        }
        this.connect(count);
        this.producer_max_count = this.producersList.size();
    }

    @Override
    public void connect(int count) throws WMSKafkaQueueException {
        for (int producerCount = 0; producerCount < count; ++producerCount) {
            logger.info("KafkaProducerImpl : initialising KafkaProducer " + producerCount);
            try {
                org.apache.kafka.clients.producer.KafkaProducer producer = new org.apache.kafka.clients.producer.KafkaProducer(this.producerProps);
                this.producersList.add(producer);
                this.pullPartitions(producer);
                this.pulledTopics = new ArrayList();
                continue;
            }
            catch (Exception ex) {
                if (this.listener != null) {
                    this.listener.onDisconnect();
                }
                ex.printStackTrace();
            }
        }
    }

    public void pullPartitions(org.apache.kafka.clients.producer.KafkaProducer producer) {
        Hashtable<String, Hashtable> catergoryTopics = WMSKafkaProperties.getCategoryTopicsTable();
        if (catergoryTopics != null) {
            Enumeration<Hashtable> values = catergoryTopics.elements();
            while (values.hasMoreElements()) {
                try {
                    Hashtable topicsPartition = values.nextElement();
                    Enumeration e = topicsPartition.keys();
                    while (e.hasMoreElements()) {
                        try {
                            String topic = (String)e.nextElement();
                            if (topic == null || this.pulledTopics.contains(topic)) continue;
                            logger.info("Pulling partition info for topic " + topic);
                            this.pullPartitions(producer, topic);
                            this.pulledTopics.add(topic);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    public void pullPartitions(org.apache.kafka.clients.producer.KafkaProducer producer, String topic) {
        block6: {
            try {
                List info = producer.partitionsFor(topic);
                logger.info("Paritions Info for topic " + topic + " Info " + info + " list " + this.listener);
                if (info == null || info.size() == 0) {
                    if (this.listener != null) {
                        this.listener.onFailure(topic);
                    }
                } else if (info.size() > 0 && this.listener != null) {
                    this.listener.onSuccess(topic);
                }
            }
            catch (Exception ex) {
                if (this.listener == null) break block6;
                this.listener.onFailure(topic);
            }
        }
    }

    @Override
    public void closeAllProducer() {
        for (int producerCount = 0; producerCount < this.producersList.size(); ++producerCount) {
            try {
                org.apache.kafka.clients.producer.KafkaProducer producer = this.producersList.get(producerCount);
                producer.close();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addToQueue(String topic, String msg) throws WMSKafkaQueueException {
        this.addToQueue(-1, topic, -1, null, msg);
    }

    @Override
    public void addToQueue(int produceSelectCount, String topic, int partitionCount, String partitionkey, String msg) throws WMSKafkaQueueException {
        this.addToQueue(produceSelectCount, topic, partitionCount, partitionkey, msg, this.callback);
    }

    @Override
    public void addToQueue(int produceSelectCount, String topic, int partitionCount, String partitionkey, String msg, Callback msgCallback) throws WMSKafkaQueueException {
        try {
            org.apache.kafka.clients.producer.KafkaProducer producer = null;
            producer = produceSelectCount != -1 && produceSelectCount <= this.producersList.size() ? this.producersList.get(produceSelectCount) : this.getProducer(partitionkey);
            ProducerRecord data = null;
            data = partitionCount != -1 ? new ProducerRecord(topic, Integer.valueOf(partitionCount), (Object)partitionkey, (Object)msg) : new ProducerRecord(topic, (Object)partitionkey, (Object)msg);
            producer.send(data, msgCallback);
        }
        catch (WMSKafkaQueueException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private org.apache.kafka.clients.producer.KafkaProducer getProducer(String key) throws WMSKafkaQueueException {
        int selectcount = WMSKafkaQUtil.getUniqueInt(key, this.producer_max_count);
        org.apache.kafka.clients.producer.KafkaProducer producer = this.producersList.get(selectcount);
        if (producer == null) {
            producer = this.producersList.get(0);
        }
        if (producer == null) {
            throw new WMSKafkaQueueException("Producer not initialized or not available");
        }
        return producer;
    }
}

