/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid.ar;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.ar.ARConstants;
import com.adventnet.wms.servercommon.grid.ar.ARModule;
import com.adventnet.wms.servercommon.grid.ar.ARModuleStat;
import com.adventnet.wms.servercommon.qos.QOSClient;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ARManager {
    private static final Logger LOGGER = Logger.getLogger(ARManager.class.getName());
    private static int arStage = 0;
    private static int moduleStage = -1;
    private static int serverMode = -1;
    private static long stime = 0L;
    private static boolean parallelModuleFailed = false;
    private static boolean executionInProgress = false;
    private static boolean isARCompleted = false;
    private static Map<ARModule, Integer> parallelModules = new ConcurrentHashMap<ARModule, Integer>();
    private static Map<ARModule, Integer> sequentialModules = new LinkedHashMap<ARModule, Integer>();
    private static Map<String, ARModule> arModulesInventory = new LinkedHashMap<String, ARModule>();
    private static Hashtable<String, Object> arDetails = new Hashtable();
    private static Map<String, String> arProvDetails = new HashMap<String, String>();
    private static Map<ARModule, ARModuleStat> statDetail = new HashMap<ARModule, ARModuleStat>();
    private static final ReentrantLock MODULELOCK = new ReentrantLock();
    private static final Condition MODULECOMPLETED = MODULELOCK.newCondition();
    private static Semaphore semaphore;
    private static Semaphore notifyARStatus;
    public static long notifyAdminTime;
    private static List<String> overAllDuration;
    private static List<String> status;
    private static final DateFormat DATEFORMAT;

    public static boolean startActiveReplacement(int serverMode, Map<String, String> arDetailsMap) throws Exception {
        long starteTime = System.currentTimeMillis();
        try {
            ARManager.reset();
            isARCompleted = false;
            ARManager.setServerMode(serverMode);
            arProvDetails = arDetailsMap;
            if (arProvDetails.containsKey("ip") && arProvDetails.containsKey("server_port")) {
                arProvDetails.put("wnet", arProvDetails.get("ip") + ":" + arProvDetails.get("server_port"));
            }
            LOGGER.info("ARProvDetails = " + arProvDetails);
            if (serverMode == 1) {
                if (arDetailsMap.containsKey("stime")) {
                    stime = Long.valueOf(arDetailsMap.get("stime"));
                }
            } else {
                if (serverMode == 2) {
                    return DC.notifyARStart(serverMode);
                }
                throw new Exception(" Invalid server mode " + serverMode);
            }
            new ARExecutor().start();
            LOGGER.info("NS--> ActiveReplacement started in " + (System.currentTimeMillis() - starteTime) + "ms [ServerMode: " + serverMode + "] [ARProvDetails: " + arDetailsMap + "] [Version: " + ARManager.getVersion() + "]");
            return true;
        }
        catch (Exception e) {
            ARManager.abortAR("Exception while notifying Active Replacement Start " + e.getMessage());
            LOGGER.log(Level.SEVERE, "Exception while notifying Active Replacement Start ", e);
            return false;
        }
    }

    public static boolean isARInProgress() {
        return executionInProgress;
    }

    public static boolean isARCompleted() {
        return isARCompleted;
    }

    public static void sendDataToAdmin(boolean isHeaderTitle) {
        Hashtable<String, Object> data = ARManager.getStatus(true);
        if (arProvDetails.containsKey("version")) {
            data.put("version", ARManager.getVersion());
            data.put("operation", ARManager.getOperation());
            data.put("cluster", DC.getCluster());
            data.put("stime", arProvDetails.get("stime"));
        }
        if (isHeaderTitle) {
            data.put("__store", "");
        }
        data.put("Duration", System.currentTimeMillis() - Long.valueOf(arProvDetails.get("stime")));
        data.put("Type", String.valueOf(arStage));
        data.put("duration", HttpDataWraper.getString(ARManager.setDuration()));
        data.put("status", HttpDataWraper.getString(status));
        data.put("overallduration", HttpDataWraper.getString(overAllDuration));
        data.put("moduleStage", moduleStage);
        QOSClient.GridLogger.ActiveReplacement.send(data);
    }

    public static List<String> setDuration() {
        ArrayList<String> duration = new ArrayList<String>();
        try {
            int index;
            long[] durationInMillis = new long[]{0L, 0L, 0L, 0L};
            for (ARModule module : arModulesInventory.values()) {
                index = module.getExecutionType() - 1;
                long prepareTime = statDetail.get(module).getDurationInMillis().get(0);
                long performTime = statDetail.get(module).getDurationInMillis().get(1);
                if (module.getExecutionType() == 2) {
                    int n = index;
                    durationInMillis[n] = durationInMillis[n] + prepareTime;
                    int n2 = index + 2;
                    durationInMillis[n2] = durationInMillis[n2] + performTime;
                    continue;
                }
                durationInMillis[index] = durationInMillis[index] < prepareTime ? prepareTime : durationInMillis[index];
                durationInMillis[index + 2] = durationInMillis[index + 2] < performTime ? performTime : durationInMillis[index + 2];
            }
            for (index = 0; index < 4; ++index) {
                duration.add(index, WMSUtil.HumanReadable.getDuration(durationInMillis[index], true));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while setting AR duration for modulestage", e);
        }
        return duration;
    }

    public static void setStatus(String statusMsg) {
        try {
            status.set(moduleStage, statusMsg);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while setting status", e);
        }
    }

    public static synchronized void register(ARModule module) throws Exception {
        if (module == null) {
            return;
        }
        if (executionInProgress) {
            LOGGER.info("AR-->Tried to register after AR start.module : " + module.getModuleName());
            throw new Exception("AR started.Can't register Module");
        }
        if (arModulesInventory.containsKey(module.getModuleName())) {
            throw new Exception("Module Name is already present.Try a different module name");
        }
        switch (module.getExecutionType()) {
            case 2: {
                sequentialModules.put(module, null);
                break;
            }
            case 1: {
                parallelModules.put(module, null);
                break;
            }
            default: {
                LOGGER.info("AR--> Invalid execution type for register --> " + module.getExecutionType() + " for moduleName: " + module.getModuleName() + " [Version: " + ARManager.getVersion() + "]");
                throw new Exception(" Invalid execution type for module. ");
            }
        }
        if (!module.init(serverMode)) {
            throw new Exception("ARERR--> " + module.getModuleName() + " initialisation failed. ");
        }
        statDetail.put(module, new ARModuleStat(module.getModuleName(), module.getExecutionType()));
        arModulesInventory.put(module.getModuleName(), module);
        LOGGER.info("AR--> Module " + module.getModuleName() + " registered successfully.Execution Type : " + ARConstants.getExecutionType(module.getExecutionType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updateStatus(ARModule module, int statusCode, String message) throws Exception {
        int stage;
        int operationType;
        if (module == null || !sequentialModules.containsKey(module) && !parallelModules.containsKey(module)) {
            throw new Exception("Invalid module.");
        }
        if (!ARConstants.isValidStatusCode(statusCode, statDetail.get(module).getOperation())) {
            LOGGER.warning("AR--> Invalid status code inside updateStatus--> " + statusCode + " for moduleName: " + module.getModuleName() + " [Version: " + ARManager.getVersion() + "]");
            statDetail.get(module).setStatus("Failed");
            statDetail.get(module).setOverAllStatus("Failed");
            ARManager.setStatus("Failed");
            if (parallelModules.containsKey(module)) {
                parallelModuleFailed = true;
            }
            MODULECOMPLETED.signal();
            ARManager.abortAR("Invalid StatusCode from " + module.getModuleName());
            throw new Exception("Invalid StatusCode.");
        }
        if (statDetail.get(module).getOperation() == ARConstants.Operation.operationsMap.get(1)) {
            operationType = 1;
            stage = 3;
        } else {
            operationType = 2;
            stage = 4;
        }
        if (!statDetail.get(module).isInProgress(operationType)) {
            LOGGER.info("AR-->Already updated module " + module.getModuleName());
            return;
        }
        try {
            statDetail.get(module).setEndTime(System.currentTimeMillis());
            MODULELOCK.lock();
            LOGGER.info("AR-->\tCalling update status for " + module.getModuleName() + " and status is " + message + "  " + ARConstants.getStatusMessage(statusCode) + ". [Version: " + ARManager.getVersion() + "]");
            if (sequentialModules.containsKey(module)) {
                sequentialModules.put(module, statusCode);
                MODULECOMPLETED.signal();
            } else if (parallelModules.containsKey(module)) {
                semaphore.release();
                LOGGER.info("AR-->\tReleased semaphore; Available permits : " + semaphore.availablePermits());
                parallelModules.put(module, statusCode);
                if (statusCode == 101 || statusCode == 201) {
                    parallelModuleFailed = true;
                    MODULECOMPLETED.signal();
                    LOGGER.warning("NSERR--> Failure in parallel module: " + module.getModuleName() + " status: " + ARConstants.getStatusMessage(statusCode) + " [Version: " + ARManager.getVersion() + "]");
                } else if (semaphore.availablePermits() == parallelModules.size()) {
                    MODULECOMPLETED.signal();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AR-->\tError while updating execution status for Active Replacement module. [Version: " + ARManager.getVersion() + "]\n", e);
        }
        finally {
            if (statusCode == 101 || statusCode == 201) {
                statDetail.get(module).setStatus("Failed");
                statDetail.get(module).setOverAllStatus("Failed");
                ARManager.setStatus("Failed");
                ARManager.setARDetails(0.0, module.getModuleName() + "  " + ARConstants.getStatusMessage(statusCode), "Failed", stage);
            } else {
                statDetail.get(module).setStatus("Completed");
                ARManager.setARDetails(17.0 / (double)arModulesInventory.size(), module.getModuleName() + "  " + ARConstants.getStatusMessage(statusCode), "Inprogress", stage);
                if (operationType == 2) {
                    statDetail.get(module).setOverAllStatus("Completed");
                }
            }
            Map<String, String> progresMap = module.getProgress();
            if (!CommonUtil.isEmpty((String)message)) {
                if (CommonUtil.isEmpty(progresMap)) {
                    progresMap = new HashMap<String, String>();
                }
                progresMap.put("Title", message);
            }
            statDetail.get(module).setProgress(progresMap);
            statDetail.get(module).setCurrentStage(statDetail.get(module).getCurrentStage() + 1);
            MODULELOCK.unlock();
        }
    }

    private static void setServerMode(int mode) {
        serverMode = mode;
    }

    public static int getServerMode() {
        return serverMode;
    }

    public static String getARIp() {
        if (arProvDetails != null) {
            return arProvDetails.get("ip");
        }
        return null;
    }

    public static String getARWnet() {
        if (arProvDetails != null) {
            return arProvDetails.get("wnet");
        }
        return null;
    }

    public static String getVersion() {
        if (arProvDetails != null) {
            return arProvDetails.get("version");
        }
        return null;
    }

    public static String getRequestMethod() {
        if (arProvDetails != null) {
            return arProvDetails.get("reqmethod");
        }
        return null;
    }

    public static String getOperation() {
        if (arProvDetails != null && arProvDetails.containsKey("operation")) {
            return arProvDetails.get("operation");
        }
        return "";
    }

    public static int getGACPort() {
        try {
            if (arProvDetails != null) {
                return Integer.parseInt(arProvDetails.get("gac_port"));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "NS--> Error while getting GAC Port. Hence returning default port value 7070. [Version: " + ARManager.getVersion() + "]\n", e);
        }
        return 7070;
    }

    public static String getServerPort() {
        if (arProvDetails != null) {
            return arProvDetails.get("server_port");
        }
        return null;
    }

    public static String getWeight() {
        if (arProvDetails != null) {
            return arProvDetails.get("weight");
        }
        return null;
    }

    public static String getPosition() {
        if (arProvDetails != null) {
            return arProvDetails.get("position");
        }
        return null;
    }

    public static void setOverAllDuration(int type) {
        if (type > 0) {
            try {
                overAllDuration.set(type - 1, WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - stime, true));
            }
            catch (Exception e) {
                try {
                    overAllDuration.add(type - 1, WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - stime, true));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Exception while setting overall duration for type : " + type, ex);
                }
            }
        }
    }

    public static void getRegisteredModules() {
        try {
            if (!arDetails.containsKey("ParallelModules")) {
                ArrayList<String> modules = new ArrayList<String>();
                for (ARModule module : parallelModules.keySet()) {
                    modules.add(module.getModuleName());
                }
                arDetails.put("ParallelModules", HttpDataWraper.getString(modules));
                modules = new ArrayList();
                for (ARModule module : sequentialModules.keySet()) {
                    modules.add(module.getModuleName());
                }
                arDetails.put("SequentialModules", HttpDataWraper.getString(modules));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while adding module details in AR Details Map : " + arDetails, e);
        }
    }

    public static void setARDetails(double progress, String title, String status, int type) {
        ARManager.setARDetails(progress, title, status, type, false);
    }

    public static void setARDetails(double progress, String title, String status, int type, boolean isHeaderTitle) {
        try {
            if (!arDetails.containsKey("StartTime")) {
                arDetails.put("_order", HttpDataWraper.getString(ARConstants.AR_ORDER));
                arDetails.put("ReplacementIP", ARManager.getARIp());
                arDetails.put("OldIP", InetAddress.getLocalHost().getHostAddress());
                arDetails.put("User", arProvDetails.get("user"));
                arDetails.put("Progress", "16.67");
                arDetails.put("StartTime", DATEFORMAT.format(stime));
            }
            arDetails.put("Duration", WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - Long.valueOf(arProvDetails.get("stime")), true));
            double prevProgress = Double.valueOf((String)arDetails.get("Progress"));
            arDetails.put("Progress", String.valueOf(prevProgress + progress));
            if (!CommonUtil.isEmpty((String)title)) {
                arDetails.put("Title", title);
                arDetails.put("Status", status);
                arDetails.put("Status", status);
                if (type != -1) {
                    arStage = type;
                }
            }
            ARManager.sendDataToAdmin(isHeaderTitle);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while setting AR details\n" + arDetails + ". [Version: " + ARManager.getVersion() + "]\n", e);
        }
    }

    protected static void notifyARComplete() {
        try {
            if (DC.notifyARComplete(ARManager.getServerMode(), ARManager.getOperation())) {
                LOGGER.info("ARSUCCESS--> Successfully completed. onComplete status true;");
            } else {
                LOGGER.info("ARSUCCESS--> Successfully completed. onComplete status false;");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while notifying AR Complete. [Version: " + ARManager.getVersion() + "]\n", e);
        }
    }

    public static void waitTillARComplete(long time, TimeUnit timeUnit) {
        try {
            if (notifyARStatus.tryAcquire(time, timeUnit)) {
                notifyARStatus.release();
                LOGGER.info("AR--> Shutdown Completed successfully.");
            } else {
                LOGGER.warning("AR--> ShutDown timed out.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside waitTillARComplete. wait-time=" + time + " TimeUnit=" + timeUnit.name(), e);
        }
    }

    protected static void abortAR(String error) {
        try {
            LOGGER.info("AR-->aborted active replacement. " + error + " [Version: " + ARManager.getVersion() + "]");
            executionInProgress = false;
            DC.abortAR(ARManager.getARIp());
            for (ARModule module : arModulesInventory.values()) {
                try {
                    module.abort();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "AR-->Exception while aborting active replacement for module :" + module.getModuleName(), e);
                }
            }
            DC.notifyARFailure(serverMode, -1, -1);
            ARManager.setStatus("Failed");
            ARManager.setOverAllDuration(-1);
            ARManager.setARDetails(0.0, "Aborted Active Replacement " + error, "Failed", -1, true);
            LOGGER.info("AR--> Total time taken to send data to Admin server : " + WMSUtil.HumanReadable.getDuration(notifyAdminTime));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AR-->Exception while aborting active replacement", e);
        }
    }

    public static void notifyOnComplete() {
        try {
            LOGGER.info("AR--> Inside notify notifyOnComplete [Version: " + ARManager.getVersion() + "]");
            for (ARModule module : arModulesInventory.values()) {
                try {
                    module.onComplete(serverMode);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "AR--> Exception while notifying active replacement for module :" + module.getModuleName(), e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "AR--> Exception inside notifyOnComplete [Version: " + ARManager.getVersion() + "]", e);
        }
    }

    private static void reset() {
        arStage = 0;
        moduleStage = -1;
        serverMode = -1;
        semaphore = null;
        arProvDetails = null;
        parallelModuleFailed = false;
        arDetails = new Hashtable();
        parallelModules = new HashMap<ARModule, Integer>();
        sequentialModules = new LinkedHashMap<ARModule, Integer>();
        arModulesInventory = new HashMap<String, ARModule>();
        executionInProgress = false;
        status = new ArrayList<String>();
        overAllDuration = new ArrayList<String>();
        status.add(null);
        status.add(null);
        status.add(null);
        status.add(null);
    }

    private static long getMaximumExecutionTime(ARModule module, int executionType, int operationType) {
        long maximumExecutionTime = 3000L;
        try {
            if (executionType == 2) {
                if (operationType == 1) {
                    maximumExecutionTime = module.getMaximumPrepareTime();
                } else if (operationType == 2) {
                    maximumExecutionTime = module.getMaximumPerformTime();
                }
            } else if (executionType == 1) {
                for (ARModule armodule : parallelModules.keySet()) {
                    if (operationType == 1 && armodule.getMaximumPrepareTime() > maximumExecutionTime) {
                        maximumExecutionTime = armodule.getMaximumPrepareTime();
                        continue;
                    }
                    if (operationType != 2 || armodule.getMaximumPerformTime() <= maximumExecutionTime) continue;
                    maximumExecutionTime = armodule.getMaximumPerformTime();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while getting maxmimum execution time", e);
        }
        return maximumExecutionTime;
    }

    private static void getProgressForModules() {
        for (ARModule module : arModulesInventory.values()) {
            try {
                long stime = System.currentTimeMillis();
                statDetail.get(module).setProgress(module.getProgress());
                long etime = System.currentTimeMillis();
                if (etime - stime <= 500L) continue;
                LOGGER.info("ARDEBUG-->Exceeded GetProgress time " + WMSUtil.HumanReadable.getDuration(etime - stime, true) + " for module : " + module.getModuleName());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "AR-->Exception while getting progress for " + module.getModuleName(), e);
            }
        }
    }

    public static Hashtable<String, Object> getStatus(boolean forAdmin) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        Hashtable<String, Hashtable<String, Object>> moduleDetails = new Hashtable<String, Hashtable<String, Object>>();
        try {
            data.put("ARDetails", arDetails);
            for (Map.Entry<String, ARModule> entry : arModulesInventory.entrySet()) {
                Hashtable<String, Object> moduleStatus = entry.getValue().getStatus(ARManager.getServerMode());
                if (CommonUtil.isEmpty(moduleStatus)) {
                    moduleStatus = statDetail.get(entry.getValue()).getDetails(forAdmin);
                } else {
                    moduleStatus.putAll(statDetail.get(entry.getValue()).getDetails(forAdmin));
                }
                moduleDetails.put(entry.getKey(), moduleStatus);
            }
            data.put("ModuleDetails", moduleDetails);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV--> Error while getting AR status for all modules. [Version: " + ARManager.getVersion() + "]\n", e);
        }
        return data;
    }

    public static Hashtable<String, Object> getStatus(String moduleName, boolean forAdmin) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        Hashtable moduleDetails = new Hashtable();
        try {
            data.put("ARDetails", arDetails);
            if (arModulesInventory.containsKey(moduleName)) {
                Hashtable<String, Object> moduleStatus = arModulesInventory.get(moduleName).getStatus(ARManager.getServerMode());
                if (CommonUtil.isEmpty(moduleStatus)) {
                    moduleStatus = statDetail.get(arModulesInventory.get(moduleName)).getDetails(forAdmin);
                } else {
                    moduleStatus.putAll(statDetail.get(arModulesInventory.get(moduleName)).getDetails(forAdmin));
                }
                moduleDetails.put(moduleName, moduleStatus);
            } else {
                Hashtable<String, String> error = new Hashtable<String, String>();
                error.put(moduleName, "Enter valid module name.");
                moduleDetails.put("ERROR", error);
            }
            data.put("ModuleDetails", moduleDetails);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV-->Error while getting AR status for module : " + moduleName + ". [Version: " + ARManager.getVersion() + "]\n", e);
        }
        return data;
    }

    public static Hashtable<String, Object> getDetailedStatus() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        Hashtable<String, Hashtable<String, Object>> moduleDetails = new Hashtable<String, Hashtable<String, Object>>();
        try {
            data.put("ARDetails", arDetails);
            for (Map.Entry<String, ARModule> entry : arModulesInventory.entrySet()) {
                Hashtable<String, Object> moduleStatus = entry.getValue().getDetailedStatus(ARManager.getServerMode());
                if (CommonUtil.isEmpty(moduleStatus)) {
                    moduleStatus = statDetail.get(entry.getValue()).getDetails(false);
                } else {
                    moduleStatus.putAll(statDetail.get(entry.getValue()).getDetails(false));
                }
                moduleDetails.put(entry.getKey(), moduleStatus);
            }
            data.put("Module Details", moduleDetails);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV-->Error while getting detailed AR status. [Version: " + ARManager.getVersion() + "] \n", e);
        }
        return data;
    }

    public static Hashtable<String, Object> getDetailedStatus(String moduleName) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        Hashtable moduleDetails = new Hashtable();
        try {
            data.put("ARDetails", arDetails);
            if (arModulesInventory.containsKey(moduleName)) {
                Hashtable<String, Object> moduleStatus = arModulesInventory.get(moduleName).getDetailedStatus(ARManager.getServerMode());
                if (CommonUtil.isEmpty(moduleStatus)) {
                    moduleStatus = statDetail.get(arModulesInventory.get(moduleName)).getDetails(false);
                } else {
                    moduleStatus.putAll(statDetail.get(arModulesInventory.get(moduleName)).getDetails(false));
                }
                moduleDetails.put(moduleName, moduleStatus);
            } else {
                Hashtable<String, String> error = new Hashtable<String, String>();
                error.put(moduleName, "Enter valid module name.");
                moduleDetails.put("ERROR", error);
            }
            data.put("ModuleDetails", moduleDetails);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NAV-->Error while getting Detailed AR status for module : " + moduleName + ". [Version: " + ARManager.getVersion() + "]\n", e);
        }
        return data;
    }

    static {
        notifyARStatus = new Semaphore(1);
        notifyAdminTime = 0L;
        overAllDuration = new ArrayList<String>();
        status = new ArrayList<String>();
        DATEFORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss");
    }

    private static class ARWorkerThread
    extends Thread {
        int operationType;
        ARModule arModule = null;

        ARWorkerThread(ARModule module, int operationType) {
            this.arModule = module;
            this.operationType = operationType;
            this.setName("AR-" + ARManager.getVersion() + "-" + this.arModule.getModuleName() + "-" + ARConstants.Operation.operationsMap.get(operationType));
        }

        @Override
        public void run() {
            try {
                ((ARModuleStat)statDetail.get(this.arModule)).setStartTime();
                switch (this.operationType) {
                    case 1: {
                        this.arModule.prepare();
                        break;
                    }
                    case 2: {
                        this.arModule.perform();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NS--> Error inside ARWorker thread module :  " + this.arModule.getModuleName() + " and operation : " + ARConstants.Operation.operationsMap.get(this.operationType) + ". [Version: " + ARManager.getVersion() + "]\n", e);
                try {
                    if (this.operationType == 1) {
                        ARManager.updateStatus(this.arModule, 101, "Error inside ARWorker thread");
                    } else {
                        ARManager.updateStatus(this.arModule, 201, "Error inside ARWorker thread");
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "ARERR--> Exception while updating Perform Failed status in ARWorker Thread for module " + this.arModule.getModuleName() + ". [Version: " + ARManager.getVersion() + "]\n", ex);
                }
            }
        }
    }

    private static class ARExecutor
    extends Thread {
        private ARExecutor() {
            super("ARExecutor-" + ARManager.getVersion());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ARManager.setARDetails(7.0, "Notifying Active Replacement Start", "Started", 1);
                ARManager.setOverAllDuration(1);
                stime = System.currentTimeMillis();
                if (!DC.notifyARStart(serverMode)) {
                    LOGGER.info("AR-->Error  while notifying AR start.Aborting active replacement");
                    ARManager.setARDetails(0.0, "Error while notifying AR Start", "Failed", -1);
                    ARManager.abortAR("Failure while notifying AR start");
                    return;
                }
                executionInProgress = true;
                ARManager.getRegisteredModules();
                ARManager.setOverAllDuration(2);
                stime = System.currentTimeMillis();
                semaphore = new Semaphore(parallelModules.size());
                ARManager.setARDetails(10.0, arModulesInventory.size() + " Modules registered Successfully.Active Replacement started", "Inprogress", 2, true);
                int type = 3;
                for (Integer operationType : ARConstants.Operation.operationsMap.keySet()) {
                    if (operationType == 2) {
                        type = 4;
                    }
                    ARManager.setOverAllDuration(type);
                    ++moduleStage;
                    if (!parallelModules.isEmpty()) {
                        try {
                            MODULELOCK.lock();
                            ARManager.setStatus("Inprogress");
                            this.perform(1, operationType, type);
                            long interval = 0L;
                            long maximumExecutionTime = ARManager.getMaximumExecutionTime(null, 1, operationType);
                            LOGGER.info("ARDEBUG--> Maximum execution time for parallel prepare = " + maximumExecutionTime);
                            while (interval < maximumExecutionTime) {
                                long remainingTime = maximumExecutionTime - interval;
                                long waitingTime = remainingTime > 3000L ? 3000L : remainingTime;
                                boolean isAwaitElapsed = MODULECOMPLETED.await(waitingTime, TimeUnit.MILLISECONDS);
                                ARManager.setOverAllDuration(type);
                                ARManager.getProgressForModules();
                                ARManager.setARDetails(0.0, null, null, arStage);
                                if (isAwaitElapsed || parallelModuleFailed) break;
                                LOGGER.info("AR-->" + (interval += waitingTime) / 1000L + " secs elapsed..awaiting again [parallel modules][" + ARConstants.Operation.operationsMap.get(operationType) + " operation] [Version: " + ARManager.getVersion() + "]");
                                if (semaphore.availablePermits() != parallelModules.size()) continue;
                                LOGGER.info("AR-->Parallel modules Completed.Break");
                                break;
                            }
                            if (interval >= maximumExecutionTime) {
                                for (ARModule module : parallelModules.keySet()) {
                                    if (operationType == 1 && ((ARModuleStat)statDetail.get(module)).isInProgress(1)) {
                                        ARManager.updateStatus(module, 101, "Time exceeded more than given time : " + maximumExecutionTime / 1000L + "s");
                                    } else if (operationType == 2 && ((ARModuleStat)statDetail.get(module)).isInProgress(2)) {
                                        ARManager.updateStatus(module, 201, "Time exceeded more than given time :" + maximumExecutionTime / 1000L + "s");
                                    }
                                    LOGGER.info("AR-->Calling abort." + module.getModuleName() + " Time exceeded more than given time :" + maximumExecutionTime / 1000L + "s");
                                }
                                parallelModuleFailed = true;
                            }
                            LOGGER.info("ARDEBUG--> Maximum execution time for parallel prepare = " + maximumExecutionTime + " interval=" + interval + " parallelModuleStatus=" + parallelModuleFailed);
                            if (parallelModuleFailed) {
                                ARManager.setStatus("Failed");
                                arDetails.put("Status", "Failed");
                                LOGGER.info("AR-->Parallel module failed");
                                throw new Exception("Parallel Module Failed.");
                            }
                            ARManager.setStatus("Completed");
                        }
                        finally {
                            ARManager.setOverAllDuration(type);
                            MODULELOCK.unlock();
                        }
                    }
                    ++moduleStage;
                    ARManager.setStatus("Inprogress");
                    this.perform(2, operationType, type);
                    ARManager.setStatus("Completed");
                    ARManager.setOverAllDuration(type);
                    stime = System.currentTimeMillis();
                    ARManager.setARDetails(0.0, (operationType == 1 ? "Warming up" : "Stop the world") + " completed", "Inprogress", type, true);
                }
                this.notifyARStatusToReplacementIP();
            }
            catch (Exception e) {
                ARManager.abortAR("Exception in ARManager " + e.getMessage());
                ARManager.setARDetails(0.0, "Aborted Active Replacement. " + e.getMessage(), "Failed", -1);
                LOGGER.log(Level.SEVERE, "ARERR-->\tError in ARExecutor Thread for Active Replacement. [Version: " + ARManager.getVersion() + "]\n", e);
            }
            executionInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void perform(int executionType, int operationType, int type) throws Exception {
            Map modules = null;
            if (executionType == 1) {
                modules = parallelModules;
            } else if (executionType == 2) {
                modules = sequentialModules;
            }
            Iterator iterator = modules.entrySet().iterator();
            block7: while (iterator.hasNext()) {
                Map.Entry moduleDetail = iterator.next();
                LOGGER.info("AR--> Started  " + ARConstants.Operation.operationsMap.get(operationType) + " for module " + ((ARModule)moduleDetail.getKey()).getModuleName() + " and Execution type : " + ARConstants.getExecutionType(executionType) + ". [Version: " + ARManager.getVersion() + "]");
                ((ARModuleStat)statDetail.get(moduleDetail.getKey())).setOperation(operationType);
                ((ARModuleStat)statDetail.get(moduleDetail.getKey())).setStatus("Inprogress");
                ((ARModuleStat)statDetail.get(moduleDetail.getKey())).setOverAllStatus("Inprogress");
                ((ARModuleStat)statDetail.get(moduleDetail.getKey())).setCurrentStage(moduleStage);
                ((ARModuleStat)statDetail.get(moduleDetail.getKey())).setProgress(null);
                ARManager.setARDetails(0.0, "Started  " + ARConstants.Operation.operationsMap.get(operationType) + " for module " + ((ARModule)moduleDetail.getKey()).getModuleName(), "Inprogress", type);
                try {
                    MODULELOCK.lock();
                    switch (executionType) {
                        case 2: {
                            new ARWorkerThread((ARModule)moduleDetail.getKey(), operationType).start();
                            long interval = 0L;
                            long maximumExecutionTime = ARManager.getMaximumExecutionTime((ARModule)moduleDetail.getKey(), executionType, operationType);
                            LOGGER.info("ARDEBUG-->Maximum execution time for sequential module " + ((ARModule)moduleDetail.getKey()).getModuleName() + " is : " + WMSUtil.HumanReadable.getDuration(maximumExecutionTime, true));
                            while (interval < maximumExecutionTime) {
                                long remainingTime = maximumExecutionTime - interval;
                                long waitingTime = remainingTime > 3000L ? 3000L : remainingTime;
                                boolean isAwaitElapsed = MODULECOMPLETED.await(waitingTime, TimeUnit.MILLISECONDS);
                                ARManager.setOverAllDuration(type);
                                ARManager.getProgressForModules();
                                ARManager.setARDetails(0.0, null, null, type);
                                if (isAwaitElapsed) break;
                                LOGGER.info("AR-->" + (interval += waitingTime) / 1000L + " secs Time Elapsed.awaiting for " + ((ARModule)moduleDetail.getKey()).getModuleName() + " to complete. [Version: " + ARManager.getVersion() + "]");
                                if (((ARModuleStat)statDetail.get(moduleDetail.getKey())).isInProgress(operationType)) continue;
                                LOGGER.info("AR-->" + ((ARModule)moduleDetail.getKey()).getModuleName() + " Completed.Break");
                                break;
                            }
                            if (interval >= maximumExecutionTime) {
                                if (operationType == 1) {
                                    ARManager.updateStatus((ARModule)moduleDetail.getKey(), 101, "Time exceeded more than " + maximumExecutionTime / 1000L + "s");
                                } else if (operationType == 2) {
                                    ARManager.updateStatus((ARModule)moduleDetail.getKey(), 201, "Time exceeded more than " + maximumExecutionTime / 1000L + "s");
                                }
                                LOGGER.info("AR-->Calling abort." + ((ARModule)moduleDetail.getKey()).getModuleName() + " Time exceeded more than given time :" + maximumExecutionTime / 1000L + "s");
                                throw new Exception("Module " + ((ARModule)moduleDetail.getKey()).getModuleName() + " " + ((ARModuleStat)statDetail.get(moduleDetail.getKey())).getOperation() + " time exceeded more than " + maximumExecutionTime / 1000L + "s");
                            }
                            if ((Integer)moduleDetail.getValue() != 101 && (Integer)moduleDetail.getValue() != 201) continue block7;
                            LOGGER.warning("AR-->Module " + ((ARModule)moduleDetail.getKey()).getModuleName() + " failure alert. with statusCode=" + ARConstants.getStatusMessage((Integer)moduleDetail.getValue()) + ". [Version: " + ARManager.getVersion() + "]");
                            throw new Exception("Module " + ((ARModule)moduleDetail.getKey()).getModuleName() + " " + ((ARModuleStat)statDetail.get(moduleDetail.getKey())).getOperation() + " Failed.");
                        }
                        case 1: {
                            semaphore.acquire();
                            new ARWorkerThread((ARModule)moduleDetail.getKey(), operationType).start();
                            continue block7;
                        }
                    }
                    continue;
                }
                finally {
                    ARManager.setOverAllDuration(type);
                    MODULELOCK.unlock();
                    continue;
                }
                break;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyARStatusToReplacementIP() {
            Hashtable<String, String> header = new Hashtable<String, String>();
            header.put("version", ARManager.getVersion());
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("status", String.valueOf(100));
            params.put("operation", ARManager.getOperation());
            stime = System.currentTimeMillis();
            HttpConnection con = new HttpConnection("http://" + ARManager.getARIp() + ":" + ARManager.getGACPort() + "/grid/arstatus", 60000, 30000);
            String failureReason = "";
            try {
                notifyARStatus.acquire();
                String requestMethod = ARManager.getRequestMethod();
                String response = "mpost".equals(requestMethod) ? (String)con.doPost(params, header, null) : (String)con.doPost(params, header);
                ARManager.setOverAllDuration(5);
                ARManager.setARDetails(17.0, "Notified AR Completion to new machine successfully", "Inprogress", 5, true);
                LOGGER.info("AR--> " + response + " " + con.getStatusCode());
                if (con.getStatusCode() == 200) {
                    LOGGER.info("AR-->Time taken to take over new machine " + WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - stime));
                    stime = System.currentTimeMillis();
                    if ("Completed".equals(response)) {
                        isARCompleted = true;
                        ARManager.notifyARComplete();
                        ARManager.setOverAllDuration(6);
                        ARManager.setARDetails(17.0, "Active Replacement Completed Successfully", "Completed", 6, true);
                        LOGGER.info("AR--> Total time taken to send data to Admin server : " + WMSUtil.HumanReadable.getDuration(notifyAdminTime));
                        return;
                    }
                    failureReason = "Message received from New IP : " + response;
                } else {
                    failureReason = "Connection status " + con.getStatusCode();
                }
            }
            catch (Exception e) {
                failureReason = "Error Message : " + e.getMessage();
                LOGGER.log(Level.SEVERE, "Error while notifying AR status to Replacement ip", e);
            }
            finally {
                notifyARStatus.release();
            }
            LOGGER.info("AR-->Time taken to take over new machine " + WMSUtil.HumanReadable.getDuration(System.currentTimeMillis() - stime));
            ARManager.abortAR("Failed to attach New IP");
            ARManager.setOverAllDuration(-1);
            ARManager.setARDetails(0.0, "Error while connecting to new machine." + failureReason, "Failed", 5, true);
        }
    }
}

