/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServingMode {
    private static final Logger LOGGER = Logger.getLogger(ServingMode.class.getName());
    private static final String SERVINGMODE_RW = "RW";
    private static Hashtable<String, Boolean> servingModeMap = new Hashtable();

    public static void addRecords(Hashtable<String, String> clusterWiseServingMode) {
        try {
            for (String cluster : clusterWiseServingMode.keySet()) {
                String servingMode = clusterWiseServingMode.get(cluster);
                if (servingMode.equalsIgnoreCase(SERVINGMODE_RW)) {
                    servingModeMap.put(cluster, true);
                    continue;
                }
                servingModeMap.put(cluster, false);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DK--> Error while addding records for cluster wise serving mode : " + clusterWiseServingMode, e);
        }
    }

    public static boolean isPrimary(String cluster) throws Exception {
        if (servingModeMap.containsKey(cluster)) {
            return servingModeMap.get(cluster);
        }
        throw new Exception("Serving mode for cluster : " + cluster + " is not available.");
    }
}

