/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.grid.ClusterDistributionLogic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class GeoMap
extends ClusterDistributionLogic {
    private static AtomicInteger serversMapIndex = new AtomicInteger(0);
    private static Map<String, AtomicInteger> countryWiseServersMapIndex = new HashMap<String, AtomicInteger>();
    private long version;
    private Map<String, List<String>> countryWiseIPList = new HashMap<String, List<String>>();
    private Map<String, Map<String, List<String>>> regionWiseIPList = new HashMap<String, Map<String, List<String>>>();
    private Map<String, Object> ipMap = new HashMap<String, Object>();
    private HashMap<String, String> ipRegionMap = new HashMap();
    private HashMap<String, String> ipCountryCodeMap = new HashMap();

    public GeoMap(long version, Hashtable geoMapDetails) {
        this.version = version;
        this.init((Map)geoMapDetails.get("ipmap"));
    }

    public void init(Map<String, Map<String, Map<String, Object>>> ipMap) {
        for (String country : ipMap.keySet()) {
            ArrayList<String> ips = new ArrayList<String>();
            HashMap regionWiseIps = new HashMap();
            for (String region : ipMap.get(country).keySet()) {
                ArrayList<String> regionIps = new ArrayList<String>();
                for (String ip : ipMap.get(country).get(region).keySet()) {
                    this.ipMap.put(ip, ipMap.get(country).get(region).get(ip));
                    ips.add(ip);
                    regionIps.add(ip);
                }
                regionWiseIps.put(region, regionIps);
            }
            this.regionWiseIPList.put(country, regionWiseIps);
            this.countryWiseIPList.put(country, ips);
        }
    }

    public boolean isValidIP(String ip) {
        return this.ipMap.containsKey(ip);
    }

    public boolean isValidCountry(String country) {
        return this.countryWiseIPList.containsKey(country.toUpperCase());
    }

    @Override
    public String getServer() {
        ArrayList<String> set = new ArrayList<String>(this.ipMap.keySet());
        int index = serversMapIndex.incrementAndGet();
        if (index >= set.size()) {
            serversMapIndex.set(0);
            index = 0;
        }
        return (String)set.get(index);
    }

    public List<String> getServerList(String countryName) {
        if (this.countryWiseIPList.containsKey(countryName = countryName.toUpperCase())) {
            return Collections.unmodifiableList(this.countryWiseIPList.get(countryName));
        }
        return null;
    }

    public Map getCountryWiseIPMap() {
        return this.countryWiseIPList;
    }

    public Map getRegionWiseIPMap() {
        return this.regionWiseIPList;
    }

    public List<String> getServerList(String countryName, String region) {
        Map<String, List<String>> regionWiseIps;
        if (this.regionWiseIPList.containsKey(countryName = countryName.toUpperCase()) && (regionWiseIps = this.regionWiseIPList.get(countryName)).containsKey(region)) {
            return Collections.unmodifiableList(regionWiseIps.get(region));
        }
        return null;
    }

    @Override
    public String getServer(String country) {
        country = country.toUpperCase();
        List<String> set = this.countryWiseIPList.get(country);
        int index = 0;
        if (countryWiseServersMapIndex.containsKey(country)) {
            index = countryWiseServersMapIndex.get(country).incrementAndGet();
        } else {
            countryWiseServersMapIndex.put(country, new AtomicInteger(0));
        }
        if (index >= set.size()) {
            countryWiseServersMapIndex.get(country).set(0);
            index = 0;
        }
        return set.get(index);
    }

    public String toString() {
        return "version=" + this.version + " ipMap=" + this.ipMap + " countryWiseIPList=" + this.countryWiseIPList;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isSameVersion(GeoMap geoMap) {
        return this.getVersion() == geoMap.getVersion();
    }

    public String getCountryCode(String ip) {
        if (!this.isValidIP(ip)) {
            return null;
        }
        if (this.ipCountryCodeMap.containsKey(ip)) {
            return this.ipCountryCodeMap.get(ip);
        }
        for (String countryCode : this.countryWiseIPList.keySet()) {
            if (!this.countryWiseIPList.get(countryCode).contains(ip)) continue;
            this.ipCountryCodeMap.put(ip, countryCode);
            return countryCode;
        }
        return null;
    }

    public String getRegion(String ip, String countryCode) {
        if (!this.isValidIP(ip)) {
            return null;
        }
        if (this.ipRegionMap.containsKey(ip)) {
            return this.ipRegionMap.get(ip);
        }
        if (!CommonUtil.isEmpty((String)countryCode)) {
            for (String region : this.regionWiseIPList.get(countryCode).keySet()) {
                if (!this.regionWiseIPList.get(countryCode).get(region).contains(ip)) continue;
                this.ipRegionMap.put(ip, region);
                return region;
            }
        }
        return null;
    }

    public Map<String, Map<String, List<String>>> getRegionWiseIPList() {
        return this.regionWiseIPList;
    }
}

