/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.WmsService;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfHandler {
    private static final Logger LOGGER = Logger.getLogger(ConfHandler.class.getName());
    private Map<String, String> confFilePathMap = new HashMap<String, String>();

    public abstract boolean handleConfChange(String var1, Hashtable var2);

    public abstract boolean handleServicesMap(Hashtable<String, WmsService> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean save(String confName, Hashtable<String, String> confMap) {
        if (CommonUtil.isEmpty(confMap)) {
            LOGGER.log(Level.SEVERE, "DK--> Conf Map is empty for conf : " + confName);
            return false;
        }
        if (!this.confFilePathMap.containsKey(confName)) {
            LOGGER.log(Level.SEVERE, "DK--> File Path not found in confFileMap for the conf : " + confName);
            return false;
        }
        FileOutputStream out = null;
        try {
            String filePath = "";
            filePath = !this.confFilePathMap.get(confName).contains("/") ? System.getProperty("server.home") + File.separator + "conf" + File.separator + this.confFilePathMap.get(confName) : System.getProperty("server.home") + File.separator + this.confFilePathMap.get(confName);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)confMap);
            out = new FileOutputStream(filePath);
            properties.store(out, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DK--> Error while writing conf properties", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public void setFilePath(String confName, String filePath) {
        try {
            this.confFilePathMap.put(confName, filePath);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DK--> Error while setting file path for the conf : " + confName + " and FilePath : " + filePath, e);
        }
    }

    protected String getFilePath(String confName) {
        return this.confFilePathMap.get(confName);
    }

    public void removeFilePath(String confName) {
        try {
            this.confFilePathMap.remove(confName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DK--> Error while removing file path for the conf : " + confName, e);
        }
    }
}

