/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.counters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RangeCounter {
    public static final int TYPE_COUNT = 1;
    public static final int TYPE_TIME = 2;
    public static final int TYPE_MEMORY = 3;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long KILOBYTE = 1024L;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long TERABYTE = 0x10000000000L;
    private long rmin;
    private long rmax;
    private long hpRmin;
    private long hpRmax;
    private AtomicLong count;
    private long totalValue;
    private long maxValue;
    private long minValue = Long.MAX_VALUE;
    private boolean hpEnabled = false;
    private ConcurrentHashMap<Long, RangeValue> range = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, RangeValue> hpRange = new ConcurrentHashMap();
    private int dataType = 1;
    private double[] percentageRanges = new double[]{50.0, 75.0, 90.0, 92.5, 95.0, 96.0, 97.0, 98.0, 98.5, 99.0, 99.5, 100.0};

    public RangeCounter(long rmin, long rmax) {
        this.rmin = rmin > 0L ? this.floor(rmin) : 0L;
        this.rmax = rmax > 0L ? this.ceil(rmax) : 0L;
        this.hpRmin = 0L;
        this.hpRmax = rmax;
        this.count = new AtomicLong();
    }

    public RangeCounter(long rmin, long rmax, int dataType, boolean hpEnabled) {
        this.rmin = rmin > 0L ? this.floor(rmin) : 0L;
        this.rmax = rmax > 0L ? this.ceil(rmax) : 0L;
        this.hpRmin = 0L;
        this.hpRmax = rmax;
        this.count = new AtomicLong();
        this.dataType = dataType;
        this.hpEnabled = hpEnabled;
    }

    private RangeCounter(long rmin, long rmax, long count, long maxValue) {
        this.rmin = rmin;
        this.rmax = rmax;
        this.count = new AtomicLong();
        this.count.addAndGet(count);
        this.maxValue = maxValue;
    }

    private RangeCounter(long rmin, long rmax, long count, long maxValue, int dataType) {
        this.rmin = rmin;
        this.rmax = rmax;
        this.count = new AtomicLong();
        this.count.addAndGet(count);
        this.maxValue = maxValue;
        this.dataType = dataType;
    }

    public void reset() {
        this.count = new AtomicLong();
        this.maxValue = 0L;
        this.range = new ConcurrentHashMap();
        this.hpRange = new ConcurrentHashMap();
    }

    public long maxValue() {
        return this.maxValue;
    }

    public long minValue() {
        if (this.minValue == Long.MAX_VALUE) {
            return 0L;
        }
        return this.minValue;
    }

    public long totalValue() {
        return this.totalValue;
    }

    public long count() {
        return this.count.longValue();
    }

    public long add(long value) {
        this.count.incrementAndGet();
        this.totalValue += value;
        this.maxValue = value > this.maxValue ? value : this.maxValue;
        this.minValue = value < this.minValue ? value : this.minValue;
        long spread = this.floor(value);
        spread = spread < this.rmin ? 0L : (spread > this.rmax ? this.rmax : spread);
        RangeValue rv = this.range.get(spread);
        if (rv == null) {
            rv = spread < this.rmin ? new RangeValue(spread, this.rmin, new AtomicLong()) : (spread == this.rmax ? new RangeValue(spread, this.ceil(value), new AtomicLong()) : new RangeValue(spread, this.ceil(spread + 1L), new AtomicLong()));
            this.range.put(spread, rv);
        }
        if (spread == this.rmax && rv.rmax < this.ceil(value)) {
            rv.rmax = this.ceil(value);
        }
        rv.counter.incrementAndGet();
        if (this.hpEnabled) {
            long hpspread = this.floor(value);
            hpspread = hpspread < this.hpRmin ? 0L : (hpspread > this.hpRmax ? this.hpRmax : hpspread);
            RangeValue hpRV = this.hpRange.get(hpspread);
            if (hpRV == null) {
                hpRV = hpspread < this.hpRmin ? new RangeValue(hpspread, this.hpRmin, new AtomicLong()) : (hpspread == this.rmax ? new RangeValue(hpspread, this.ceil_hp(value), new AtomicLong()) : new RangeValue(hpspread, this.ceil_hp(hpspread + 1L), new AtomicLong()));
                this.hpRange.put(hpspread, hpRV);
            }
            if (hpspread == this.hpRmax && hpRV.rmax < this.ceil_hp(value)) {
                hpRV.rmax = this.ceil_hp(value);
            }
            hpRV.counter.incrementAndGet();
        }
        return this.count.longValue();
    }

    public ArrayList getSpread() {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList<RangeValue> spreadList = Collections.list(this.range.elements());
        Collections.sort(spreadList, new Comparator<RangeValue>(){

            @Override
            public int compare(RangeValue o1, RangeValue o2) {
                if (o1 != null && o2 != null) {
                    if (o1.rmin < o2.rmin) {
                        return 1;
                    }
                    if (o1.rmin > o2.rmin) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        for (RangeValue rv : spreadList) {
            list.add(rv.getHash());
        }
        return list;
    }

    public ArrayList getHPSpread() {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList<RangeValue> spreadList = Collections.list(this.hpRange.elements());
        Collections.sort(spreadList, new Comparator<RangeValue>(){

            @Override
            public int compare(RangeValue o1, RangeValue o2) {
                if (o1 != null && o2 != null) {
                    if (o1.rmin < o2.rmin) {
                        return 1;
                    }
                    if (o1.rmin > o2.rmin) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        for (RangeValue rv : spreadList) {
            list.add(rv.getHash());
        }
        return list;
    }

    public LinkedHashMap<Double, Long> getPercentageRange() {
        long reValue = 0L;
        int position = 0;
        double percentage = 0.0;
        long totalCount = this.count.get();
        LinkedHashMap<Double, Long> percentageRange = new LinkedHashMap<Double, Long>();
        ArrayList spreads = this.getHPSpread();
        Collections.reverse(spreads);
        int spreadsSize = spreads.size();
        for (int i = 0; i < spreadsSize; ++i) {
            Hashtable ht = (Hashtable)spreads.get(i);
            reValue = (Long)ht.get("re");
            percentage += (double)((Long)ht.get("count")).longValue() / (double)totalCount * 100.0;
            while (position < this.percentageRanges.length && percentage >= this.percentageRanges[position]) {
                percentageRange.put(this.percentageRanges[position], reValue);
                ++position;
            }
        }
        while (position < this.percentageRanges.length) {
            percentageRange.put(this.percentageRanges[position], reValue);
            ++position;
        }
        return percentageRange;
    }

    public Hashtable getHash() {
        Hashtable<String, Serializable> value = new Hashtable<String, Serializable>();
        value.put("rmin", Long.valueOf(this.rmin));
        value.put("rmax", Long.valueOf(this.rmax));
        value.put("count", Long.valueOf(this.count.longValue()));
        value.put("maxValue", Long.valueOf(this.maxValue));
        value.put("spread", this.getSpread());
        return value;
    }

    public static RangeCounter parse(Hashtable ht) {
        try {
            RangeCounter wrc = new RangeCounter((long)((Long)ht.get("rmin")), (long)((Long)ht.get("rmax")), (Long)ht.get("count"), (Long)ht.get("maxValue"));
            ArrayList spread = (ArrayList)ht.get("spread");
            for (Hashtable r : spread) {
                RangeValue rv = new RangeValue(r);
                wrc.range.put(rv.rmin, rv);
            }
            return wrc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList getSpread(int mx, int bcmin, int bcmax) {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList<RangeValue> groupList = new ArrayList<RangeValue>();
        ArrayList<RangeValue> spreadList = Collections.list(this.range.elements());
        if (spreadList.size() == 0) {
            return list;
        }
        Collections.sort(spreadList, new Comparator<RangeValue>(){

            @Override
            public int compare(RangeValue o1, RangeValue o2) {
                if (o1 != null && o2 != null) {
                    if (o1.rmin < o2.rmin) {
                        return 1;
                    }
                    if (o1.rmin > o2.rmin) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        RangeValue prev = spreadList.get(0);
        groupList.add(prev);
        for (int i = 1; i < spreadList.size(); ++i) {
            RangeValue newVal = spreadList.get(i);
            if (prev.counter.get() > (long)bcmin || prev.counter.get() + newVal.counter.get() > (long)bcmax || (prev.rmin - newVal.rmax) * (long)mx > newVal.rmin) {
                prev = newVal;
                groupList.add(newVal);
                continue;
            }
            prev.counter.addAndGet(newVal.counter.get());
            prev.rmin = newVal.rmin;
        }
        for (RangeValue rv : groupList) {
            list.add(rv.getHash());
        }
        return list;
    }

    public boolean merge(Hashtable ht) {
        try {
            this.rmin = (Long)ht.get("rmin") < this.rmin ? (Long)ht.get("rmin") : this.rmin;
            this.rmax = (Long)ht.get("rmax") > this.rmax ? (Long)ht.get("rmax") : this.rmax;
            this.count.addAndGet((Long)ht.get("count"));
            this.maxValue = (Long)ht.get("maxValue") > this.maxValue ? (Long)ht.get("maxValue") : this.maxValue;
            ArrayList spread = (ArrayList)ht.get("spread");
            for (Hashtable r : spread) {
                RangeValue rv = new RangeValue(r);
                RangeValue base = this.range.get(rv.rmin);
                if (base == null) {
                    base = rv;
                    this.range.put(rv.rmin, rv);
                    continue;
                }
                base.merge(rv);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private long ceil(long value) {
        switch (this.dataType) {
            case 1: {
                return this.ceilCount(value);
            }
            case 2: {
                return this.ceilTime(value);
            }
            case 3: {
                return this.ceilMemory(value);
            }
        }
        return this.ceilCount(value);
    }

    private long floor(long value) {
        switch (this.dataType) {
            case 1: {
                return this.floorCount(value);
            }
            case 2: {
                return this.floorTime(value);
            }
            case 3: {
                return this.floorMemory(value);
            }
        }
        return this.floorCount(value);
    }

    private long ceil_hp(long value) {
        switch (this.dataType) {
            case 1: {
                return this.ceilCount_hp(value);
            }
            case 2: {
                return this.ceilTime_hp(value);
            }
            case 3: {
                return this.ceilMemory_hp(value);
            }
        }
        return this.ceilCount_hp(value);
    }

    private long floor_hp(long value) {
        switch (this.dataType) {
            case 1: {
                return this.floorCount_hp(value);
            }
            case 2: {
                return this.floorTime_hp(value);
            }
            case 3: {
                return this.floorMemory_hp(value);
            }
        }
        return this.floorCount_hp(value);
    }

    private long ceilCount(long value) {
        try {
            return new BigDecimal(value, new MathContext(1, RoundingMode.CEILING)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floorCount(long value) {
        try {
            return new BigDecimal(value, new MathContext(1, RoundingMode.FLOOR)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long ceilCount_hp(long value) {
        try {
            return new BigDecimal(value, new MathContext(2, RoundingMode.CEILING)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floorCount_hp(long value) {
        try {
            return new BigDecimal(value, new MathContext(2, RoundingMode.FLOOR)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long ceilTime(long value) {
        try {
            if (value < 0L) {
                return -1L;
            }
            if (value <= 1000L) {
                return this.ceilCount(value);
            }
            if (value <= 60000L) {
                return (value / 1000L + 1L) * 1000L;
            }
            if (value <= 3600000L) {
                return (value / 60000L + 1L) * 60000L;
            }
            if (value <= 86400000L) {
                return (value / 3600000L + 1L) * 3600000L;
            }
            return (value / 86400000L + 1L) * 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floorTime(long value) {
        try {
            if (value < 0L) {
                return -1L;
            }
            if (value <= 1000L) {
                return this.floorCount(value);
            }
            if (value <= 60000L) {
                return value / 1000L * 1000L;
            }
            if (value <= 3600000L) {
                return value / 60000L * 60000L;
            }
            if (value <= 86400000L) {
                return value / 3600000L * 3600000L;
            }
            return value / 86400000L * 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long ceilTime_hp(long value) {
        try {
            if (value < 0L) {
                return -1L;
            }
            if (value <= 1000L) {
                return value;
            }
            if (value <= 60000L) {
                return (value / 1000L + 1L) * 1000L;
            }
            if (value <= 3600000L) {
                return (value / 60000L + 1L) * 60000L;
            }
            if (value <= 86400000L) {
                return (value / 3600000L + 1L) * 3600000L;
            }
            return (value / 86400000L + 1L) * 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floorTime_hp(long value) {
        try {
            if (value < 0L) {
                return -1L;
            }
            if (value <= 1000L) {
                return value;
            }
            if (value <= 60000L) {
                return value / 1000L * 1000L;
            }
            if (value <= 3600000L) {
                return value / 60000L * 60000L;
            }
            if (value <= 86400000L) {
                return value / 3600000L * 3600000L;
            }
            return value / 86400000L * 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long ceilMemory(long value) {
        try {
            if (value < 1L) {
                return 0L;
            }
            if (value <= 1024L) {
                return 1024L;
            }
            if (value <= 0x100000L) {
                return this.ceilCount(value / 1024L) * 1024L;
            }
            if (value <= 0x40000000L) {
                return this.ceilCount(value / 0x100000L) * 0x100000L;
            }
            if (value <= 0x10000000000L) {
                return this.ceilCount(value / 0x40000000L) * 0x40000000L;
            }
            return (value / 0x10000000000L + 1L) * 0x10000000000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floorMemory(long value) {
        try {
            if (value < 1L) {
                return 0L;
            }
            if (value <= 1024L) {
                return 1L;
            }
            if (value <= 0x100000L) {
                return this.floorCount(value / 1024L) * 1024L;
            }
            if (value <= 0x40000000L) {
                return this.floorCount(value / 0x100000L) * 0x100000L;
            }
            if (value <= 0x10000000000L) {
                return this.floorCount(value / 0x40000000L) * 0x40000000L;
            }
            return value / 0x10000000000L * 0x10000000000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long ceilMemory_hp(long value) {
        try {
            if (value < 1L) {
                return 0L;
            }
            if (value <= 1024L) {
                return 1024L;
            }
            if (value <= 0x100000L) {
                return (value / 1024L + 1L) * 1024L;
            }
            if (value <= 0x40000000L) {
                return (value / 0x100000L + 1L) * 0x100000L;
            }
            if (value <= 0x10000000000L) {
                return (value / 0x40000000L + 1L) * 0x40000000L;
            }
            return (value / 0x10000000000L + 1L) * 0x10000000000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floorMemory_hp(long value) {
        try {
            if (value < 1L) {
                return 0L;
            }
            if (value <= 1024L) {
                return 1L;
            }
            if (value <= 0x100000L) {
                return value / 1024L * 1024L;
            }
            if (value <= 0x40000000L) {
                return value / 0x100000L * 0x100000L;
            }
            if (value <= 0x10000000000L) {
                return value / 0x40000000L * 0x40000000L;
            }
            return value / 0x10000000000L * 0x10000000000L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static class RangeValue {
        public long rmin;
        public long rmax;
        public AtomicLong counter;

        private RangeValue(long rmin, long rmax, AtomicLong counter) {
            this.rmin = rmin;
            this.rmax = rmax;
            this.counter = counter;
        }

        private RangeValue(Hashtable<String, Long> ht) {
            this.rmin = ht.get("rs");
            this.rmax = ht.get("re");
            this.counter = new AtomicLong();
            this.counter.addAndGet(ht.get("count"));
        }

        private Hashtable getHash() {
            Hashtable<String, Long> v = new Hashtable<String, Long>();
            v.put("rs", this.rmin);
            v.put("re", this.rmax);
            v.put("count", this.counter.longValue());
            return v;
        }

        private void merge(RangeValue rv) {
            if (this.rmin == rv.rmin) {
                this.rmax = this.rmax < rv.rmax ? rv.rmax : this.rmax;
                this.counter.addAndGet(rv.counter.longValue());
            }
        }
    }
}

