/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue.ar;

import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketFactory;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RocksDBDTConnection {
    private static final Logger LOGGER = Logger.getLogger(RocksDBDTConnection.class.getName());
    private WebSocket ws;
    private WebSocketHandler wsHandler = null;
    private String sockurl;
    private HashMap<String, String> headers;
    private int batchSize = 100;
    private int receivedCounter;
    private int sentCounter;
    private Queue<Long> sentQueue;
    private long receivedSeqNo = 0L;
    private long totalSentCount = 0L;
    StreamReceiver streamReceiver;
    FutureTask<Boolean> streamReceiveTask;
    private static boolean isInitialised = false;

    public void init(String wnet, WebSocketHandler wsHandler, boolean reInitialize) throws WMSCommunicationException {
        this.init(wnet, null, wsHandler, reInitialize);
    }

    public void init(String wnet, HashMap<String, String> headers, WebSocketHandler wsHandler, boolean reInitialize) throws WMSCommunicationException {
        try {
            if (!isInitialised || reInitialize) {
                if (wnet == null) {
                    throw new Exception("NS--> QOS Connecting url is null. Unable to establish connection.");
                }
                this.wsHandler = wsHandler;
                this.sockurl = "ws://" + wnet + "/grid/rocksdbdt";
                this.ws = WebSocketFactory.createSocket((String)this.sockurl, (boolean)true);
                if (headers != null && !headers.isEmpty()) {
                    this.headers = headers;
                    this.ws.addHeaders(headers);
                }
                this.ws.setHandler(this.wsHandler);
                this.ws.connect();
                isInitialised = true;
            } else {
                LOGGER.info("NS--> QOSClient is already initialised. ");
            }
        }
        catch (Exception e) {
            LOGGER.severe("NS--> Exception while initializing QOSClient. Exception: " + e.getMessage());
            isInitialised = false;
        }
    }

    public void reconnect() throws WMSCommunicationException {
        this.ws = WebSocketFactory.createSocket((String)this.sockurl);
        if (this.headers != null && !this.headers.isEmpty()) {
            this.ws.addHeaders(this.headers);
        }
        this.ws.setHandler(this.wsHandler);
        this.ws.connect();
    }

    public void startBatch(int batchSize) {
        this.sentCounter = 0;
        this.receivedCounter = 0;
        this.receivedSeqNo = -1L;
        this.sentQueue = new LinkedList<Long>();
        this.batchSize = batchSize;
        this.streamReceiver = new StreamReceiver();
        this.streamReceiveTask = new FutureTask(this.streamReceiver);
        new Thread(this.streamReceiveTask).start();
    }

    public boolean awaitBatchCompletion() throws Exception {
        this.streamReceiver.endStreamReceiver();
        this.totalSentCount += (long)this.sentCounter;
        return this.streamReceiveTask.get(30L, TimeUnit.SECONDS);
    }

    public long getLastReceivedSeqNo() {
        return this.receivedSeqNo;
    }

    public long getTotalSentCount() {
        return this.totalSentCount;
    }

    public void onReceive(long receivedSeqNo) {
        ++this.receivedCounter;
        this.receivedSeqNo = receivedSeqNo;
        this.streamReceiver.onReceive();
    }

    public void onClose(int status) {
        this.streamReceiver.onClose(status);
    }

    public boolean write(byte[] data, long sentSeqNo) throws WMSCommunicationException {
        this.ws.writeBinary(data);
        this.sentQueue.add(sentSeqNo);
        return ++this.sentCounter == this.batchSize;
    }

    public void close() {
        this.ws.close();
    }

    class StreamReceiver
    implements Callable {
        private final Object streamLock = new Object();
        private boolean endStreamFlag = false;
        private boolean result = false;

        StreamReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean call() throws Exception {
            Object object = this.streamLock;
            synchronized (object) {
                this.streamLock.wait();
            }
            LOGGER.log(Level.INFO, "SEQ-- Stream receiver result = {0}", this.result);
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onReceive() {
            if (RocksDBDTConnection.this.sentQueue.peek() != null && (Long)RocksDBDTConnection.this.sentQueue.peek() == RocksDBDTConnection.this.receivedSeqNo) {
                RocksDBDTConnection.this.sentQueue.remove();
                this.result = true;
            } else {
                LOGGER.log(Level.WARNING, "SEQ-- sent seq no does not match with received seq no");
                this.result = false;
            }
            if (this.endStreamFlag && RocksDBDTConnection.this.sentCounter == RocksDBDTConnection.this.receivedCounter) {
                LOGGER.log(Level.INFO, "SEQ-- endstream flag, sent counter == received counter");
                this.result = true;
                Object object = this.streamLock;
                synchronized (object) {
                    this.streamLock.notify();
                }
                return;
            }
            if (RocksDBDTConnection.this.batchSize == RocksDBDTConnection.this.receivedCounter) {
                this.result = true;
                Object object = this.streamLock;
                synchronized (object) {
                    this.streamLock.notify();
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onClose(int statusCode) {
            LOGGER.log(Level.WARNING, "SNA-- Stream close status {0}", statusCode);
            if (statusCode != -1) {
                this.result = false;
                Object object = this.streamLock;
                synchronized (object) {
                    this.streamLock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endStreamReceiver() {
            LOGGER.log(Level.INFO, "SEQ-- end Stream receiver");
            this.endStreamFlag = true;
            if (RocksDBDTConnection.this.sentCounter == RocksDBDTConnection.this.receivedCounter) {
                this.result = true;
                Object object = this.streamLock;
                synchronized (object) {
                    this.streamLock.notify();
                }
            }
        }
    }
}

