/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.queue.BQInventory;
import com.adventnet.wms.servercommon.components.queue.CircularList;
import com.adventnet.wms.servercommon.components.queue.QueueListener;
import com.adventnet.wms.servercommon.serialization.WMSSerialization;
import com.adventnet.wms.servercommon.serialization.WMSSerializationFactory;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedQueue {
    private static Logger logger = Logger.getLogger(BufferedQueue.class.getName());
    private CircularList inRingBuffer = null;
    private CircularList outRingBuffer = null;
    private long incounter = 0L;
    private long outcounter = 0L;
    private long previncounter = 0L;
    private long prevoutcounter = 0L;
    private boolean freezeQ = false;
    private boolean isClosed = false;
    private int qSize;
    private final int defaultSize = 500;
    private boolean clearStats = false;
    private int createdfiles = 0;
    private int proccesdfiles = 0;
    private final ReentrantLock inLock = new ReentrantLock();
    private final ReentrantLock outLock = new ReentrantLock();
    private final Condition dataAvailable = this.inLock.newCondition();
    private long st;
    private ErrorMonitor em = null;
    private Serializer serializer = null;
    private AckController ackController = null;
    private DiskController diskController = null;
    private boolean isAckCntlrEnabled = false;
    private String fileName;
    private String filePath;
    private boolean isAREnabled;
    private boolean isInterrupted;
    private QueueListener queueListener;

    public BufferedQueue(String filePath, String fileName, int qSize, boolean isAREnabled) {
        this.qSize = qSize > 0 ? qSize : 500;
        this.serializer = new Serializer();
        this.em = new ErrorMonitor();
        this.diskController = new DiskController(filePath, fileName);
        if (!this.diskController.initialize()) {
            logger.severe("HB_ERR --> DiskController is not initialized. filePath=" + filePath + ", fileName=" + fileName);
            throw new RuntimeException("Unable to initialize the DiskController");
        }
        this.inRingBuffer = new CircularList(qSize);
        this.outRingBuffer = this.diskController.loadMemFile();
        if (this.outRingBuffer == null) {
            this.outRingBuffer = new CircularList(qSize);
        }
        this.isAREnabled = isAREnabled;
        this.isInterrupted = false;
        this.fileName = fileName;
        this.filePath = filePath;
        BQInventory.register(this);
        this.st = System.currentTimeMillis();
    }

    public BufferedQueue(String strDir, String fileName, int qSize, boolean isAREnabled, QueueListener queueListener) {
        this.qSize = qSize > 0 ? qSize : 500;
        this.serializer = new Serializer();
        this.em = new ErrorMonitor();
        this.diskController = new DiskController(strDir, fileName);
        if (!this.diskController.initialize()) {
            logger.severe("HB_ERR --> DiskController is not initialized. filePath=" + strDir + ", fileName=" + fileName);
            throw new RuntimeException("Unable to initialize the DiskController");
        }
        this.inRingBuffer = new CircularList(qSize);
        this.outRingBuffer = this.diskController.loadMemFile();
        if (this.outRingBuffer == null) {
            this.outRingBuffer = new CircularList(qSize);
        }
        this.isAREnabled = isAREnabled;
        this.isInterrupted = false;
        this.fileName = fileName;
        this.filePath = strDir;
        this.queueListener = queueListener;
        BQInventory.register(this);
        this.st = System.currentTimeMillis();
    }

    public BufferedQueue(String strDir, String fileName, int qSize, int ackQueueSize, boolean isAREnabled) {
        this.qSize = qSize > 0 ? qSize : 500;
        this.serializer = new Serializer();
        this.em = new ErrorMonitor();
        this.diskController = new DiskController(strDir, fileName);
        if (!this.diskController.initialize()) {
            logger.severe("HB_ERR --> DiskController is not initialized.  filePath=" + strDir + ", fileName=" + fileName);
            throw new RuntimeException("Unable to initialize the DiskController");
        }
        this.inRingBuffer = new CircularList(qSize);
        this.outRingBuffer = this.diskController.loadMemFile();
        if (this.outRingBuffer == null) {
            this.outRingBuffer = new CircularList(qSize);
        }
        this.ackController = new AckController(ackQueueSize);
        this.isAckCntlrEnabled = true;
        this.isAREnabled = isAREnabled;
        this.fileName = fileName;
        this.filePath = strDir;
        BQInventory.register(this);
        this.isAREnabled = isAREnabled;
        this.isInterrupted = false;
        this.fileName = fileName;
        this.filePath = strDir;
        BQInventory.register(this);
        this.st = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object obj) {
        if (this.freezeQ) {
            return false;
        }
        this.inLock.lock();
        try {
            if (this.inRingBuffer.isFull()) {
                int tryCount;
                File file = this.diskController.getNextWriteFile();
                for (tryCount = 0; !this.diskController.saveToFile(this.inRingBuffer, file) && tryCount < 3; ++tryCount) {
                    this.em.tryWriteCount++;
                }
                if (tryCount >= 3) {
                    logger.severe("BQERR--> Failure while saving CL. Dropping CircularList for fileName=" + this.fileName + " filePath=" + this.filePath);
                    StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.FILE_DROPPED_FAILED_TO_SAVE.getErrorCode(), 1L);
                }
                this.inRingBuffer = new CircularList(this.qSize);
            }
            ++this.incounter;
            this.inRingBuffer.put(obj);
            if (this.queueListener != null) {
                this.queueListener.onAdd();
            }
            this.dataAvailable.signal();
        }
        finally {
            this.inLock.unlock();
        }
        return true;
    }

    public Object peek(long time) {
        if (this.freezeQ) {
            return null;
        }
        this.waitTillDataAvailable(time);
        return this.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        if (this.freezeQ) {
            return null;
        }
        this.outLock.lock();
        try {
            Object obj = null;
            if (this.isInterrupted) {
                Object object = obj;
                return object;
            }
            if (this.outRingBuffer.isEmpty()) {
                CircularList tempOutRingBuffer = null;
                if (this.diskController.hasFilesInDisk()) {
                    tempOutRingBuffer = this.diskController.loadFromFile();
                    while ((tempOutRingBuffer == null || tempOutRingBuffer.isEmpty()) && this.diskController.hasFilesInDisk()) {
                        this.em.skipReadFile++;
                        tempOutRingBuffer = this.diskController.loadFromFile();
                    }
                }
                if (tempOutRingBuffer != null) {
                    this.outRingBuffer = tempOutRingBuffer;
                }
            }
            if (!this.outRingBuffer.isEmpty()) {
                obj = this.outRingBuffer.peek();
            } else {
                this.inLock.lock();
                try {
                    if (this.diskController.hasFilesInDisk()) {
                        this.em.ringModifiedOnWait++;
                        obj = null;
                    } else {
                        obj = this.inRingBuffer.peek();
                    }
                }
                finally {
                    this.inLock.unlock();
                }
            }
            if (obj != null) {
                ++this.outcounter;
                if (this.queueListener != null) {
                    this.queueListener.onRemove();
                }
            }
            Object object = obj;
            return object;
        }
        finally {
            this.isInterrupted = false;
            this.outLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        if (this.freezeQ) {
            return null;
        }
        this.outLock.lock();
        try {
            Object obj = null;
            if (this.isInterrupted) {
                Object object = obj;
                return object;
            }
            if (this.outRingBuffer.isEmpty()) {
                CircularList tempOutRingBuffer = null;
                if (this.diskController.hasFilesInDisk()) {
                    tempOutRingBuffer = this.diskController.loadFromFile();
                    while ((tempOutRingBuffer == null || tempOutRingBuffer.isEmpty()) && this.diskController.hasFilesInDisk()) {
                        this.em.skipReadFile++;
                        tempOutRingBuffer = this.diskController.loadFromFile();
                    }
                }
                if (tempOutRingBuffer != null) {
                    this.outRingBuffer = tempOutRingBuffer;
                }
            }
            if (!this.outRingBuffer.isEmpty()) {
                obj = this.outRingBuffer.take();
            } else {
                this.inLock.lock();
                try {
                    if (this.diskController.hasFilesInDisk()) {
                        this.em.ringModifiedOnWait++;
                        obj = null;
                    } else {
                        obj = this.inRingBuffer.take();
                    }
                }
                finally {
                    this.inLock.unlock();
                }
            }
            ++this.outcounter;
            if (this.queueListener != null && obj != null) {
                this.queueListener.onRemove();
            }
            Object object = obj;
            return object;
        }
        finally {
            this.isInterrupted = false;
            this.outLock.unlock();
        }
    }

    public boolean interruptIfEmpty() {
        this.inLock.lock();
        try {
            if (this.isEmpty()) {
                this.isInterrupted = true;
                this.dataAvailable.signal();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR--> Exception while interruptIfEmpty", e);
            StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.INTERRUPT_IF_EMPTY.getErrorCode(), 1L);
        }
        finally {
            this.inLock.unlock();
        }
        return true;
    }

    public Object get(int retryCount) {
        if (retryCount > 1000) {
            retryCount = 1000;
        }
        Object obj = null;
        while (obj == null && retryCount > 0 && this.size() > 0) {
            obj = this.get();
            --retryCount;
        }
        return obj;
    }

    public Object poll() {
        return this.poll(-1L);
    }

    public Object poll(long time) {
        if (this.freezeQ) {
            return null;
        }
        this.waitTillDataAvailable(time);
        return this.get();
    }

    public Object poll(long time, long seqId) {
        if (this.freezeQ) {
            return null;
        }
        this.waitTillDataAvailable(time);
        return this.get(seqId);
    }

    public Object poll(String category, long seqId) {
        return this.poll(-1L, category, seqId);
    }

    public Object poll(long time, String category, long seqId) {
        if (this.freezeQ) {
            return null;
        }
        this.waitTillDataAvailable(time);
        return this.get(category, seqId);
    }

    public Object get(long seqId) {
        return this.ackController.get(seqId);
    }

    public Object get(String sid, long seqId) {
        return this.ackController.get(sid, seqId);
    }

    public void handleAck(String category, long seqId) {
        this.ackController.handleAck(category, seqId);
    }

    public void handleAck(long seqId) {
        this.ackController.handleAck(seqId);
    }

    public synchronized Object getUnAckData(String category, long seqId) {
        return this.ackController.getUnAckData(category, seqId);
    }

    public synchronized ArrayList getUnAckQueue(String category) {
        return this.ackController.getUnAckQueue(category);
    }

    public synchronized ArrayList getUnAckQueue() {
        return this.ackController.getUnAckQueue("default_sid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillDataAvailable(long time) {
        try {
            this.inLock.lock();
            if (this.isEmpty()) {
                if (time == -1L) {
                    this.dataAvailable.await();
                } else {
                    this.dataAvailable.await(time, TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.LOCK_DATA_AVAILABLE.getErrorCode(), 1L);
        }
        finally {
            this.inLock.unlock();
        }
    }

    public HashMap<String, LinkedHashMap<Long, Object>> getCategoryMap() {
        return this.ackController.getCategoryMap();
    }

    public void setCategoryMap(HashMap<String, LinkedHashMap<Long, Object>> categoryMap) {
        this.ackController.setCategoryMap(categoryMap);
    }

    public synchronized void open() {
        this.freezeQ = false;
        this.isClosed = false;
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.freezeQ = true;
        if (!this.inRingBuffer.isEmpty()) {
            File file = this.diskController.getNextWriteFile();
            this.diskController.saveToFile(this.inRingBuffer, file);
        }
        if (!this.outRingBuffer.isEmpty()) {
            this.diskController.saveMemFile(this.outRingBuffer);
        }
        this.inRingBuffer.removeAllElements();
        this.outRingBuffer.removeAllElements();
        if (this.isAckCntlrEnabled) {
            HashMap<String, LinkedHashMap<Long, Object>> categoryMap = this.ackController.getCategoryMap();
            Iterator<String> iterator = categoryMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (categoryMap.get(key).size() != 0) continue;
                iterator.remove();
            }
            if (categoryMap.size() > 0) {
                this.ackController.close();
            }
        }
        this.isClosed = true;
    }

    public boolean isAREnabled() {
        return this.isAREnabled;
    }

    public boolean isEmpty() {
        if (this.freezeQ) {
            return true;
        }
        return this.inRingBuffer.isEmpty() && this.outRingBuffer.isEmpty() && !this.diskController.hasFilesInDisk();
    }

    public int size() {
        if (this.freezeQ) {
            return 0;
        }
        return this.inRingBuffer.size() + this.outRingBuffer.size() + this.diskController.getFilesCount() * this.qSize;
    }

    public int qSize() {
        return this.qSize;
    }

    public void swapQueues(BufferedQueue bq1, BufferedQueue bq2) {
        while (!bq1.isEmpty()) {
            bq2.add(bq1.get());
        }
        if (bq1.getCategoryMap() != null) {
            bq2.setCategoryMap(bq1.getCategoryMap());
        }
    }

    public Hashtable<String, String> getStats() {
        Hashtable<String, String> stats = new Hashtable<String, String>();
        stats.put("in", String.valueOf(this.incounter));
        stats.put("out", String.valueOf(this.outcounter));
        stats.put("bqname", this.diskController.getFileName());
        int cursize = this.size();
        stats.put("size", String.valueOf(cursize));
        stats.put("bqdir", this.diskController.getFileDir());
        stats.put("proccesdfiles", String.valueOf(this.diskController.getFileStartCount()));
        stats.put("createdfiles", String.valueOf(this.diskController.getFileEndCount()));
        stats.put("pendingfiles", String.valueOf(this.diskController.getFilesCount()));
        stats.put("alivetime", (System.currentTimeMillis() - this.st) / 60000L + "min");
        stats.put("overflow", String.valueOf(cursize > this.qSize));
        stats.put("isclosed", String.valueOf(this.isClosed));
        stats.put("savetofiletime", String.valueOf(this.serializer.savetofiletime));
        stats.put("loadfromfiletime", String.valueOf(this.serializer.loadfromfiletime));
        return stats;
    }

    public Hashtable<String, String> getWmsQStats() {
        Hashtable<String, String> stats = new Hashtable<String, String>();
        stats.put("in", "" + Math.abs(this.incounter - this.previncounter));
        stats.put("out", "" + Math.abs(this.outcounter - this.prevoutcounter));
        stats.put("bqname", this.diskController.getFileName());
        int cursize = this.size();
        stats.put("size", "" + cursize);
        stats.put("overflow", "" + (cursize > this.qSize));
        stats.put("createdfiles", "" + this.createdfiles);
        stats.put("proccesdfiles", "" + this.proccesdfiles);
        stats.put("remainingfiles", "" + this.diskController.getFilesCount());
        stats.put("savetofiletime", "" + this.serializer.savetofiletime);
        stats.put("loadfromfiletime", "" + this.serializer.loadfromfiletime);
        if (this.clearStats) {
            this.incounter = 0L;
            this.outcounter = 0L;
            this.clearStats = false;
        }
        this.createdfiles = 0;
        this.proccesdfiles = 0;
        this.serializer.savetofiletime = 0L;
        this.serializer.loadfromfiletime = 0L;
        this.previncounter = this.incounter;
        this.prevoutcounter = this.outcounter;
        return stats;
    }

    public Hashtable<String, String> getStat() {
        Hashtable<String, String> stats = new Hashtable<String, String>();
        stats.put("PUTS", " " + this.incounter);
        stats.put("GETS", " " + this.outcounter);
        stats.put("PendingFiles", " " + this.diskController.getFilesCount());
        stats.put("Files Created", " " + this.diskController.getFileEndCount());
        stats.put("Files Processed", " " + this.diskController.getFileStartCount());
        int cursize = this.size();
        stats.put("Current Size", "" + cursize);
        stats.put("Overflow", "" + (cursize > this.qSize));
        stats.put("Duration", (System.currentTimeMillis() - this.st) / 60000L + "min");
        return stats;
    }

    public Hashtable<String, String> getAckStat() {
        Hashtable<String, String> stats = new Hashtable<String, String>();
        stats.put("AckQueueCapacity", " " + this.ackController.ackQueueSize);
        stats.put("AckQueueFilledCount ", " " + this.ackController.categoryMap.size());
        return stats;
    }

    public Hashtable<String, String> getErrorStat() {
        return this.em.getErrorStats();
    }

    public void clearStats() {
        this.clearStats = true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> bqDetails = new LinkedHashMap<String, Object>();
        bqDetails.put("Size", this.size());
        bqDetails.put("Queue Limit", this.qSize);
        bqDetails.put("In", "" + this.incounter);
        bqDetails.put("Out", "" + this.outcounter);
        bqDetails.put("File Name", this.getFileName());
        bqDetails.put("File Path", this.getFilePath());
        bqDetails.put("Processed Files", this.diskController.getFileStartCount());
        bqDetails.put("Created Files", this.diskController.getFileEndCount());
        bqDetails.put("Pending Files", this.diskController.getFilesCount());
        bqDetails.put("Alive Time", (System.currentTimeMillis() - this.st) / 60000L + "min");
        bqDetails.put("Backlog", this.isOverFlowed());
        ArrayList bqDetailsOrder = new ArrayList(bqDetails.keySet());
        bqDetails.put("_order", bqDetailsOrder);
        return bqDetails;
    }

    public boolean isOverFlowed() {
        return this.size() > this.qSize;
    }

    public synchronized boolean drop(int count) {
        boolean dropStatus = false;
        int deleteFilesCount = count / this.qSize;
        int dropElementCount = count % this.qSize;
        if (count > 0) {
            if (count > this.size()) {
                return this.dropAll();
            }
            logger.info("HB--> deleteFilesCount=" + deleteFilesCount + " dropElementCount=" + dropElementCount);
            if (this.dropFiles(deleteFilesCount)) {
                this.dropElements(dropElementCount);
                dropStatus = true;
            }
        } else {
            logger.info("HB--> Invalid drop count. size=" + this.size() + " count=" + count);
        }
        return dropStatus;
    }

    public synchronized void dropElements(int count) {
        for (int i = 0; i < count; ++i) {
            this.get();
        }
        logger.info("HB--> Successfully dropped " + count + " elements");
    }

    public synchronized boolean dropFiles() {
        return this.dropFiles(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean dropFiles(int count) {
        this.inLock.lock();
        this.outLock.lock();
        try {
            int totalFilesCount = 0;
            totalFilesCount = count > 0 ? count : this.diskController.getFilesCount();
            for (int i = 0; i < totalFilesCount; ++i) {
                File file = this.diskController.getNextReadFile();
                try {
                    this.serializer.deleteFile(file);
                    continue;
                }
                catch (Exception e) {
                    logger.info("Error while dropping the file. file=" + file.getAbsolutePath());
                    boolean bl = false;
                    this.outLock.unlock();
                    this.inLock.unlock();
                    return bl;
                }
            }
            logger.info("HB--> Successfully dropped " + totalFilesCount + " files");
        }
        finally {
            this.outLock.unlock();
            this.inLock.unlock();
        }
        return true;
    }

    public synchronized boolean dropAll() {
        if (this.dropFiles()) {
            this.dropElements(2 * this.qSize);
            return true;
        }
        return false;
    }

    class ErrorMonitor {
        private long waitingToWriteFileTime;
        private int waitingToWriteFile;
        private int ringModifiedOnWait;
        private int skipReadFile;
        private int tryWriteCount;

        ErrorMonitor() {
        }

        public Hashtable<String, String> getErrorStats() {
            Hashtable<String, String> stats = new Hashtable<String, String>();
            stats.put("TryWriteCount", "" + this.tryWriteCount);
            stats.put("SkipReadFile", "" + this.skipReadFile);
            stats.put("RingModifiedOnWait", "" + this.ringModifiedOnWait);
            stats.put("WaitingToWriteFile", "" + this.waitingToWriteFile);
            stats.put("WaitingToWriteFileTime", "" + this.waitingToWriteFileTime);
            return stats;
        }
    }

    class AckController {
        private HashMap<String, LinkedHashMap<Long, Object>> categoryMap = null;
        private Hashtable<String, Object> lockMap = null;
        private int ackQueueSize = 5;
        private static final String DEFAULT_CATEGORY = "default_sid";

        public AckController(int ackQueueSize) {
            File file = new File(BufferedQueue.this.diskController.directory, "Ackmap.dmp");
            this.ackQueueSize = ackQueueSize;
            this.categoryMap = file.exists() ? (HashMap)BufferedQueue.this.serializer.loadFromFile(file) : new HashMap();
            this.lockMap = new Hashtable();
        }

        public Object get(long seqId) {
            return this.get((Long)seqId);
        }

        public Object get(Long seqId) {
            return this.get(DEFAULT_CATEGORY, seqId);
        }

        public Object get(String category, long seqId) {
            return this.get(category, (Long)seqId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(String category, Long seqId) {
            Object obj = null;
            if (!BufferedQueue.this.isEmpty()) {
                if (this.categoryMap.get(category) == null) {
                    this.categoryMap.put(category, new LinkedHashMap());
                }
                if (this.categoryMap.get(category).size() == this.ackQueueSize) {
                    logger.fine("AckMap is FULL. category=" + category + ", seqId=" + seqId);
                    obj = null;
                } else {
                    if (this.lockMap.get(category) == null) {
                        this.lockMap.put(category, new Object());
                    }
                    Object object = this.lockMap.get(category);
                    synchronized (object) {
                        obj = BufferedQueue.this.get();
                        if (this.categoryMap.get(category).get(seqId) == null) {
                            this.categoryMap.get(category).put(seqId, obj);
                        } else {
                            logger.info("given seqId already found. category=" + category + ", seqId=" + seqId);
                        }
                    }
                }
            }
            return obj;
        }

        public void handleAck(long seqId) {
            this.handleAck((Long)seqId);
        }

        public void handleAck(Long seqId) {
            this.handleAck(DEFAULT_CATEGORY, seqId);
        }

        public void handleAck(String category, long seqId) {
            this.handleAck(category, (Long)seqId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAck(String category, Long seqId) {
            block8: {
                try {
                    if (this.categoryMap.get(category) != null) {
                        LinkedHashMap<Long, Object> ackMap = this.categoryMap.get(category);
                        if (ackMap.size() > 0) {
                            Object obj = null;
                            Object object = this.lockMap.get(category);
                            synchronized (object) {
                                obj = ackMap.remove(seqId);
                            }
                            if (obj == null) {
                                logger.fine("ackMap doesn't have the seqId, category=" + category + ", seqId=" + seqId);
                            }
                            break block8;
                        }
                        logger.fine("AckMap is empty. category=" + category + ", seqId=" + seqId);
                        break block8;
                    }
                    logger.fine("categoryMap doesn't have the categoryId as key, category=" + category + ", seqId=" + seqId);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to handle the ack, category=" + category + ", seqId=" + seqId, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getUnAckData(String category, long seqId) {
            Object obj;
            block8: {
                obj = null;
                try {
                    if (this.categoryMap.get(category) != null) {
                        LinkedHashMap<Long, Object> ackMap = this.categoryMap.get(category);
                        if (ackMap.size() > 0) {
                            Object object = this.lockMap.get(category);
                            synchronized (object) {
                                obj = ackMap.get(seqId);
                            }
                            if (obj == null) {
                                logger.fine("[getUnAckData] ackMap doesn't have the seqId, category=" + category + ", seqId=" + seqId);
                            }
                            break block8;
                        }
                        logger.fine("[getUnAckData] AckMap is empty. category=" + category + " ,seqId" + seqId);
                        break block8;
                    }
                    logger.fine("[getUnAckData] categoryMap doesn't have the categoryId as key, categoryId=" + category + ", seqId" + seqId);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to get unAckData, category=" + category + ", seqId=" + seqId, e);
                }
            }
            return obj;
        }

        public synchronized ArrayList getUnAckQueue(String category) {
            ArrayList<Object> objs = new ArrayList<Object>();
            try {
                LinkedHashMap<Long, Object> currAckMap = null;
                if (this.categoryMap.get(category) == null) {
                    logger.info("HB_ERR --> categoryMap doesn't have the categoryID, categoryId=" + category);
                    return objs;
                }
                currAckMap = this.categoryMap.get(category);
                for (Map.Entry<Long, Object> entry : currAckMap.entrySet()) {
                    objs.add(entry.getValue());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to get unAckQueue, categoryId=" + category, e);
            }
            return objs;
        }

        public HashMap<String, LinkedHashMap<Long, Object>> getCategoryMap() {
            return this.categoryMap;
        }

        public void setCategoryMap(HashMap<String, LinkedHashMap<Long, Object>> categoryMap) {
            this.categoryMap = categoryMap;
        }

        public void close() {
            File file = new File(BufferedQueue.this.diskController.directory, "Ackmap.dmp");
            BufferedQueue.this.serializer.saveToFile(this.categoryMap, file);
        }
    }

    class Serializer {
        private long savetofiletime = 0L;
        private long loadfromfiletime = 0L;

        Serializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveToFile(Object persistL, File file) throws RuntimeException {
            WMSSerialization oos = null;
            long stime = System.currentTimeMillis();
            try {
                oos = WMSSerializationFactory.getInstance(2);
                oos.openStream(file.toString());
                oos.writeObject(persistL);
                BufferedQueue.this.createdfiles++;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to write the CircularList to filePath=" + file.getAbsolutePath(), e);
                StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.FST_WRITE.getErrorCode(), 1L);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (oos != null) {
                        oos.closeStream();
                        oos = null;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the file stream(write) filePath=" + file.getAbsolutePath(), ex);
                    StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.FST_CLOSE_ON_WRITE.getErrorCode(), 1L);
                }
                this.savetofiletime += System.currentTimeMillis() - stime;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object loadFromFile(File file) {
            WMSSerialization ois = null;
            Object data = null;
            long stime = System.currentTimeMillis();
            try {
                ois = WMSSerializationFactory.getInstance(1);
                ois.openStream(file.toString());
                data = ois.readObject();
                BufferedQueue.this.proccesdfiles++;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to load the file from disk, filePath=" + file.getAbsolutePath(), e);
                StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.FST_READ.getErrorCode(), 1L);
            }
            finally {
                try {
                    if (ois != null) {
                        ois.closeStream();
                        ois = null;
                    }
                    this.deleteFile(file);
                }
                catch (Exception ee) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the file stream(read) filePath=" + file.getAbsolutePath(), ee);
                    StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.FST_CLOSE_ON_READ.getErrorCode(), 1L);
                }
            }
            this.loadfromfiletime += System.currentTimeMillis() - stime;
            return data;
        }

        private void deleteFile(File file) {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    class DiskController {
        private int currentFileNo;
        private STATUS writeStatus;
        private File directory;
        private String fileName;
        private String strDir;
        private int dataFilesStartCount = 0;
        private int dataFilesEndCount = 0;
        private final ReentrantLock fileCounterLock = new ReentrantLock();

        public DiskController(String strDir, String fileName) {
            this.strDir = strDir;
            this.fileName = fileName;
        }

        public boolean initialize() {
            try {
                this.directory = new File(this.strDir + File.separator);
                if (!this.directory.isDirectory()) {
                    this.directory.mkdirs();
                }
                if (!this.directory.exists()) {
                    throw new IllegalArgumentException(this.strDir + " temp directory does not exist");
                }
                this.resetFileCounts();
                this.currentFileNo = this.dataFilesEndCount;
                this.writeStatus = STATUS.COMPLETED;
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to initialize the DiskController filePath=" + this.strDir + ", fileName=" + this.fileName, e);
                StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.DISKCONTROLLER_INIT_FAILED.getErrorCode(), 1L);
                return false;
            }
        }

        public boolean saveToFile(CircularList persistL, File file) {
            boolean status;
            block4: {
                status = false;
                try {
                    status = BufferedQueue.this.serializer.saveToFile(persistL, file);
                }
                catch (RuntimeException re) {
                    if (!re.getMessage().contains("does not implement Serializable or externalizable")) break block4;
                    int unSerializableElements = persistL.removeAllUnSerializableElements();
                    logger.severe(" Number of UnSerializableElements in queue =" + this.fileName + " in filePath=" + BufferedQueue.this.filePath + " is " + unSerializableElements);
                    try {
                        status = BufferedQueue.this.serializer.saveToFile(persistL, file);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "BQERR--> Error while re-writing the CircularList ", e);
                        StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.SAVE_TO_FILE_FAIELD.getErrorCode(), 1L);
                    }
                }
            }
            this.writeStatus = STATUS.COMPLETED;
            return status;
        }

        public CircularList loadFromFile() {
            File file = this.getNextReadFile();
            if (file.exists()) {
                return (CircularList)BufferedQueue.this.serializer.loadFromFile(file);
            }
            return null;
        }

        public File getNextWriteFile() {
            File file = null;
            try {
                this.fileCounterLock.lock();
                file = new File(this.directory, this.fileName + "-" + this.dataFilesEndCount + ".dmp");
                this.currentFileNo = this.dataFilesEndCount++;
                this.writeStatus = STATUS.ALOCATED;
            }
            finally {
                this.fileCounterLock.unlock();
            }
            return file;
        }

        private File getNextReadFile() {
            File file = null;
            try {
                this.fileCounterLock.lock();
                file = new File(this.directory, this.fileName + "-" + this.dataFilesStartCount + ".dmp");
                ++this.dataFilesStartCount;
            }
            finally {
                this.fileCounterLock.unlock();
            }
            long st = System.currentTimeMillis();
            boolean waitingToWriteFile = false;
            while (this.currentFileNo == this.dataFilesStartCount - 1 && this.writeStatus != STATUS.COMPLETED) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINE, "HB_ERR --> InterruptedException while getting the next read file, file=" + file.getAbsolutePath(), e);
                    StatsDB.recordError(ComponentConstants.BufferedQueue.getModuleCode(), ComponentConstants.BufferedQueue.INTERRUPTED_ON_LAST_FILE.getErrorCode(), 1L);
                }
                waitingToWriteFile = true;
            }
            if (waitingToWriteFile) {
                BufferedQueue.this.em.waitingToWriteFile++;
                BufferedQueue.this.em.waitingToWriteFileTime = BufferedQueue.this.em.waitingToWriteFileTime + (System.currentTimeMillis() - st);
            }
            return file;
        }

        private void resetFileCounts() {
            File[] fileList;
            int min = -1;
            int max = -1;
            for (File file : fileList = this.directory.listFiles()) {
                String currFile = file.getName();
                if (!currFile.startsWith(this.fileName + "-")) continue;
                String baseName = currFile.substring(this.fileName.length() + 1, currFile.length() - 4);
                int currVal = Integer.parseInt(baseName);
                if (currVal <= min || min == -1) {
                    min = currVal;
                }
                if (currVal < max && max != -1) continue;
                max = currVal + 1;
            }
            if (min != -1) {
                this.dataFilesStartCount = min;
            }
            if (max != -1) {
                this.dataFilesEndCount = max;
            }
        }

        public CircularList loadMemFile() {
            File file = new File(this.directory, this.fileName + ".mem");
            if (file.exists()) {
                return (CircularList)BufferedQueue.this.serializer.loadFromFile(file);
            }
            return null;
        }

        public boolean saveMemFile(CircularList persistL) {
            return BufferedQueue.this.serializer.saveToFile(persistL, new File(this.directory, this.fileName + ".mem"));
        }

        public int getFilesCount() {
            return this.dataFilesEndCount - this.dataFilesStartCount;
        }

        public boolean hasFilesInDisk() {
            return this.dataFilesEndCount > this.dataFilesStartCount;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileDir() {
            return this.strDir;
        }

        public int getCurrentFileNo() {
            return this.currentFileNo;
        }

        public STATUS getWriteStatus() {
            return this.writeStatus;
        }

        public int getFileStartCount() {
            return this.dataFilesStartCount;
        }

        public int getFileEndCount() {
            return this.dataFilesEndCount;
        }
    }

    private static enum STATUS {
        ALOCATED,
        COMPLETED;

    }
}

