/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.util;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.security.CryptoAlgorithm;
import com.adventnet.wms.servercommon.components.security.WMSSecurityUtil;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPSecurityUtil {
    private static final Logger LOGGER = Logger.getLogger(WCPSecurityUtil.class.getName());

    public static String getAccessToken(String remoteServerType) throws Exception {
        try {
            String data = WCPConfManager.getServerIp() + "@" + DC.getServertype() + "@" + remoteServerType + "@" + System.currentTimeMillis();
            return WMSSecurityUtil.encrypt(CryptoAlgorithm.ALGORITHM.AES, "server2server", remoteServerType, DC.getServertype(), data);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while getAccessToken. remoteServerType=" + remoteServerType, e);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_GET_ACCESS_TOKEN.getErrorCode(), 1L);
            WCPStats.addErrorStats("EXCEPTION_IN_GET_ACCESS_TOKEN", "[remoteServerType : " + remoteServerType + "]");
            return null;
        }
    }

    public static int verifyServerAccessToken(String accessToken, String remoteServerType, String remoteIp) {
        try {
            String data = WMSSecurityUtil.decrypt(CryptoAlgorithm.ALGORITHM.AES, "server2server", DC.getServertype(), remoteServerType, accessToken);
            String[] dataList = data.split("@");
            String ip = dataList[0];
            String rst = dataList[1];
            String st = dataList[2];
            long time = Long.parseLong(dataList[3]);
            if (!ip.equals(remoteIp)) {
                LOGGER.log(Level.SEVERE, "WCPERR--> verifyServerAccessToken - remoteIp mismatch. remoteIp=" + remoteIp + " ip=" + ip + " remoteServerType=" + remoteServerType);
                return 1;
            }
            if (!rst.equals(remoteServerType)) {
                LOGGER.log(Level.SEVERE, "WCPERR--> verifyServerAccessToken - remoteServerType mismatch. remoteServerType=" + remoteServerType + " rst=" + rst + " remoteIp=" + remoteIp);
                return 1;
            }
            if (!st.equals(DC.getServertype())) {
                LOGGER.log(Level.SEVERE, "WCPERR--> verifyServerAccessToken - serverType mismatch. serverType=" + DC.getServertype() + " st=" + st + " remoteServerType=" + remoteServerType + " remoteIp=" + remoteIp);
                return 1;
            }
            if (System.currentTimeMillis() - time > WCPConfManager.getAccessTokenExpireTime()) {
                LOGGER.log(Level.SEVERE, "WCPERR--> verifyServerAccessToken - accessToken time expired. time=" + (System.currentTimeMillis() - time) + "ms");
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while verifyServerAccessToken. accessToken=" + accessToken + " remoteServerType=" + remoteServerType + " remoteIp=" + remoteIp, e);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_VERIFY_ACCESS_TOKEN.getErrorCode(), 1L);
            WCPStats.addErrorStats("EXCEPTION_IN_VERIFY_ACCESS_TOKEN", "[accessToken : " + accessToken + "][remoteServerType : " + remoteServerType + "][remoteIp : " + remoteIp + "]");
            return -1;
        }
    }

    public static int verifyAPIAccessToken(String accessToken, String apiName, String prd, String remoteIp) {
        try {
            String data = WMSSecurityUtil.decrypt(CryptoAlgorithm.ALGORITHM.AES, "api2server", prd.toUpperCase(), apiName.toLowerCase(), accessToken);
            String[] dataList = data.split("@");
            String ip = dataList[0];
            String PRD = dataList[1];
            String apiname = dataList[2];
            long time = Long.parseLong(dataList[3]);
            if (!ip.equals(remoteIp)) {
                LOGGER.warning("WCPERR--> verifyAPIAccessToken - remoteIp mismatch. remoteIp=" + remoteIp + " ip=" + ip + " apiName=" + apiName);
                return 1;
            }
            if (!prd.equalsIgnoreCase(PRD)) {
                LOGGER.warning("WCPERR--> verifyAPIAccessToken - prd mismatch. prd=" + prd + " PRD=" + PRD + " remoteIp=" + remoteIp);
                return 1;
            }
            if (!apiName.equalsIgnoreCase(apiname)) {
                LOGGER.warning("WCPERR--> verifyAPIAccessToken - apiName mismatch. apiName=" + apiName + " apiname=" + apiname + " prd=" + prd + " remoteIp=" + remoteIp);
                return 1;
            }
            if (System.currentTimeMillis() - time > WCPConfManager.getAccessTokenExpireTimeForAPI()) {
                LOGGER.warning("WCPERR--> verifyAPIAccessToken - accessToken time expired. time=" + (System.currentTimeMillis() - time) + "ms");
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while verifyAPIAccessToken. accessToken=" + accessToken + " apiName=" + apiName + " prd=" + prd + " remoteIp=" + remoteIp, e);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.EXCEPTION_IN_VERIFY_ACCESS_TOKEN_FOR_API.getErrorCode(), 1L);
            WCPStats.addErrorStats("EXCEPTION_IN_VERIFY_ACCESS_TOKEN_FOR_API", "[accessToken : " + accessToken + "][apiName : " + apiName + "][prd : " + prd + "]");
            return -1;
        }
    }
}

