/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.util;

import java.util.ArrayList;
import java.util.List;

public class WCPConstants {
    public static final long WCP_FLAG_EMPTY = 0L;
    public static final int WCP_DEFAULT_PAYLOAD_TYPE = 0;
    public static final int WCP_SERVER_ACCEPT_TIME = 5;
    public static final String WCP_DEFAULT_LB_TECHNIQUE = "df";
    public static final String WCP_ROUND_ROBIN_LB_TECHNIQUE = "rr";
    public static final String WCP_LEAST_LOADED_LB_TECHNIQUE = "ll";
    public static final String WCP_URI = "wcpuri";
    public static final String WCP_IDB_URI = "idb";
    public static final String WCP_API_URI = "api";
    public static final String WCP_SERVER_URI = "srv";
    public static final String WCP_BACKUP_URI = "backup";
    public static final String WCP_AR_URI = "ar";
    public static final String WCP_DEFAULT_CONTEXT = "default";
    public static final String ON_DEMAND_CLUSTER_NAME = "direct";
    public static final String STATS_CONNECTION_SUCCESS = "success";
    public static final String STATS_CONNECTION_FAILURE = "failure";
    public static final String STATS_CONNECTION_LIFETIME = "lifetime";
    public static final String STATS_CONNECTION_ONCONNECT = "conn_onconnect";
    public static final String STATS_CONNECTION_ONCLOSE = "conn_onclose";
    public static final String STATS_MSG_DATA_SENT = "data_sent";
    public static final String STATS_MSG_ACK_RECEIVED = "ack_received";
    public static final String STATS_MSG_NTY_RECEIVED = "nyt_received";
    public static final String STATS_MSG_NTY_ACK_SENT = "nyt_ack_sent";
    public static final String STATS_MSG_META_RECEIVED = "meta_received";
    public static final String STATS_MSG_CTRL_RECEIVED = "ctrl_received";
    public static final String STATS_FRWD_DATA_SENT = "frwd_data_sent";
    public static final String STATS_FRWD_ACK_RECEIVED = "frwd_ack_received";
    public static final String STATS_PACKET_RESEND = "packet_resend";
    public static final String STATS_REQUEST_SENT = "req_sent";
    public static final String STATS_REQUEST_ACK_RECEIVED = "req_ack_received";
    public static final String STATS_RESPONCE_RECEIVED = "res_received";
    public static final String STATS_RESPONSE_ACK_SENT = "res_ack_sent";
    public static final String STATS_MSG_DATA_RECEIVED = "data_received";
    public static final String STATS_MSG_ACK_SENT = "ack_sent";
    public static final String STATS_MSG_NTY_SENT = "nyt_sent";
    public static final String STATS_MSG_NTY_ACK_RECEIVED = "nyt_ack_received";
    public static final String STATS_MSG_META_SENT = "meta_sent";
    public static final String STATS_MSG_CTRL_SENT = "ctrl_sent";
    public static final String STATS_FRWD_DATA_RECEIVED = "frwd_data_received";
    public static final String STATS_FRWD_ACK_SENT = "frwd_ack_sent";
    public static final String STATS_REQUEST_RECEIVED = "req_received";
    public static final String STATS_REQUEST_ACK_SENT = "req_ack_sent";
    public static final String STATS_RESPONSE_ACK_RECEIVED = "res_ack_received";
    public static final String STATS_MSG_RTT = "rtt";
    public static final int RTT_IN = 1;
    public static final int RTT_OUT = 0;
    public static final String STATS_LISTENER_ONMESSAGE = "on_message";
    public static final String STATS_LISTENER_ONERROR = "on_error";
    public static final String STATS_LISTENER_ONNOTIFY = "on_notify";
    public static final String STATS_LISTENER_HANDLEFORWARD = "handle_forward";
    public static final String STATS_LISTENER_META = "meta";
    public static final String STATS_WCP_DATA_STATUS_SUCCESS = "success";
    public static final String STATS_WCP_DATA_STATUS_FAILURE = "failure";
    public static final String STATS_WCP_DATA_STATUS_DROP = "drop";
    public static final String STATS_WCP_DATA_SIZE_EXCEEDS = "exceeds";
    public static final String SUCCESS_RESPONSE_CODE = "200";
    public static final String SUCCESS_RESPONSE_STRING = "OK";
    public static final String REQUEST_TIMEOUT_CODE = "408";
    public static final String REQUEST_TIMEOUT_STRING = "request_timeout";
    public static final String REDIRECT_RESPONSE_CODE = "307";
    public static final String INTERNAL_SERVER_ERROR_CODE = "500";
    public static final String IS_FORWARD_REQUEST = "x-isforward-request";
    public static final String IS_BROADCAST_REQUEST = "x-broadcast-request";
    public static final String BROADCAST_DEST_DC = "x-broadcast-dest-dc";
    public static final String REQUEST_PATH = "x-request-path";
    public static final String REQUEST_ORIGIN_IP = "x-request-origin-ip";
    public static final String REQUEST_ID = "x-wcp-reqid";
    public static final String REQUEST_EXPIRY_TIME = "wcp-request-expiry-time";
    public static final String WCP_THREAD_PREFIX = "WCP/";
    public static final String IPADDRESS_PATTERN = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";

    public static class BQDrainStatus {
        public static String getStats(int drainStats) {
            switch (drainStats) {
                case 0: {
                    return "SUCCESS";
                }
                case 1: {
                    return "PoolName Not Found";
                }
                case 2: {
                    return "BufferedQueue Not Found";
                }
                case 3: {
                    return "IP not found in SeedsMap";
                }
            }
            return "unknwon_error";
        }
    }

    public static enum ClientType {
        SERVER,
        API,
        IDB;

    }

    public static final class Security {
        public static final String SERVER_TO_SERVER_KEY = "server2server";
        public static final String API_TO_SERVER_KEY = "api2server";

        public static final class ConnectionFailedStatusCode {
            public static final int CLUSTER_NOT_ALLOWED = 501;
            public static final int IP_NOT_ALLOWED = 502;
            public static final int ACCESS_TOKEN_VERIFICATION_FAILED = 503;
            public static final int ACCESS_TOKEN_EXPIRED = 504;
            public static final int API_NOT_ALLOWED = 505;
        }

        public static final class AccessTokenStatus {
            public static final int SUCCESS = 0;
            public static final int FAILED = 1;
            public static final int EXPIRED = 2;
        }

        public static final class HeadersKeys {
            public static final String ACCESS_TOKEN = "x-wcp-accesstoken";
            public static final String FAILED_STATUS = "x-wcp-failed-status";
            public static final String ACCESS_TOKEN_FOR_API = "x-wcp-api-accesstoken";
            public static final String ACCESS_TOKEN_VERIFICATION_STATUS = "x-wcp-accesstoken-verification-status";
        }
    }

    public static class IDB {
        public static final String CLUSTER_NAME = "idbserver-main";
        public static final String SERVER_TYPE = "idbserver";
        public static final String POOLNAME = "idbconnpool";
        public static final String IDB_POOLNAME = "idbconnpool";
        public static final String CONTEXT = "intra_dc";
        public static final String SOURCE_DC_NAME = "x-req-source-dc";
        public static final String SOURCE_POOLNAME = "x-req-source-pn";
        public static final String SOURCE_CLUSTER_NAME = "x-req-source-cluster";
        public static final String SOURCE_IP = "x-req-source-ip";
        public static final String DEST_DC_NAME = "x-req-dest-dc";
        public static final String DEST_CLUSTER_NAME = "x-req-dest-cluster";
        public static final String DEST_CONTEXT = "x-req-dest-context";
        public static final String REMOTE_IP = "x-req-remote-ip";
        public static final String CD_NAME = "cdname";
        public static final String RKEY = "rkey";
        public static final String EVENT_ID = "x-idb-event-id";
        public static final String EVENT_TYPE = "x-idb-event-type";
        public static final String DATA_TYPE = "x-idb-data-type";

        public static class DcNames {
            public static final String US4 = "us4";
            public static final String US3 = "us3";
            public static final String IN1 = "in1";
            public static final String IN2 = "in2";
            public static final String EU1 = "eu1";
            public static final String EU2 = "eu2";
            public static final String CN2 = "cn2";
            public static final String CN3 = "cn3";
            public static final String AU1 = "au1";
            public static final String AU2 = "au2";
            public static final String CT1 = "local";
            public static final String CT2 = "ct2";
            public static final String CSEZ = "csez";

            public static boolean isValidDcName(String dcName) {
                switch (dcName.toLowerCase()) {
                    case "us3": 
                    case "us4": 
                    case "in1": 
                    case "in2": 
                    case "eu1": 
                    case "eu2": 
                    case "cn2": 
                    case "cn3": 
                    case "au1": 
                    case "au2": 
                    case "local": 
                    case "ct2": 
                    case "csez": {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    public static class StatusCode {
        public static final int SUCCESS = 200;
        public static final int CLUSTER_VERSION_MISMATCH = 201;
    }

    public static class AROpCode {
        public static final int PAUSE = 1;
        public static final int DRAIN = 2;
    }

    public static class META {
        public static final int SEED_CHANGE = 1;
    }

    public static class CONTROL {
        public static final int PAUSE = 1;
        public static final int RESUME = 2;
        public static final int START = 3;
        public static final int CLOSE = 4;
        public static final int REDIRECT = 5;
        public static final int ADD_CONNECTION = 6;

        public static String getName(int packetType) {
            switch (packetType) {
                case 1: {
                    return "PAUSE";
                }
                case 2: {
                    return "RESUME";
                }
                case 3: {
                    return "START";
                }
                case 4: {
                    return "CLOSE";
                }
                case 5: {
                    return "REDIRECT";
                }
                case 6: {
                    return "ADD_CONNECTION";
                }
            }
            return null;
        }
    }

    public static class ConnectionPool {
        public static final int CREATED = 1;
        public static final int ALREADY_EXISTS = 2;
    }

    public static class CommunicationType {
        public static final String MSG_SENT = "msg_sent";
        public static final String MSG_RECEIVED = "msg_received";
        public static final String ACK_SENT = "ack_sent";
        public static final String ACK_RECEIVED = "ack_received";
    }

    public static class PacketType {
        public static final String DATA = "data";
        public static final String META = "meta";
        public static final String NOTIFY = "notify";
        public static final String CONTROL = "control";
        public static final String FORWARD = "forward";
        public static final String REQUEST = "request";
        public static final String RESPONSE = "response";
        public static final String CB_REQUEST = "cb-request";
        public static final String CB_RESPONSE = "cb-response";
        public static final String IDB_DATA = "idb-data";
        public static final String IDB_CB_DATA = "idb-cb-data";
        public static final String IDB_REQUEST = "idb-request";
        public static final String IDB_RESPONSE = "idb-response";
        public static final String IDB_CB_NOTIFY = "idb-cb-notify";

        public static String getPacketTypeString(int packtype) {
            switch (packtype) {
                case 1: {
                    return DATA;
                }
                case 3: {
                    return "meta";
                }
                case 4: {
                    return NOTIFY;
                }
                case 5: {
                    return CONTROL;
                }
                case 6: {
                    return FORWARD;
                }
                case 7: {
                    return REQUEST;
                }
                case 8: {
                    return RESPONSE;
                }
                case 14: {
                    return CB_REQUEST;
                }
                case 15: {
                    return CB_RESPONSE;
                }
                case 9: {
                    return IDB_DATA;
                }
                case 10: {
                    return IDB_CB_DATA;
                }
                case 11: {
                    return IDB_REQUEST;
                }
                case 12: {
                    return IDB_RESPONSE;
                }
                case 13: {
                    return IDB_CB_NOTIFY;
                }
            }
            return null;
        }
    }

    public static class PacketHeader {
        public static final String QUEUE_TIME = "x-bq-intime";
        public static final String SERVLET_IN_TIME = "x-servlet-intime";
    }

    public static class INFO {
        public static final String ORDER = "_order";
        public static final List<String> WCPINFO_ORDER = new ArrayList<String>();
        public static final String POOLNAME = "PoolName";
        public static final String SERVERTYPE = "ServerType";
        public static final String REMOTE_SERVERTYPE = "RemoteServerType";
        public static final String REMOTE_CLUSTER = "RemoteCluster";
        public static final String CONTEXT = "Context";
        public static final String SEEDSMAP = "SeedsMap";
        public static final String PORT = "Port";
        public static final String LB_TECH = "LB_Tech";
        public static final String IS_AR_ENABLED = "isAREnabled";
        public static final String IS_CV_DEPENDENT = "isCVDependent";
        public static final String IS_SSL_BASED = "isSSLBased";
        public static final String IS_SELF_CONNECTION_ENABLED = "isSelfConnEnabled";
        public static final String CALLBACK_HANDLER_POOLSIZE = "CallBackHandler Core-Max PoolSize";
        public static final String RESPONSE_HANDLER_POOLSIZE = "ResponseHandler Core-Max PoolSize";
        public static final String IDB_CALLBACK_HANDLER_POOLSIZE = "IDBCallBackHandler Core-Max PoolSize";
        public static final String BUFFERED_QUEUE_SIZE = "BufferedQueue Size";
        public static final String MIN_CONNECTION_PER_IP = "Min ConnectionPerIp";
        public static final String MAX_CONNECTION_PER_IP = "Max ConnectionPerIp";
        public static final String MAX_DATA_PER_CONNECTION = "Max DataPerConnection";

        static {
            WCPINFO_ORDER.add(POOLNAME);
            WCPINFO_ORDER.add(SERVERTYPE);
            WCPINFO_ORDER.add(REMOTE_SERVERTYPE);
            WCPINFO_ORDER.add(REMOTE_CLUSTER);
            WCPINFO_ORDER.add(CONTEXT);
            WCPINFO_ORDER.add(SEEDSMAP);
            WCPINFO_ORDER.add(PORT);
            WCPINFO_ORDER.add(LB_TECH);
            WCPINFO_ORDER.add(IS_AR_ENABLED);
            WCPINFO_ORDER.add(IS_CV_DEPENDENT);
            WCPINFO_ORDER.add(IS_SSL_BASED);
            WCPINFO_ORDER.add(IS_SELF_CONNECTION_ENABLED);
            WCPINFO_ORDER.add(CALLBACK_HANDLER_POOLSIZE);
            WCPINFO_ORDER.add(RESPONSE_HANDLER_POOLSIZE);
            WCPINFO_ORDER.add(IDB_CALLBACK_HANDLER_POOLSIZE);
            WCPINFO_ORDER.add(BUFFERED_QUEUE_SIZE);
            WCPINFO_ORDER.add(MIN_CONNECTION_PER_IP);
            WCPINFO_ORDER.add(MAX_CONNECTION_PER_IP);
            WCPINFO_ORDER.add(MAX_DATA_PER_CONNECTION);
        }
    }
}

