/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.stats;

import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.Hashtable;
import java.util.logging.Logger;

public class WCPStats {
    private static Logger logger = Logger.getLogger(WCPStats.class.getName());
    public static boolean disableStats = false;

    public static void addWCPConnection(String serverType, String remoteServerType, String poolName, String remoteIp, String tname, String connstatus, String reason, long millis) {
        if (!disableStats) {
            try {
                switch (tname) {
                    case "conn_onconnect": {
                        StatsDB.addData("wcp_clientconn", serverType, remoteServerType, poolName, remoteIp, connstatus, reason, millis, 1, 0, 0);
                        break;
                    }
                    case "conn_onclose": {
                        StatsDB.addData("wcp_clientconn", serverType, remoteServerType, poolName, remoteIp, connstatus, reason, 0, 0, 1, millis);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPConnection][wcp_clientconn][" + e.getMessage() + "]");
            }
        }
    }

    public static void updateLiveStats(String serverType, String remoteServerType, String poolName, String remoteIp, long liveConnCount, long optimalConnCount, long bqRatePerMin, long liveBqSize, long notifyQueueSize, long resHandlerQueueSize, long idbNotiferQueueSize, long cbResponseHandlerQsize, long metaQueueSize, long pendingResponses) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientlivestats", serverType, remoteServerType, poolName, remoteIp, liveConnCount, optimalConnCount, bqRatePerMin, liveBqSize, notifyQueueSize, resHandlerQueueSize, idbNotiferQueueSize, cbResponseHandlerQsize, metaQueueSize, pendingResponses);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - updateLiveStats][wcp_clientlivestats][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPClientData(String serverType, String remoteServerType, String poolName, String remoteIp, String packetType, String communication) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientdata", serverType, remoteServerType, poolName, remoteIp, packetType, communication, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPClientData][wcp_clientdata][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPClientRttSize(String poolName, String uri, String serverType, String remoteServerType, String remoteClusterName, String remoteIp, int packetType, int size, int status) {
        if (disableStats) {
            return;
        }
        try {
            if (status == 1) {
                StatsDB.addData("wcp_clientrtt_size", poolName, uri, serverType, remoteServerType, remoteClusterName, remoteIp, packetType, size, 1, 0);
            } else {
                StatsDB.addData("wcp_clientrtt_size", poolName, uri, serverType, remoteServerType, remoteClusterName, remoteIp, packetType, size, 0, 1);
            }
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPClientRttSize][wcp_clientrtt_size][" + e.getMessage() + "]");
        }
    }

    public static void addWCPServerRttSize(String context, String uri, String serverType, String remoteServerType, String remoteClusterName, String remoteIp, int packetType, int size, int status) {
        if (disableStats) {
            return;
        }
        try {
            if (status == 1) {
                StatsDB.addData("wcp_serverrtt_size", context, uri, serverType, remoteServerType, remoteClusterName, remoteIp, packetType, size, 1, 0);
            } else {
                StatsDB.addData("wcp_serverrtt_size", context, uri, serverType, remoteServerType, remoteClusterName, remoteIp, packetType, size, 0, 1);
            }
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPServerRttSize][wcp_serverrtt_size][" + e.getMessage() + "]");
        }
    }

    public static void addWCPClientRTT(String serverType, String remoteServerType, String poolName, String remoteIp, String packetType, long millis) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientrtt", serverType, remoteServerType, poolName, remoteIp, packetType, millis, 1);
                StatsDB.addData("wcp_clientrtt_range", serverType, remoteServerType, poolName, remoteIp, packetType, millis);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPClientData][wcp_clientrtt_range][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPServerRTT(String serverType, String remoteServerType, String context, String remoteIp, String packetType, long millis) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_serverrtt_range", serverType, remoteServerType, context, remoteIp, packetType, millis);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPClientData][wcp_serverrtt_range][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPServerData(String uri, String serverType, String remoteServerType, String clusterName, String remoteClusterName, String context, String remoteIp, String packetType, String communication) {
        if (disableStats) {
            return;
        }
        WCPStats.addWCPServerData(uri, serverType, remoteServerType, clusterName, remoteClusterName, context, remoteIp, packetType, communication, null);
    }

    public static void addWCPServerData(String serverType, String remoteServerType, String clusterName, String remoteClusterName, String context, String remoteIp, String packetType, String communication) {
        if (disableStats) {
            return;
        }
        WCPStats.addWCPServerData("srv", serverType, remoteServerType, clusterName, remoteClusterName, context, remoteIp, packetType, communication, null);
    }

    public static void addWCPServerData(String uri, String serverType, String remoteServerType, String clusterName, String remoteClusterName, String context, String remoteIp, String packetType, String communication, Hashtable<String, String> packetHeader) {
        if (disableStats) {
            return;
        }
        try {
            if (packetHeader != null) {
                long bqtime = WCPStats.getLong(packetHeader.get("x-bq-intime"));
                long bqOutTime = WCPStats.getLong(packetHeader.get("time"));
                long servletintime = WCPStats.getLong(packetHeader.get("x-servlet-intime"));
                long netTime = servletintime - bqOutTime;
                if (netTime < 0L) {
                    netTime = 0L;
                }
                StatsDB.addData("wcp_serverdata", uri, serverType, remoteServerType, clusterName, remoteClusterName, context, remoteIp, packetType, communication, 1, bqtime, netTime, bqtime + netTime);
            } else {
                StatsDB.addData("wcp_serverdata", uri, serverType, remoteServerType, clusterName, remoteClusterName, context, remoteIp, packetType, communication, 1, 0, 0, 0);
            }
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPClientData][wcp_serverdata][" + e.getMessage() + "]");
        }
    }

    private static Long getLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static void addWCPServerAPIData(String serverType, String remoteServerType, String clusterName, String apiName, String context, String packetType, String communication, String remoteIp) {
        if (!disableStats) {
            WCPStats.addWCPServerAPIData(serverType, remoteServerType, clusterName, apiName, context, packetType, communication, remoteIp, null);
        }
    }

    public static void addWCPServerAPIData(String serverType, String remoteServerType, String clusterName, String apiName, String context, String packetType, String communication, String remoteIp, Hashtable<String, String> packetHeader) {
        if (!disableStats) {
            try {
                if (packetHeader != null) {
                    long bqtime = WCPStats.getLong(packetHeader.get("x-bq-intime"));
                    long bqOutTime = WCPStats.getLong(packetHeader.get("time"));
                    long servletintime = WCPStats.getLong(packetHeader.get("x-servlet-intime"));
                    long netTime = servletintime - bqOutTime;
                    if (netTime < 0L) {
                        netTime = 0L;
                    }
                    StatsDB.addData("wcp_server_api_data", serverType, remoteServerType, clusterName, apiName, context, packetType, communication, remoteIp, 1, bqtime, netTime, bqtime + netTime);
                } else {
                    StatsDB.addData("wcp_server_api_data", serverType, remoteServerType, clusterName, apiName, context, packetType, communication, remoteIp, 1, 0, 0, 0);
                }
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPServerAPIData][wcp_server_api_data][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPForwardMisuse(String serverType) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_frwd_missuse", serverType, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPForwardMisuse][wcp_frwd_misuse][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPListenerStats(String tname, String remoteIp, long millis) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_listnr_process_time", tname, DC.getServertype(), DC.getCluster(), remoteIp, millis, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPListenerStats][wcp_listnr_process_time][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPConnReconnect(String serverType, String remoteServerType, String poolName, String remoteIp) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_reconnect", serverType, remoteServerType, poolName, remoteIp, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPConnReconnect][wcp_reconnect][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPDataSizeStats(String serverType, String remoteServerType, String poolName, String remoteIp, String status, long size) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientdatasize_range", serverType, remoteServerType, poolName, remoteIp, status, size);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPDataSizeStats][wcp_clientdatasize_range][" + e.getMessage() + "]");
            }
        }
    }

    public static void addBQSize(String serverType, String remoteServerType, String poolName, String remoteIp, int size) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_bqsize", serverType, remoteServerType, poolName, remoteIp, size);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addBQSize][wcp_bqsize][" + e.getMessage() + "]");
            }
        }
    }

    public static void addUnnecessaryClose(String serverType, String remoteServerType, String poolName, String remoteIp) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_force_close", serverType, remoteServerType, poolName, remoteIp, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addUnnecessaryClose][wcp_force_close][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPAPIHits(String serverType, String prd, String remoteIp, String servletName, String status, long time) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_api_hits", serverType, prd, servletName, status, remoteIp, 1, time);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPAPIHits][wcp_api_hits][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPSrvHits(String serverType, String remoteServerType, String remoteIp, String servletName, String status, long time) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_srv_hits", serverType, remoteServerType, remoteIp, servletName, status, 1, time);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPSrvHits][wcp_srv_hits][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPRequestTimeout(String serverType, String remoteServerType, String poolName, String clusterName, String remoteClusterName, String destIp, String servlet, String isFrwdRequest) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_req_timeout", serverType, remoteServerType, poolName, clusterName, remoteClusterName, destIp, servlet, isFrwdRequest, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPRequestTimeout][wcp_req_timeout][" + e.getMessage() + "]");
        }
    }

    public static void addWCPCVMismatch(String clusterName, String oldClusterVersion, String newClusterVersion) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_cv_mismatch", clusterName, oldClusterVersion, newClusterVersion, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPCVMismatch][wcp_cv_mismatch][" + e.getMessage() + "]");
        }
    }

    public static void sendRandomSidCount(String uri, String reqSource, String sid) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_randomsid_res", uri, reqSource, sid, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPCVMismatch][" + e.getMessage() + "]");
        }
    }

    public static void wcpFilterFailed(String packetType, String filterType, String servletOrContext, String remoteIp) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_filter_fail", packetType, filterType, servletOrContext, remoteIp, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - wcpFilterFailed][" + e.getMessage() + "]");
        }
    }

    public static void servletNotFound(String remoteServerType, String remoteIp, String servlet, String uri) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_servlet_notfound", remoteServerType, servlet, uri, remoteIp, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - servletNotFound][" + e.getMessage() + "]");
        }
    }

    public static void addWCPAccessLoggerStats(String clusterName, String servlet, String remoteIp, String uri, long size, long time) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_accesslogger", clusterName, servlet, uri, remoteIp, size, time, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPAccessLoggerStats][" + e.getMessage() + "]");
        }
    }

    public static void addWCPRequestTakenTime(String poolName, String destinationIp, String servlet, String resCode, long takenTime) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_request_time", DC.getServertype(), DC.getCluster(), poolName, destinationIp, servlet, resCode, takenTime, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPRequestTakenTime][" + e.getMessage() + "]");
        }
    }

    public static void addErrorStats(String errorType, String message) {
        StatsDB.addData("wcp_error_monitoring", errorType, DC.getServertype(), DC.getCluster(), message, 1);
    }

    public static void addIDBLoadTestStats(String data_type, String dc, String batchID, long forward_time, long roundTripTime, long payload_size) {
        StatsDB.addData("idbloadtest", data_type, dc, DC.getCluster(), batchID, forward_time, roundTripTime, payload_size, 1);
    }

    public static void addServerSessionStats(String operation, String reqSource, String uri, String source, String ip, String poolName, String context, String sid, long listenerTime) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_serversession_stats", DC.getServertype(), DC.getCluster(), operation, uri, source, ip, poolName, context, reqSource, sid, listenerTime, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPRequestTakenTime][" + e.getMessage() + "]");
        }
    }

    public static void addWCPForwardRequests(String serverType, String remoteServerType, String remoteClusterName, String poolName, String remoteIp, String destinationIp, String servlet, String frwdIps, String reqid) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_frwd_requests", serverType, remoteServerType, DC.getCluster(), remoteClusterName, poolName, remoteIp, destinationIp, servlet, frwdIps, reqid, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPForwardRequests][wcp_frwd_requests][" + e.getMessage() + "]");
        }
    }

    public static void addWCPServerDataSize(String uri, String serverType, String remoteServerType, String clusterName, String remoteClusterName, String context, String remoteIp, String packetType, long dataSize) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_serverdata_size", uri, serverType, remoteServerType, clusterName, remoteClusterName, context, remoteIp, packetType, dataSize);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPServerDataSize][wcp_serverdata_size][" + e.getMessage() + "]");
        }
    }

    public static void addWCPClientDataSize(String uri, String serverType, String remoteServerType, String remoteClusterName, String poolName, String destinationIp, String packetType, long dataSize) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_clientdata_size", uri, serverType, remoteServerType, DC.getCluster(), remoteClusterName, poolName, destinationIp, packetType, dataSize);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPClientDataSize][wcp_clientdata_size][" + e.getMessage() + "]");
        }
    }

    public static void addWCPHandlerProcessingTime(String handlerName, long processTime) {
        WCPStats.addWCPHandlerProcessingTime(DC.getServertype(), "cbresponsehandler", "cbresponsehandler", "cbresponsehandler", "cbresponsehandler", handlerName, processTime);
    }

    public static void addWCPHandlerProcessingTime(String serverType, String remoteServerType, String remoteClusterName, String poolName, String context, String handlerName, long processTime) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_handler_processtime", serverType, remoteServerType, DC.getCluster(), remoteClusterName, poolName, context, handlerName, processTime, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPHandlerProcessingTime][wcp_handler_processtime][" + e.getMessage() + "]");
        }
    }

    public static void addWCPHits() {
        try {
            StatsDB.addData("httphits", DC.getServertype(), "default", "internal", "wcp", 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPHits][httphits][" + e.getMessage() + "]");
        }
    }

    public static void addWCPSecurityFailure(String uri, String source, String poolName, String context, String remoteIp, String failedStatus) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_security_failure", uri, source, DC.getCluster(), poolName, context, remoteIp, failedStatus, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPSecurityFailure][wcp_security_failure][" + e.getMessage() + "]");
        }
    }

    public static void addConnPoolTime(String remoteServerType, String remoteClusterName, String poolName, String context, long initTime) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_connpool_time", DC.getServertype(), remoteServerType, DC.getCluster(), remoteClusterName, poolName, context, initTime, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addConnPoolTime][wcp_connpool_time][" + e.getMessage() + "]");
        }
    }
}

