/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idbloadtest;

import java.util.concurrent.atomic.AtomicInteger;

public class IDBPayloadStatus {
    private boolean isEnded = false;
    private String batchId;
    private String dc;
    private String type;
    private String cluster;
    private long batchCount;
    private long endTime = -1L;
    private long startTime;
    private AtomicInteger responseSent = new AtomicInteger(0);
    private AtomicInteger responseReceived = new AtomicInteger(0);
    private AtomicInteger errorReceived = new AtomicInteger(0);
    private AtomicInteger dataSent = new AtomicInteger(0);
    private AtomicInteger dataReceived = new AtomicInteger(0);

    public IDBPayloadStatus(String batchId, long batchCount, long startTime, String type) {
        this.batchId = batchId;
        this.batchCount = batchCount;
        this.startTime = startTime;
        this.type = type;
    }

    public void responseRecieved() {
        this.endTime = System.currentTimeMillis();
        this.responseReceived.incrementAndGet();
        this.checkRTTEnd();
    }

    public void errorReceived() {
        this.endTime = System.currentTimeMillis();
        this.errorReceived.incrementAndGet();
        this.checkRTTEnd();
        this.checkForwardEnd();
    }

    public void responseSent() {
        this.responseSent.incrementAndGet();
    }

    public void dataRecieved() {
        this.endTime = System.currentTimeMillis();
        this.dataReceived.incrementAndGet();
        this.checkForwardEnd();
    }

    public void dataSent() {
        this.dataSent.incrementAndGet();
    }

    public void setDC(String dc) {
        this.dc = dc;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getType() {
        return this.type;
    }

    public String getDC() {
        return this.dc;
    }

    public int getResponseReceived() {
        return this.responseReceived.get();
    }

    public int getResponseSent() {
        return this.responseSent.get();
    }

    public int getDataSent() {
        return this.dataSent.get();
    }

    public int getDataReceived() {
        return this.dataReceived.get();
    }

    public int getErrorReceived() {
        return this.errorReceived.get();
    }

    public double getResponseReceivedPercentageLoss() {
        return this.calcPercentange(this.responseReceived.get(), this.batchCount);
    }

    public double getResponseSentPercentageLoss() {
        return this.calcPercentange(this.responseSent.get(), this.batchCount);
    }

    public double getDataSentPercentageLoss() {
        return this.calcPercentange(this.dataSent.get(), this.batchCount);
    }

    public double getDataReceivedPercentageLoss() {
        return this.calcPercentange(this.dataReceived.get(), this.batchCount);
    }

    public String getBatchID() {
        return this.batchId;
    }

    public long getCount() {
        return this.batchCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalTime() {
        if (this.endTime != -1L) {
            return this.endTime - this.startTime;
        }
        return -1L;
    }

    private void checkForwardEnd() {
        if ((long)(this.dataReceived.get() + this.errorReceived.get()) == this.batchCount) {
            this.isEnded = true;
        }
    }

    private void checkRTTEnd() {
        if ((long)(this.responseReceived.get() + this.errorReceived.get()) == this.batchCount) {
            this.isEnded = true;
        }
    }

    double calcPercentange(long num, long total) {
        return (double)Math.round((100.0 - (double)num * 100.0 / (double)total) * 100000.0) / 100000.0;
    }
}

