/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idbloadtest;

import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTest;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTestRequestListener;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBPayload;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBPayloadStatus;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IDBLoadTestProducer
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(IDBLoadTestProducer.class.getName());
    private String poolName;
    private String cluster;
    private String batchID;
    private long count = -1L;
    private long reqTimeout;
    private long sleepTime;
    private int dataType;
    private boolean sendToDC;
    private Hashtable params = null;
    private String dcName = null;
    private Hashtable<String, IDBPayloadStatus> map = IDBLoadTest.getMap();

    public IDBLoadTestProducer(Hashtable params, int dataType, String poolName, String batchID) {
        this.poolName = poolName;
        this.params = params;
        this.dataType = dataType;
        this.batchID = batchID;
    }

    @Override
    public void run() {
        String opr = (String)this.params.get("operation");
        this.count = this.params.get("count") == null ? 1000L : Long.parseLong((String)this.params.get("count"));
        this.cluster = this.params.get("cluster") == null ? DC.getCluster() : (String)this.params.get("cluster");
        this.reqTimeout = this.params.get("timeout") == null ? 30000L : Long.parseLong((String)this.params.get("timeout"));
        long l = this.sleepTime = this.params.get("sleeptime") == null ? 0L : Long.parseLong((String)this.params.get("sleeptime"));
        if (this.params.containsKey("dc_name")) {
            if (this.params.get("dc_name") == null) {
                this.sendToDC = true;
                this.dcName = DC.getDrDCId();
            } else {
                this.sendToDC = true;
                this.dcName = (String)this.params.get("dc_name");
            }
        }
        switch (opr) {
            case "data": {
                this.handleData();
                break;
            }
            case "req": {
                this.handleRequest();
                break;
            }
        }
    }

    private void handleData() {
        long originTime = System.currentTimeMillis();
        IDBPayloadStatus plStatus = new IDBPayloadStatus(this.batchID, this.count, originTime, "data");
        this.map.put(this.batchID, plStatus);
        plStatus.setCluster(this.cluster);
        String pl = "aaaaaaaaaaaaaaaaaaaa";
        int i = 0;
        while ((long)i < this.count) {
            try {
                IDBPayload payload;
                if (this.sendToDC) {
                    payload = new IDBPayload(this.batchID).setReqOriginTime(originTime).setStartTime().setBatchCount(this.count).setCount(i).setDC(this.dcName).setOriginDC().setPayload(pl).setPayloadSize(pl.length());
                    WCPDispatcher.sendDataToDc(this.poolName, this.dataType, payload.toString(), this.dcName, null, this.cluster);
                    plStatus.setDC(this.dcName);
                    LOGGER.info("SH --> data sent " + i + "-TEST-MSG-TODC");
                } else {
                    payload = new IDBPayload(this.batchID).setReqOriginTime(originTime).setStartTime().setBatchCount(this.count).setCount(i).setDC(DC.getDrDCId()).setOriginDC().setPayload(pl).setPayloadSize(pl.length());
                    WCPDispatcher.sendDataToDr(this.poolName, payload.toString(), null, this.cluster);
                    plStatus.setDC(DC.getDrDCId());
                    LOGGER.info("SH --> data sent " + i + "-TEST-MSG-TODR");
                }
                plStatus.dataSent();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception while sending IDB-Load-Test DATA. opr = data; cluster = " + this.cluster + "; dcname = " + this.dcName + " count = " + this.count, e);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "SH --> InterruptedException", e);
            }
            ++i;
        }
    }

    private void handleRequest() {
        IDBLoadTestRequestListener listener = new IDBLoadTestRequestListener();
        String uri = "idbloadtestservlet";
        long originTime = System.currentTimeMillis();
        IDBPayloadStatus plStatus = new IDBPayloadStatus(this.batchID, this.count, originTime, "req");
        this.map.put(this.batchID, plStatus);
        plStatus.setCluster(this.cluster);
        String pl = "aaaaaaaaaaaaaaaaaaaa";
        int i = 0;
        while ((long)i < this.count) {
            try {
                WCPRequest req = new WCPRequest(uri);
                req.addHeader("batchid", this.batchID);
                req.addHeader("origin_dc", DC.getDCId());
                req.addHeader("origintime", String.valueOf(originTime));
                req.addHeader("msg_starttime", String.valueOf(System.currentTimeMillis()));
                req.addHeader("batchcount", String.valueOf(this.count));
                req.addHeader("count", String.valueOf(i));
                req.addHeader("payloadsize", String.valueOf(pl.length()));
                req.addHeader("origin_cluster", DC.getCluster());
                req.setTimeOutInMillis(this.reqTimeout);
                req.setData(pl);
                if (this.sendToDC) {
                    req.addHeader("dc", this.dcName);
                    plStatus.setDC(this.dcName);
                    WCPDispatcher.sendRequestToDc(this.poolName, this.dcName, req, listener);
                    LOGGER.info("SH --> request sent " + this.dcName + "-" + i + "-IDB-Req-Res-TODC");
                } else {
                    req.addHeader("dc", DC.getDrDCId());
                    plStatus.setDC(DC.getDrDCId());
                    WCPDispatcher.sendRequestToDR(this.poolName, req, listener, null, this.cluster);
                    LOGGER.info("SH --> request sent " + i + "-IDB-Req-Res-TODR cl" + this.cluster);
                }
                plStatus.dataSent();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception while sending IDB-Load-Test REQ. opr = request; cluster = " + this.cluster + "; dcname = " + this.dcName + " count = " + this.count, e);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "SH --> InterruptedException", e);
            }
            ++i;
        }
    }
}

