/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idbloadtest;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.callback.WCPListener;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTest;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBPayloadStatus;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import java.util.Hashtable;
import java.util.logging.Logger;

public class IDBLoadTestListener
implements WCPListener {
    private static Logger logger = Logger.getLogger(IDBLoadTestListener.class.getName());
    private static Hashtable<String, IDBPayloadStatus> map = IDBLoadTest.getMap();

    @Override
    public void onError(String poolName, int dataType, String data, String reason) {
        logger.info("SH --> onError load test : poolName=" + poolName + " dataType=" + dataType + " data=" + data + " reason=" + reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String source, int dataType, String data) {
        logger.info("SH --> onMessage load test : source=" + source + " dataType=" + dataType + " data=" + data);
        try {
            Hashtable idbpayload = (Hashtable)HttpDataWraper.getObject((String)data);
            if (!map.containsKey(idbpayload.get("batchid"))) {
                Hashtable hashtable = idbpayload;
                synchronized (hashtable) {
                    if (!map.containsKey(idbpayload.get("batchid"))) {
                        IDBPayloadStatus st = new IDBPayloadStatus((String)idbpayload.get("batchid"), Long.parseLong((String)idbpayload.get("batchcount")), Long.parseLong((String)idbpayload.get("origintime")), "data");
                        st.setDC((String)idbpayload.get("origin_dc"));
                        st.setCluster((String)idbpayload.get("origin_cluster"));
                        map.put((String)idbpayload.get("batchid"), st);
                    }
                }
            }
            map.get(idbpayload.get("batchid")).dataRecieved();
            WCPStats.addIDBLoadTestStats("data", (String)idbpayload.get("dc"), (String)idbpayload.get("batchid"), System.currentTimeMillis() - Long.parseLong((String)idbpayload.get("msg_starttime")), 0L, Long.parseLong((String)idbpayload.get("payloadsize")));
            WCPDispatcher.sendCBNotifyData(source, dataType, data);
            map.get(idbpayload.get("batchid")).responseSent();
        }
        catch (Exception e) {
            logger.severe("SH --> Exception while sending CB Notify ==> source=" + source + " dataType=" + dataType + " data=" + data);
        }
    }

    @Override
    public Hashtable handleForward(String source, Hashtable header) {
        return null;
    }
}

