/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.idbloadtest;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.components.net.WCPConnPoolConfig;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTestCBListener;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTestListener;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTestProducer;
import com.adventnet.wms.servercommon.components.net.idbloadtest.IDBPayloadStatus;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServletMapper;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IDBLoadTest
extends WmsRuntime {
    private static final Logger LOGGER = Logger.getLogger(IDBLoadTest.class.getName());
    private static String poolName = "idb-load-test-pool";
    private static boolean isInit = false;
    private static HashSet<String> oprVal = null;
    private static Hashtable<String, IDBPayloadStatus> status;

    public IDBLoadTest() {
        IDBLoadTest.init();
        oprVal = new HashSet();
        oprVal.add("status");
        oprVal.add("data");
        oprVal.add("req");
    }

    public static boolean init() {
        if (!isInit) {
            if (WCPDispatcher.isInitialised() && WCPSessionManager.isInitialised()) {
                try {
                    status = new Hashtable();
                    Properties servletMapping = new Properties();
                    servletMapping.put("idbloadtestservlet", "com.adventnet.wms.servercommon.components.net.idbloadtest.IDBLoadTestServlet");
                    WCPServletMapper.initialize(servletMapping);
                    WCPConnPoolConfig conf = new WCPConnPoolConfig("idb-load-test-pool", DC.getServertype(), DC.getServertype(), DC.getCluster()).setContext("idb-load-test-context");
                    WCPDispatcher.createWCPConnPool(conf);
                    WCPSessionManager.registerListener("idb-load-test-context", new IDBLoadTestListener());
                    WCPSessionManager.registerCBListener("idb-load-test-context", new IDBLoadTestCBListener());
                    LOGGER.info("SH --> idb-load-test-pool successfully created");
                    isInit = true;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "SH --> Exception in initializing listener", e);
                }
            } else {
                LOGGER.warning("SH --> WCPDispatcher and WCPSessionManager not initialized");
            }
        }
        return isInit;
    }

    @Override
    public Hashtable getInfo(Hashtable params) {
        Hashtable<String, Object> resultMap = new Hashtable<String, Object>();
        try {
            String opr = (String)params.get("operation");
            if (!IDBLoadTest.init()) {
                resultMap.put("Not able to initialize", "check if WCPDispatcher and WCPSessionManager are initialized");
                return resultMap;
            }
            if ("status".equalsIgnoreCase(opr) || opr == null && CommonUtil.isEmpty((String)((String)params.get("batchid")))) {
                if (params.containsKey("batchid") && !CommonUtil.isEmpty((String)((String)params.get("batchid")))) {
                    String batchId = (String)params.get("batchid");
                    IDBPayloadStatus st = status.get(batchId);
                    if (st == null) {
                        resultMap.put("invalid batchid", "Pls check the batchid you have entered.");
                        return resultMap;
                    }
                    Hashtable<String, String> batchDetails = new Hashtable<String, String>();
                    String type = st.getType();
                    if (st.getDataSent() != 0 && st.getDataReceived() == 0) {
                        if (st.isEnded()) {
                            batchDetails.put("Total RTT", String.valueOf(st.getTotalTime()));
                        } else {
                            batchDetails.put("RTT (Not received fully)", String.valueOf(st.getTotalTime()));
                            batchDetails.put("Request is", "in progress");
                        }
                        batchDetails.put(type + " sent", String.valueOf(st.getDataSent()));
                        batchDetails.put("% of " + type + " sent", String.valueOf(st.calcPercentange(st.getDataSent(), st.getCount())));
                        batchDetails.put("Response received", String.valueOf(st.getResponseReceived()));
                        batchDetails.put(type + " error", String.valueOf(st.getErrorReceived()));
                        batchDetails.put("% of data loss", String.valueOf(st.getResponseReceivedPercentageLoss()));
                        batchDetails.put("Destination cluster", st.getCluster());
                    } else {
                        if (st.isEnded()) {
                            batchDetails.put("Total forward time", String.valueOf(st.getTotalTime()));
                        } else {
                            batchDetails.put("Forward time (Not received fully)", String.valueOf(st.getTotalTime()));
                            batchDetails.put("Request is", "in progress");
                        }
                        batchDetails.put("Response sent", String.valueOf(st.getResponseSent()));
                        batchDetails.put("% of response sent", String.valueOf(st.calcPercentange(st.getDataSent(), st.getCount())));
                        batchDetails.put(type + " received", String.valueOf(st.getDataReceived()));
                        batchDetails.put(type + " error", String.valueOf(st.getErrorReceived()));
                        batchDetails.put("% of data loss", String.valueOf(st.getDataReceivedPercentageLoss()));
                    }
                    resultMap.put(st.getDC(), batchDetails);
                    resultMap.put("Batch ID", st.getBatchID());
                } else {
                    Set<String> ids = status.keySet();
                    for (String batchId : ids) {
                        IDBPayloadStatus st = status.get(batchId);
                        Hashtable<String, String> batchDetails = new Hashtable<String, String>();
                        batchDetails.put("count", String.valueOf(st.getCount()));
                        batchDetails.put("start time", WMSUtil.HumanReadable.getTime(st.getStartTime()));
                        if (st.getDataSent() != 0 && st.getDataReceived() == 0) {
                            if (st.getTotalTime() != -1L) {
                                batchDetails.put("Total round trip time", String.valueOf(st.getTotalTime()));
                            } else {
                                batchDetails.put("Request is", "in progress");
                            }
                            batchDetails.put("Destination DC", st.getDC());
                            batchDetails.put("Destination Cluster", st.getCluster());
                        } else {
                            if (st.getTotalTime() != -1L) {
                                batchDetails.put("total forward time", String.valueOf(st.getTotalTime()));
                            } else {
                                batchDetails.put("Request is", "in progress");
                            }
                            batchDetails.put("Source DC", st.getDC());
                            batchDetails.put("Source Cluster", st.getCluster());
                        }
                        batchDetails.put("Type", st.getType());
                        resultMap.put(batchId, batchDetails);
                    }
                }
            } else if (oprVal.contains(opr)) {
                String batchID = UUID.randomUUID().toString();
                new Thread(new IDBLoadTestProducer(params, 1, poolName, batchID)).start();
                resultMap.put("Request has been started. Check with batch id : ", batchID);
            } else {
                resultMap.put("Invalid opr", "Check with 'man idbloadtest'");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SH --> ERROR", e);
        }
        return resultMap;
    }

    public static Hashtable<String, IDBPayloadStatus> getMap() {
        return status;
    }
}

