/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.connection;

import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import java.util.concurrent.atomic.AtomicLong;

public class WCPConnection {
    protected String remoteIp;
    protected AtomicLong packetId;
    protected WCPServerConnPool connPool;
    protected String sid;
    protected long connectionTime;
    protected String closeReason = null;
    protected String serverType;
    protected String remoteServerType;
    protected String remoteClusterName;

    public WCPConnection(String serverType, String remoteServerType, String remoteClusterName, String ip, long msgId, String sid, WCPServerConnPool connPool) {
        this.serverType = serverType;
        this.remoteServerType = remoteServerType;
        this.remoteClusterName = remoteClusterName;
        this.remoteIp = ip;
        this.packetId = new AtomicLong(0L);
        this.sid = sid;
        this.connPool = connPool;
        this.connectionTime = System.currentTimeMillis();
    }

    public WCPConnection(String remoteClusterName, String ip, long msgId, String sid, WCPServerConnPool connPool) {
        this.remoteClusterName = remoteClusterName;
        this.remoteIp = ip;
        this.packetId = new AtomicLong(0L);
        this.connPool = connPool;
        this.sid = sid;
        this.connectionTime = System.currentTimeMillis();
    }

    public String getRemoteIP() {
        return this.remoteIp;
    }

    public String getSID() {
        return this.sid;
    }

    public String getRemoteServerType() {
        return this.remoteServerType;
    }

    public long getAvgMsgRecieveTime() {
        return 0L;
    }

    public void setWCPConnPool(WCPServerConnPool connPool) {
        this.connPool = connPool;
    }

    public void onConnect() {
    }

    public boolean writeData(WCPPacket packet) throws Exception {
        return false;
    }

    public boolean writeData(byte[] data) throws Exception {
        return false;
    }

    public void onMessage(byte[] data) {
    }

    public void onClose() {
    }

    public void close() throws Exception {
    }

    public long getMsgID() {
        return this.packetId.get();
    }

    protected void addConnStats(String status, String reason) {
        String poolName;
        long connLife = System.currentTimeMillis() - this.connectionTime;
        String string = poolName = this.connPool == null ? "serverconn" : this.connPool.getPoolName();
        if (reason == null) {
            reason = "object-null";
        }
        try {
            switch (status) {
                case "conn_onconnect": {
                    WCPStats.addWCPConnection(this.serverType, this.remoteServerType, poolName, this.remoteIp, "conn_onconnect", "success", reason, connLife);
                    break;
                }
                case "conn_onclose": {
                    WCPStats.addWCPConnection(this.serverType, this.remoteServerType, poolName, this.remoteIp, "conn_onclose", "lifetime", reason, connLife);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCloseReason(String closeReason) {
        if (closeReason != null) {
            this.closeReason = closeReason;
        }
    }
}

