/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.connection;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.connection.WCPConnection;
import com.adventnet.wms.servercommon.components.net.connection.WCPWebSocketV13;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.net.util.WCPPacketTypes;
import com.adventnet.wms.servercommon.components.net.util.WCPPacketizer;
import com.adventnet.wms.servercommon.components.net.util.WCPUtil;
import com.adventnet.wms.servercommon.components.queue.BQInventory;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.DistributionManager;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPBIOClientConn
extends WCPConnection {
    private Logger logger = Logger.getLogger(WCPBIOClientConn.class.getName());
    private WCPWebSocketV13 request;
    private BufferedQueue bq;
    private LinkedBlockingQueue<WCPPacket> ackQueue = new LinkedBlockingQueue();
    private String poolName = null;
    private int connectionNumber;
    private boolean manualClose = false;
    private long retryTime = -1L;
    private long recentPacketSentTime;
    private byte[] failedPacket = null;
    private boolean retryFailedPacket = false;
    private int retryFailedPacketCount = 0;
    private boolean isPaused = false;
    private BufferedQueue readQueue;
    private WCPPacketReadThread readThread;
    private boolean isReadTheadLive = false;

    public WCPBIOClientConn(String serverType, String remoteServerType, String poolName, String remoteClusterName, String remoteIp, String sid, WCPServerConnPool connPool, BufferedQueue bq, int connNumber) throws Exception {
        super(serverType, remoteServerType, remoteClusterName, remoteIp, 0L, sid, connPool);
        this.bq = bq;
        this.connectionNumber = connNumber;
        this.poolName = poolName;
        this.retryTime = -1L;
        this.recentPacketSentTime = System.currentTimeMillis();
        this.readQueue = new BufferedQueue(bq.getFilePath() + "-readqueue", bq.getFileName() + "-readqueue-" + sid.trim(), bq.qSize(), false);
        this.readThread = new WCPPacketReadThread();
        this.connect();
    }

    public void connect() throws Exception {
        this.connectionTime = System.currentTimeMillis();
        String protocol = "ws://";
        int port = this.connPool.getPort();
        if (this.connPool.isSSLBased()) {
            protocol = "wss://";
            port = 443;
        }
        String uri = this.connPool.getURI();
        String context = this.connPool.getContext();
        String poolName = "&pname=" + this.connPool.getPoolName();
        String source = this.remoteClusterName != null ? this.remoteClusterName : "Unknown";
        String sourceCluster = "&sourcecluster=" + DC.getCluster();
        String cntx = "";
        String rst = "";
        if (context != null) {
            cntx = "&context=" + context;
        }
        if (this.serverType != null) {
            rst = "&rst=" + this.serverType;
        }
        this.closeReason = null;
        this.request = new WCPWebSocketV13(protocol + this.remoteIp + ":" + port + uri + "?source=" + source + "&sid=" + this.sid.trim() + cntx + rst + poolName + sourceCluster, this);
        this.request.connect();
    }

    @Override
    public void onConnect() {
        this.recentPacketSentTime = System.currentTimeMillis();
        this.addConnStats("conn_onconnect", "client-onconnect");
        if (!this.isReadTheadLive) {
            this.readThread.start();
        }
        this.logger.info("[WCP][New Client Connection Established][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + this.connectionNumber + "]");
    }

    @Override
    public void onMessage(byte[] data) {
        block25: {
            if (this.retryTime != -1L) {
                this.retryTime = -1L;
            }
            try {
                if (data == null) break block25;
                WCPPacket packet = WCPPacketizer.getDataFromPacket(data);
                if (packet == null) {
                    return;
                }
                if (packet.getPacketType() == 2) {
                    WCPUtil.printDebugLogs("[Ack Received][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + packet.getPacketId() + "][" + packet.getPayLoadType() + "]");
                    if (packet.getStatusCode() == 201) {
                        DistributionManager.refreshClusterVersion(this.connPool.getClusterName());
                    }
                    int payLoadType = packet.getPayLoadType();
                    switch (payLoadType) {
                        case 1: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 13: {
                            WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(payLoadType), "ack_received");
                            if (packet.getNetInTime() != -1L) {
                                WCPStats.addWCPClientRTT(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(payLoadType), System.currentTimeMillis() - packet.getNetInTime());
                                break;
                            }
                            break block25;
                        }
                        default: {
                            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.INVALID_ACK_PACKET_TYPE_RECEIVED_IN_CLIENT.getErrorCode(), 1L);
                            WCPStats.addErrorStats("INVALID_ACK_PACKET_TYPE_RECEIVED_IN_CLIENT", "[packetType : " + packet.getPacketType() + "][payloadType : " + payLoadType + "]");
                            this.logger.info("WCPERR--> Invalid ack_packetType received. ack_packetType=" + (WCPPacketTypes.isValidPacketType(payLoadType) ? WCPConstants.PacketType.getPacketTypeString(payLoadType) : Integer.valueOf(payLoadType)));
                            return;
                        }
                    }
                    break block25;
                }
                if (packet.getPacketType() == 4) {
                    WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "notify", "msg_received");
                    if (packet.getHeader("x-req-source-ip") != null) {
                        this.connPool.processWCPIDBNotifyData(this.remoteIp, packet);
                    } else {
                        this.connPool.processWCPNotifyData(this.remoteIp, packet);
                    }
                    WCPUtil.printDebugLogs("[Notify Received][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + packet.getPacketId() + "]");
                    this.sendAck(packet.getPacketId(), 4);
                    break block25;
                }
                if (packet.getPacketType() == 3) {
                    WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "meta", "msg_received");
                    this.connPool.processWCPMetaData(this.remoteIp, packet);
                    WCPUtil.printDebugLogs("[Meta Received][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + packet.getPacketId() + "]");
                    this.sendAck(packet.getPacketId(), 3);
                    break block25;
                }
                if (packet.getPacketType() == 8) {
                    WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "response", "msg_received");
                    if (packet.getHeader("x-req-source-ip") != null) {
                        this.connPool.processWCPIDBNotifyData(this.remoteIp, packet);
                    } else {
                        String id = packet.getHeaderAsTable().get("reqid");
                        this.connPool.receiveResponse(id, packet);
                        WCPUtil.printDebugLogs("[Response Received][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + id + "]");
                    }
                    this.sendAck(packet.getPacketId(), 8);
                    break block25;
                }
                if (packet.getPacketType() == 5) {
                    WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "control", "msg_received");
                    int controlType = packet.getPayLoadType();
                    if (controlType == -1) {
                        this.logger.info("HB--> Wrong ControlType Came. controlType=" + controlType);
                        return;
                    }
                    this.logger.info("HB--> Control Packet Received. clusterName=" + DC.getCluster() + " remoteClusterName=" + this.remoteClusterName + " poolName=" + this.poolName + " remoteIp=" + this.remoteIp + "sid=" + this.sid + " controlType=" + WCPConstants.CONTROL.getName(controlType));
                    this.processControlPacket(controlType);
                    WCPUtil.printDebugLogs("[Control Packet Received][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + controlType + "][" + packet.getPacketId() + "]");
                    this.sendAck(packet.getPacketId(), 5);
                    break block25;
                }
                if (packet.getPacketType() == 10) {
                    WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "idb-cb-data", "msg_received");
                    String poolName = packet.getHeader("x-req-source-pn");
                    String remoteIp = packet.getHeader("x-req-remote-ip");
                    WCPPacket cbPacket = WCPPacketizer.getDataFromPacket(packet.getPayLoadData());
                    switch (cbPacket.getPacketType()) {
                        case 13: {
                            WCPDispatcher.processNotifyPackets(poolName, remoteIp, new String(cbPacket.getPayLoadData(), "UTF-8"));
                            break;
                        }
                        case 8: {
                            String id = cbPacket.getHeaderAsTable().get("reqid");
                            WCPDispatcher.receiveResponse(poolName, id, cbPacket);
                            WCPUtil.printDebugLogs("[IDB-CB Response Received][" + poolName + "][" + remoteIp + "][" + this.sid + "][" + id + "]");
                            break;
                        }
                        default: {
                            this.logger.info("Invalid IDB-CB Packet received. packetType=" + WCPConstants.PacketType.getPacketTypeString(cbPacket.getPacketType()));
                        }
                    }
                    this.sendAck(packet.getPacketId(), 10);
                    break block25;
                }
                if (packet.getPacketType() == 13) {
                    WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "idb-cb-notify", "msg_received");
                    this.connPool.processWCPIDBNotifyData(this.remoteIp, packet);
                    WCPUtil.printDebugLogs("[IDBCBNotify Received][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + packet.getPacketId() + "]");
                    this.sendAck(packet.getPacketId(), 13);
                    break block25;
                }
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.INVALID_PACKET_TYPE_RECEIVED_IN_CLIENT.getErrorCode(), 1L);
                WCPStats.addErrorStats("INVALID_PACKET_TYPE_RECEIVED_IN_CLIENT", "[packetType : " + packet.getPacketType() + "]");
                this.logger.info("WCPERR--> Invalid packetType received. packetType=" + (WCPPacketTypes.isValidPacketType(packet.getPacketType()) ? WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()) : Integer.valueOf(packet.getPacketType())));
                return;
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "[Exception - WCPBIOCLientConn.onMessage][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]", ex);
            }
        }
    }

    public void add(byte[] data) {
        this.readQueue.add(data);
    }

    public byte[] poll(long time) {
        WCPPacket packet = null;
        try {
            packet = this.ackQueue.poll();
            if (packet != null) {
                this.recentPacketSentTime = System.currentTimeMillis();
                int payLoadType = packet.getPayLoadType();
                switch (payLoadType) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 10: 
                    case 13: {
                        WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(payLoadType), "ack_sent");
                        break;
                    }
                    default: {
                        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.INVALID_ACK_PACKET_TYPE_SENT_FROM_CLIENT.getErrorCode(), 1L);
                        WCPStats.addErrorStats("INVALID_ACK_PACKET_TYPE_SENT_FROM_CLIENT", "[packetType : " + packet.getPacketType() + "][payloadType : " + payLoadType + "]");
                        this.logger.info("WCPERR--> Invalid ack_packetType sent in client. ack_packetType=" + (WCPPacketTypes.isValidPacketType(payLoadType) ? WCPConstants.PacketType.getPacketTypeString(payLoadType) : Integer.valueOf(payLoadType)));
                        return null;
                    }
                }
                WCPUtil.printDebugLogs("[Ack Sent][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + packet.getPacketId() + "][" + packet.getPayLoadType() + "]");
                return packet.getCompletePacketData();
            }
            if (this.isPaused) {
                return null;
            }
            if (this.retryFailedPacket && this.failedPacket != null) {
                byte[] data = this.failedPacket;
                this.retryFailedPacket = false;
                this.failedPacket = null;
                this.logger.severe("[WCPBIOClientConn - Retrying FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
                return data;
            }
            this.retryFailedPacketCount = 0;
            if (this.manualClose) {
                this.logger.info("[WCPBIOClientConn - Request Closing][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
                this.request.close();
                return null;
            }
            if (this.connPool.isHandleAsBB()) {
                Object obj = this.bq.poll(time);
                if (obj != null) {
                    if (obj instanceof byte[]) {
                        byte[] data = (byte[])obj;
                        ByteBuffer bb = ByteBuffer.wrap(data);
                        int packetType = WCPPacketizer.getPacketType(bb);
                        WCPPacketizer.setPacketInfoOnIDBPacket(bb, this.packetId.incrementAndGet(), 0L, System.currentTimeMillis());
                        WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(packetType), "msg_sent");
                        return bb.array();
                    }
                    packet = (WCPPacket)obj;
                }
            } else {
                packet = (WCPPacket)this.bq.poll(time);
            }
            if (packet != null) {
                long currTime = System.currentTimeMillis();
                long pcktId = this.packetId.incrementAndGet();
                packet.addHeader("x-bq-intime", Long.toString(currTime - packet.getQueueInTime()));
                packet.setPacketId(pcktId);
                packet.setQTime(System.currentTimeMillis() - packet.getQueueInTime());
                packet.setNetInTime(System.currentTimeMillis());
                this.recentPacketSentTime = System.currentTimeMillis();
                packet.addHeader("time", Long.toString(currTime));
                switch (packet.getPacketType()) {
                    case 1: 
                    case 6: 
                    case 9: 
                    case 10: {
                        WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()), "msg_sent");
                        break;
                    }
                    case 7: {
                        String reqid = packet.getHeader("reqid");
                        reqid = this.remoteClusterName + "@" + this.remoteIp + "@" + this.sid + "@" + reqid;
                        packet.addHeader("reqid", reqid);
                        WCPStats.addWCPClientData(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "request", "msg_sent");
                        break;
                    }
                    default: {
                        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.INVALID_PACKET_TYPE_SENT_FROM_CLIENT.getErrorCode(), 1L);
                        WCPStats.addErrorStats("INVALID_PACKET_TYPE_SENT_FROM_CLIENT", "[packetType : " + packet.getPacketType() + "]");
                        this.logger.info("WCPERR--> Invalid packetType sent in client. packetType=" + (WCPPacketTypes.isValidPacketType(packet.getPacketType()) ? WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()) : Integer.valueOf(packet.getPacketType())));
                        return null;
                    }
                }
                byte[] data = packet.getCompletePacketData();
                WCPStats.addWCPClientDataSize(this.connPool.getURI(), this.serverType, this.remoteServerType, this.remoteClusterName, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(packet.getPacketType()), data.length);
                packet = null;
                return data;
            }
            if (packet == null && System.currentTimeMillis() - this.recentPacketSentTime > WCPConfManager.getWCPMaxConnIdelTime() && this.connPool.getIPSidMap().containsKey(this.remoteIp) && this.connPool.getMinConnPerIp() < this.connPool.getIPSidMap().get(this.remoteIp).size()) {
                this.closeReason = "ConnIdel";
                this.close();
                this.logger.info("[WCPBIOClientConn - connIdel Close][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "[Exception - WCPBIOCLientConn.Poll][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]", ex);
        }
        return null;
    }

    @Override
    public void onClose() {
        block10: {
            try {
                if (this.retryTime == -1L) {
                    this.retryTime = System.currentTimeMillis();
                }
                this.addConnStats("conn_onclose", this.closeReason);
                if (!this.manualClose && System.currentTimeMillis() - this.retryTime < WCPConfManager.getWCPMaxRetryTime()) {
                    try {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.logger.info("[WCPBIOClientConn - Reconnecting][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
                        WCPStats.addWCPConnReconnect(this.serverType, this.remoteServerType, this.poolName, this.remoteIp);
                        this.connect();
                    }
                    catch (Exception e) {
                        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.RECONNECTION_FAILED.getErrorCode(), 1L);
                        WCPStats.addErrorStats("RECONNECTION_FAILED", "[remoteIP : " + this.remoteIp + "][poolName : " + this.poolName + "][sid : " + this.sid + "][exception : " + e.getMessage() + "]");
                        WCPUtil.printDebugLogs("[Exception][WCPBIOClientConn - Reconnecting][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + e.getMessage() + "]", e);
                    }
                    break block10;
                }
                this.connPool.removeConnFromPool(this.remoteIp, this.sid);
                BQInventory.unRegister(this.readQueue);
                this.request = null;
                try {
                    this.readThread.interrupt();
                }
                catch (Exception e) {}
            }
            catch (Exception ex) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.ON_CLOSE_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("ON_CLOSE_FAILED", "[remoteIP : " + this.remoteIp + "][poolName : " + this.poolName + "][sid : " + this.sid + "][exception : " + ex.getMessage() + "]");
                this.logger.log(Level.SEVERE, "[Exception][WCPBIOClientConn - onClose][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]", ex);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.manualClose = true;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void storeFailedPacket(byte[] data, long actual_size, Exception ex) {
        if (this.retryFailedPacketCount >= 3) {
            this.logger.info("[Exception][WCPBIOClientConn - WebSocketV13][Dropping FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + ex.getMessage() + "][" + data.length + "]");
            WCPUtil.printDebugLogs("[Exception][WCPBIOClientConn - WebSocketV13][Dropping FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + ex.getMessage() + "][" + data.length + "]", ex);
            WCPStats.addWCPDataSizeStats(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "drop", actual_size);
            this.retryFailedPacket = false;
            this.failedPacket = null;
            this.retryFailedPacketCount = 0;
            return;
        }
        this.logger.info("[Exception][WCPBIOClientConn - WebSocketV13][Storing FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + ex.getMessage() + "]");
        WCPUtil.printDebugLogs("[Exception][WCPBIOClientConn - WebSocketV13][Storing FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + ex.getMessage() + "]", ex);
        WCPStats.addWCPDataSizeStats(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, "failure", actual_size);
        this.failedPacket = data;
        this.retryFailedPacket = true;
        ++this.retryFailedPacketCount;
    }

    public void punchWCPDataSizeStats(long dataSize, String status) {
        WCPStats.addWCPDataSizeStats(this.serverType, this.remoteServerType, this.poolName, this.remoteIp, status, dataSize);
    }

    private void processControlPacket(int action) throws InterruptedException {
        switch (action) {
            case 1: {
                this.isPaused = true;
                break;
            }
            case 2: {
                this.request.resumeWrite();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                this.logger.info("HB--> WCPControl-INVALID ACTION, action=" + action);
            }
        }
    }

    public void sendAck(long packetId, int packetType) throws Exception {
        WCPPacket ackPacket = WCPPacketizer.getPacketFromData(packetId, 2, packetType);
        this.ackQueue.put(ackPacket);
        this.bq.interruptIfEmpty();
        if (this.isPaused) {
            this.request.signalWrite();
        }
    }

    protected boolean isAckQueueEmpty() {
        return this.ackQueue.isEmpty();
    }

    protected boolean isPaused() {
        return this.isPaused;
    }

    protected void pauseDataStream() {
        this.isPaused = true;
    }

    protected void resumeDataStream() {
        this.isPaused = false;
    }

    protected void startDataStream() {
        this.isPaused = false;
    }

    protected void startReadThead() {
        this.readThread.start();
    }

    protected String getAccessToken() {
        return this.connPool.getAccessToken();
    }

    class WCPPacketReadThread
    extends Thread {
        WCPPacketReadThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.setName("WCP/WCPPacketReadThread-" + WCPBIOClientConn.this.poolName + "-" + WCPBIOClientConn.this.connectionNumber);
            WCPBIOClientConn.this.logger.info("NS--> WCPPacketReadThread-" + WCPBIOClientConn.this.poolName + "-" + WCPBIOClientConn.this.connectionNumber + " sid=" + WCPBIOClientConn.this.sid + " started;");
            WCPBIOClientConn.this.isReadTheadLive = true;
            try {
                while (!WCPBIOClientConn.this.manualClose) {
                    try {
                        byte[] data = (byte[])WCPBIOClientConn.this.readQueue.poll();
                        if (data == null) continue;
                        WCPBIOClientConn.this.onMessage(data);
                    }
                    catch (Exception e) {
                        WCPBIOClientConn.this.logger.log(Level.SEVERE, "NS--> Error while taking from BQ. poolName=" + WCPBIOClientConn.this.poolName + " connectionNumber=" + WCPBIOClientConn.this.connectionNumber + " sid=" + WCPBIOClientConn.this.sid, e);
                    }
                }
                return;
            }
            catch (Exception e) {
                WCPBIOClientConn.this.logger.log(Level.SEVERE, "NS--> Error inside WCPPacketReadThread poolName=" + WCPBIOClientConn.this.poolName + " connectionNumber=" + WCPBIOClientConn.this.connectionNumber + " sid=" + WCPBIOClientConn.this.sid, e);
                return;
            }
            finally {
                WCPBIOClientConn.this.isReadTheadLive = false;
                WCPBIOClientConn.this.logger.info("NS--> WCPPacketReadThread-" + WCPBIOClientConn.this.poolName + "-" + WCPBIOClientConn.this.connectionNumber + " sid=" + WCPBIOClientConn.this.sid + "closed;");
            }
        }
    }
}

