/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.callback;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBEvent;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPResponseHandler {
    private Logger logger = Logger.getLogger(WCPResponseHandler.class.getName());
    private boolean closed = false;
    private BufferedQueue bq = null;
    private WCPServerConnPool connPool = null;
    private WMSThreadPoolExecutor wmsTPE = null;

    public WCPResponseHandler(WCPServerConnPool connPool, String dir, String fileName, int queueSize) {
        this.connPool = connPool;
        this.bq = new BufferedQueue(dir, fileName, queueSize, false);
        this.wmsTPE = new WMSThreadPoolExecutor("WCP/" + connPool.getPoolName() + "-ResponseHandler", 1, 1, 5L, TimeUnit.SECONDS, this.bq, new WCPResponseNotifier());
    }

    public void putData(String poolName, String ip, WCPPacket packet) {
        try {
            if (!this.closed) {
                this.wmsTPE.execute(new WCPCBEvent(poolName, ip, packet));
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "WCPERR--> putData exception with poolName : " + poolName + " :: ip : " + ip, ex);
        }
    }

    public synchronized void setCorePoolSize(int corePoolSize) {
        this.wmsTPE.setCorePoolSize(corePoolSize);
    }

    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        this.wmsTPE.setMaximumPoolSize(maximumPoolSize);
    }

    public synchronized void setPoolSize(int corePoolSize, int maximumPoolSize) {
        this.wmsTPE.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public void start() {
        this.wmsTPE.start();
        this.wmsTPE.prestartAllCoreThreads();
    }

    public void closeCBNotifyHandler() {
        this.closed = true;
    }

    public long getQueueSize() {
        return this.bq.size();
    }

    public int getActiveThreadsCount() {
        return this.wmsTPE.getActivePoolSize();
    }

    public int getMaxThreadsCount() {
        return this.wmsTPE.getMaximumPoolSize();
    }

    class WCPResponseNotifier
    implements WmsTask {
        WCPResponseNotifier() {
        }

        @Override
        public void handle(Object wcpCBEvent) {
            long processTime = System.currentTimeMillis();
            WCPCBEvent cbe = (WCPCBEvent)wcpCBEvent;
            if (cbe != null) {
                try {
                    if (cbe.getWCPPacket().getPacketType() == 8) {
                        String id = cbe.getWCPPacket().getHeaderAsTable().get("reqid");
                        String[] splt = id.split("@");
                        String clusterName = splt[0];
                        String ip = splt[1];
                        String sid = splt[2];
                        String reqid = splt[3];
                        WCPFuture future = WCPResponseHandler.this.connPool.removeWCPFutureObj(reqid);
                        if (future != null) {
                            String data = new String(cbe.getWCPPacket().getPayLoadData(), "UTF-8");
                            Hashtable ht = (Hashtable)HttpDataWraper.getObject((String)data);
                            WCPResponse res = new WCPResponse(ht);
                            future.setResponse(res);
                        } else {
                            WCPResponseHandler.this.logger.info("[WCP][No WCPFutureObject][" + WCPResponseHandler.this.connPool.getPoolName() + "][" + clusterName + "][" + ip + "][" + sid + "][" + reqid + "]");
                        }
                    } else {
                        WCPResponseHandler.this.logger.warning("Invalid packet inside WCPResponse Handler; packettype=" + cbe.getWCPPacket().getPacketType() + " ConnPool=" + WCPResponseHandler.this.connPool.getPoolName());
                    }
                }
                catch (Exception ex) {
                    WCPResponseHandler.this.logger.log(Level.SEVERE, "WCPERR--> Error while executing WCPReponse inside connPool=" + WCPResponseHandler.this.connPool.getPoolName(), ex);
                }
            }
            WCPStats.addWCPHandlerProcessingTime(WCPResponseHandler.this.connPool.getServerType(), WCPResponseHandler.this.connPool.getRemoteServerType(), WCPResponseHandler.this.connPool.getClusterName(), WCPResponseHandler.this.connPool.getPoolName(), WCPResponseHandler.this.connPool.getContext(), "ResponseHandler", System.currentTimeMillis() - processTime);
        }
    }
}

