/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.util.WCPAccessLogger;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.grid.AbsAutoReBalancer;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPCLIRuntime
extends WmsRuntime {
    private static final Logger LOGGER = Logger.getLogger(WCPCLIRuntime.class.getName());

    @Override
    public Hashtable getInfo(Hashtable params) {
        Hashtable<String, Object> cmdResult;
        block80: {
            cmdResult = new Hashtable<String, Object>();
            String operation = (String)params.get("operation");
            String poolName = (String)params.get("poolname");
            String clusterName = (String)params.get("clustername");
            String ip = (String)params.get("ip");
            String prd = (String)params.get("prd");
            String ips = (String)params.get("ips");
            String api = (String)params.get("api");
            String limit = (String)params.get("drainlimit");
            try {
                if (operation != null) {
                    if (operation.equals("refresh")) {
                        if (poolName != null) {
                            if (WCPDispatcher.isValidPool(poolName)) {
                                if (WCPDispatcher.refreshSeedsOfPool(poolName)) {
                                    cmdResult.put(poolName, poolName + " refreshed Successfully.");
                                } else {
                                    cmdResult.put(poolName, poolName + " refresh Failed.");
                                }
                            } else {
                                cmdResult.put("PoolName '-pn'", "Can not be empty");
                            }
                        } else if (clusterName != null) {
                            if (WCPDispatcher.refreshSeeds(clusterName)) {
                                cmdResult.put(clusterName, clusterName + " refreshed Successfully.");
                            } else {
                                cmdResult.put(clusterName, clusterName + " refresh Failed.");
                            }
                        }
                        break block80;
                    }
                    if (operation.equals("refreshapi")) {
                        int sessions = 0;
                        if (api != null && !api.isEmpty()) {
                            if (api.equalsIgnoreCase("all")) {
                                sessions = WCPSessionManager.notifySeedsChangeToAPI("SeedsChange");
                                cmdResult.put(api, " SeedsChange Notified Successfully. sessions=" + sessions);
                                return cmdResult;
                            }
                            if (prd != null && !prd.isEmpty()) {
                                if (WCPSessionManager.isValidPrd(prd.toUpperCase())) {
                                    if (ip == null || ip.isEmpty()) {
                                        sessions = WCPSessionManager.notifySeedsChangeToAPI("SeedsChange", api + "-" + prd);
                                        cmdResult.put(api + "-" + prd, " SeedsChange Notified Successfully. sessions=" + sessions);
                                    } else if (WCPSessionManager.isValidRemoteIp(ip)) {
                                        sessions = WCPSessionManager.notifySeedsChangeToAPI("SeedsChange", api + "-" + prd, ip);
                                        cmdResult.put(api + "-" + prd + " : " + ip, " SeedsChange Notified Successfully. sessions=" + sessions);
                                    } else {
                                        cmdResult.put(api + "-" + prd + " : " + ip, " remoteIp is not valid. remoteIp=" + ip);
                                    }
                                } else {
                                    cmdResult.put("prd is not Valid", "prd=" + prd);
                                }
                            } else {
                                cmdResult.put("-prd Can not be empty ", " please provide valid prd");
                            }
                        } else {
                            cmdResult.put("apiname '-api'", "Can not be empty");
                        }
                        break block80;
                    }
                    if ("block".equalsIgnoreCase(operation)) {
                        if (poolName != null) {
                            if (WCPDispatcher.isValidPool(poolName)) {
                                if (ip != null) {
                                    if (WCPDispatcher.blockIP(poolName, ip)) {
                                        cmdResult.put(poolName, "added in block list");
                                    } else {
                                        cmdResult.put(poolName, "already added in block list");
                                    }
                                } else {
                                    cmdResult.put("IP '-ip'", "Can not be empty");
                                }
                            } else {
                                cmdResult.put(poolName, "poolName is not valid");
                            }
                        } else {
                            cmdResult.put("PoolName '-pn'", "Can not be empty");
                        }
                        break block80;
                    }
                    if ("unblock".equalsIgnoreCase(operation)) {
                        if (poolName != null) {
                            if (WCPDispatcher.isValidPool(poolName)) {
                                if (ip != null) {
                                    cmdResult.put(ip, WCPDispatcher.unblockIP(poolName, ip));
                                } else {
                                    cmdResult.put("IP '-ip'", "Can not be empty");
                                }
                            } else {
                                cmdResult.put(poolName, "poolName is not valid");
                            }
                        } else {
                            cmdResult.put("PoolName '-pn'", "Can not be empty");
                        }
                        break block80;
                    }
                    if ("getblkips".equals(operation)) {
                        if (poolName != null) {
                            if (WCPDispatcher.isValidPool(poolName)) {
                                cmdResult.put(poolName, WCPDispatcher.getBlockedIPs(poolName));
                            } else {
                                cmdResult.put(poolName, "poolName is not valid");
                            }
                            break block80;
                        }
                        return WCPDispatcher.getBlockedIPs();
                    }
                    if ("arb".equals(operation)) {
                        if (prd != null && !prd.isEmpty()) {
                            if (WCPSessionManager.isValidPrd(prd.toUpperCase())) {
                                if (ips != null) {
                                    try {
                                        String[] ipList = ips.split(",");
                                        for (int i = 0; i < ipList.length; ++i) {
                                            if (WCPSessionManager.isValidRemoteIp(ipList[i])) {
                                                if (WCPSessionManager.getPrd(ipList[i]).equals(prd.toUpperCase())) {
                                                    cmdResult.put(WCPSessionManager.getPrd(ipList[i]) + " - " + ipList[i], WCPSessionManager.getSessionsCount(ipList[i]));
                                                    continue;
                                                }
                                                cmdResult.put(ipList[i], "prd mismatch. This ip belongs to " + WCPSessionManager.getPrd(ipList[i]));
                                                continue;
                                            }
                                            cmdResult.put(ipList[i], " ip not valid or sessions count is 0");
                                        }
                                        break block80;
                                    }
                                    catch (Exception e) {
                                        cmdResult.put("Exception ", "please give valid ips with ',' separated");
                                        break block80;
                                    }
                                }
                                Hashtable<String, Integer> sessions = WCPSessionManager.getAPISessionCount(prd.toUpperCase());
                                cmdResult.put(prd.toUpperCase() + " - Sessions Info", sessions);
                                cmdResult.put(prd.toUpperCase() + " - Total Count", sessions.remove("totalsessions"));
                                break block80;
                            }
                            cmdResult.put(prd, prd + " is not a valid prd, please enter vaid prd");
                            break block80;
                        }
                        if (ips != null) {
                            try {
                                String[] ipList = ips.split(",");
                                int totalCount = 0;
                                for (int i = 0; i < ipList.length; ++i) {
                                    if (WCPSessionManager.isValidRemoteIp(ipList[i])) {
                                        totalCount += WCPSessionManager.getSessionsCount(ipList[i]);
                                        cmdResult.put(WCPSessionManager.getPrd(ipList[i]) + " - " + ipList[i], WCPSessionManager.getSessionsCount(ipList[i]));
                                        continue;
                                    }
                                    cmdResult.put(ipList[i], " ip not valid or sessions count is 0");
                                }
                                cmdResult.put("Total Count", totalCount);
                            }
                            catch (Exception e) {
                                cmdResult.put("Exception ", "please give valid ips with ',' separated");
                            }
                            return cmdResult;
                        }
                        cmdResult.put("ARB Info", AbsAutoReBalancer.getLoadInfo("wcpapi"));
                        cmdResult.put("API Session Info", WCPSessionManager.getAPISessionCount());
                        break block80;
                    }
                    if ("enableaccesslogs".equals(operation)) {
                        WCPAccessLogger.enableAccessLogs();
                        cmdResult.put(" WCP ", " WCPAccessLogger Enabled Successfully.");
                        break block80;
                    }
                    if ("disableaccesslogs".equals(operation)) {
                        WCPAccessLogger.disableAccessLogs();
                        cmdResult.put(" WCP ", " WCPAccessLogger Diabled Successfully.");
                        break block80;
                    }
                    if ("enableforceclose".equals(operation)) {
                        if (poolName != null) {
                            WCPDispatcher.enableForceCloseConn(poolName);
                            cmdResult.put(" WCP ", " ForceConnClose Enabled for " + poolName);
                        } else {
                            WCPDispatcher.enableForceCloseConn();
                            cmdResult.put(" WCP ", " ForceConnClose Enabled for all pools.");
                        }
                        break block80;
                    }
                    if ("disableforceclose".equals(operation)) {
                        if (poolName != null) {
                            WCPDispatcher.disableForceCloseConn(poolName);
                            cmdResult.put(" WCP ", " ForceConnClose Disabled for " + poolName);
                        } else {
                            WCPDispatcher.disableForceCloseConn();
                            cmdResult.put(" WCP ", " ForceConnClose Disabled for all pools.");
                        }
                        break block80;
                    }
                    if ("drainbq".equals(operation)) {
                        LOGGER.log(Level.INFO, "WCP - DrainBQ called. zuid={0}", params.get("_zuid"));
                        int drainlimit = -1;
                        int drainStatus = -1;
                        if (!CommonUtil.isEmpty((String)poolName)) {
                            if (CommonUtil.isEmpty((String)limit)) {
                                cmdResult.put(" WCP - DrainBQ Error", "Please enter limit -l");
                                return cmdResult;
                            }
                            try {
                                drainlimit = Integer.parseInt(limit);
                            }
                            catch (NumberFormatException e) {
                                cmdResult.put(" WCP - DrainBQ Error", "Given limit is not an Integer. limit=" + limit);
                            }
                            if (!CommonUtil.isEmpty((String)ip)) {
                                drainStatus = WCPDispatcher.clearBQData(poolName, ip, drainlimit);
                                cmdResult.put(" WCP ", " BQ drainStatus=" + WCPConstants.BQDrainStatus.getStats(drainStatus) + " for ip=" + ip + " poolName=" + poolName);
                            } else {
                                drainStatus = WCPDispatcher.clearBQData(poolName, drainlimit);
                                cmdResult.put(" WCP ", " BQ drainStatus=" + WCPConstants.BQDrainStatus.getStats(drainStatus) + " poolName=" + poolName);
                            }
                            break block80;
                        }
                        cmdResult.put(" WCP ", " PoolName is null or empty.");
                        break block80;
                    }
                    if ("info".equals(operation)) {
                        if (!CommonUtil.isEmpty((String)poolName)) {
                            if (WCPDispatcher.isValidPool(poolName)) {
                                cmdResult.putAll(WCPDispatcher.getConnPoolInfo(poolName));
                            } else {
                                cmdResult.put(poolName, "poolName is not valid");
                            }
                        } else {
                            cmdResult.putAll(WCPDispatcher.getConnPoolInfo());
                        }
                    } else {
                        cmdResult.put("operation is invalid", "Must be either, block, unblock, listblockedpools, refresh, refreshapi, arb, info");
                    }
                    break block80;
                }
                Hashtable<String, LinkedHashMap<String, Object>> hashtable = new Hashtable<String, LinkedHashMap<String, Object>>();
                hashtable.put("WCP", WCPDispatcher.getInfo());
                return hashtable;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "HB_ERR--> Exception in wcp runtime. opr=" + operation + " poolName=" + poolName + " clusterName=" + clusterName + " prd=" + prd + " ips=" + ips, e);
            }
        }
        return cmdResult;
    }
}

