/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.WCPApiReBalancer;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.AbsAutoReBalancer;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class WCPApiHitsReBalancer
extends AbsAutoReBalancer {
    private static final Logger LOGGER = Logger.getLogger(WCPApiReBalancer.class.getName());
    public static final String CONTEXT = "wcpapi";
    public static final String CONTEXT_ROUTER = "router";

    @Override
    public boolean rebalanceContext(Map<String, Object> rebalanceDetails, String context) throws Exception {
        boolean sendControlPacketResult = true;
        if (rebalanceDetails.containsKey("hits")) {
            try {
                rebalanceDetails.remove("hits");
                LOGGER.info("WMSAPI Hits rebalancer--> " + rebalanceDetails + " for context : " + context);
                for (String remoteIp : rebalanceDetails.keySet()) {
                    Hashtable redirectIpContolType = (Hashtable)rebalanceDetails.get(remoteIp);
                    for (String redirectIp : redirectIpContolType.keySet()) {
                        int controlType = (Integer)redirectIpContolType.get(redirectIp);
                        Hashtable<String, String> header = new Hashtable<String, String>();
                        header.put("redirectip", redirectIp);
                        try {
                            WCPSessionManager.sendControlDataToApi(WCPSessionManager.getApiName(remoteIp), remoteIp, controlType, header);
                            StatsDB.addData("wcpapirebalancer", DC.getCluster(), redirectIp, WCPSessionManager.getApiName(remoteIp), WCPSessionManager.getPrd(remoteIp), remoteIp, "success", 1);
                            LOGGER.info("WMSAPI Hits rebalance source=" + WCPSessionManager.getApiName(remoteIp) + " remoteIp=" + remoteIp + " poolName=" + WCPSessionManager.getPoolName(remoteIp) + " controlType=" + WCPConstants.CONTROL.getName(controlType));
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "ARB HITS-->Exception while sending control packet to remoteip :" + remoteIp + " source=" + WCPSessionManager.getApiName(remoteIp) + " for context : " + context + " controlType=" + WCPConstants.CONTROL.getName(controlType), e);
                            StatsDB.addData("wcpapirebalancer", DC.getCluster(), redirectIp, WCPSessionManager.getApiName(remoteIp), WCPSessionManager.getPrd(remoteIp), remoteIp, "failed", 1);
                            sendControlPacketResult = false;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "ARB HITS-->Exception in rebalanceContext : " + context, e);
                throw e;
            }
        }
        try {
            LOGGER.info("WMSAPI Session rebalancer--> " + rebalanceDetails + " for context : " + context);
            JSONObject rebalanceData = new JSONObject(HttpDataWraper.getString(rebalanceDetails));
            Iterator keys = rebalanceData.keys();
            block10: while (keys.hasNext()) {
                String redirectip = (String)keys.next();
                long sessions = rebalanceData.getLong(redirectip);
                int counter = 0;
                while ((long)counter < sessions) {
                    Hashtable<String, String> header = new Hashtable<String, String>();
                    header.put("redirectip", redirectip);
                    String remoteip = WCPSessionManager.getRemoteip(counter);
                    if (CommonUtil.isEmpty((String)remoteip)) continue block10;
                    try {
                        WCPSessionManager.sendControlData(CONTEXT_ROUTER, remoteip, 5, header, "api");
                        StatsDB.addData("wcpapirebalancer", DC.getCluster(), redirectip, WCPSessionManager.getApiName(remoteip), WCPSessionManager.getPrd(remoteip), remoteip, "success", 1);
                        LOGGER.info("WMSAPI Session rebalance source=" + WCPSessionManager.getApiName(remoteip) + " remoteIp=" + remoteip + " poolName=" + WCPSessionManager.getPoolName(remoteip));
                    }
                    catch (Exception e) {
                        sendControlPacketResult = false;
                        LOGGER.log(Level.SEVERE, "ARB SESSION-->Exception while sending control packet to remoteip :" + remoteip + " for context : " + context, e);
                        StatsDB.addData("wcpapirebalancer", DC.getCluster(), redirectip, WCPSessionManager.getApiName(remoteip), WCPSessionManager.getPrd(remoteip), remoteip, "failed", 1);
                    }
                    ++counter;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ARB SESSION-->Exception while sending control packet for context : " + context, e);
            throw e;
        }
        return sendControlPacketResult;
    }
}

